/*
 * Decompiled with CFR 0.152.
 */
import deconv.Parameters;
import deconv.ThreadDeconvolution;
import deconv.algo.AbstractAlgorithm;
import deconv.algo.Convolution;
import deconv.algo.FISTA;
import deconv.algo.InverseFiltering;
import deconv.algo.Landweber;
import deconv.algo.RegularizedInverseFiltering;
import deconv.algo.RichardsonLucy;
import deconv.algo.RichardsonLucyTV;
import deconv.algo.ThresholdedLandweber;
import deconv.algo.TikhonovMiller;
import deconv.gui.AdvancedDialog;
import ij.IJ;
import ij.Macro;
import ij.gui.GUI;
import ij.plugin.PlugIn;
import java.awt.Window;
import javax.swing.JButton;
import toolbox.gui.LogSingleton;

public class DeconvolutionLab_
implements PlugIn {
    public void run(String arg0) {
        if (IJ.versionLessThan((String)"1.35s")) {
            return;
        }
        String options = Macro.getOptions();
        if (options == null) {
            AdvancedDialog dl = new AdvancedDialog();
            dl.pack();
            GUI.center((Window)dl);
            dl.setVisible(true);
        } else {
            LogSingleton log = LogSingleton.getInstance();
            log.macroMode = true;
            Parameters parameters = new Parameters();
            parameters.useMacro = true;
            parameters.nameAlgo = Macro.getValue((String)options, (String)"nameAlgo", (String)"");
            parameters.namePSF = Macro.getValue((String)options, (String)"namePSF", (String)"");
            parameters.normalizePSF = Boolean.parseBoolean(Macro.getValue((String)options, (String)"normalizePSF", (String)"true"));
            parameters.recenterPSF = Boolean.parseBoolean(Macro.getValue((String)options, (String)"recenterPSF", (String)"true"));
            parameters.monitorPerf = Boolean.parseBoolean(Macro.getValue((String)options, (String)"monitorPerf", (String)"false"));
            parameters.nameRef = Macro.getValue((String)options, (String)"nameRef", (String)"");
            parameters.folderPerfMon = Macro.getValue((String)options, (String)"folderPerfMon", (String)"");
            parameters.useSeed = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useSeed", (String)"false"));
            parameters.seed = Float.parseFloat(Macro.getValue((String)options, (String)"seed", (String)"0"));
            parameters.background = Float.parseFloat(Macro.getValue((String)options, (String)"background", (String)"0"));
            parameters.subtractBackground = Boolean.parseBoolean(Macro.getValue((String)options, (String)"subtractBackground", (String)"false"));
            parameters.estimateBackground = Boolean.parseBoolean(Macro.getValue((String)options, (String)"estimateBackground", (String)"true"));
            parameters.saveVideo = Boolean.parseBoolean(Macro.getValue((String)options, (String)"saveVideo", (String)"false"));
            parameters.folderVideo = Macro.getValue((String)options, (String)"folderVideo", (String)"");
            parameters.cropSelection = Boolean.parseBoolean(Macro.getValue((String)options, (String)"cropSelection", (String)"false"));
            parameters.useWindowing = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useWindowing", (String)"false"));
            parameters.addBorders = Boolean.parseBoolean(Macro.getValue((String)options, (String)"addBorders", (String)"false"));
            parameters.percentWindowing = Float.parseFloat(Macro.getValue((String)options, (String)"percentWindowing", (String)"0"));
            parameters.percentBorder = Float.parseFloat(Macro.getValue((String)options, (String)"percentBorder", (String)"0"));
            parameters.windowingFunction = Integer.parseInt(Macro.getValue((String)options, (String)"windowingFunction", (String)"0"));
            parameters.processMultiFile = Boolean.parseBoolean(Macro.getValue((String)options, (String)"processMultiFile", (String)"false"));
            parameters.folderBatchInput = Macro.getValue((String)options, (String)"folderBatchInput", (String)"");
            parameters.folderBatchOutput = Macro.getValue((String)options, (String)"folderBatchOutput", (String)"");
            parameters.useFFTW = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useFFTW", (String)"false"));
            parameters.logPriorityLevel = Integer.parseInt(Macro.getValue((String)options, (String)"logPriorityLevel", (String)"0"));
            parameters.nameOutput = Macro.getValue((String)options, (String)"nameOutput", (String)"");
            AbstractAlgorithm[] algo = this.initialize();
            int i = 0;
            i = 0;
            while (i < algo.length) {
                if (algo[i].getName().equals(parameters.nameAlgo)) break;
                ++i;
            }
            if (i < algo.length) {
                algo[i].getMacroParameters(options);
                algo[i].log();
                ThreadDeconvolution threadDeconvolution = new ThreadDeconvolution(algo[i], parameters, new JButton("Run"), "run");
                threadDeconvolution.setPriority(1);
                threadDeconvolution.start();
            } else {
                IJ.error((String)("<" + parameters.nameAlgo + "> is an unknown algorithm."));
            }
        }
    }

    private AbstractAlgorithm[] initialize() {
        AbstractAlgorithm[] algo = new AbstractAlgorithm[]{new Convolution(), new InverseFiltering(), new RegularizedInverseFiltering(), new Landweber(), new ThresholdedLandweber(), new FISTA(), new TikhonovMiller(), new RichardsonLucy(), new RichardsonLucyTV()};
        return algo;
    }
}

