/*
 * Decompiled with CFR 0.152.
 */
package deconv;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.gui.PlotWindow;
import ij.io.FileSaver;
import ij.io.Opener;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JButton;
import toolbox.MatlabWriter;
import toolbox.gui.LogSingleton;

public class ThreadDeconvolution
extends Thread {
    protected Parameters parameters;
    protected AbstractAlgorithm algorithm;
    protected JButton jRunButton;
    protected String runText;

    public ThreadDeconvolution(AbstractAlgorithm algorithm, Parameters parameters, JButton jRunButton, String runText) {
        this.parameters = parameters;
        this.algorithm = algorithm;
        this.runText = runText;
        this.jRunButton = jRunButton;
    }

    @Override
    public void run() {
        if (this.parameters.processMultiFile) {
            this.batchProcess(this.parameters);
        } else if (this.parameters.processMultiParam) {
            this.multiParamProcess(this.parameters);
        } else {
            this.algorithm.execute(this.parameters);
            if (this.parameters.monitorPerf && this.algorithm.serg != null) {
                int k;
                String outputFolderName = new String(String.valueOf(this.parameters.folderPerfMon) + this.algorithm.getName() + File.separator);
                new File(outputFolderName).mkdirs();
                MatlabWriter mWriter = new MatlabWriter(String.valueOf(outputFolderName) + "Measurements.m");
                mWriter.openFile();
                mWriter.writeArray("SERG", this.algorithm.serg);
                mWriter.writeArray("time", this.algorithm.time);
                mWriter.closeFile();
                try {
                    FileWriter fWriter = new FileWriter(String.valueOf(outputFolderName) + "Measurements.csv", false);
                    k = 0;
                    while (k < this.algorithm.serg.length) {
                        fWriter.write(k + ", " + this.algorithm.serg[k] + ", " + this.algorithm.time[k] + "\n");
                        ++k;
                    }
                    fWriter.close();
                }
                catch (IOException e) {
                    IJ.error((String)("The file \"" + this.parameters.folderPerfMon + "Measurements.csv\" could not be opened."));
                }
                if (!this.parameters.useMacro) {
                    float[] index = new float[this.algorithm.serg.length];
                    k = 0;
                    while (k < this.algorithm.serg.length) {
                        index[k] = k;
                        ++k;
                    }
                    PlotWindow plot = new PlotWindow("SER gain vs. number of iterations", "Iteration number", "SER gain (dB)", index, this.algorithm.serg);
                    plot.setColor(Color.red);
                    plot.draw();
                    PlotWindow plot2 = new PlotWindow("Time vs. number of iterations", "Iteration number", "Time (s)", index, this.algorithm.time);
                    plot2.setColor(Color.red);
                    plot2.draw();
                }
            }
        }
        System.gc();
        this.jRunButton.setText(this.runText);
    }

    private void multiParamProcess(Parameters parameters) {
        String outputFolderName = new String(String.valueOf(parameters.folderBatchOutput) + this.algorithm.getName() + File.separator);
        File outputFolder = new File(outputFolderName);
        outputFolder.mkdir();
        if (!outputFolder.exists()) {
            IJ.showMessage((String)"Directory could not be created");
            return;
        }
        float[] param = new float[(int)((parameters.multiParamEnd - parameters.multiParamStart) / parameters.multiParamStep) + 1];
        int k = 0;
        while (k < param.length) {
            param[k] = parameters.multiParamStart + (float)k * parameters.multiParamStep;
            this.algorithm.setRegParamValue(param[k]);
            this.algorithm.updateGUI();
            this.algorithm.execute(parameters);
            if (parameters.monitorPerf && this.algorithm.serg != null) {
                MatlabWriter mWriter = new MatlabWriter(outputFolderName, "meas" + k);
                mWriter.openFile();
                mWriter.writeArray("SERG", this.algorithm.serg);
                mWriter.writeArray("time", this.algorithm.time);
                mWriter.closeFile();
            }
            ++k;
        }
        MatlabWriter mWriter = new MatlabWriter(outputFolderName, "range");
        mWriter.openFile();
        mWriter.writeArray("param", param);
        mWriter.closeFile();
    }

    private void batchProcess(Parameters parameters) {
        File inputFolder = new File(parameters.folderBatchInput);
        String[] fileNames = inputFolder.list();
        Vector<String> imageFileNames = new Vector<String>();
        Opener opener = new Opener();
        FileSaver saver = null;
        LogSingleton log = LogSingleton.getInstance();
        int i = 0;
        while (i < fileNames.length) {
            int fileType = opener.getFileType(String.valueOf(parameters.folderBatchInput) + fileNames[i]);
            if (fileType != 0 && fileType != 12) {
                imageFileNames.add(fileNames[i]);
            }
            ++i;
        }
        String msg = "";
        int i2 = 0;
        while (i2 < imageFileNames.size()) {
            msg = String.valueOf(msg) + (String)imageFileNames.get(i2) + " -----> ";
            msg = String.valueOf(msg) + "out_" + (String)imageFileNames.get(i2) + "\n";
            ++i2;
        }
        if (imageFileNames.size() == 0) {
            msg = String.valueOf(msg) + "No input files of known type!";
        }
        IJ.error((String)"Input and Output files", (String)msg);
        int i3 = 0;
        while (i3 < imageFileNames.size()) {
            ImagePlus img = opener.openImage(parameters.folderBatchInput, (String)imageFileNames.get(i3));
            if (img == null) {
                log.append(String.valueOf(parameters.folderBatchInput) + (String)imageFileNames.get(i3) + " could not be opened.", 2);
            } else {
                log.append("Processing " + parameters.folderBatchInput + (String)imageFileNames.get(i3), 2);
                img = this.algorithm.execute(parameters, img);
            }
            if (img != null) {
                saver = new FileSaver(img);
                if (img.getStackSize() > 1) {
                    saver.saveAsTiffStack(String.valueOf(parameters.folderBatchOutput) + (String)imageFileNames.get(i3));
                } else {
                    saver.saveAsTiff(String.valueOf(parameters.folderBatchOutput) + (String)imageFileNames.get(i3));
                }
            }
            img = null;
            saver = null;
            System.gc();
            ++i3;
        }
    }
}

