/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import toolbox.Signal;
import toolbox.ToolboxSignal;
import toolbox.gui.LogSingleton;

public abstract class AbstractAlgorithm {
    private final int INSET_SPACE = 5;
    protected GridBagLayout gbLayout = new GridBagLayout();
    protected GridBagConstraints gbConstraints = new GridBagConstraints();
    protected static LogSingleton log = LogSingleton.getInstance();
    public float[] serg = null;
    public float[] time = null;

    public abstract JPanel getJPanel();

    public abstract String getName();

    public abstract boolean process(Signal var1, Signal var2, Signal var3, Parameters var4);

    public abstract void setRegParamValue(float var1);

    public abstract void saveParameters(Properties var1);

    public abstract void loadParameters(Properties var1);

    public abstract void getMacroParameters(String var1);

    public abstract void log();

    public abstract void getParameters();

    public abstract void updateGUI();

    public abstract void reset();

    public ImagePlus execute(Parameters parameters) {
        return this.run(parameters, null);
    }

    public ImagePlus execute(Parameters parameters, ImagePlus inputImage) {
        return this.run(parameters, inputImage);
    }

    private ImagePlus run(Parameters parameters, ImagePlus inputImage) {
        Rectangle roi;
        log.resetStartTime();
        log.appendWithTime("\n\nStarting algorithm \"" + parameters.nameAlgo + "\".", 1);
        log.setProgressLength(0);
        ImagePlus input = null;
        input = inputImage == null ? WindowManager.getCurrentImage() : inputImage;
        if (input == null) {
            IJ.error((String)"No current image.");
            return null;
        }
        log.start("Loading input image: \"" + input.getTitle() + "\"", 1);
        if (input.getType() != 2 && input.getType() != 1 && input.getType() != 0 && !IJ.showMessageWithCancel((String)"Warning", (String)"Multichannel images are converted into a single grayscale image.\nPlease split the channels first if you want to process them separately.\n \nPress Cancel if you want to abort the operation.")) {
            return null;
        }
        int z0 = 0;
        int depth = input.getStackSize();
        if (parameters.cropSelection) {
            if (input.getRoi() == null) {
                IJ.error((String)"No active selection.");
                return null;
            }
            roi = input.getRoi().getBounds();
        } else {
            roi = new Rectangle(0, 0, input.getWidth(), input.getHeight());
        }
        float pB = 0.0f;
        if (parameters.addBorders) {
            pB = parameters.percentBorder / 2.0f;
            this.addBorder(roi, pB);
            if (input.getStackSize() != 1) {
                z0 = -((int)(pB * (float)input.getStackSize()));
                depth = input.getStackSize() - 2 * z0;
            }
        }
        Signal y = input.getStackSize() != 1 ? new Signal(input, roi, z0, depth) : new Signal(input, roi);
        if (parameters.subtractBackground) {
            float background = parameters.estimateBackground ? ToolboxSignal.minimum(y) : parameters.background;
            ToolboxSignal.addConstant(y, -background, 0.0f);
        }
        if (parameters.useWindowing) {
            float pW = parameters.percentWindowing / 2.0f;
            if (y.D == 2) {
                ToolboxSignal.weightBorder(y, pW / (1.0f + 2.0f * pB), parameters.windowingFunction);
            }
            if (y.D == 3) {
                ToolboxSignal.weightBorder1D(y, 0, pW / (1.0f + 2.0f * pB), parameters.windowingFunction);
                ToolboxSignal.weightBorder1D(y, 1, pW / (1.0f + 2.0f * pB), parameters.windowingFunction);
                ToolboxSignal.weightBorder1D(y, 2, pW / (1.0f + 2.0f * pB), parameters.windowingFunction);
            }
        }
        log.acknowledge(1);
        log.setProgressLength(10);
        log.start("Loading PSF: \"" + parameters.namePSF + "\"", 1);
        ImagePlus psf = WindowManager.getImage((String)parameters.namePSF);
        if (psf == null) {
            IJ.error((String)("The PSF \"" + parameters.namePSF + "\" was not found."));
            return null;
        }
        Signal h = new Signal(psf);
        log.acknowledge(1);
        if (parameters.normalizePSF) {
            log.start("Normalizing PSF", 0);
            ToolboxSignal.multiplyConstant(h, 1.0f / ToolboxSignal.sum(h));
            log.acknowledge(0);
        }
        if (parameters.recenterPSF) {
            log.start("Flipping PSF quadrants", 0);
            int[] shift = new int[h.D];
            int d = 0;
            while (d < h.D) {
                shift[d] = h.N[d] / 2;
                ++d;
            }
            ToolboxSignal.fftShift(h, shift);
            log.acknowledge(0);
        }
        if (!ToolboxSignal.checkCompatibility(y, h)) {
            log.start("Resizing PSF", 0);
            if (!ToolboxSignal.resizePSF(y.N, h)) {
                IJ.error((String)("PSF image \"" + parameters.namePSF + "\" and current image \"" + input.getTitle() + "\" are of incompatible sizes.\nThis means that they are" + " either of different dimension (e.g. a 2D PSF and a 3D image)" + " \nor that the PSF has greater dimensions (e.g. a bigger width)" + " than the image."));
                return null;
            }
            log.acknowledge(0);
            log.setProgressLength(15);
        }
        Signal x = null;
        if (parameters.monitorPerf) {
            log.start("Loading ground-truth image: \"" + parameters.nameRef + "\"", 1);
            ImagePlus ser = WindowManager.getImage((String)parameters.nameRef);
            if (ser == null) {
                IJ.error((String)("Ground-truth image \"" + parameters.nameRef + "\" was not found."));
                return null;
            }
            x = new Signal(ser);
            if (ser.getWidth() != input.getWidth() || ser.getHeight() != input.getHeight() || ser.getImageStackSize() != input.getImageStackSize()) {
                IJ.error((String)("Ground-truth image \"" + parameters.nameRef + "\" and current image \"" + input.getTitle() + "\" are of incompatible sizes."));
                return null;
            }
            log.acknowledge(1);
            log.setProgressLength(20);
        }
        log.appendWithTime("Processing started...", 1);
        this.process(y, h, x, parameters);
        log.appendWithTime("...processing finished.", 1);
        log.start("Showing processed image", 0);
        ImagePlus output = y.get_image(String.valueOf(this.getName()) + " of " + input.getTitle());
        if (parameters.useMacro && parameters.nameOutput != "") {
            output.setTitle(parameters.nameOutput);
        }
        output.setDisplayRange((double)ToolboxSignal.minimum(y), (double)ToolboxSignal.maximum(y));
        if (!parameters.processMultiFile) {
            output.show();
        }
        log.acknowledge(0);
        log.setProgressLength(100);
        log.appendWithTime("Algorithm \"" + parameters.nameAlgo + "\" finished.", 1);
        return output;
    }

    protected void addTextFieldLine(JPanel panel, int gridy, double weighty, JComponent labelLeft, JComponent textField, JComponent labelRight) {
        this.addTextFieldLine(panel, gridy, weighty, 1, labelLeft, textField, labelRight);
    }

    protected void addTextFieldLine(JPanel panel, int gridy, double weighty, int gridwith, JComponent labelLeft, JComponent textField, JComponent labelRight) {
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridy = gridy;
        this.gbConstraints.weighty = weighty;
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.gridx = 0;
        this.gbConstraints.weightx = 25.0;
        this.gbConstraints.anchor = 18;
        this.gbLayout.setConstraints(labelLeft, this.gbConstraints);
        panel.add(labelLeft);
        if (textField != null) {
            this.gbConstraints.gridx = 1;
            this.gbConstraints.gridwidth = gridwith;
            this.gbConstraints.weightx = 50.0;
            this.gbConstraints.anchor = 11;
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(textField, this.gbConstraints);
            panel.add(textField);
        }
        if (labelRight != null) {
            this.gbConstraints.gridx = 2;
            this.gbConstraints.weightx = 25.0;
            this.gbConstraints.anchor = 18;
            this.gbLayout.setConstraints(labelRight, this.gbConstraints);
            panel.add(labelRight);
        }
    }

    protected void addCheckBoxLine(JPanel panel, int gridy, double weighty, JComponent checkBox, JComponent label, JComponent textField) {
        this.gbConstraints = new GridBagConstraints();
        this.gbConstraints.gridy = gridy;
        this.gbConstraints.weighty = weighty;
        this.gbConstraints.insets = new Insets(5, 5, 5, 5);
        this.gbConstraints.gridx = 0;
        this.gbConstraints.weightx = 30.0;
        this.gbConstraints.anchor = 18;
        this.gbLayout.setConstraints(checkBox, this.gbConstraints);
        panel.add(checkBox);
        this.gbConstraints.gridx = 1;
        this.gbConstraints.weightx = 30.0;
        this.gbConstraints.anchor = 12;
        this.gbLayout.setConstraints(label, this.gbConstraints);
        panel.add(label);
        this.gbConstraints.gridx = 2;
        this.gbConstraints.weightx = 30.0;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.fill = 0;
        this.gbLayout.setConstraints(textField, this.gbConstraints);
        panel.add(textField);
    }

    protected void addComponent(JPanel pn, int gridy, int gridx, int gridwidth, int gridheight, int space, Component comp) {
        this.gbConstraints.anchor = 17;
        this.gbConstraints.gridy = gridy;
        this.gbConstraints.gridx = gridx;
        this.gbConstraints.gridwidth = gridwidth;
        this.gbConstraints.gridheight = gridheight;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        this.gbConstraints.fill = 0;
        this.gbConstraints.insets = new Insets(space, space, space, space);
        this.gbLayout.setConstraints(comp, this.gbConstraints);
        pn.add(comp);
    }

    private void addBorder(Rectangle rect, float p) {
        int borderX = (int)(p * (float)rect.width);
        int borderY = (int)(p * (float)rect.height);
        rect.x -= borderX;
        rect.y -= borderY;
        rect.width += 2 * borderX;
        rect.height += 2 * borderY;
    }

    protected int setImageList(JComboBox cBox) {
        cBox.removeAllItems();
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            cBox.addItem("No images open");
            return 0;
        }
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            cBox.addItem(imp.getTitle());
            ++i;
        }
        return cBox.getItemCount();
    }
}

