/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.Macro;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class Convolution
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JCheckBox jCheckBoxAddPoissonNoise = null;
    private JLabel jLabelGain = null;
    private JTextField jTextFieldGain = null;
    private JCheckBox jCheckBoxAddGaussianNoise = null;
    private JLabel jLabelSigma = null;
    private JTextField jTextFieldSigma = null;
    private JCheckBox jCheckBoxAddBackground = null;
    private JLabel jLabelMu = null;
    private JTextField jTextFieldMu = null;
    private boolean addPoissonNoisedef = false;
    private float gammamin = 0.0f;
    private float gammamax = 65535.0f;
    private float gammadef = 1.0f;
    private boolean addPoissonNoise = this.addPoissonNoisedef;
    private float gamma = this.gammadef;
    private boolean addGaussianNoisedef = false;
    private float sigmamin = 0.0f;
    private float sigmamax = 10000.0f;
    private float sigmadef = 1.0f;
    private boolean addGaussianNoise = this.addGaussianNoisedef;
    private float sigma = this.sigmadef;
    private boolean addBackgrounddef = false;
    private float mumin = 0.0f;
    private float mumax = 1000000.0f;
    private float mudef = 0.0f;
    private boolean addBackground = this.addBackgrounddef;
    private float mu = this.mudef;
    private MyVerifier verifier = new MyVerifier();

    public Convolution() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelConvolution");
        this.jCheckBoxAddPoissonNoise = new JCheckBox();
        this.jLabelGain = new JLabel();
        this.jTextFieldGain = new JTextField();
        this.jCheckBoxAddPoissonNoise.setText("Add Poisson noise");
        this.jCheckBoxAddPoissonNoise.addItemListener(this);
        this.jLabelGain.setText("Gain: ");
        this.jTextFieldGain.setInputVerifier(this.verifier);
        this.jCheckBoxAddGaussianNoise = new JCheckBox();
        this.jLabelSigma = new JLabel();
        this.jTextFieldSigma = new JTextField();
        this.jCheckBoxAddGaussianNoise.setText("Add Gaussian noise");
        this.jCheckBoxAddGaussianNoise.addItemListener(this);
        this.jLabelSigma.setText("Standard deviation: ");
        this.jTextFieldSigma.setInputVerifier(this.verifier);
        this.jCheckBoxAddBackground = new JCheckBox();
        this.jLabelMu = new JLabel();
        this.jTextFieldMu = new JTextField();
        this.jCheckBoxAddBackground.setText("Add background signal");
        this.jCheckBoxAddBackground.addItemListener(this);
        this.jLabelMu.setText("Value: ");
        this.jTextFieldMu.setInputVerifier(this.verifier);
        this.updateGUI();
        this.addCheckBoxLine(this.jPanel, 0, 0.0, this.jCheckBoxAddPoissonNoise, this.jLabelGain, this.jTextFieldGain);
        this.addCheckBoxLine(this.jPanel, 1, 0.0, this.jCheckBoxAddGaussianNoise, this.jLabelSigma, this.jTextFieldSigma);
        this.addCheckBoxLine(this.jPanel, 2, 100.0, this.jCheckBoxAddBackground, this.jLabelMu, this.jTextFieldMu);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Convolution";
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty(String.valueOf(this.getName()) + "AddPoissonNoise", "" + this.addPoissonNoise);
        properties.setProperty(String.valueOf(this.getName()) + "Intensity", "" + this.gamma);
        properties.setProperty(String.valueOf(this.getName()) + "AddGaussianNoise", "" + this.addGaussianNoise);
        properties.setProperty(String.valueOf(this.getName()) + "Sigma", "" + this.sigma);
        properties.setProperty(String.valueOf(this.getName()) + "AddBackground", "" + this.addBackground);
        properties.setProperty(String.valueOf(this.getName()) + "Mu", "" + this.mu);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty(String.valueOf(this.getName()) + "AddPoissonNoise", "" + this.addPoissonNoise);
        this.addPoissonNoise = Boolean.parseBoolean(s);
        s = properties.getProperty(String.valueOf(this.getName()) + "Intensity", "" + this.gamma);
        this.gamma = Float.parseFloat(s);
        s = properties.getProperty(String.valueOf(this.getName()) + "AddGaussianNoise", "" + this.addGaussianNoise);
        this.addGaussianNoise = Boolean.parseBoolean(s);
        s = properties.getProperty(String.valueOf(this.getName()) + "Sigma", "" + this.sigma);
        this.sigma = Float.parseFloat(s);
        s = properties.getProperty(String.valueOf(this.getName()) + "AddBackground", "" + this.addBackground);
        this.addBackground = Boolean.parseBoolean(s);
        s = properties.getProperty(String.valueOf(this.getName()) + "Mu", "" + this.mu);
        this.mu = Float.parseFloat(s);
    }

    @Override
    public void getMacroParameters(String options) {
        this.addPoissonNoise = Boolean.parseBoolean(Macro.getValue((String)options, (String)"addPoissonNoise", (String)Boolean.toString(this.addPoissonNoisedef)));
        this.addGaussianNoise = Boolean.parseBoolean(Macro.getValue((String)options, (String)"addGaussianNoise", (String)Boolean.toString(this.addGaussianNoisedef)));
        this.addBackground = Boolean.parseBoolean(Macro.getValue((String)options, (String)"addBackground", (String)Boolean.toString(this.addBackgrounddef)));
        this.gamma = Float.parseFloat(Macro.getValue((String)options, (String)"gamma", (String)Float.toString(this.gammadef)));
        this.sigma = Float.parseFloat(Macro.getValue((String)options, (String)"sigma", (String)Float.toString(this.sigmadef)));
        this.mu = Float.parseFloat(Macro.getValue((String)options, (String)"mu", (String)Float.toString(this.mudef)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append("Poisson " + this.jLabelGain.getText() + " " + this.addPoissonNoise + " <" + this.gamma + ">", 2);
        log.append("Gaussian " + this.jLabelSigma.getText() + " " + this.addGaussianNoise + " <" + this.sigma + ">", 2);
        log.append("Background " + this.jLabelMu.getText() + " " + this.addBackground + " <" + this.mu + ">", 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.addPoissonNoise = this.jCheckBoxAddPoissonNoise.isSelected();
        this.gamma = Float.parseFloat(this.jTextFieldGain.getText());
        this.addGaussianNoise = this.jCheckBoxAddGaussianNoise.isSelected();
        this.sigma = Float.parseFloat(this.jTextFieldSigma.getText());
        this.addBackground = this.jCheckBoxAddBackground.isSelected();
        this.mu = Float.parseFloat(this.jTextFieldMu.getText());
    }

    @Override
    public void updateGUI() {
        this.jCheckBoxAddPoissonNoise.setSelected(this.addPoissonNoise);
        this.jLabelGain.setEnabled(this.addPoissonNoise);
        this.jTextFieldGain.setEnabled(this.addPoissonNoise);
        this.jTextFieldGain.setText("" + this.gamma);
        this.jCheckBoxAddGaussianNoise.setSelected(this.addGaussianNoise);
        this.jLabelSigma.setEnabled(this.addGaussianNoise);
        this.jTextFieldSigma.setEnabled(this.addGaussianNoise);
        this.jTextFieldSigma.setText("" + this.sigma);
        this.jCheckBoxAddBackground.setSelected(this.addBackground);
        this.jLabelMu.setEnabled(this.addBackground);
        this.jTextFieldMu.setEnabled(this.addBackground);
        this.jTextFieldMu.setText("" + this.mu);
    }

    @Override
    public void reset() {
        this.addPoissonNoise = this.addPoissonNoisedef;
        this.gamma = this.gammadef;
        this.addGaussianNoise = this.addGaussianNoisedef;
        this.sigma = this.sigmadef;
        this.addBackground = this.addBackgrounddef;
        this.mu = this.mudef;
    }

    @Override
    public boolean process(Signal y, Signal h, Signal x, Parameters parameters) {
        float ser;
        IJ.log((String)("process " + parameters.fileWisdom));
        IJ.log((String)("process " + y.array.length + " " + y.N[0] + " " + y.N[1] + " " + y.N[2]));
        IJ.log((String)("process " + h.array.length + " " + h.N[0] + " " + h.N[1] + " " + h.N[2]));
        IJ.log((String)("process " + x.array.length + " " + x.N[0] + " " + x.N[1] + " " + x.N[2]));
        ToolboxFourier fftToolbox = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        if (x != null && parameters.monitorPerf) {
            ser = ToolboxSignal.calculateSER(y, x);
            log.append("SER before convolution: " + ser + " dB.", 1);
        }
        log.start("FFT of input image and PSF", 0);
        fftToolbox.forwardDFT(y);
        fftToolbox.forwardDFT(h);
        log.acknowledge(0);
        log.setProgressLength(40);
        log.start("Filtering", 0);
        if (!ToolboxSignal.multiply(y, h)) {
            return false;
        }
        log.acknowledge(0);
        log.start("Inverse FFT", 0);
        fftToolbox.inverseDFT(y);
        log.acknowledge(0);
        log.setProgressLength(60);
        if (x != null && parameters.monitorPerf) {
            ser = ToolboxSignal.calculateSER(y, x);
            log.append("SER after convolution: " + ser + " dB.", 1);
        }
        if (parameters.saveVideo) {
            log.start("Saving PostConv.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "PostConv");
            log.acknowledge(1);
        }
        if (this.addPoissonNoise) {
            log.start("Adding Poisson noise", 0);
            ToolboxSignal.addNoisePoisson(parameters.useSeed, (long)parameters.seed, y);
            ToolboxSignal.multiplyConstant(y, this.gamma);
            log.setProgressLength(70);
            log.acknowledge(0);
        }
        if (this.addGaussianNoise) {
            log.start("Adding Gaussian noise", 0);
            ToolboxSignal.addNoiseGaussian(parameters.useSeed, (long)parameters.seed, y, this.sigma);
            log.setProgressLength(75);
            log.acknowledge(0);
        }
        if (this.addBackground) {
            log.start("Adding background signal", 0);
            ToolboxSignal.addConstant(y, this.mu, 0.0f);
            log.setProgressLength(80);
            log.acknowledge(0);
        }
        if (x != null && parameters.monitorPerf) {
            ser = ToolboxSignal.calculateSER(y, x);
            log.append("SER after adding noise: " + ser + " dB.", 1);
        }
        if (parameters.saveVideo) {
            log.start("Saving PostConvAddNoise.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "PostConvAddNoise");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    public static boolean convolve(Signal f, Signal h, Signal reference, Parameters parameters) {
        float ser;
        IJ.log((String)("convolve " + parameters.fileWisdom));
        IJ.log((String)("convolve " + f.array.length));
        ToolboxFourier fftToolbox = new ToolboxFourier(f.N, parameters.useFFTW, parameters.fileWisdom);
        if (reference != null && parameters.monitorPerf) {
            log.start("Calculating and saving SER", 0);
            ser = ToolboxSignal.calculateSER(f, reference);
            log.acknowledge(0);
            log.append("SER before convolution: " + ser + "dB.", 1);
        }
        log.start("FFT of input image and PSF", 0);
        fftToolbox.forwardDFT(f);
        fftToolbox.forwardDFT(h);
        log.acknowledge(0);
        log.setProgressLength(40);
        log.start("Filtering", 0);
        if (!ToolboxSignal.multiply(f, h)) {
            return false;
        }
        log.acknowledge(0);
        log.start("Inverse FFT", 0);
        fftToolbox.inverseDFT(f);
        log.acknowledge(0);
        log.setProgressLength(60);
        if (reference != null && parameters.monitorPerf) {
            log.start("Calculating and saving SER", 0);
            ser = ToolboxSignal.calculateSER(f, reference);
            log.acknowledge(0);
            log.append("SER after convolution: " + ser + "dB.", 1);
        }
        if (parameters.saveVideo) {
            log.start("Saving PostConv.tiff", 1);
            ToolboxSignal.save(f, parameters.folderVideo, "PostConv");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable source = event.getItemSelectable();
        if (source == this.jCheckBoxAddPoissonNoise) {
            this.jLabelGain.setEnabled(this.jCheckBoxAddPoissonNoise.isSelected());
            this.jTextFieldGain.setEnabled(this.jCheckBoxAddPoissonNoise.isSelected());
        } else if (source == this.jCheckBoxAddGaussianNoise) {
            this.jLabelSigma.setEnabled(this.jCheckBoxAddGaussianNoise.isSelected());
            this.jTextFieldSigma.setEnabled(this.jCheckBoxAddGaussianNoise.isSelected());
        } else if (source == this.jCheckBoxAddBackground) {
            this.jLabelMu.setEnabled(this.jCheckBoxAddBackground.isSelected());
            this.jTextFieldMu.setEnabled(this.jCheckBoxAddBackground.isSelected());
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == Convolution.this.jTextFieldGain) {
                return this.checkFloatField(Convolution.this.getName(), Convolution.this.jLabelGain.getText(), Convolution.this.jTextFieldGain, Convolution.this.gammamin, Convolution.this.gammamax, Convolution.this.gammadef, changeIt);
            }
            if (input == Convolution.this.jTextFieldSigma) {
                return this.checkFloatField(Convolution.this.getName(), Convolution.this.jLabelSigma.getText(), Convolution.this.jTextFieldSigma, Convolution.this.sigmamin, Convolution.this.sigmamax, Convolution.this.sigmadef, changeIt);
            }
            if (input == Convolution.this.jTextFieldMu) {
                return this.checkFloatField(Convolution.this.getName(), Convolution.this.jLabelMu.getText(), Convolution.this.jTextFieldMu, Convolution.this.mumin, Convolution.this.mumax, Convolution.this.mudef, changeIt);
            }
            return true;
        }
    }
}

