/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.ToolboxWavelet;
import toolbox.gui.AbstractVerifier;

public class ForWaRD
extends AbstractAlgorithm {
    private JPanel jPanel = null;
    private JLabel jLabelTau = null;
    private JTextField jTextFieldTau = null;
    private JLabel jLabelUnitTau = null;
    private JLabel jLabelWIterations = null;
    private JTextField jTextFieldWIterations = null;
    private JLabel jLabelUnitWIterations = null;
    private JLabel jLabelWaveShape = null;
    private JComboBox jComboBoxWaveShape = null;
    private JLabel jLabelWaveShapeUnit = null;
    private JLabel jLabelRegularization = null;
    private JComboBox jComboBoxRegularization = null;
    private JLabel jLabelRegularizationUnit = null;
    private float tau = 1.0f;
    private int wIterations = 1;
    private int waveShape = 0;
    private int regularization = 0;
    private float MIN_TAU = 0.0f;
    private float MAX_TAU = 1000.0f;
    private int MIN_W_ITERATIONS = 1;
    private int MAX_W_ITERATIONS = 20;
    private MyVerifier verifier = new MyVerifier();

    public ForWaRD() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelForWaRD");
        this.jTextFieldTau = new JTextField();
        this.jLabelTau = new JLabel();
        this.jLabelUnitTau = new JLabel();
        this.jTextFieldWIterations = new JTextField();
        this.jLabelWIterations = new JLabel();
        this.jLabelUnitWIterations = new JLabel();
        this.jLabelWaveShape = new JLabel();
        this.jComboBoxWaveShape = new JComboBox<String>(ToolboxWavelet.wavFamily);
        this.jLabelWaveShapeUnit = new JLabel();
        this.jLabelRegularization = new JLabel();
        this.jComboBoxRegularization = new JComboBox();
        this.jLabelRegularizationUnit = new JLabel();
        this.jLabelTau.setText("Tau:");
        this.jLabelWIterations.setText("Wavelet decomposition iterations:");
        this.jTextFieldTau.setText("" + this.tau);
        this.jTextFieldWIterations.setText("" + this.wIterations);
        this.jTextFieldTau.setInputVerifier(this.verifier);
        this.jTextFieldWIterations.setInputVerifier(this.verifier);
        this.jLabelUnitTau.setText("");
        this.jLabelUnitWIterations.setText("");
        this.jLabelWaveShape.setText("Wavelet Family:");
        this.jLabelRegularization.setText("Regularization:");
        this.jComboBoxRegularization.addItem("Constant");
        this.jComboBoxRegularization.addItem("Laplacian");
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelRegularization, this.jComboBoxRegularization, this.jLabelRegularizationUnit);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelTau, this.jTextFieldTau, this.jLabelUnitTau);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelWaveShape, this.jComboBoxWaveShape, this.jLabelWaveShapeUnit);
        this.addTextFieldLine(this.jPanel, 3, 100.0, this.jLabelWIterations, this.jTextFieldWIterations, this.jLabelUnitWIterations);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "ForWaRD";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal reference, Parameters parameters) {
        ToolboxFourier fftToolbox = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        SignalWavelet wTransformTemp = new SignalWavelet(y.N, this.wIterations);
        SignalWavelet wTransform = new SignalWavelet(y.N, this.wIterations);
        ToolboxWavelet wToolbox = new ToolboxWavelet(wTransform, this.waveShape, parameters.useFFTW, parameters.fileWisdom);
        float eta = ToolboxSignal.l1Norm(h);
        eta *= eta;
        log.start("FFT of image and PSF", 0);
        fftToolbox.forwardDFT(y);
        fftToolbox.forwardDFT(h);
        fftToolbox.forwardDFT(reference);
        log.setProgressLength(35);
        Signal gCopy = (Signal)y.clone();
        wToolbox.transform(gCopy, wTransform, 1);
        gCopy = null;
        float sigma = wToolbox.estimateSigma(wTransform);
        log.appendWithTime("sigma = " + sigma, 2);
        log.appendWithTime("eta = " + (eta *= (float)y.length * sigma * sigma / (ToolboxSignal.norm2Difference(y, y.array[0] / (float)y.length) / (float)y.length - (float)y.length * sigma * sigma)), 2);
        Signal inverseFilter = (Signal)h.clone();
        log.appendWithTime("tau = " + this.tau, 2);
        ToolboxSignal.multiplyConj(inverseFilter, h);
        if (this.regularization == 0) {
            ToolboxSignal.addConstant(inverseFilter, this.tau, 0.0f);
        } else if (this.regularization == 1) {
            ToolboxSignal.addLaplacianSquare2D3D(inverseFilter, this.tau);
        }
        ToolboxSignal.inverseStable(inverseFilter, this.tau / 1000.0f);
        ToolboxSignal.multiplyConj(inverseFilter, h);
        ForWaRD.forward(y, inverseFilter, sigma, wTransform, wTransformTemp, wToolbox);
        log.start("Inverse FFT of image", 0);
        fftToolbox.inverseDFT(y);
        log.acknowledge(0);
        log.setProgressLength(80);
        if (parameters.saveVideo) {
            log.start("Saving PostForWaRD.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "PostForWaRD");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    private static void forward(Signal g, Signal inverseFilter, float sigma, SignalWavelet wTransform, SignalWavelet wTransformTemp, ToolboxWavelet wToolbox) {
        int m;
        float[][] sigmaJLDaub2 = new float[wTransform.J][wTransform.M];
        float[][] sigmaJLDaub6 = new float[wTransform.J][wTransform.M];
        float threshFactor = 3.0f;
        ToolboxSignal.multiply(g, inverseFilter);
        Signal inverseFilterCopy = (Signal)inverseFilter.clone();
        wToolbox.transform(inverseFilterCopy, wTransformTemp, wTransformTemp.J);
        inverseFilterCopy = null;
        int j = 0;
        while (j < wTransform.J) {
            m = 0;
            while (m < wTransform.M) {
                sigmaJLDaub6[j][m] = (float)Math.sqrt(ToolboxSignal.norm2(wTransformTemp.w[j][m])) * sigma * (float)Math.pow(2.0, (j + 1) * g.D);
                ++m;
            }
            ++j;
        }
        float sigmaSDaub6 = (float)Math.sqrt(ToolboxSignal.norm2(wTransformTemp.s)) * sigma * (float)Math.pow(2.0, wTransform.J * g.D);
        inverseFilterCopy = (Signal)inverseFilter.clone();
        wToolbox.transform(inverseFilterCopy, wTransform, wTransform.J);
        inverseFilterCopy = null;
        j = 0;
        while (j < wTransform.J) {
            m = 0;
            while (m < wTransform.M) {
                sigmaJLDaub2[j][m] = (float)Math.sqrt(ToolboxSignal.norm2(wTransform.w[j][m])) * sigma * (float)Math.pow(2.0, (j + 1) * g.D);
                ++m;
            }
            ++j;
        }
        float sigmaSDaub2 = (float)Math.sqrt(ToolboxSignal.norm2(wTransform.s)) * sigma * (float)Math.pow(2.0, wTransform.J * g.D);
        Signal gCopy = (Signal)g.clone();
        wToolbox.transform(gCopy, wTransformTemp, wTransformTemp.J);
        gCopy = null;
        j = 0;
        while (j < wTransformTemp.performedIterations) {
            m = 0;
            while (m < wTransformTemp.M) {
                ToolboxSignal.threshold(wTransformTemp.w[j][m], -sigmaJLDaub6[j][m] * threshFactor, sigmaJLDaub6[j][m] * threshFactor);
                ++m;
            }
            ++j;
        }
        ToolboxSignal.threshold(wTransformTemp.s, -sigmaSDaub6 * threshFactor, sigmaSDaub6 * threshFactor);
        wToolbox.transform(g, wTransform, wTransform.J);
        j = 0;
        while (j < wTransform.performedIterations) {
            m = 0;
            while (m < wTransform.M) {
                ForWaRD.oracleShrinkage(wTransform.w[j][m], wTransformTemp.w[j][m], sigmaJLDaub2[j][m]);
                ++m;
            }
            ++j;
        }
        ForWaRD.oracleShrinkage(wTransform.s, wTransformTemp.s, sigmaSDaub2);
        wToolbox.transformInverse(wTransform, g);
    }

    private static void oracleShrinkage(Signal s1, Signal s2, float sigma) {
        int n = 0;
        while (n < s1.extLength) {
            int n2 = n;
            s1.array[n2] = s1.array[n2] * (s2.array[n] * s2.array[n] / (s2.array[n] * s2.array[n] + sigma * sigma));
            ++n;
        }
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("ForWaRDTau", "" + this.tau);
        properties.setProperty("ForWaRDWIterations", "" + this.wIterations);
        properties.setProperty("ForWaRDWaveShape", "" + this.waveShape);
        properties.setProperty("ForWaRDRegularization", "" + this.regularization);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty("ForWaRDTau", "" + this.tau);
        this.tau = Float.parseFloat(s);
        s = properties.getProperty("ForWaRDWIterations", "" + this.wIterations);
        this.wIterations = Integer.parseInt(s);
        s = properties.getProperty("ForWaRDWaveShape", "" + this.waveShape);
        this.waveShape = Integer.parseInt(s);
        s = properties.getProperty("ForWaRDRegularization", "" + this.regularization);
        this.regularization = Integer.parseInt(s);
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("The " + this.getName() + " algorithm cannot be called from a macro."));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
        this.tau = Float.parseFloat(this.jTextFieldTau.getText());
        this.wIterations = Integer.parseInt(this.jTextFieldWIterations.getText());
        this.waveShape = this.jComboBoxWaveShape.getSelectedIndex();
        this.regularization = this.jComboBoxRegularization.getSelectedIndex();
    }

    @Override
    public void updateGUI() {
        this.jTextFieldTau.setText("" + this.tau);
        this.jTextFieldWIterations.setText("" + this.wIterations);
        this.jComboBoxWaveShape.setSelectedIndex(this.waveShape);
        this.jComboBoxRegularization.setSelectedIndex(this.regularization);
    }

    @Override
    public void reset() {
        this.tau = 0.0f;
        this.wIterations = 1;
        this.waveShape = 0;
        this.regularization = 0;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == ForWaRD.this.jTextFieldTau) {
                return this.checkFloatField(ForWaRD.this.getName(), ForWaRD.this.jLabelTau.getText(), ForWaRD.this.jTextFieldTau, ForWaRD.this.MIN_TAU, ForWaRD.this.MAX_TAU, 0.0f, changeIt);
            }
            if (input == ForWaRD.this.jTextFieldWIterations) {
                return this.checkIntField(ForWaRD.this.getName(), ForWaRD.this.jLabelWIterations.getText(), ForWaRD.this.jTextFieldWIterations, ForWaRD.this.MIN_W_ITERATIONS, ForWaRD.this.MAX_W_ITERATIONS, 1, changeIt);
            }
            return true;
        }
    }
}

