/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.MatlabWriter;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class Gold
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelIterations = null;
    private JLabel jLabelUnitIterations = null;
    private JTextField jTextFieldIterations = null;
    private JLabel jLabelFrequency = null;
    private JLabel jLabelUnitFrequency = null;
    private JTextField jTextFieldFrequency = null;
    private JLabel jLabelSigma = null;
    private JLabel jLabelUnitSigma = null;
    private JTextField jTextFieldSigma = null;
    private JLabel jLabelComboBoxSmoothingMode = null;
    private JComboBox jComboBoxSmoothingMode = null;
    private JComboBox jComboBoxImage = null;
    private JLabel jLabelComboBoxImage = null;
    private JCheckBox jCheckBoxImage = null;
    public int iterations = 10;
    public int frequency = 4;
    public float sigma = 0.8f;
    public String initialImage = null;
    public boolean useInitialImage = false;
    public int smoothingMode = 0;
    private int MIN_ITERATIONS = 1;
    private int MAX_ITERATIONS = 1000000;
    private int MIN_FREQUENCY = 0;
    private int MAX_FREQUENCY = 1000000;
    private float MIN_SIGMA = 0.3f;
    private float MAX_SIGMA = 1000000.0f;
    private MyVerifier verifier = new MyVerifier();

    public Gold() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelGold");
        this.jLabelIterations = new JLabel();
        this.jLabelFrequency = new JLabel();
        this.jLabelSigma = new JLabel();
        this.jLabelUnitIterations = new JLabel();
        this.jLabelUnitFrequency = new JLabel();
        this.jLabelUnitSigma = new JLabel();
        this.jLabelComboBoxSmoothingMode = new JLabel();
        this.jTextFieldIterations = new JTextField();
        this.jTextFieldFrequency = new JTextField();
        this.jTextFieldSigma = new JTextField();
        this.jComboBoxSmoothingMode = new JComboBox();
        this.jLabelIterations.setText("Number of Iterations:");
        this.jLabelUnitIterations.setText("");
        this.jTextFieldIterations.setText("" + this.iterations);
        this.jTextFieldIterations.setInputVerifier(this.verifier);
        this.jLabelFrequency.setText("Smoothing Frequency:");
        this.jLabelUnitFrequency.setText("");
        this.jTextFieldFrequency.setText("" + this.frequency);
        this.jTextFieldFrequency.setInputVerifier(this.verifier);
        this.jLabelSigma.setText("Sigma:");
        this.jLabelUnitSigma.setText("");
        this.jTextFieldSigma.setText("" + this.sigma);
        this.jTextFieldSigma.setInputVerifier(this.verifier);
        this.jLabelComboBoxSmoothingMode.setText("Smoothing Mode:");
        this.jComboBoxSmoothingMode.addItem("2D Gaussian");
        this.jComboBoxSmoothingMode.addItem("3D Gaussian");
        this.jComboBoxSmoothingMode.setSelectedIndex(0);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelIterations, this.jTextFieldIterations, this.jLabelUnitIterations);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelFrequency, this.jTextFieldFrequency, this.jLabelUnitFrequency);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelSigma, this.jTextFieldSigma, this.jLabelUnitSigma);
        this.addComponent(this.jPanel, 3, 0, 1, 1, 5, this.jLabelComboBoxSmoothingMode);
        this.addComponent(this.jPanel, 3, 1, 2, 1, 5, this.jComboBoxSmoothingMode);
        this.jLabelComboBoxImage = new JLabel();
        this.jLabelComboBoxImage.setText("Initial estimate: ");
        this.jComboBoxImage = new JComboBox();
        super.setImageList(this.jComboBoxImage);
        this.jComboBoxImage.setSelectedIndex(0);
        this.jCheckBoxImage = new JCheckBox();
        this.jCheckBoxImage.setText("Use input image");
        this.jCheckBoxImage.setSelected(false);
        this.jCheckBoxImage.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 4, 100.0, this.jLabelComboBoxImage, this.jComboBoxImage, this.jCheckBoxImage);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Gold";
    }

    @Override
    public boolean process(Signal g, Signal H, Signal reference, Parameters parameters) {
        ToolboxFourier fftToolbox = new ToolboxFourier(g.N, parameters.useFFTW, parameters.fileWisdom);
        ToolboxFourier fftTB2D = null;
        MatlabWriter serWriter = null;
        MatlabWriter timeWriter = null;
        Signal gmes = null;
        Signal oldG = null;
        Signal gauss = null;
        float initialSER = 0.0f;
        int[] gaussDim = new int[2];
        if (reference != null && parameters.monitorPerf) {
            serWriter = new MatlabWriter(parameters.folderPerfMon, "Gold");
            serWriter.openFile();
            serWriter.newArray("serGold");
            initialSER = ToolboxSignal.calculateSER(g, reference);
            log.append("Initial SER: " + initialSER + " dB.", 1);
            timeWriter = new MatlabWriter(parameters.folderPerfMon, "goldTime");
            timeWriter.openFile();
            timeWriter.newArray("timeGold");
        }
        if (g.D != 2 && g.D != 3) {
            IJ.error((String)"Only 2D or 3D images please.");
            return false;
        }
        if (this.smoothingMode == 0) {
            int offset = g.D == 2 ? 0 : 1;
            gaussDim[0] = g.N[offset + 0];
            gaussDim[1] = g.N[offset + 1];
            gauss = new Signal(gaussDim);
            fftTB2D = new ToolboxFourier(gauss.N, parameters.useFFTW, parameters.fileWisdom);
            ToolboxSignal.gaussian2D3D(gauss, this.sigma);
            ToolboxSignal.multiplyConstant(gauss, 1.0f / ToolboxSignal.sum(gauss));
            fftTB2D.forwardDFT(gauss);
        } else if (this.smoothingMode == 1) {
            gauss = new Signal(g.N);
            ToolboxSignal.gaussian2D3D(gauss, this.sigma);
            ToolboxSignal.multiplyConstant(gauss, 1.0f / ToolboxSignal.sum(gauss));
            fftToolbox.forwardDFT(gauss);
        }
        log.append("positivity constraint active", 0);
        ToolboxSignal.minConstraint(g, 0.0f, false, fftToolbox);
        log.start("Preparing temporary objects", 0);
        gmes = (Signal)g.clone();
        if (this.useInitialImage) {
            ImagePlus newInit = WindowManager.getImage((String)this.initialImage);
            if (newInit == null) {
                IJ.error((String)("Initial image \"" + this.initialImage + "\" was not found."));
            } else {
                Signal newG = new Signal(newInit);
                if (!ToolboxSignal.checkCompatibility(g, newG)) {
                    IJ.error((String)("Initial image \"" + this.initialImage + " is of incompatible size.\nThis means that it is" + " either of different dimension (e.g. a 2D instead of 3D )" + " \nor of different size"));
                } else {
                    ToolboxSignal.transfer(g, newG);
                    log.append("New initial image: " + this.initialImage, 0);
                }
            }
            System.gc();
        }
        if (this.smoothingMode == 0) {
            ToolboxSignal.filterBy2D(g, gauss, fftTB2D);
            ToolboxSignal.minConstraint(g, 0.0f, true, fftTB2D);
            oldG = (Signal)g.clone();
            fftToolbox.forwardDFT(g);
        } else if (this.smoothingMode == 1) {
            fftToolbox.forwardDFT(g);
            ToolboxSignal.multiply(g, gauss);
            oldG = (Signal)g.clone();
            fftToolbox.inverseDFT(oldG);
        }
        fftToolbox.forwardDFT(H);
        fftToolbox.forwardDFT(gmes);
        ToolboxSignal.multiplyConj(gmes, H);
        fftToolbox.inverseDFT(gmes);
        ToolboxSignal.module2(H);
        log.setProgressLength(40);
        log.acknowledge(0);
        int i = 1;
        while (i <= this.iterations) {
            if (!ToolboxSignal.multiply(g, H)) {
                IJ.error((String)"error1");
            }
            fftToolbox.inverseDFT(g);
            if (!ToolboxSignal.divideStable2(oldG, g, 1.0E-7f)) {
                IJ.error((String)"error2");
            }
            if (!ToolboxSignal.multiply(g, gmes)) {
                IJ.error((String)"error3");
            }
            if (this.smoothingMode == 0) {
                if (this.frequency > 0 && i % this.frequency == 0) {
                    ToolboxSignal.filterBy2D(g, gauss, fftTB2D);
                }
                ToolboxSignal.copy(oldG, g);
                fftToolbox.forwardDFT(g);
            } else if (this.smoothingMode == 1) {
                if (this.frequency > 0 && i % this.frequency == 0) {
                    fftToolbox.forwardDFT(g);
                    ToolboxSignal.multiply(g, gauss);
                    ToolboxSignal.copy(oldG, g);
                    fftToolbox.inverseDFT(oldG);
                } else {
                    ToolboxSignal.copy(oldG, g);
                    fftToolbox.forwardDFT(g);
                }
            }
            log.appendWithTime("Iteration " + i + " completed.", 1);
            log.setProgressLength(40 + (int)((double)(55 * i) / (double)this.iterations));
            if (reference != null && parameters.monitorPerf) {
                float gain = ToolboxSignal.calculateSER(oldG, reference) - initialSER;
                serWriter.addValue(gain);
                log.append("SER gain after iteration " + i + ": " + gain + " dB.", 1);
                timeWriter.addValue(log.getElapsedTime());
            }
            if (parameters.saveVideo) {
                log.start("Saving GoldIter" + i + ".tiff", 1);
                ToolboxSignal.save(oldG, parameters.folderVideo, "GoldIter" + i);
                log.acknowledge(1);
            }
            ++i;
        }
        fftToolbox.inverseDFT(g);
        if (reference != null && parameters.monitorPerf) {
            serWriter.closeFile();
            timeWriter.closeFile();
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("GoldIterations", "" + this.iterations);
        properties.setProperty("GoldFrequency", "" + this.frequency);
        properties.setProperty("GoldSigma", "" + this.sigma);
        properties.setProperty("GoldInitialImage", this.initialImage);
        properties.setProperty("GoldUseInitialImage", "" + this.useInitialImage);
        properties.setProperty("GoldSmoothingMode", "" + this.smoothingMode);
    }

    @Override
    public void loadParameters(Properties properties) {
        this.iterations = Integer.parseInt(properties.getProperty("GoldIterations", "" + this.iterations));
        this.frequency = Integer.parseInt(properties.getProperty("GoldFrequency", "" + this.frequency));
        this.sigma = Float.parseFloat(properties.getProperty("GoldSigma", "" + this.sigma));
        this.initialImage = properties.getProperty("GoldInitialImage", this.initialImage);
        this.useInitialImage = Boolean.parseBoolean(properties.getProperty("GoldUseInitialImage", "" + this.useInitialImage));
        this.smoothingMode = Integer.parseInt(properties.getProperty("GoldSmoothingMode", "" + this.smoothingMode));
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("The " + this.getName() + " algorithm cannot be called from a macro."));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
        this.iterations = Integer.parseInt(this.jTextFieldIterations.getText());
        this.frequency = Integer.parseInt(this.jTextFieldFrequency.getText());
        this.sigma = Float.parseFloat(this.jTextFieldSigma.getText());
        this.initialImage = (String)this.jComboBoxImage.getSelectedItem();
        this.useInitialImage = !this.jCheckBoxImage.isSelected();
        this.smoothingMode = this.jComboBoxSmoothingMode.getSelectedIndex();
    }

    @Override
    public void updateGUI() {
        this.jTextFieldIterations.setText("" + this.iterations);
        this.jTextFieldFrequency.setText("" + this.frequency);
        this.jTextFieldSigma.setText("" + this.sigma);
        this.jComboBoxImage.setSelectedItem(this.initialImage);
        this.jCheckBoxImage.setSelected(!this.useInitialImage);
        this.jComboBoxSmoothingMode.setSelectedIndex(this.smoothingMode);
    }

    @Override
    public void reset() {
        this.iterations = 15;
        this.frequency = 4;
        this.sigma = 0.8f;
        this.initialImage = "";
        this.useInitialImage = false;
        this.smoothingMode = 0;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.jCheckBoxImage) {
            super.setImageList(this.jComboBoxImage);
            this.jComboBoxImage.setSelectedItem(this.initialImage);
            this.jComboBoxImage.setEnabled(!this.jCheckBoxImage.isSelected());
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == Gold.this.jTextFieldIterations) {
                return this.checkIntField(Gold.this.getName(), Gold.this.jLabelIterations.getText(), Gold.this.jTextFieldIterations, Gold.this.MIN_ITERATIONS, Gold.this.MAX_ITERATIONS, 10, changeIt);
            }
            if (input == Gold.this.jTextFieldFrequency) {
                return this.checkIntField(Gold.this.getName(), Gold.this.jLabelFrequency.getText(), Gold.this.jTextFieldFrequency, Gold.this.MIN_FREQUENCY, Gold.this.MAX_FREQUENCY, 4, changeIt);
            }
            if (input == Gold.this.jTextFieldSigma) {
                return this.checkFloatField(Gold.this.getName(), Gold.this.jLabelSigma.getText(), Gold.this.jTextFieldSigma, Gold.this.MIN_SIGMA, Gold.this.MAX_SIGMA, 1.0f, changeIt);
            }
            return true;
        }
    }
}

