/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.Macro;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class InverseFiltering
extends AbstractAlgorithm {
    private JPanel jPanel = null;
    private JLabel jLabelThreshold = null;
    private JTextField jTextFieldEpsilon = null;
    private static final float epsilonmin = 0.0f;
    private static final float epsilonmax = 1000000.0f;
    private static final float epsilondef = 1.0E-6f;
    public float epsilon = 1.0E-6f;
    private MyVerifier verifier = new MyVerifier();

    public InverseFiltering() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelInverseFiltering");
        this.jLabelThreshold = new JLabel("Threshold:");
        this.jTextFieldEpsilon = new JTextField(Float.toString(this.epsilon));
        this.jTextFieldEpsilon.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 0, 1.0, this.jLabelThreshold, this.jTextFieldEpsilon, null);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Inverse filtering";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        float serref = 0.0f;
        if (xorig != null && parameters.monitorPerf) {
            this.serg = new float[2];
            this.serg[0] = 0.0f;
            serref = ToolboxSignal.calculateSER(y, xorig);
            this.time = new float[2];
            this.time[0] = log.getElapsedTime();
        }
        log.start("FFT of image and PSF", 0);
        tbFourier.forwardDFT(y);
        log.setProgressLength(30);
        tbFourier.forwardDFT(h);
        log.acknowledge(0);
        log.setProgressLength(40);
        log.start("Division", 0);
        ToolboxSignal.divideStable(y, h, this.epsilon);
        log.acknowledge(0);
        log.setProgressLength(60);
        log.start("Inverse FFT", 0);
        tbFourier.inverseDFT(y);
        log.acknowledge(0);
        log.setProgressLength(80);
        if (xorig != null && parameters.monitorPerf) {
            this.time[1] = log.getElapsedTime();
            this.serg[1] = ToolboxSignal.calculateSER(y, xorig) - serref;
        }
        if (parameters.saveVideo) {
            log.start("Saving PostInvDeconv.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "PostInvDeconv");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
        this.epsilon = param;
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("InverseFilteringEpsilon", Float.toString(this.epsilon));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.epsilon = Float.parseFloat(properties.getProperty("InverseFilteringEpsilon", Float.toString(this.epsilon)));
    }

    @Override
    public void getMacroParameters(String options) {
        this.epsilon = Float.parseFloat(Macro.getValue((String)options, (String)"epsilon", (String)Float.toString(1.0E-6f)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append("epsilon: " + this.epsilon, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.epsilon = Float.parseFloat(this.jTextFieldEpsilon.getText());
    }

    @Override
    public void updateGUI() {
        this.jTextFieldEpsilon.setText("" + this.epsilon);
    }

    @Override
    public void reset() {
        this.epsilon = 1.0E-6f;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == InverseFiltering.this.jTextFieldEpsilon) {
                return this.checkFloatField(InverseFiltering.this.getName(), InverseFiltering.this.jLabelThreshold.getText(), InverseFiltering.this.jTextFieldEpsilon, 0.0f, 1000000.0f, 1.0E-6f, changeIt);
            }
            return true;
        }
    }
}

