/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class Landweber
extends AbstractAlgorithm
implements ActionListener,
ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelInitialEst = null;
    private JComboBox jComboBoxInitialEst = null;
    private JCheckBox jCheckBoxUseInputImg = null;
    private static final String initialEstdef = new String();
    public String initialEst = initialEstdef;
    private static final boolean useInputImgdef = true;
    public boolean useInputImg = true;
    private JLabel jLabelNumIter = null;
    private JTextField jTextFieldNumIter = null;
    private static final int Kmin = 1;
    private static final int Kmax = 1000000;
    private static final int Kdef = 10;
    public int K = 10;
    private JLabel jLabelStepSize = null;
    private JTextField jTextFieldStepSize = null;
    private JCheckBox jCheckBoxOptStepSize = null;
    private static final float taumin = 0.0f;
    private static final float taumax = 1000000.0f;
    private static final float taudef = 1.0f;
    public float tau = 1.0f;
    private static final boolean autoStepSizedef = true;
    public boolean autoStepSize = true;
    private JLabel jLabelMiscOptions = null;
    private JCheckBox jCheckBoxOneGo = null;
    private JCheckBox jCheckBoxPosConstraint = null;
    private static final boolean oneGodef = false;
    public boolean oneGo = false;
    private static final boolean posConstraintdef = false;
    public boolean posConstraint = false;
    private JLabel jLabelStopCrit = null;
    private JComboBox jComboBoxStopCrit = null;
    private static final int FIXEDNUMITER = 0;
    private static final int RESIDUAL = 1;
    private static final int UPDATE = 2;
    private static final int stopCritdef = 0;
    public int stopCrit = 0;
    private JLabel jLabelStopCritName = null;
    private JTextField jTextFieldStopCritValue = null;
    private JCheckBox jCheckBoxStopCritOption = null;
    private static final float sigmamin = 0.0f;
    private static final float sigmamax = 1000.0f;
    private static final float sigmadef = 1.0f;
    public float sigma = 1.0f;
    private static final boolean estimateSigmadef = false;
    public boolean estimateSigma = false;
    private static final float tolerancemin = 0.0f;
    private static final float tolerancemax = 1.0f;
    private static final float tolerancedef = 0.001f;
    public float tolerance = 0.001f;
    private MyVerifier verifier = new MyVerifier();

    public Landweber() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelLandweber");
        this.jLabelInitialEst = new JLabel("Initial estimate:");
        this.jComboBoxInitialEst = new JComboBox();
        super.setImageList(this.jComboBoxInitialEst);
        this.jComboBoxInitialEst.setEnabled(!this.useInputImg);
        this.jCheckBoxUseInputImg = new JCheckBox("Use input image", this.useInputImg);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jCheckBoxUseInputImg.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelInitialEst, this.jComboBoxInitialEst, this.jCheckBoxUseInputImg);
        this.jLabelNumIter = new JLabel("Number of iterations (maximum):");
        this.jTextFieldNumIter = new JTextField(Integer.toString(this.K));
        this.jTextFieldNumIter.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelNumIter, this.jTextFieldNumIter, null);
        this.jLabelStepSize = new JLabel("Step size:");
        this.jTextFieldStepSize = new JTextField(Float.toString(this.tau));
        this.jTextFieldStepSize.setInputVerifier(this.verifier);
        this.jTextFieldStepSize.setEnabled(!this.autoStepSize);
        this.jCheckBoxOptStepSize = new JCheckBox("Auto-adjust step size", this.autoStepSize);
        this.jCheckBoxOptStepSize.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelStepSize, this.jTextFieldStepSize, this.jCheckBoxOptStepSize);
        this.jLabelMiscOptions = new JLabel("Iteration options (exclusive):");
        this.jCheckBoxOneGo = new JCheckBox("Fixed number of iterations in one go", this.oneGo);
        this.jCheckBoxOneGo.addItemListener(this);
        this.jCheckBoxPosConstraint = new JCheckBox("Positivity constraint", this.posConstraint);
        this.jCheckBoxPosConstraint.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 3, 0.0, this.jLabelMiscOptions, this.jCheckBoxOneGo, this.jCheckBoxPosConstraint);
        this.jLabelStopCrit = new JLabel("Early-stopping criterion:");
        this.jComboBoxStopCrit = new JComboBox();
        this.jComboBoxStopCrit.addItem("None (fixed number of iterations)");
        this.jComboBoxStopCrit.addItem("StdDev of residual < StdDev of noise");
        this.jComboBoxStopCrit.addItem("Norm of update / Norm of estimate < Tolerance");
        this.jComboBoxStopCrit.setSelectedIndex(this.stopCrit);
        this.jComboBoxStopCrit.addActionListener(this);
        this.addTextFieldLine(this.jPanel, 4, 0.0, 2, this.jLabelStopCrit, this.jComboBoxStopCrit, null);
        this.jLabelStopCritName = new JLabel();
        this.jTextFieldStopCritValue = new JTextField();
        this.jTextFieldStopCritValue.setVisible(false);
        this.jTextFieldStopCritValue.setInputVerifier(this.verifier);
        this.jCheckBoxStopCritOption = new JCheckBox();
        this.jCheckBoxStopCritOption.setVisible(false);
        this.jCheckBoxStopCritOption.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 5, 1.0, this.jLabelStopCritName, this.jTextFieldStopCritValue, this.jCheckBoxStopCritOption);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Landweber";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        int k = 0;
        float serref = 0.0f;
        Signal hbkp = null;
        Signal ybkp = null;
        if (xorig != null && parameters.monitorPerf) {
            if (this.oneGo) {
                this.serg = new float[2];
                this.time = new float[2];
            } else {
                this.serg = new float[this.K + 1];
                this.time = new float[this.K + 1];
            }
            serref = ToolboxSignal.calculateSER(y, xorig);
            tbFourier.forwardDFT(xorig);
        }
        log.start("FFT of input image and PSF", 0);
        tbFourier.forwardDFT(y);
        tbFourier.forwardDFT(h);
        log.acknowledge(0);
        log.setProgressLength(30);
        if (this.stopCrit == 1) {
            hbkp = (Signal)h.clone();
            ybkp = (Signal)y.clone();
            if (this.estimateSigma) {
                this.sigma = ToolboxSignal.estimateSigma(y, parameters.useFFTW, parameters.fileWisdom);
                log.append("Estimated standard deviation of noise: " + this.sigma, 2);
            }
        }
        Signal b = (Signal)h.clone();
        ToolboxSignal.conjugate(b);
        ToolboxSignal.multiply(b, y);
        log.setProgressLength(33);
        ToolboxSignal.multiplyConj(h, h);
        if (this.autoStepSize) {
            this.tau = 2.0f / (ToolboxSignal.minimum(h) + ToolboxSignal.maximum(h));
            log.append("Step-size value: " + this.tau, 1);
        }
        ToolboxSignal.multiplyConstant(b, this.tau);
        log.setProgressLength(35);
        ToolboxSignal.multiplyConstant(h, -this.tau);
        ToolboxSignal.addConstant(h, 1.0f, 0.0f);
        log.setProgressLength(40);
        if (!this.useInputImg) {
            ImagePlus newInit = WindowManager.getImage((String)this.initialEst);
            if (newInit == null) {
                IJ.error((String)("Initial estimate \"" + this.initialEst + "\" was not found.\n" + "Using input image instead."));
            } else {
                Signal ynew = new Signal(newInit);
                tbFourier.forwardDFT(ynew);
                if (!ToolboxSignal.checkCompatibility(y, ynew)) {
                    IJ.error((String)("Initial estimate \"" + this.initialEst + "\" does not\n" + "have the same size as the input image. Using\n" + "input image instead."));
                } else {
                    ToolboxSignal.transfer(y, ynew);
                    log.append("Initial estimate: " + this.initialEst, 0);
                }
            }
        }
        if (xorig != null && parameters.monitorPerf) {
            this.serg[0] = ToolboxSignal.calculateSER(y, xorig) - serref;
            this.time[0] = log.getElapsedTime();
        }
        if (this.oneGo) {
            Signal hClone = (Signal)h.clone();
            ToolboxSignal.pow(h, this.K);
            ToolboxSignal.multiply(y, h);
            ToolboxSignal.addConstant(h, -1.0f, 0.0f);
            ToolboxSignal.addConstant(hClone, -1.0f, 0.0f);
            log.setProgressLength(60);
            ToolboxSignal.divideStable(h, hClone, 1.0E-7f);
            hClone = null;
            ToolboxSignal.multiply(h, b);
            ToolboxSignal.add(y, h);
            b = null;
            log.setProgressLength(80);
            if (xorig != null && parameters.monitorPerf) {
                this.time[1] = log.getElapsedTime();
                this.serg[1] = ToolboxSignal.calculateSER(y, xorig) - serref;
            }
        } else {
            k = 1;
            while (k <= this.K) {
                ToolboxSignal.multiply(y, h);
                ToolboxSignal.add(y, b);
                if (this.posConstraint) {
                    log.append("Applying positivity constraint", 0);
                    ToolboxSignal.minConstraint(y, 0.0f, false, tbFourier);
                }
                log.appendWithTime("Iteration " + k + " completed.", 1);
                log.setProgressLength(40 + (int)((double)(55 * k) / (double)this.K));
                if (xorig != null && parameters.monitorPerf) {
                    this.time[k] = log.getElapsedTime();
                    this.serg[k] = ToolboxSignal.calculateSER(y, xorig) - serref;
                }
                if (parameters.saveVideo) {
                    log.start("Saving LandweberIter" + k + ".tiff", 1);
                    if (!y.isReal) {
                        tbFourier.inverseDFT(y);
                    }
                    ToolboxSignal.save(y, parameters.folderVideo, "LandweberIter" + k);
                    if (y.isReal) {
                        tbFourier.forwardDFT(y);
                    }
                    log.acknowledge(1);
                }
                if (this.stopCrit == 1) {
                    Signal hx = (Signal)y.clone();
                    ToolboxSignal.multiply(hx, hbkp);
                    if (Math.sqrt(ToolboxSignal.norm2Difference(ybkp, hx) / (double)hx.length) < (double)this.sigma) {
                        log.append("Early stopping", 0);
                        break;
                    }
                } else if (this.stopCrit == 2 && Math.sqrt(ToolboxSignal.norm2Difference(y, ybkp) / ToolboxSignal.norm2(y)) < (double)this.tolerance) {
                    log.append("Early stopping", 0);
                    break;
                }
                ++k;
            }
        }
        if (xorig != null && parameters.monitorPerf && !this.oneGo && k < this.K) {
            float[] sergtmp = new float[k + 1];
            float[] timetmp = new float[k + 1];
            k = 0;
            while (k < sergtmp.length) {
                sergtmp[k] = this.serg[k];
                timetmp[k] = this.time[k];
                ++k;
            }
            this.serg = sergtmp;
            this.time = timetmp;
        }
        tbFourier.inverseDFT(y);
        if (this.oneGo & parameters.saveVideo) {
            log.start("Saving LandweberOneGo.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "LandweberOneGo");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("Landweber|initialEst", this.initialEst);
        properties.setProperty("Landweber|useInputImg", Boolean.toString(this.useInputImg));
        properties.setProperty("Landweber|K", Integer.toString(this.K));
        properties.setProperty("Landweber|tau", Float.toString(this.tau));
        properties.setProperty("Landweber|autoStepSize", Boolean.toString(this.autoStepSize));
        properties.setProperty("Landweber|oneGo", Boolean.toString(this.oneGo));
        properties.setProperty("Landweber|posConstraint", Boolean.toString(this.posConstraint));
        properties.setProperty("Landweber|stopCrit", Integer.toString(this.stopCrit));
        properties.setProperty("Landweber|sigma", Float.toString(this.sigma));
        properties.setProperty("Landweber|estimateSigma", Boolean.toString(this.estimateSigma));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.initialEst = properties.getProperty("Landweber|initialEst", initialEstdef);
        this.useInputImg = Boolean.parseBoolean(properties.getProperty("Landweber|useInputImg", "true"));
        this.K = Integer.parseInt(properties.getProperty("Landweber|K", "10"));
        this.tau = Float.parseFloat(properties.getProperty("Landweber|tau", "1.0"));
        this.autoStepSize = Boolean.parseBoolean(properties.getProperty("Landweber|autoStepSize", "true"));
        this.oneGo = Boolean.parseBoolean(properties.getProperty("Landweber|oneGo", "false"));
        this.posConstraint = Boolean.parseBoolean(properties.getProperty("Landweber|posConstraint", "false"));
        this.stopCrit = Integer.parseInt(properties.getProperty("Landweber|stopCrit", "0"));
        this.sigma = Float.parseFloat(properties.getProperty("Landweber|sigma", "1.0"));
        this.estimateSigma = Boolean.parseBoolean(properties.getProperty("Landweber|estimateSigma", "false"));
    }

    @Override
    public void getMacroParameters(String options) {
        this.initialEst = Macro.getValue((String)options, (String)"initialEst", (String)initialEstdef);
        this.useInputImg = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useInputImg", (String)Boolean.toString(true)));
        this.K = Integer.parseInt(Macro.getValue((String)options, (String)"K", (String)Integer.toString(10)));
        this.tau = Float.parseFloat(Macro.getValue((String)options, (String)"tau", (String)Float.toString(1.0f)));
        this.autoStepSize = Boolean.parseBoolean(Macro.getValue((String)options, (String)"autoStepSize", (String)Boolean.toString(true)));
        this.oneGo = Boolean.parseBoolean(Macro.getValue((String)options, (String)"oneGo", (String)Boolean.toString(false)));
        this.posConstraint = Boolean.parseBoolean(Macro.getValue((String)options, (String)"posConstraint", (String)Boolean.toString(false)));
        this.stopCrit = Integer.parseInt(Macro.getValue((String)options, (String)"stopCrit", (String)Integer.toString(0)));
        this.sigma = Float.parseFloat(Macro.getValue((String)options, (String)"sigma", (String)Float.toString(1.0f)));
        this.estimateSigma = Boolean.parseBoolean(Macro.getValue((String)options, (String)"estimateSigma", (String)Boolean.toString(false)));
        this.tolerance = Float.parseFloat(Macro.getValue((String)options, (String)"tolerance", (String)Float.toString(0.001f)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append("initialEst: " + this.initialEst, 2);
        log.append("useInputImg: " + this.useInputImg, 2);
        log.append(String.valueOf(this.jLabelNumIter.getText()) + " (K) " + this.K, 2);
        log.append(String.valueOf(this.jLabelStepSize.getText()) + " (tau) " + this.tau, 2);
        log.append("autoStepSize: " + this.autoStepSize, 2);
        log.append("oneGo: " + this.oneGo, 2);
        log.append("posConstraint: " + this.posConstraint, 2);
        log.append(String.valueOf(this.jLabelStopCrit.getText()) + " (stopCrit) " + this.stopCrit, 2);
        log.append("sigma: " + this.sigma, 2);
        log.append("estimateSigma: " + this.estimateSigma, 2);
        log.append("tolerance: " + this.tolerance, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.initialEst = (String)this.jComboBoxInitialEst.getSelectedItem();
        this.useInputImg = this.jCheckBoxUseInputImg.isSelected();
        this.K = Integer.parseInt(this.jTextFieldNumIter.getText());
        this.tau = Float.parseFloat(this.jTextFieldStepSize.getText());
        this.oneGo = this.jCheckBoxOneGo.isSelected();
        this.posConstraint = this.jCheckBoxPosConstraint.isSelected();
        this.autoStepSize = this.jCheckBoxOptStepSize.isSelected();
        this.stopCrit = this.jComboBoxStopCrit.getSelectedIndex();
        switch (this.stopCrit) {
            case 1: {
                this.sigma = Float.parseFloat(this.jTextFieldStopCritValue.getText());
                this.estimateSigma = this.jCheckBoxStopCritOption.isSelected();
                break;
            }
            case 2: {
                this.tolerance = Float.parseFloat(this.jTextFieldStopCritValue.getText());
            }
        }
    }

    @Override
    public void updateGUI() {
        this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jTextFieldNumIter.setText(Integer.toString(this.K));
        this.jTextFieldStepSize.setText(Float.toString(this.tau));
        this.jCheckBoxOptStepSize.setSelected(this.autoStepSize);
        this.jCheckBoxOneGo.setSelected(this.oneGo);
        this.jCheckBoxPosConstraint.setSelected(this.posConstraint);
        this.jComboBoxStopCrit.setSelectedIndex(this.stopCrit);
        switch (this.stopCrit) {
            case 1: {
                this.jTextFieldStopCritValue.setText(Float.toString(this.sigma));
                this.jCheckBoxStopCritOption.setSelected(this.estimateSigma);
                break;
            }
            case 2: {
                this.jTextFieldStopCritValue.setText(Float.toString(this.tolerance));
            }
        }
    }

    @Override
    public void reset() {
        this.initialEst = initialEstdef;
        this.useInputImg = true;
        this.K = 10;
        this.tau = 1.0f;
        this.autoStepSize = true;
        this.oneGo = false;
        this.posConstraint = false;
        this.stopCrit = 0;
        this.sigma = 1.0f;
        this.estimateSigma = false;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable src = event.getItemSelectable();
        if (src == this.jCheckBoxUseInputImg) {
            super.setImageList(this.jComboBoxInitialEst);
            this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
            this.jComboBoxInitialEst.setEnabled(!this.jCheckBoxUseInputImg.isSelected());
        } else if (src == this.jCheckBoxOptStepSize) {
            this.jTextFieldStepSize.setEnabled(!this.jCheckBoxOptStepSize.isSelected());
        } else if (src == this.jCheckBoxOneGo && this.jCheckBoxOneGo.isSelected()) {
            this.jComboBoxStopCrit.setSelectedIndex(0);
            this.jCheckBoxPosConstraint.setSelected(false);
        } else if (src == this.jCheckBoxPosConstraint) {
            if (this.jCheckBoxPosConstraint.isSelected()) {
                this.jCheckBoxOneGo.setSelected(false);
            }
        } else if (event.getItemSelectable() == this.jCheckBoxStopCritOption) {
            this.jTextFieldStopCritValue.setEnabled(!this.jCheckBoxStopCritOption.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.jComboBoxStopCrit) {
            switch (this.jComboBoxStopCrit.getSelectedIndex()) {
                case 0: {
                    this.jLabelStopCritName.setVisible(true);
                    this.jTextFieldStopCritValue.setVisible(false);
                    this.jCheckBoxStopCritOption.setVisible(false);
                    this.jLabelStopCritName.setText("");
                    break;
                }
                case 1: {
                    this.jCheckBoxOneGo.setSelected(false);
                    this.jLabelStopCritName.setVisible(true);
                    this.jTextFieldStopCritValue.setVisible(true);
                    this.jCheckBoxStopCritOption.setVisible(true);
                    this.jLabelStopCritName.setText("Standard deviation of noise:");
                    this.jTextFieldStopCritValue.setText(Float.toString(this.sigma));
                    this.jCheckBoxStopCritOption.setText("Estimate StdDev of noise");
                    this.jCheckBoxStopCritOption.setSelected(this.estimateSigma);
                    break;
                }
                case 2: {
                    this.jCheckBoxOneGo.setSelected(false);
                    this.jLabelStopCritName.setVisible(true);
                    this.jTextFieldStopCritValue.setVisible(true);
                    this.jCheckBoxStopCritOption.setVisible(false);
                    this.jLabelStopCritName.setText("Tolerance:");
                    this.jTextFieldStopCritValue.setText(Float.toString(this.tolerance));
                }
            }
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == Landweber.this.jTextFieldNumIter) {
                return this.checkIntField(Landweber.this.getName(), Landweber.this.jLabelNumIter.getText(), Landweber.this.jTextFieldNumIter, 1, 1000000, 10, changeIt);
            }
            if (input == Landweber.this.jTextFieldStepSize) {
                return this.checkFloatField(Landweber.this.getName(), Landweber.this.jLabelStepSize.getText(), Landweber.this.jTextFieldStepSize, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == Landweber.this.jTextFieldStopCritValue && Landweber.this.jComboBoxStopCrit.getSelectedIndex() == 1) {
                return this.checkFloatField(Landweber.this.getName(), Landweber.this.jLabelStopCritName.getText(), Landweber.this.jTextFieldStopCritValue, 0.0f, 1000.0f, 1.0f, changeIt);
            }
            if (input == Landweber.this.jTextFieldStopCritValue && Landweber.this.jComboBoxStopCrit.getSelectedIndex() == 2) {
                return this.checkFloatField(Landweber.this.getName(), Landweber.this.jLabelStopCritName.getText(), Landweber.this.jTextFieldStopCritValue, 0.0f, 1.0f, 0.001f, changeIt);
            }
            return true;
        }
    }
}

