/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class PSFModel
extends AbstractAlgorithm {
    private int PEAK = 1;
    private double PI = Math.PI;
    private int STEPRATE = 8;
    private double[] t = new double[]{1.0, -2.2499997, 1.2656208, -0.3163866, 0.0444479, -0.0039444, 2.1E-4};
    private double[] p = new double[]{-0.78539816, -0.04166397, -3.954E-5, 0.00262573, -5.4125E-4, -2.9333E-4, 1.3558E-4};
    private double[] f = new double[]{0.79788456, -7.7E-7, -0.0055274, -9.512E-5, 0.00137237, -7.2805E-4, 1.4476E-4};
    private double[] t1 = new double[]{0.5, -0.56249985, 0.21093573, -0.03954289, 0.00443319, -3.1761E-4, 1.109E-5};
    private double[] p1 = new double[]{-2.35619449, 0.12499612, 5.65E-5, -0.00637879, 7.4348E-4, 7.9824E-4, -2.9166E-4};
    private double[] f1 = new double[]{0.79788456, 1.56E-6, 0.01659667, 1.7105E-4, -0.00249511, 0.00113653, -2.0033E-4};
    Signal h = null;
    Signal dh = null;
    Signal d2h = null;
    Signal h1 = null;
    Signal dh1 = null;
    Signal d2h1 = null;
    Signal h2 = null;
    Signal dh2 = null;
    Signal d2h2 = null;
    Signal hx = null;
    Signal dhdx = null;
    Signal d2hdx2 = null;
    Signal hy = null;
    Signal dhdy = null;
    Signal d2hdy2 = null;
    Signal hz = null;
    Signal dhdz = null;
    Signal d2hdz2 = null;
    Signal hna = null;
    Signal dhdna = null;
    Signal d2hdna2 = null;
    Signal hw = null;
    Signal dhdw = null;
    Signal d2hdw2 = null;
    Signal cc = null;
    Signal im = null;
    Signal s = null;
    Signal ds = null;
    Signal d2s = null;
    Signal object = null;
    private JPanel jPanel = null;
    private JLabel jLabelBeads = null;
    private JTextField jTextFieldBeads = null;
    private JLabel jLabelUnitBeads = null;
    private JLabel jLabelThres = null;
    private JTextField jTextFieldThres = null;
    private JLabel jLabelUnitThres = null;
    private JLabel jLabelNi = null;
    private JTextField jTextFieldNi = null;
    private JLabel jLabelUnitNi = null;
    private JLabel jLabelNa = null;
    private JTextField jTextFieldNa = null;
    private JLabel jLabelUnitNa = null;
    private JLabel jLabelW040 = null;
    private JTextField jTextFieldW040 = null;
    private JLabel jLabelUnitW040 = null;
    private JLabel jLabelLambda = null;
    private JTextField jTextFieldLambda = null;
    private JLabel jLabelUnitLambda = null;
    private JLabel jLabelBackground = null;
    private JTextField jTextFieldBackground = null;
    private JLabel jLabelUnitBackground = null;
    private JLabel jLabelDeltar = null;
    private JTextField jTextFieldDeltar = null;
    private JLabel jLabelUnitDeltar = null;
    private JLabel jLabelDeltaz = null;
    private JTextField jTextFieldDeltaz = null;
    private JLabel jLabelUnitDeltaz = null;
    private int beads = 1;
    private float threshold = 0.9f;
    private float ni = 1.51f;
    private float NA = 1.4f;
    private float W040 = 0.0f;
    private float lambda = 5.3E-7f;
    private float background = 500.0f;
    private float deltar = 1.0635E-7f;
    private float deltaz = 1.5625E-7f;
    private int Nx = 64;
    private int Ny = 64;
    private int Nz = 15;
    private int iterations = 9;
    private int normMode = this.PEAK;
    private MyVerifier verifier = new MyVerifier();

    public PSFModel() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelOpticPSF");
        this.jTextFieldBeads = new JTextField();
        this.jTextFieldThres = new JTextField();
        this.jTextFieldNi = new JTextField();
        this.jTextFieldNa = new JTextField();
        this.jTextFieldW040 = new JTextField();
        this.jTextFieldLambda = new JTextField();
        this.jTextFieldBackground = new JTextField();
        this.jTextFieldDeltar = new JTextField();
        this.jTextFieldDeltaz = new JTextField();
        this.jLabelBeads = new JLabel();
        this.jLabelThres = new JLabel();
        this.jLabelNi = new JLabel();
        this.jLabelNa = new JLabel();
        this.jLabelW040 = new JLabel();
        this.jLabelLambda = new JLabel();
        this.jLabelBackground = new JLabel();
        this.jLabelDeltar = new JLabel();
        this.jLabelDeltaz = new JLabel();
        this.jLabelUnitBeads = new JLabel();
        this.jLabelUnitThres = new JLabel();
        this.jLabelUnitNi = new JLabel();
        this.jLabelUnitNa = new JLabel();
        this.jLabelUnitW040 = new JLabel();
        this.jLabelUnitLambda = new JLabel();
        this.jLabelUnitBackground = new JLabel();
        this.jLabelUnitDeltar = new JLabel();
        this.jLabelUnitDeltaz = new JLabel();
        this.jTextFieldBeads.setText("" + this.beads);
        this.jTextFieldThres.setText("" + this.threshold);
        this.jTextFieldNi.setText("" + this.ni);
        this.jTextFieldNa.setText("" + this.NA);
        this.jTextFieldW040.setText("" + this.W040);
        this.jTextFieldLambda.setText("" + this.lambda);
        this.jTextFieldBackground.setText("" + this.background);
        this.jTextFieldDeltar.setText("" + this.deltar);
        this.jTextFieldDeltaz.setText("" + this.deltaz);
        this.jTextFieldBeads.setInputVerifier(this.verifier);
        this.jTextFieldThres.setInputVerifier(this.verifier);
        this.jTextFieldNi.setInputVerifier(this.verifier);
        this.jTextFieldNa.setInputVerifier(this.verifier);
        this.jTextFieldW040.setInputVerifier(this.verifier);
        this.jTextFieldLambda.setInputVerifier(this.verifier);
        this.jTextFieldBackground.setInputVerifier(this.verifier);
        this.jTextFieldDeltar.setInputVerifier(this.verifier);
        this.jTextFieldDeltaz.setInputVerifier(this.verifier);
        this.jLabelBeads.setText("Number of beads");
        this.jLabelThres.setText("Threshold value for CC");
        this.jLabelNi.setText("ni");
        this.jLabelNa.setText("NA");
        this.jLabelW040.setText("W040");
        this.jLabelLambda.setText("lambda");
        this.jLabelBackground.setText("background");
        this.jLabelDeltar.setText("deltar");
        this.jLabelDeltaz.setText("deltaz");
        this.jLabelUnitBeads.setText("[ ]");
        this.jLabelUnitThres.setText("%");
        this.jLabelUnitNi.setText("[ ]");
        this.jLabelUnitNa.setText("[ ]");
        this.jLabelUnitW040.setText("m");
        this.jLabelUnitLambda.setText("m");
        this.jLabelUnitBackground.setText("[]");
        this.jLabelUnitDeltar.setText("m");
        this.jLabelUnitDeltaz.setText("m");
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelBeads, this.jTextFieldBeads, this.jLabelUnitBeads);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelThres, this.jTextFieldThres, this.jLabelUnitThres);
        this.addTextFieldLine(this.jPanel, 3, 0.0, this.jLabelNi, this.jTextFieldNi, this.jLabelUnitNi);
        this.addTextFieldLine(this.jPanel, 4, 0.0, this.jLabelNa, this.jTextFieldNa, this.jLabelUnitNa);
        this.addTextFieldLine(this.jPanel, 5, 0.0, this.jLabelW040, this.jTextFieldW040, this.jLabelUnitW040);
        this.addTextFieldLine(this.jPanel, 6, 0.0, this.jLabelLambda, this.jTextFieldLambda, this.jLabelUnitLambda);
        this.addTextFieldLine(this.jPanel, 7, 0.0, this.jLabelBackground, this.jTextFieldBackground, this.jLabelUnitBackground);
        this.addTextFieldLine(this.jPanel, 8, 0.0, this.jLabelDeltar, this.jTextFieldDeltar, this.jLabelUnitDeltar);
        this.addTextFieldLine(this.jPanel, 9, 0.0, this.jLabelDeltaz, this.jTextFieldDeltaz, this.jLabelUnitDeltaz);
        this.gbConstraints.weighty = 100.0;
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "PSF Fitting";
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("This algorithm " + this.getName() + " is not macro callable"));
    }

    @Override
    public void log() {
    }

    @Override
    public boolean process(Signal g, Signal dontUse, Signal dontUse2, Parameters parameters) {
        if (this.ni <= this.NA) {
            IJ.error((String)"Refractive index must be strictly larger than NA.");
            return false;
        }
        if (this.lambda / 4.0f / this.NA < this.deltar) {
            IJ.error((String)("LATERAL sampling problem: the pixel width (deltar = " + this.deltar * 1.0E9f + " nm)\n" + "should be twice as small as the theoretical lateral resolution (lambda/2/NA = " + this.lambda / 2.0f / this.NA * 1.0E9f + " nm)."));
        }
        if (this.ni * this.lambda / this.NA / this.NA < this.deltaz) {
            IJ.error((String)("AXIAL sampling problem: the pixel height (deltaz = " + this.deltaz * 1.0E9f + " nm)\n" + "should be twice as small as the theoretical axial resolution (2*ni*lambda/NA^2 = " + (double)(2.0f * this.ni * this.lambda / this.NA / this.NA) * 1.0E9 + " nm)."));
            return false;
        }
        float[] amp = new float[this.beads];
        float step = 0.0f;
        int progress = 0;
        int coord_count = 1;
        this.Nx = g.N[2];
        this.Ny = g.N[1];
        this.Nz = g.N[0];
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        this.h = new Signal(dims);
        this.dh = new Signal(dims);
        this.d2h = new Signal(dims);
        this.h1 = new Signal(dims);
        this.dh1 = new Signal(dims);
        this.d2h1 = new Signal(dims);
        this.hx = new Signal(dims);
        this.dhdx = new Signal(dims);
        this.d2hdx2 = new Signal(dims);
        this.hy = new Signal(dims);
        this.dhdy = new Signal(dims);
        this.d2hdy2 = new Signal(dims);
        this.hz = new Signal(dims);
        this.dhdz = new Signal(dims);
        this.d2hdz2 = new Signal(dims);
        this.hna = new Signal(dims);
        this.dhdna = new Signal(dims);
        this.d2hdna2 = new Signal(dims);
        this.hw = new Signal(dims);
        this.dhdw = new Signal(dims);
        this.d2hdw2 = new Signal(dims);
        this.cc = new Signal(dims);
        step = 100 / (16 * this.iterations + 12);
        float[] coord = this.crosscorr(g, this.background, this.deltar, this.deltaz, this.NA, this.W040, this.beads, this.threshold);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            log.append("CC: x0= " + coord[coord_count] + "pix, y0=" + coord[coord_count + 1] + "pix, z0=" + coord[coord_count + 2] + " pix", 1);
            coord_count += 3;
        }
        log.setProgressLength(progress += (int)(2.0f * step));
        amp = this.amplitude(g, coord, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            log.append("AMP: amp= " + amp[(coord_count - 1) / 3], 1);
            coord_count += 3;
        }
        log.setProgressLength(progress += (int)step);
        float[] coordinates = this.newtonpos(g, coord, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            log.append("N-R: x0= " + coordinates[coord_count] + "pix, y0=" + coordinates[coord_count + 1] + "pix, z0=" + coordinates[coord_count + 2] + " pixel", 1);
            coord_count += 3;
        }
        log.setProgressLength(progress += (int)(9.0f * step));
        float epsilon = 1.0f;
        float NAold = this.NA;
        while ((double)epsilon > 0.003) {
            amp = this.amplitude(g, coordinates, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
            coord_count = 1;
            while ((float)coord_count <= coord[0]) {
                log.append("AMP: amp= " + amp[(coord_count - 1) / 3], 1);
                coord_count += 3;
            }
            log.setProgressLength(progress += (int)step);
            this.NA = this.newtonna(g, coordinates, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
            epsilon = Math.abs(NAold - this.NA);
            NAold = this.NA;
            log.append("N-R: NA= " + this.NA + "epsilon =" + epsilon, 1);
            log.setProgressLength(progress += (int)(3.0f * step));
            this.W040 = this.newtonw(g, coordinates, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
            log.append("N-R: W= " + this.W040, 1);
            log.setProgressLength(progress += (int)(3.0f * step));
            coordinates = this.newtonpos(g, coordinates, this.background, this.deltar, this.deltaz, amp, this.NA, this.W040);
            coord_count = 1;
            while ((float)coord_count <= coord[0]) {
                log.append("N-R: x0= " + coordinates[coord_count] + "pixel, y0=" + coordinates[coord_count + 1] + "pixel, z0=" + coordinates[coord_count + 2] + " pixel", 1);
                coord_count += 3;
            }
            log.setProgressLength(progress += (int)(9.0f * step));
        }
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            log.append("x0= " + coordinates[coord_count] + "pix, y0=" + coordinates[coord_count + 1] + "pix, z0=" + coordinates[coord_count + 2] + " pix, amp=" + amp[(coord_count - 1) / 3] + " NA=" + this.NA + " W=" + this.W040, 1);
            coord_count += 3;
        }
        this.h = new Signal(dims);
        this.s = new Signal(dims);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            this.PSF(this.ni, this.NA, this.lambda, this.W040, this.deltar, this.deltaz, this.Nx, this.Ny, this.Nz, coordinates[coord_count] * this.deltar, coordinates[coord_count + 1] * this.deltar, coordinates[coord_count + 2] * this.deltaz, this.normMode);
            ToolboxSignal.multiplyConstant(this.h, amp[(coord_count - 1) / 3]);
            ToolboxSignal.add(this.s, this.h);
            coord_count += 3;
        }
        ToolboxSignal.pow(this.s, 0.5f);
        ToolboxSignal.addConstant(this.s, (float)(-Math.sqrt(this.background)), 0.0f);
        this.s.get_image("Fitted PSF Model sqrt").show();
        ToolboxSignal.copy(this.s, g);
        ToolboxSignal.pow(this.s, 0.5f);
        ToolboxSignal.addConstant(this.s, (float)(-Math.sqrt(this.background)), 0.0f);
        this.s.get_image("Real Acquisition sqrt").show();
        this.PSF(this.ni, this.NA, this.lambda, this.W040, this.deltar, this.deltaz, this.Nx, this.Ny, this.Nz, (float)(this.Nx / 2) * this.deltar, (float)(this.Ny / 2) * this.deltar, (float)(this.Nz / 2) * this.deltaz, this.normMode);
        int[] shift = new int[]{-this.Nz / 2, -this.Ny / 2, -this.Nx / 2};
        ToolboxSignal.fftShift(this.h, shift);
        this.h.get_image("PSF for deconvolution").show();
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    private float[] amplitude(Signal g, float[] coord, float background, float deltar, float deltaz, float[] amp, float NA, float W040) {
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        int amp_count = 0;
        int coord_count = 1;
        this.h = new Signal(dims);
        this.s = new Signal(dims);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            ToolboxSignal.copy(this.s, g);
            ToolboxSignal.addConstant(this.s, -background, 0.0f);
            this.PSF(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
            ToolboxSignal.multiply(this.s, this.h);
            float enumer = ToolboxSignal.sum(this.s);
            ToolboxSignal.multiply(this.h, this.h);
            float denom = ToolboxSignal.sum(this.h);
            amp[amp_count] = enumer / denom;
            ++amp_count;
            coord_count += 3;
        }
        return amp;
    }

    private float newtonw(Signal g, float[] coord, float background, float deltar, float deltaz, float[] amp, float NA, float W040) {
        int iw = 0;
        float wnew = 0.0f;
        float epsilon = 1.0f;
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        int coord_count = 1;
        this.hw = new Signal(dims);
        this.dhdw = new Signal(dims);
        this.d2hdw2 = new Signal(dims);
        this.h1 = new Signal(dims);
        this.dh1 = new Signal(dims);
        this.d2h1 = new Signal(dims);
        this.s = new Signal(dims);
        float squaresum = 0.0f;
        float squaresum2 = 0.0f;
        while ((double)epsilon > 3.0E-9 & iw < 25) {
            coord_count = 1;
            while ((float)coord_count <= coord[0]) {
                this.PSFw(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hw, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdw, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdw2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.add(this.h1, this.hw);
                ToolboxSignal.add(this.dh1, this.dhdw);
                ToolboxSignal.add(this.d2h1, this.d2hdw2);
                coord_count += 3;
            }
            ToolboxSignal.copy(this.s, g);
            ToolboxSignal.addConstant(this.s, -background, 0.0f);
            ToolboxSignal.subtract(this.s, this.h1);
            ToolboxSignal.multiply(this.s, this.dh1);
            squaresum = ToolboxSignal.sum(this.s);
            ToolboxSignal.copy(this.s, g);
            ToolboxSignal.addConstant(this.s, -background, 0.0f);
            ToolboxSignal.multiply(this.dh1, this.dh1);
            ToolboxSignal.subtract(this.s, this.h1);
            ToolboxSignal.multiply(this.d2h1, this.s);
            ToolboxSignal.subtract(this.d2h1, this.dh1);
            squaresum2 = ToolboxSignal.sum(this.d2h1);
            wnew = W040 - squaresum / squaresum2;
            epsilon = Math.abs(W040 - wnew);
            W040 = wnew;
            ++iw;
            log.append("N-R: W040= " + W040 + "nm", 1);
            ToolboxSignal.multiplyConstant(this.h1, 0.0f);
            ToolboxSignal.multiplyConstant(this.dh1, 0.0f);
            ToolboxSignal.multiplyConstant(this.d2h1, 0.0f);
        }
        return W040;
    }

    private float newtonna(Signal g, float[] coord, float background, float deltar, float deltaz, float[] amp, float NA, float W040) {
        float nanew = 0.0f;
        float epsilon = 1.0f;
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        int coord_count = 1;
        this.h2 = new Signal(dims);
        this.dh2 = new Signal(dims);
        this.d2h2 = new Signal(dims);
        this.hna = new Signal(dims);
        this.dhdna = new Signal(dims);
        this.d2hdna2 = new Signal(dims);
        this.s = new Signal(dims);
        float squaresum = 0.0f;
        float squaresum2 = 0.0f;
        while ((double)epsilon > 0.001) {
            coord_count = 1;
            while ((float)coord_count <= coord[0]) {
                this.PSFna(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hna, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdna, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdna2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.add(this.h2, this.hna);
                ToolboxSignal.add(this.dh2, this.dhdna);
                ToolboxSignal.add(this.d2h2, this.d2hdna2);
                coord_count += 3;
            }
            ToolboxSignal.copy(this.s, g);
            ToolboxSignal.addConstant(this.s, -background, 0.0f);
            ToolboxSignal.subtract(this.s, this.h2);
            ToolboxSignal.multiply(this.s, this.dh2);
            squaresum = ToolboxSignal.sum(this.s);
            ToolboxSignal.copy(this.s, g);
            ToolboxSignal.addConstant(this.s, -background, 0.0f);
            ToolboxSignal.multiply(this.dh2, this.dh2);
            ToolboxSignal.subtract(this.s, this.h2);
            ToolboxSignal.multiply(this.d2h2, this.s);
            ToolboxSignal.subtract(this.d2h2, this.dh2);
            squaresum2 = ToolboxSignal.sum(this.d2h2);
            nanew = NA - squaresum / squaresum2;
            epsilon = Math.abs(NA - nanew);
            NA = nanew;
            log.append("N-R: NA= " + NA, 1);
            ToolboxSignal.multiplyConstant(this.h2, 0.0f);
            ToolboxSignal.multiplyConstant(this.dh2, 0.0f);
            ToolboxSignal.multiplyConstant(this.d2h2, 0.0f);
        }
        return NA;
    }

    private float[] newtonpos(Signal g, float[] coord, float background, float deltar, float deltaz, float[] amp, float NA, float W040) {
        float xnew = 0.0f;
        float ynew = 0.0f;
        float znew = 0.0f;
        float epsilon = 1.0f;
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        int coord_count = 1;
        this.hx = new Signal(dims);
        this.dhdx = new Signal(dims);
        this.d2hdx2 = new Signal(dims);
        this.hy = new Signal(dims);
        this.dhdy = new Signal(dims);
        this.d2hdy2 = new Signal(dims);
        this.hz = new Signal(dims);
        this.dhdz = new Signal(dims);
        this.d2hdz2 = new Signal(dims);
        this.s = new Signal(dims);
        float squaresum = 0.0f;
        float squaresum2 = 0.0f;
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 5.0E-10) {
                this.PSFx(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hx, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdx, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdx2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hx);
                ToolboxSignal.multiply(this.s, this.dhdx);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdx, this.dhdx);
                ToolboxSignal.subtract(this.s, this.hx);
                ToolboxSignal.multiply(this.d2hdx2, this.s);
                ToolboxSignal.subtract(this.d2hdx2, this.dhdx);
                squaresum2 = ToolboxSignal.sum(this.d2hdx2);
                xnew = coord[coord_count] * deltar - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count] * deltar - xnew);
                coord[coord_count] = xnew / deltar;
                log.append("N-R: x0= " + coord[coord_count] + "pixel", 1);
            }
            coord_count += 3;
        }
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 5.0E-10) {
                this.PSFy(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hy, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdy, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdy2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hy);
                ToolboxSignal.multiply(this.s, this.dhdy);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdy, this.dhdy);
                ToolboxSignal.subtract(this.s, this.hy);
                ToolboxSignal.multiply(this.d2hdy2, this.s);
                ToolboxSignal.subtract(this.d2hdy2, this.dhdy);
                squaresum2 = ToolboxSignal.sum(this.d2hdy2);
                ynew = coord[coord_count + 1] * deltar - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count + 1] * deltar - ynew);
                coord[coord_count + 1] = ynew / deltar;
                log.append("N-R: y0= " + coord[coord_count + 1] + "pixel", 1);
            }
            coord_count += 3;
        }
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 3.0E-9) {
                this.PSFz(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hz, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdz, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdz2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hz);
                ToolboxSignal.multiply(this.s, this.dhdz);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdz, this.dhdz);
                ToolboxSignal.subtract(this.s, this.hz);
                ToolboxSignal.multiply(this.d2hdz2, this.s);
                ToolboxSignal.subtract(this.d2hdz2, this.dhdz);
                squaresum2 = ToolboxSignal.sum(this.d2hdz2);
                znew = coord[coord_count + 2] * deltaz - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count + 2] * deltaz - znew);
                coord[coord_count + 2] = znew / deltaz;
                log.append("N-R: z0= " + coord[coord_count + 2] + "pixel", 1);
            }
            coord_count += 3;
        }
        return coord;
    }

    private float[] newtonposshift(Signal g, float[] coord, float background, float deltar, float deltaz, float[] amp, float NA, float W040) {
        float xnew = 0.0f;
        float ynew = 0.0f;
        float znew = 0.0f;
        float epsilon = 1.0f;
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        int coord_count = 1;
        this.hx = new Signal(dims);
        this.dhdx = new Signal(dims);
        this.d2hdx2 = new Signal(dims);
        this.hy = new Signal(dims);
        this.dhdy = new Signal(dims);
        this.d2hdy2 = new Signal(dims);
        this.hz = new Signal(dims);
        this.dhdz = new Signal(dims);
        this.d2hdz2 = new Signal(dims);
        this.s = new Signal(dims);
        float squaresum = 0.0f;
        float squaresum2 = 0.0f;
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 1.0E-10) {
                this.PSFx(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hx, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdx, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdx2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hx);
                ToolboxSignal.multiply(this.s, this.dhdx);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdx, this.dhdx);
                ToolboxSignal.subtract(this.s, this.hx);
                ToolboxSignal.multiply(this.d2hdx2, this.s);
                ToolboxSignal.subtract(this.d2hdx2, this.dhdx);
                squaresum2 = ToolboxSignal.sum(this.d2hdx2);
                xnew = coord[coord_count] * deltar - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count] * deltar - xnew);
                coord[coord_count] = xnew / deltar;
                log.append("N-R: x0= " + coord[coord_count] + "pixel", 1);
            }
            coord_count += 3;
        }
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 1.0E-10) {
                this.PSFy(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hy, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdy, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdy2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hy);
                ToolboxSignal.multiply(this.s, this.dhdy);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdy, this.dhdy);
                ToolboxSignal.subtract(this.s, this.hy);
                ToolboxSignal.multiply(this.d2hdy2, this.s);
                ToolboxSignal.subtract(this.d2hdy2, this.dhdy);
                squaresum2 = ToolboxSignal.sum(this.d2hdy2);
                ynew = coord[coord_count + 1] * deltar - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count + 1] * deltar - ynew);
                coord[coord_count + 1] = ynew / deltar;
                log.append("N-R: y0= " + coord[coord_count + 1] + "pixel", 1);
            }
            coord_count += 3;
        }
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            epsilon = 1.0f;
            while ((double)epsilon > 1.0E-9) {
                this.PSFz(this.ni, NA, this.lambda, W040, deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[coord_count] * deltar, coord[coord_count + 1] * deltar, coord[coord_count + 2] * deltaz, this.normMode);
                ToolboxSignal.multiplyConstant(this.hz, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.dhdz, amp[(coord_count - 1) / 3]);
                ToolboxSignal.multiplyConstant(this.d2hdz2, amp[(coord_count - 1) / 3]);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.subtract(this.s, this.hz);
                ToolboxSignal.multiply(this.s, this.dhdz);
                squaresum = ToolboxSignal.sum(this.s);
                ToolboxSignal.copy(this.s, g);
                ToolboxSignal.addConstant(this.s, -background, 0.0f);
                ToolboxSignal.multiply(this.dhdz, this.dhdz);
                ToolboxSignal.subtract(this.s, this.hz);
                ToolboxSignal.multiply(this.d2hdz2, this.s);
                ToolboxSignal.subtract(this.d2hdz2, this.dhdz);
                squaresum2 = ToolboxSignal.sum(this.d2hdz2);
                znew = coord[coord_count + 2] * deltaz - squaresum / squaresum2;
                epsilon = Math.abs(coord[coord_count + 2] * deltaz - znew);
                coord[coord_count + 2] = znew / deltaz;
                log.append("N-R: z0= " + coord[coord_count + 2] + "pixel", 1);
            }
            coord_count += 3;
        }
        return coord;
    }

    private float[] crosscorr(Signal g, float background, float deltax, float deltaz, float NA, float W040, int beads, float threshold) {
        int nb_call = 1;
        int coord_count = 1;
        float x0 = (float)(this.Nx / 2) * this.deltar;
        float y0 = (float)(this.Ny / 2) * this.deltar;
        float z0 = (float)(this.Nz / 2) * deltaz;
        float sum = 1.0f;
        float[] coord = new float[]{x0, y0, z0};
        float[] coordinates = new float[beads * 3 + 1];
        int[] dims = new int[]{this.Nz, this.Ny, this.Nx};
        this.h = new Signal(dims);
        this.s = new Signal(dims);
        ToolboxSignal.copy(this.s, g);
        ToolboxSignal.addConstant(this.s, -background, 0.0f);
        this.PSF(this.ni, NA, this.lambda, W040, this.deltar, deltaz, this.Nx, this.Ny, this.Nz, coord[0], coord[1], coord[2], this.normMode);
        ToolboxFourier toolbox = new ToolboxFourier(this.h.N, false, null);
        toolbox.forwardFFT(this.h);
        toolbox.forwardFFT(this.s);
        ToolboxSignal.multiplyConj(this.s, this.h);
        toolbox.inverseFFT(this.s);
        int[] shift = new int[]{-this.Nz / 2, -this.Ny / 2, -this.Nx / 2};
        ToolboxSignal.fftShift(this.s, shift);
        float maxs = ToolboxSignal.maximum(this.s);
        ToolboxSignal.multiplyConstant(this.s, 1.0f / maxs);
        ToolboxSignal.threshold(this.s, 0.0f, threshold);
        this.s.get_image("cc").show();
        while (sum != 0.0f) {
            int nzy = 0;
            while (nzy < this.Nz) {
                int offsetZ = this.s.extN[1] * this.s.extN[2] * nzy;
                int ny = 0;
                while (ny < this.Ny) {
                    int offsetZY = offsetZ + ny * this.s.extN[2];
                    int nx = 0;
                    while (nx < this.Nx) {
                        if (this.s.array[offsetZY + nx] != 0.0f) {
                            if (nb_call == 1) {
                                coordinates[coord_count] = nx;
                                coordinates[coord_count + 1] = ny;
                                coordinates[coord_count + 2] = nzy;
                                ++nb_call;
                            }
                            if (Math.pow(coordinates[coord_count] / (float)(nb_call - 1) - (float)nx, 2.0) + Math.pow(coordinates[coord_count + 1] / (float)(nb_call - 1) - (float)ny, 2.0) < 100.0 && nb_call != 1) {
                                int n = coord_count;
                                coordinates[n] = coordinates[n] + (float)nx;
                                int n2 = coord_count + 1;
                                coordinates[n2] = coordinates[n2] + (float)ny;
                                int n3 = coord_count + 2;
                                coordinates[n3] = coordinates[n3] + (float)nzy;
                                ++nb_call;
                                this.s.array[offsetZY + nx] = 0.0f;
                            }
                        }
                        ++nx;
                    }
                    ++ny;
                }
                ++nzy;
            }
            int n = coord_count;
            coordinates[n] = coordinates[n] / (float)(nb_call - 1);
            int n4 = coord_count + 1;
            coordinates[n4] = coordinates[n4] / (float)(nb_call - 1);
            int n5 = coord_count + 2;
            coordinates[n5] = coordinates[n5] / (float)(nb_call - 1);
            int n6 = coord_count + 2;
            coordinates[n6] = coordinates[n6] - 1.0f;
            coord_count += 3;
            nb_call = 1;
            sum = ToolboxSignal.sum(this.s);
        }
        coordinates[0] = coord_count - 3;
        return coordinates;
    }

    private void shift(float[] coord, float[] amp, int Nx, int Ny, int Nz) {
        int[] dims = new int[]{Nz, Ny, Nx};
        int coord_count = 1;
        this.object = new Signal(dims);
        coord_count = 1;
        while ((float)coord_count <= coord[0]) {
            int nzy = 0;
            while (nzy < Nz) {
                int offsetZ = this.object.extN[1] * this.object.extN[2] * nzy;
                int ny = 0;
                while (ny < Ny) {
                    int offsetZY = offsetZ + ny * this.object.extN[2];
                    int nx = 0;
                    while (nx < Nx) {
                        this.object.array[offsetZY + nx] = 0.0f;
                        ++nx;
                    }
                    ++ny;
                }
                ++nzy;
            }
            coord_count += 3;
        }
    }

    private void PSF(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                integral0[nr] = deltarho * deltarho * ((sumR += Math.cos(angle) * bessel) * sumR + (sumI += Math.sin(angle) * bessel) * sumI);
                ++nr;
            }
            int offsetZ = this.h.extN[1] * this.h.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.h.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.h.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
    }

    private void PSFz(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        double[] integral1 = new double[Nr];
        double[] integral2 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            double constM = -k * NA * NA / ni / 2.0;
            double constM2 = -k * k * NA * NA * NA * NA / ni / ni / 4.0;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR += Math.cos(angle) * bessel;
                sumI += Math.sin(angle) * bessel;
                double sumR1 = 0.0;
                double sumI1 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * rho2 * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 2.0 * Math.cos(angle) * bessel;
                    sumI1 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * rho2 * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 4.0 * Math.cos(angle) * bessel;
                    sumI1 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                double sumR1mem = sumR1 += Math.cos(angle) * bessel;
                sumR1 = -(sumI1 += Math.sin(angle) * bessel) * constM;
                sumI1 = sumR1mem * constM;
                double sumR2 = 0.0;
                double sumI2 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 2.0 * Math.cos(angle) * bessel;
                    sumI2 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * rho2 * rho2 * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 4.0 * Math.cos(angle) * bessel;
                    sumI2 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR2 += Math.cos(angle) * bessel;
                sumI2 += Math.sin(angle) * bessel;
                integral0[nr] = deltarho * deltarho * (sumR * sumR + sumI * sumI);
                integral1[nr] = 2.0 * deltarho * deltarho * (sumR1 * sumR + sumI1 * sumI);
                integral2[nr] = 2.0 * deltarho * deltarho * ((sumR2 *= constM2) * sumR + (sumI2 *= constM2) * sumI + sumR1 * sumR1 + sumI1 * sumI1);
                ++nr;
            }
            int offsetZ = this.hz.extN[1] * this.hz.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.hz.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.hz.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.dhdz.array[offsetZY + nx] = (float)this.interp(integral1, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.d2hdz2.array[offsetZY + nx] = (float)this.interp(integral2, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    if (Double.isNaN(this.d2hdz2.array[offsetZY + nx])) {
                        this.d2hdz2.array[offsetZY + nx] = 0.0f;
                    }
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
        integral1 = null;
        integral2 = null;
    }

    private void PSFx(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        double[] integral1 = new double[Nr];
        double[] integral21 = new double[Nr];
        double[] integral22 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            double constM = -k * k * NA * NA;
            double constM3 = -k * k * k * k * NA * NA * NA * NA;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR += Math.cos(angle) * bessel;
                sumI += Math.sin(angle) * bessel;
                double sumR1 = 0.0;
                double sumI1 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho * this.J1x1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 2.0 * Math.cos(angle) * bessel;
                    sumI1 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho * this.J1x1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 4.0 * Math.cos(angle) * bessel;
                    sumI1 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1x1(constJ);
                angle = constDefocus;
                sumR1 += Math.cos(angle) * bessel;
                sumI1 += Math.sin(angle) * bessel;
                double sumR2 = -(sumR1 *= constM);
                double sumI2 = -(sumI1 *= constM);
                double sumR3 = 0.0;
                double sumI3 = 0.0;
                double sumR4 = 0.0;
                double sumI4 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0x2(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR3 += 2.0 * Math.cos(angle) * bessel;
                    sumI3 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0x2(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR3 += 4.0 * Math.cos(angle) * bessel;
                    sumI3 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0x2(constJ);
                angle = constDefocus;
                sumR3 += Math.cos(angle) * bessel;
                sumI3 += Math.sin(angle) * bessel;
                sumR3 *= constM3;
                sumI3 *= constM3;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J1x3(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 2.0 * Math.cos(angle) * bessel;
                    sumI4 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J1x3(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 4.0 * Math.cos(angle) * bessel;
                    sumI4 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1x3(constJ);
                angle = constDefocus;
                sumR4 += Math.cos(angle) * bessel;
                sumI4 += Math.sin(angle) * bessel;
                sumR4 = -2.0 * sumR4 * constM3;
                sumI4 = -2.0 * sumI4 * constM3;
                integral0[nr] = deltarho * deltarho * (sumR * sumR + sumI * sumI);
                integral1[nr] = -2.0 * deltarho * deltarho * (sumR1 * sumR + sumI1 * sumI);
                integral21[nr] = -2.0 * deltarho * deltarho * (sumR2 * sumR + sumI2 * sumI);
                integral22[nr] = -2.0 * deltarho * deltarho * ((sumR3 + sumR4) * sumR + (sumI3 + sumI4) * sumI + sumR1 * sumR1 + sumI1 * sumI1);
                ++nr;
            }
            int offsetZ = this.hx.extN[1] * this.hx.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.hx.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.hx.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.dhdx.array[offsetZY + nx] = (float)dx * (float)this.interp(integral1, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.d2hdx2.array[offsetZY + nx] = ((float)this.interp(integral21, Math.sqrt(dx * dx + dy * dy) / deltar) + (float)dx * (float)dx * (float)this.interp(integral22, Math.sqrt(dx * dx + dy * dy) / deltar)) / 2.25f;
                    if (Double.isNaN(this.d2hdx2.array[offsetZY + nx])) {
                        this.d2hdx2.array[offsetZY + nx] = 0.0f;
                    }
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
        integral1 = null;
        integral21 = null;
        integral22 = null;
    }

    private void PSFy(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        double[] integral1 = new double[Nr];
        double[] integral21 = new double[Nr];
        double[] integral22 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            double constM = -k * k * NA * NA;
            double constM3 = -k * k * k * k * NA * NA * NA * NA;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR += Math.cos(angle) * bessel;
                sumI += Math.sin(angle) * bessel;
                double sumR1 = 0.0;
                double sumI1 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho * this.J1x1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 2.0 * Math.cos(angle) * bessel;
                    sumI1 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho * this.J1x1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 4.0 * Math.cos(angle) * bessel;
                    sumI1 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1x1(constJ);
                angle = constDefocus;
                sumR1 += Math.cos(angle) * bessel;
                sumI1 += Math.sin(angle) * bessel;
                double sumR2 = -(sumR1 *= constM);
                double sumI2 = -(sumI1 *= constM);
                double sumR3 = 0.0;
                double sumI3 = 0.0;
                double sumR4 = 0.0;
                double sumI4 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0x2(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR3 += 2.0 * Math.cos(angle) * bessel;
                    sumI3 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0x2(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR3 += 4.0 * Math.cos(angle) * bessel;
                    sumI3 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0x2(constJ);
                angle = constDefocus;
                sumR3 += Math.cos(angle) * bessel;
                sumI3 += Math.sin(angle) * bessel;
                sumR3 *= constM3;
                sumI3 *= constM3;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J1x3(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 2.0 * Math.cos(angle) * bessel;
                    sumI4 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J1x3(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 4.0 * Math.cos(angle) * bessel;
                    sumI4 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1x3(constJ);
                angle = constDefocus;
                sumR4 += Math.cos(angle) * bessel;
                sumI4 += Math.sin(angle) * bessel;
                sumR4 = -2.0 * sumR4 * constM3;
                sumI4 = -2.0 * sumI4 * constM3;
                integral0[nr] = deltarho * deltarho * (sumR * sumR + sumI * sumI);
                integral1[nr] = -2.0 * deltarho * deltarho * (sumR1 * sumR + sumI1 * sumI);
                integral21[nr] = -2.0 * deltarho * deltarho * (sumR2 * sumR + sumI2 * sumI);
                integral22[nr] = -2.0 * deltarho * deltarho * ((sumR3 + sumR4) * sumR + (sumI3 + sumI4) * sumI + sumR1 * sumR1 + sumI1 * sumI1);
                ++nr;
            }
            int offsetZ = this.hy.extN[1] * this.hy.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.hy.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.hy.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.dhdy.array[offsetZY + nx] = (float)dy * (float)this.interp(integral1, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.d2hdy2.array[offsetZY + nx] = ((float)this.interp(integral21, Math.sqrt(dx * dx + dy * dy) / deltar) + (float)dy * (float)dy * (float)this.interp(integral22, Math.sqrt(dx * dx + dy * dy) / deltar)) / 2.25f;
                    if (Double.isNaN(this.d2hdy2.array[offsetZY + nx])) {
                        this.d2hdy2.array[offsetZY + nx] = 0.0f;
                    }
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
        integral1 = null;
        integral21 = null;
        integral22 = null;
    }

    private void PSFna(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        double[] integral1 = new double[Nr];
        double[] integral2 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double constM1 = k * NA * ((double)nzy * deltaz - z0) / ni;
                double constM2 = -k * (double)nr * deltar;
                double constM3R = -k * k * (double)nr * (double)nr * deltar * deltar;
                double constM3I = k * ((double)nzy * deltaz - z0) / ni;
                double constM4R = -k * k * NA * NA * ((double)nzy * deltaz - z0) * ((double)nzy * deltaz - z0) / ni / ni;
                double constM5I = -2.0 * k * k * NA * (double)nr * deltar * ((double)nzy * deltaz - z0) / ni;
                double constM6R = k * (double)nr * deltar / NA;
                double constM6I = 0.0;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR += Math.cos(angle) * bessel;
                sumI += Math.sin(angle) * bessel;
                double sumR1 = 0.0;
                double sumI1 = 0.0;
                double sumR3 = 0.0;
                double sumI3 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * rho2 * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 2.0 * Math.cos(angle) * bessel;
                    sumI1 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * rho2 * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 4.0 * Math.cos(angle) * bessel;
                    sumI1 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                double sumR1mem = sumR1 += Math.cos(angle) * bessel;
                double sumI1mem = sumI1 += Math.sin(angle) * bessel;
                sumR1 = -sumI1 * constM1;
                sumI1 = sumR1mem * constM1;
                sumR3 = constM3R * sumR1mem - constM3I * sumI1mem;
                sumI3 = constM3I * sumR1mem + constM3R * sumI1mem;
                double sumR2 = 0.0;
                double sumI2 = 0.0;
                double sumR6 = 0.0;
                double sumI6 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * this.J1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 2.0 * Math.cos(angle) * bessel;
                    sumI2 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * this.J1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 4.0 * Math.cos(angle) * bessel;
                    sumI2 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1(constJ);
                angle = constDefocus;
                double sumR2mem = sumR2 += Math.cos(angle) * bessel;
                double sumI2mem = sumI2 += Math.sin(angle) * bessel;
                sumR2 *= constM2;
                sumI2 *= constM2;
                sumR6 = constM6R * sumR2mem - constM6I * sumI2mem;
                sumI6 = constM6R * sumI2mem + constM6I * sumR2mem;
                double sumR4 = 0.0;
                double sumI4 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 2.0 * Math.cos(angle) * bessel;
                    sumI4 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR4 += 4.0 * Math.cos(angle) * bessel;
                    sumI4 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR4 += Math.cos(angle) * bessel;
                sumI4 += Math.sin(angle) * bessel;
                sumR4 *= constM4R;
                sumI4 *= constM4R;
                double sumR5 = 0.0;
                double sumI5 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * this.J1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR5 += 2.0 * Math.cos(angle) * bessel;
                    sumI5 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho2 * rho2 * this.J1(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR5 += 4.0 * Math.cos(angle) * bessel;
                    sumI5 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J1(constJ);
                angle = constDefocus;
                double sumR5mem = sumR5 += Math.cos(angle) * bessel;
                sumR5 = -(sumI5 += Math.sin(angle) * bessel) * constM5I;
                sumI5 = sumR5mem * constM5I;
                integral0[nr] = deltarho * deltarho * (sumR * sumR + sumI * sumI);
                integral1[nr] = 2.0 * deltarho * deltarho * ((sumR1 + sumR2) * sumR + (sumI1 + sumI2) * sumI);
                integral2[nr] = 2.0 * deltarho * deltarho * ((sumR3 + sumR4 + sumR5 + sumR6) * sumR + (sumI3 + sumI4 + sumI5 + sumI6) * sumI + (sumR1 + sumR2) * (sumR1 + sumR2) + (sumI1 + sumI2) * (sumI1 + sumI2));
                ++nr;
            }
            int offsetZ = this.hy.extN[1] * this.hy.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.hy.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.hna.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.dhdna.array[offsetZY + nx] = (float)this.interp(integral1, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.d2hdna2.array[offsetZY + nx] = (float)this.interp(integral2, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
        integral1 = null;
        integral2 = null;
    }

    private void PSFw(double ni, double NA, double lambda, double W040, double deltar, double deltaz, int Nx, int Ny, int Nz, double x0, double y0, double z0, int normMode) {
        double k = 2.0 * this.PI / lambda;
        double constSA = k * W040;
        double dx = this.maxi(Math.abs(x0), Math.abs((double)(Nx - 1) * deltar - x0));
        double dy = this.maxi(Math.abs(y0), Math.abs((double)(Ny - 1) * deltar - y0));
        int Nr = 2 + (int)(Math.sqrt(dx * dx + dy * dy) / deltar);
        double[] integral0 = new double[Nr];
        double[] integral1 = new double[Nr];
        double[] integral2 = new double[Nr];
        int nzy = 0;
        while (nzy < Nz) {
            double constDefocus = k * NA * NA * ((double)nzy * deltaz - z0) / 2.0 / ni;
            int nr = 0;
            while (nr < Nr) {
                double angle;
                double bessel;
                double constJ = k * NA * (double)nr * deltar;
                double rho = constSA != 0.0 ? Math.sqrt(Math.abs(constDefocus / constSA / 2.0)) : 0.0;
                double rho2 = rho * rho;
                double constCos = this.maxi(Math.abs(constDefocus + constSA), Math.abs(constDefocus * rho2 + constSA * rho2 * rho2));
                int Nrho = (int)this.maxi(2 * (1 + (int)(constCos * 0.12)) * this.STEPRATE, 2 * (1 + (int)(constJ / 3.0)) * this.STEPRATE);
                double deltarho = 1.0 / (double)Nrho;
                double sumR = 0.0;
                double sumI = 0.0;
                int nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 2.0 * Math.cos(angle) * bessel;
                    sumI += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR += 4.0 * Math.cos(angle) * bessel;
                    sumI += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = this.J0(constJ);
                angle = constDefocus;
                sumR += Math.cos(angle) * bessel;
                sumI += Math.sin(angle) * bessel;
                double sumR1 = 0.0;
                double sumI1 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho) * (rho2 - rho2 * rho2);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 2.0 * Math.cos(angle) * bessel;
                    sumI1 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho) * (rho2 - rho2 * rho2);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR1 += 4.0 * Math.cos(angle) * bessel;
                    sumI1 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = 0.0;
                angle = constDefocus;
                double sumR1mem = sumR1 += Math.cos(angle) * bessel;
                sumR1 = k * (sumI1 += Math.sin(angle) * bessel);
                sumI1 = -k * sumR1mem;
                double sumR2 = 0.0;
                double sumI2 = 0.0;
                nrho = 1;
                while (nrho < Nrho / 2) {
                    rho = (double)(2 * nrho) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho) * (rho2 - rho2 * rho2) * (rho2 - rho2 * rho2);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 2.0 * Math.cos(angle) * bessel;
                    sumI2 += 2.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                nrho = 1;
                while (nrho <= Nrho / 2) {
                    rho = (double)(2 * nrho - 1) * deltarho;
                    rho2 = rho * rho;
                    bessel = rho * this.J0(constJ * rho) * (rho2 - rho2 * rho2) * (rho2 - rho2 * rho2);
                    angle = constDefocus * rho2 - k * W040 * (rho2 - rho2 * rho2);
                    sumR2 += 4.0 * Math.cos(angle) * bessel;
                    sumI2 += 4.0 * Math.sin(angle) * bessel;
                    ++nrho;
                }
                bessel = 0.0;
                angle = constDefocus;
                sumR2 += Math.cos(angle) * bessel;
                sumI2 += Math.sin(angle) * bessel;
                sumR2 = -k * k * sumR2;
                sumI2 = -k * k * sumI2;
                integral0[nr] = deltarho * deltarho * (sumR * sumR + sumI * sumI);
                integral1[nr] = 2.0 * deltarho * deltarho * (sumR1 * sumR + sumI1 * sumI);
                integral2[nr] = 2.0 * deltarho * deltarho * (sumR2 * sumR + sumI2 * sumI + sumR1 * sumR1 + sumI1 * sumI1);
                ++nr;
            }
            int offsetZ = this.hz.extN[1] * this.hz.extN[2] * nzy;
            int ny = 0;
            while (ny < Ny) {
                int offsetZY = offsetZ + ny * this.hz.extN[2];
                dy = (double)ny * deltar - y0;
                int nx = 0;
                while (nx < Nx) {
                    dx = (double)nx * deltar - x0;
                    this.hw.array[offsetZY + nx] = (float)this.interp(integral0, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.dhdw.array[offsetZY + nx] = (float)this.interp(integral1, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    this.d2hdw2.array[offsetZY + nx] = (float)this.interp(integral2, Math.sqrt(dx * dx + dy * dy) / deltar) / 2.25f;
                    ++nx;
                }
                ++ny;
            }
            ++nzy;
        }
        integral0 = null;
        integral1 = null;
        integral2 = null;
    }

    private double maxi(double a, double b) {
        if (a >= b) {
            return a;
        }
        return b;
    }

    private double J0(double x) {
        double r;
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            r = this.t[0] + y * (this.t[1] + y * (this.t[2] + y * (this.t[3] + y * (this.t[4] + y * (this.t[5] + y * this.t[6])))));
        } else {
            double y = 3.0 / x;
            double theta0 = x + this.p[0] + y * (this.p[1] + y * (this.p[2] + y * (this.p[3] + y * (this.p[4] + y * (this.p[5] + y * this.p[6])))));
            double f0 = this.f[0] + y * (this.f[1] + y * (this.f[2] + y * (this.f[3] + y * (this.f[4] + y * (this.f[5] + y * this.f[6])))));
            r = Math.sqrt(1.0 / x) * f0 * Math.cos(theta0);
        }
        return r;
    }

    private double J0x2(double x) {
        double r;
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            r = 1.0 / x / x * (this.t[0] + y * (this.t[1] + y * (this.t[2] + y * (this.t[3] + y * (this.t[4] + y * (this.t[5] + y * this.t[6]))))));
        } else {
            double y = 3.0 / x;
            double theta0 = x + this.p[0] + y * (this.p[1] + y * (this.p[2] + y * (this.p[3] + y * (this.p[4] + y * (this.p[5] + y * this.p[6])))));
            double f0 = this.f[0] + y * (this.f[1] + y * (this.f[2] + y * (this.f[3] + y * (this.f[4] + y * (this.f[5] + y * this.f[6])))));
            r = 1.0 / x / x * (Math.sqrt(1.0 / x) * f0 * Math.cos(theta0));
        }
        return r;
    }

    private double J1(double x) {
        double r;
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            r = (this.t1[0] + y * (this.t1[1] + y * (this.t1[2] + y * (this.t1[3] + y * (this.t1[4] + y * (this.t1[5] + y * this.t1[6])))))) * x;
        } else {
            double y = 3.0 / x;
            double theta1 = x + this.p1[0] + y * (this.p1[1] + y * (this.p1[2] + y * (this.p1[3] + y * (this.p1[4] + y * (this.p1[5] + y * this.p1[6])))));
            double fone = this.f1[0] + y * (this.f1[1] + y * (this.f1[2] + y * (this.f1[3] + y * (this.f1[4] + y * (this.f1[5] + y * this.f1[6])))));
            r = Math.sqrt(1.0 / x) * fone * Math.cos(theta1);
        }
        return r;
    }

    private double J1x1(double x) {
        double r;
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            r = this.t1[0] + y * (this.t1[1] + y * (this.t1[2] + y * (this.t1[3] + y * (this.t1[4] + y * (this.t1[5] + y * this.t1[6])))));
        } else {
            double y = 3.0 / x;
            double theta1 = x + this.p1[0] + y * (this.p1[1] + y * (this.p1[2] + y * (this.p1[3] + y * (this.p1[4] + y * (this.p1[5] + y * this.p1[6])))));
            double fone = this.f1[0] + y * (this.f1[1] + y * (this.f1[2] + y * (this.f1[3] + y * (this.f1[4] + y * (this.f1[5] + y * this.f1[6])))));
            r = 1.0 / x * Math.sqrt(1.0 / x) * fone * Math.cos(theta1);
        }
        return r;
    }

    private double J1x3(double x) {
        double r;
        if (x < 0.0) {
            x *= -1.0;
        }
        if (x <= 3.0) {
            double y = x * x / 9.0;
            r = 1.0 / x / x * (this.t1[0] + y * (this.t1[1] + y * (this.t1[2] + y * (this.t1[3] + y * (this.t1[4] + y * (this.t1[5] + y * this.t1[6]))))));
        } else {
            double y = 3.0 / x;
            double theta1 = x + this.p1[0] + y * (this.p1[1] + y * (this.p1[2] + y * (this.p1[3] + y * (this.p1[4] + y * (this.p1[5] + y * this.p1[6])))));
            double fone = this.f1[0] + y * (this.f1[1] + y * (this.f1[2] + y * (this.f1[3] + y * (this.f1[4] + y * (this.f1[5] + y * this.f1[6])))));
            r = 1.0 / x / x / x * (Math.sqrt(1.0 / x) * fone * Math.cos(theta1));
        }
        return r;
    }

    private double interp(double[] y, double x) {
        int xfloor = (int)x;
        double xfrac = x - (double)xfloor;
        return (1.0 - xfrac) * y[xfloor] + xfrac * y[xfloor + 1];
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("PSFModelBeads", "" + this.beads);
        properties.setProperty("PSFModelThres", "" + this.threshold);
        properties.setProperty("PSFModelNi", "" + this.ni);
        properties.setProperty("PSFModelNa", "" + this.NA);
        properties.setProperty("PSFModelW040", "" + this.W040);
        properties.setProperty("PSFModelLambda", "" + this.lambda);
        properties.setProperty("PSFModelBackground", "" + this.background);
        properties.setProperty("PSFModelDeltar", "" + this.deltar);
        properties.setProperty("PSFModelDeltaz", "" + this.deltaz);
        properties.setProperty("PSFModelNx", "" + this.Nx);
        properties.setProperty("PSFModelNy", "" + this.Ny);
        properties.setProperty("PSFModelNz", "" + this.Nz);
        properties.setProperty("PSFModelIterations", "" + this.iterations);
        properties.setProperty("PSFModelNormMode", "" + this.normMode);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty("PSFModelBeads", "" + this.beads);
        this.beads = Integer.parseInt(s);
        s = properties.getProperty("PSFModelThres", "" + this.threshold);
        this.threshold = Float.parseFloat(s);
        s = properties.getProperty("PSFModelNi", "" + this.ni);
        this.ni = Float.parseFloat(s);
        s = properties.getProperty("PSFModelNa", "" + this.NA);
        this.NA = Float.parseFloat(s);
        s = properties.getProperty("PSFModelW040", "" + this.W040);
        this.W040 = Float.parseFloat(s);
        s = properties.getProperty("PSFModelLambda", "" + this.lambda);
        this.lambda = Float.parseFloat(s);
        s = properties.getProperty("PSFModelBackground", "" + this.background);
        this.background = Float.parseFloat(s);
        s = properties.getProperty("PSFModelDeltar", "" + this.deltar);
        this.deltar = Float.parseFloat(s);
        s = properties.getProperty("PSFModelDeltaz", "" + this.deltaz);
        this.deltaz = Float.parseFloat(s);
        s = properties.getProperty("PSFModelNx", "" + this.Nx);
        this.Nx = Integer.parseInt(s);
        s = properties.getProperty("PSFModelNy", "" + this.Ny);
        this.Ny = Integer.parseInt(s);
        s = properties.getProperty("PSFModelNz", "" + this.Nz);
        this.Nz = Integer.parseInt(s);
        s = properties.getProperty("PSFModelIterations", "" + this.iterations);
        this.iterations = Integer.parseInt(s);
        s = properties.getProperty("PSFModelNormMode", "" + this.normMode);
        this.normMode = Integer.parseInt(s);
    }

    @Override
    public void getParameters() {
        this.beads = Integer.parseInt(this.jTextFieldBeads.getText());
        this.threshold = Float.parseFloat(this.jTextFieldThres.getText());
        this.ni = Float.parseFloat(this.jTextFieldNi.getText());
        this.NA = Float.parseFloat(this.jTextFieldNa.getText());
        this.W040 = Float.parseFloat(this.jTextFieldW040.getText());
        this.lambda = Float.parseFloat(this.jTextFieldLambda.getText());
        this.background = Float.parseFloat(this.jTextFieldBackground.getText());
        this.deltar = Float.parseFloat(this.jTextFieldDeltar.getText());
        this.deltaz = Float.parseFloat(this.jTextFieldDeltaz.getText());
    }

    @Override
    public void updateGUI() {
        this.jTextFieldBeads.setText("" + this.beads);
        this.jTextFieldThres.setText("" + this.threshold);
        this.jTextFieldNi.setText("" + this.ni);
        this.jTextFieldNa.setText("" + this.NA);
        this.jTextFieldW040.setText("" + this.W040);
        this.jTextFieldLambda.setText("" + this.lambda);
        this.jTextFieldBackground.setText("" + this.background);
        this.jTextFieldDeltar.setText("" + this.deltar);
        this.jTextFieldDeltaz.setText("" + this.deltaz);
    }

    @Override
    public void reset() {
        this.beads = 1;
        this.threshold = 0.9f;
        this.ni = 1.51f;
        this.NA = 1.4f;
        this.W040 = 0.0f;
        this.lambda = 5.3E-7f;
        this.background = 500.0f;
        this.deltar = 1.0635E-7f;
        this.deltaz = 1.5625E-7f;
        this.Nx = 64;
        this.Ny = 64;
        this.Nz = 15;
        this.iterations = 3;
        this.normMode = this.PEAK;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == PSFModel.this.jTextFieldBeads) {
                return this.checkIntField(PSFModel.this.getName(), PSFModel.this.jLabelBeads.getText(), PSFModel.this.jTextFieldBeads, 0, 5, 1, changeIt);
            }
            if (input == PSFModel.this.jTextFieldThres) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelThres.getText(), PSFModel.this.jTextFieldThres, 0.0f, 1.0f, 0.9f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldNi) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelNi.getText(), PSFModel.this.jTextFieldNi, 0.0f, 10.0f, 0.9f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldNa) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelNa.getText(), PSFModel.this.jTextFieldNa, 0.0f, 10.0f, 0.5f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldW040) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelW040.getText(), PSFModel.this.jTextFieldW040, -1.0f, 1.0f, 0.0f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldLambda) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelLambda.getText(), PSFModel.this.jTextFieldLambda, 0.0f, 1.0f, 6.0E-7f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldBackground) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelBackground.getText(), PSFModel.this.jTextFieldBackground, 0.0f, 1000.0f, 500.0f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldDeltar) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelDeltar.getText(), PSFModel.this.jTextFieldDeltar, 0.0f, 1.0f, 1.0E-7f, changeIt);
            }
            if (input == PSFModel.this.jTextFieldDeltaz) {
                return this.checkFloatField(PSFModel.this.getName(), PSFModel.this.jLabelDeltaz.getText(), PSFModel.this.jTextFieldDeltaz, 0.0f, 1.0f, 5.0E-7f, changeIt);
            }
            return true;
        }
    }
}

