/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.Macro;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class RegularizedInverseFiltering
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelRegParam = null;
    private JTextField jTextFieldRegParam = null;
    private JCheckBox jCheckBoxRegParamEst = null;
    private static final float lambdamin = 0.0f;
    private static final float lambdamax = 1000000.0f;
    private static final float lambdadef = 1.0f;
    public float lambda = 1.0f;
    private static final boolean regParamEstdef = true;
    public boolean regParamEst = true;
    private JCheckBox jCheckBoxNoiseParamEst = null;
    private static final boolean noiseParamEstdef = true;
    public boolean noiseParamEst = true;
    private JLabel jLabelGain = null;
    private JTextField jTextFieldGain = null;
    private static final float gammamin = 1.0E-6f;
    private static final float gammamax = 1000000.0f;
    private static final float gammadef = 1.0f;
    public float gamma = 1.0f;
    private JLabel jLabelStdDev = null;
    private JTextField jTextFieldStdDev = null;
    private static final float sigmamin = 0.0f;
    private static final float sigmamax = 1000000.0f;
    private static final float sigmadef = 1.0f;
    public float sigma = 1.0f;
    private JLabel jLabelMean = null;
    private JTextField jTextFieldMean = null;
    private static final float mumin = 0.0f;
    private static final float mumax = 1000000.0f;
    private static final float mudef = 0.0f;
    public float mu = 0.0f;
    private MyVerifier verifier = new MyVerifier();

    public RegularizedInverseFiltering() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelRegularizedInverseFiltering");
        this.jLabelRegParam = new JLabel("Regularization parameter:");
        this.jTextFieldRegParam = new JTextField("" + this.lambda);
        this.jTextFieldRegParam.setInputVerifier(this.verifier);
        this.jTextFieldRegParam.setEnabled(!this.regParamEst);
        this.jCheckBoxRegParamEst = new JCheckBox("Auto-adjust reg. param.", this.regParamEst);
        this.jCheckBoxRegParamEst.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelRegParam, this.jTextFieldRegParam, this.jCheckBoxRegParamEst);
        this.jCheckBoxNoiseParamEst = new JCheckBox("Estimate noise parameters", this.noiseParamEst);
        this.jCheckBoxNoiseParamEst.addItemListener(this);
        this.jCheckBoxNoiseParamEst.setEnabled(this.regParamEst);
        this.jLabelGain = new JLabel("Gain of the Poisson component:");
        this.jTextFieldGain = new JTextField("" + this.gamma);
        this.jTextFieldGain.setInputVerifier(this.verifier);
        this.jTextFieldGain.setEnabled(!this.noiseParamEst);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelGain, this.jTextFieldGain, this.jCheckBoxNoiseParamEst);
        this.jLabelStdDev = new JLabel("Standard deviation of the Gaussian component:");
        this.jTextFieldStdDev = new JTextField("" + this.sigma);
        this.jTextFieldStdDev.setInputVerifier(this.verifier);
        this.jTextFieldStdDev.setEnabled(!this.noiseParamEst);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelStdDev, this.jTextFieldStdDev, null);
        this.jLabelMean = new JLabel("Mean value of the background signal:");
        this.jTextFieldMean = new JTextField("" + this.mu);
        this.jTextFieldMean.setInputVerifier(this.verifier);
        this.jTextFieldMean.setEnabled(!this.noiseParamEst);
        this.addTextFieldLine(this.jPanel, 3, 1.0, this.jLabelMean, this.jTextFieldMean, null);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Regularized inverse filtering";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        float serref = 0.0f;
        if (xorig != null && parameters.monitorPerf) {
            this.serg = new float[2];
            this.serg[0] = 0.0f;
            serref = ToolboxSignal.calculateSER(y, xorig);
            this.time = new float[2];
            this.time[0] = log.getElapsedTime();
        }
        log.start("FFT of image and PSF", 0);
        if (y.isReal) {
            tbFourier.forwardDFT(y);
        }
        log.setProgressLength(30);
        if (h.isReal) {
            tbFourier.forwardDFT(h);
        }
        log.acknowledge(0);
        log.setProgressLength(40);
        log.start("Inverse filtering", 0);
        this.regInvFilt(y, h, this.lambda);
        log.acknowledge(0);
        log.setProgressLength(70);
        log.start("Inverse FFT", 0);
        tbFourier.inverseDFT(y);
        log.acknowledge(0);
        log.setProgressLength(80);
        if (xorig != null && parameters.monitorPerf) {
            this.time[1] = log.getElapsedTime();
            this.serg[1] = ToolboxSignal.calculateSER(y, xorig) - serref;
        }
        if (parameters.saveVideo) {
            log.start("Saving PostRLS.tiff", 1);
            ToolboxSignal.save(y, parameters.folderVideo, "PostRLS");
            log.acknowledge(1);
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
        this.lambda = param;
    }

    public void regInvFilt(Signal y, Signal h, float lambda) {
        ToolboxSignal.multiplyConj(y, h);
        ToolboxSignal.multiplyConj(h, h);
        ToolboxSignal.addLaplacianSquare2D3D(h, lambda);
        ToolboxSignal.divideStable(y, h, 1.0E-7f);
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("RegularizedInverseFiltering|regParamEst", Boolean.toString(this.regParamEst));
        properties.setProperty("RegularizedInverseFiltering|lambda", Float.toString(this.lambda));
        properties.setProperty("RegularizedInverseFiltering|noiseParamEst", Boolean.toString(this.noiseParamEst));
        properties.setProperty("RegularizedInverseFiltering|gamma", Float.toString(this.gamma));
        properties.setProperty("RegularizedInverseFiltering|sigma", Float.toString(this.sigma));
        properties.setProperty("RegularizedInverseFiltering|mu", Float.toString(this.mu));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.regParamEst = Boolean.parseBoolean(properties.getProperty("RegularizedInverseFiltering|regParamEst", Boolean.toString(true)));
        this.lambda = Float.parseFloat(properties.getProperty("RegularizedInverseFiltering|lambda", Float.toString(1.0f)));
        this.noiseParamEst = Boolean.parseBoolean(properties.getProperty("RegularizedInverseFiltering|noiseParamEst", Boolean.toString(true)));
        this.gamma = Float.parseFloat(properties.getProperty("RegularizedInverseFiltering|gamma", Float.toString(1.0f)));
        this.sigma = Float.parseFloat(properties.getProperty("RegularizedInverseFiltering|sigma", Float.toString(1.0f)));
        this.mu = Float.parseFloat(properties.getProperty("RegularizedInverseFiltering|mu", Float.toString(0.0f)));
    }

    @Override
    public void getMacroParameters(String options) {
        this.regParamEst = Boolean.parseBoolean(Macro.getValue((String)options, (String)"regParamEst", (String)Boolean.toString(true)));
        this.lambda = Float.parseFloat(Macro.getValue((String)options, (String)"lambda", (String)Float.toString(1.0f)));
        this.noiseParamEst = Boolean.parseBoolean(Macro.getValue((String)options, (String)"noiseParamEst", (String)Boolean.toString(true)));
        this.gamma = Float.parseFloat(Macro.getValue((String)options, (String)"gamma", (String)Float.toString(1.0f)));
        this.sigma = Float.parseFloat(Macro.getValue((String)options, (String)"sigma", (String)Float.toString(1.0f)));
        this.mu = Float.parseFloat(Macro.getValue((String)options, (String)"mu", (String)Float.toString(0.0f)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append("regParamEst: " + this.regParamEst, 2);
        log.append("lambda: " + this.lambda, 2);
        log.append("noiseParamEst: " + this.noiseParamEst, 2);
        log.append("gamma: " + this.gamma, 2);
        log.append("sigma: " + this.sigma, 2);
        log.append("mu: " + this.mu, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.regParamEst = this.jCheckBoxRegParamEst.isSelected();
        this.lambda = Float.parseFloat(this.jTextFieldRegParam.getText());
        this.noiseParamEst = this.jCheckBoxNoiseParamEst.isSelected();
        this.gamma = Float.parseFloat(this.jTextFieldGain.getText());
        this.sigma = Float.parseFloat(this.jTextFieldStdDev.getText());
        this.mu = Float.parseFloat(this.jTextFieldMean.getText());
    }

    @Override
    public void updateGUI() {
        this.jCheckBoxRegParamEst.setSelected(this.regParamEst);
        this.jTextFieldRegParam.setText("" + this.lambda);
        this.jCheckBoxNoiseParamEst.setSelected(this.noiseParamEst);
        this.jTextFieldGain.setText("" + this.gamma);
        this.jTextFieldStdDev.setText("" + this.sigma);
        this.jTextFieldMean.setText("" + this.mu);
    }

    @Override
    public void reset() {
        this.regParamEst = true;
        this.lambda = 1.0f;
        this.noiseParamEst = true;
        this.gamma = 1.0f;
        this.sigma = 1.0f;
        this.mu = 0.0f;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable src = event.getItemSelectable();
        if (src == this.jCheckBoxRegParamEst) {
            this.jTextFieldRegParam.setEnabled(!this.jCheckBoxRegParamEst.isSelected());
            this.jTextFieldGain.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldStdDev.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldMean.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jCheckBoxNoiseParamEst.setEnabled(this.jCheckBoxRegParamEst.isSelected());
        } else if (src == this.jCheckBoxNoiseParamEst) {
            this.jTextFieldGain.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldStdDev.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldMean.setEnabled(this.jCheckBoxRegParamEst.isSelected() & !this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldGain.setEnabled(!this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldStdDev.setEnabled(!this.jCheckBoxNoiseParamEst.isSelected());
            this.jTextFieldMean.setEnabled(!this.jCheckBoxNoiseParamEst.isSelected());
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == RegularizedInverseFiltering.this.jTextFieldRegParam) {
                return this.checkFloatField(RegularizedInverseFiltering.this.getName(), RegularizedInverseFiltering.this.jLabelRegParam.getText(), RegularizedInverseFiltering.this.jTextFieldRegParam, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == RegularizedInverseFiltering.this.jTextFieldGain) {
                return this.checkFloatField(RegularizedInverseFiltering.this.getName(), RegularizedInverseFiltering.this.jLabelGain.getText(), RegularizedInverseFiltering.this.jTextFieldGain, 1.0E-6f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == RegularizedInverseFiltering.this.jTextFieldStdDev) {
                return this.checkFloatField(RegularizedInverseFiltering.this.getName(), RegularizedInverseFiltering.this.jLabelStdDev.getText(), RegularizedInverseFiltering.this.jTextFieldStdDev, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == RegularizedInverseFiltering.this.jTextFieldMean) {
                return this.checkFloatField(RegularizedInverseFiltering.this.getName(), RegularizedInverseFiltering.this.jLabelMean.getText(), RegularizedInverseFiltering.this.jTextFieldMean, 0.0f, 1000000.0f, 0.0f, changeIt);
            }
            return true;
        }
    }
}

