/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class RichardsonLucy
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelInitialEst = null;
    private JComboBox jComboBoxInitialEst = null;
    private JCheckBox jCheckBoxUseInputImg = null;
    private static final String initialEstdef = new String();
    public String initialEst = new String(initialEstdef);
    private static final boolean useInputImgdef = true;
    public boolean useInputImg = true;
    private JLabel jLabelNumIter = null;
    private JTextField jTextFieldNumIter = null;
    private static final int Kmin = 1;
    private static final int Kmax = 1000000;
    private static final int Kdef = 10;
    public int K = 10;
    private MyVerifier verifier = new MyVerifier();

    public RichardsonLucy() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelRichardsonLucy");
        this.jLabelNumIter = new JLabel();
        this.jTextFieldNumIter = new JTextField();
        this.jLabelInitialEst = new JLabel("Initial estimate:");
        this.jComboBoxInitialEst = new JComboBox();
        super.setImageList(this.jComboBoxInitialEst);
        this.jComboBoxInitialEst.setEnabled(!this.useInputImg);
        this.jCheckBoxUseInputImg = new JCheckBox("Use input image");
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jCheckBoxUseInputImg.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelInitialEst, this.jComboBoxInitialEst, this.jCheckBoxUseInputImg);
        this.jLabelNumIter.setText("Number of iterations:");
        this.jTextFieldNumIter.setText(Integer.toString(this.K));
        this.jTextFieldNumIter.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 1, 1.0, this.jLabelNumIter, this.jTextFieldNumIter, null);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Richardson-Lucy";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        int k = 0;
        float serref = 0.0f;
        Signal ybkp = null;
        Signal yold = null;
        if (xorig != null && parameters.monitorPerf) {
            this.serg = new float[this.K + 1];
            this.time = new float[this.K + 1];
            serref = ToolboxSignal.calculateSER(y, xorig);
        }
        ToolboxSignal.minConstraint(y, 0.0f, false, tbFourier);
        log.start("Preparing temporary objects", 0);
        ybkp = (Signal)y.clone();
        if (!this.useInputImg) {
            ImagePlus newInit = WindowManager.getImage((String)this.initialEst);
            if (newInit == null) {
                IJ.error((String)("Initial estimate \"" + this.initialEst + "\" was not found.\n" + "Using input image instead."));
            } else {
                Signal ynew = new Signal(newInit);
                if (!ToolboxSignal.checkCompatibility(y, ynew)) {
                    IJ.error((String)("Initial estimate \"" + this.initialEst + "\" does not\n" + "have the same size as the input image. Using\n" + "input image instead."));
                } else {
                    ToolboxSignal.transfer(y, ynew);
                    log.append("Initial estimate: " + this.initialEst, 0);
                }
            }
        }
        yold = (Signal)y.clone();
        tbFourier.forwardDFT(yold);
        tbFourier.forwardDFT(h);
        log.setProgressLength(40);
        log.acknowledge(0);
        if (xorig != null && parameters.monitorPerf) {
            this.serg[0] = ToolboxSignal.calculateSER(y, xorig) - serref;
            this.time[0] = log.getElapsedTime();
        }
        k = 1;
        while (k <= this.K) {
            ToolboxSignal.multiply(yold, h);
            tbFourier.inverseDFT(yold);
            ToolboxSignal.divideStable2(ybkp, yold, 1.0E-7f);
            tbFourier.forwardDFT(yold);
            ToolboxSignal.multiplyConj(yold, h);
            tbFourier.inverseDFT(yold);
            ToolboxSignal.multiply(y, yold);
            if (k < this.K) {
                ToolboxSignal.copy(yold, y);
                tbFourier.forwardDFT(yold);
            }
            log.appendWithTime("Iteration " + k + " completed.", 1);
            log.setProgressLength(40 + (int)((double)(55 * k) / (double)this.K));
            if (xorig != null && parameters.monitorPerf) {
                this.time[k] = log.getElapsedTime();
                this.serg[k] = ToolboxSignal.calculateSER(y, xorig) - serref;
            }
            if (parameters.saveVideo) {
                log.start("Saving RichardsonLucyIter" + k + ".tiff", 1);
                ToolboxSignal.save(y, parameters.folderVideo, "RichardsonLucyIter" + k);
                log.acknowledge(1);
            }
            ++k;
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("RichardsonLucy|initialEst", this.initialEst);
        properties.setProperty("RichardsonLucy|useInputImg", Boolean.toString(this.useInputImg));
        properties.setProperty("RichardsonLucy|K", Integer.toString(this.K));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.initialEst = properties.getProperty("RichardsonLucy|initialEst", initialEstdef);
        this.useInputImg = Boolean.parseBoolean(properties.getProperty("RichardsonLucy|useImputImg", Boolean.toString(true)));
        this.K = Integer.parseInt(properties.getProperty("RichardsonLucy|K", Integer.toString(10)));
    }

    @Override
    public void getMacroParameters(String options) {
        this.initialEst = Macro.getValue((String)options, (String)"initialEst", (String)initialEstdef);
        this.useInputImg = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useInputImg", (String)Boolean.toString(true)));
        this.K = Integer.parseInt(Macro.getValue((String)options, (String)"K", (String)Integer.toString(10)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append("initialEst: " + this.initialEst, 2);
        log.append("useInputImg: " + this.useInputImg, 2);
        log.append(String.valueOf(this.jLabelNumIter.getText()) + " (K) " + this.K, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.initialEst = (String)this.jComboBoxInitialEst.getSelectedItem();
        this.useInputImg = this.jCheckBoxUseInputImg.isSelected();
        this.K = Integer.parseInt(this.jTextFieldNumIter.getText());
    }

    @Override
    public void updateGUI() {
        this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jTextFieldNumIter.setText(Integer.toString(this.K));
    }

    @Override
    public void reset() {
        this.initialEst = initialEstdef;
        this.useInputImg = true;
        this.K = 10;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItemSelectable() == this.jCheckBoxUseInputImg) {
            super.setImageList(this.jComboBoxInitialEst);
            this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
            this.jComboBoxInitialEst.setEnabled(!this.jCheckBoxUseInputImg.isSelected());
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == RichardsonLucy.this.jTextFieldNumIter) {
                return this.checkIntField(RichardsonLucy.this.getName(), RichardsonLucy.this.jLabelNumIter.getText(), RichardsonLucy.this.jTextFieldNumIter, 1, 1000000, 10, changeIt);
            }
            return true;
        }
    }
}

