/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class RichardsonLucyTV
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelRegParam = null;
    private JTextField jTextFieldRegParam = null;
    private static final float lambdamin = 0.0f;
    private static final float lambdamax = 1000000.0f;
    private static final float lambdadef = 1.0f;
    public float lambda = 1.0f;
    private JLabel jLabelInitialEst = null;
    private JComboBox jComboBoxInitialEst = null;
    private JCheckBox jCheckBoxUseInputImg = null;
    private static final String initialEstdef = new String();
    public String initialEst = new String(initialEstdef);
    private static final boolean useInputImgdef = true;
    public boolean useInputImg = true;
    private JLabel jLabelNumIter = null;
    private JTextField jTextFieldNumIter = null;
    private JCheckBox jCheckBoxPosConstraint = null;
    private static final int Kmin = 1;
    private static final int Kmax = 1000000;
    private static final int Kdef = 10;
    public int K = 10;
    private static final boolean posConstraintdef = true;
    public boolean posConstraint = true;
    private MyVerifier verifier = new MyVerifier();

    public RichardsonLucyTV() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelRichardsonLucyTV");
        this.jLabelRegParam = new JLabel("Regularization parameter:");
        this.jTextFieldRegParam = new JTextField(Float.toString(this.lambda));
        this.jTextFieldRegParam.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelRegParam, this.jTextFieldRegParam, null);
        this.jLabelInitialEst = new JLabel("Initial estimate:");
        this.jComboBoxInitialEst = new JComboBox();
        super.setImageList(this.jComboBoxInitialEst);
        this.jComboBoxInitialEst.setEnabled(!this.useInputImg);
        this.jCheckBoxUseInputImg = new JCheckBox("Use input image");
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jCheckBoxUseInputImg.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelInitialEst, this.jComboBoxInitialEst, this.jCheckBoxUseInputImg);
        this.jLabelNumIter = new JLabel("Number of iterations:");
        this.jTextFieldNumIter = new JTextField(Integer.toString(this.K));
        this.jTextFieldNumIter.setInputVerifier(this.verifier);
        this.jCheckBoxPosConstraint = new JCheckBox("Positivity constraint", this.posConstraint);
        this.jCheckBoxPosConstraint.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 2, 1.0, this.jLabelNumIter, this.jTextFieldNumIter, this.jCheckBoxPosConstraint);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Richardson-Lucy with TV regularization";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        int k = 0;
        float serref = 0.0f;
        Signal gmes = null;
        Signal yold = null;
        Signal yTV = null;
        if (xorig != null && parameters.monitorPerf) {
            this.serg = new float[this.K + 1];
            this.time = new float[this.K + 1];
            serref = ToolboxSignal.calculateSER(y, xorig);
        }
        if (this.posConstraint) {
            ToolboxSignal.minConstraint(y, 0.0f, false, tbFourier);
        }
        log.start("Preparing temporary objects", 0);
        gmes = (Signal)y.clone();
        if (!this.useInputImg) {
            ImagePlus newInit = WindowManager.getImage((String)this.initialEst);
            if (newInit == null) {
                IJ.error((String)("Initial estimate \"" + this.initialEst + "\" was not found.\n" + "Using input image instead."));
            } else {
                Signal ynew = new Signal(newInit);
                if (!ToolboxSignal.checkCompatibility(y, ynew)) {
                    IJ.error((String)("Initial estimate \"" + this.initialEst + "\" does not\n" + "have the same size as the input image. Using\n" + "input image instead."));
                } else {
                    ToolboxSignal.transfer(y, ynew);
                    log.append("Initial estimate: " + this.initialEst, 0);
                }
            }
        }
        yold = (Signal)y.clone();
        yTV = (Signal)y.clone();
        tbFourier.forwardDFT(yold);
        tbFourier.forwardDFT(h);
        log.setProgressLength(40);
        log.acknowledge(0);
        if (xorig != null && parameters.monitorPerf) {
            this.serg[0] = ToolboxSignal.calculateSER(y, xorig) - serref;
            this.time[0] = log.getElapsedTime();
        }
        k = 1;
        while (k <= this.K) {
            ToolboxSignal.multiply(yold, h);
            tbFourier.inverseDFT(yold);
            ToolboxSignal.divideStable2(gmes, yold, 1.0E-7f);
            tbFourier.forwardDFT(yold);
            ToolboxSignal.multiplyConj(yold, h);
            tbFourier.inverseDFT(yold);
            ToolboxSignal.minConstraint(yold, 0.0f, false, null);
            RichardsonLucyTV.totalVariation(yTV);
            ToolboxSignal.multiplyConstant(yTV, -this.lambda);
            ToolboxSignal.addConstant(yTV, 1.0f, 0.0f);
            ToolboxSignal.divideStable(y, yTV, 1.0E-7f);
            ToolboxSignal.multiply(y, yold);
            if (this.posConstraint) {
                ToolboxSignal.minConstraint(y, 0.0f, false, tbFourier);
            }
            if (k < this.K) {
                ToolboxSignal.copy(yold, y);
                ToolboxSignal.copy(yTV, y);
                tbFourier.forwardDFT(yold);
            }
            log.appendWithTime("Iteration " + k + " completed.", 1);
            log.setProgressLength(40 + (int)((double)(55 * k) / (double)this.K));
            if (xorig != null && parameters.monitorPerf) {
                this.time[k] = log.getElapsedTime();
                this.serg[k] = ToolboxSignal.calculateSER(y, xorig) - serref;
            }
            if (parameters.saveVideo) {
                log.start("Saving RichardsonLucyTVIter" + k + ".tiff", 1);
                ToolboxSignal.save(y, parameters.folderVideo, "RichardsonLucyTVIter" + k);
                log.acknowledge(1);
            }
            ++k;
        }
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
        this.lambda = param;
    }

    private static void totalVariation(Signal s) {
        Signal[] sDerivates = new Signal[s.D];
        int i = 0;
        while (i < s.D) {
            sDerivates[i] = (Signal)s.clone();
            ToolboxSignal.derivate1D(sDerivates[i], i);
            ++i;
        }
        RichardsonLucyTV.normalize(sDerivates);
        i = 0;
        while (i < s.D) {
            ToolboxSignal.derivate1D(sDerivates[i], i);
            ++i;
        }
        ToolboxSignal.multiplyConstant(s, 0.0f);
        i = 0;
        while (i < s.D) {
            ToolboxSignal.add(s, sDerivates[i]);
            ++i;
        }
    }

    private static void normalize(Signal[] sArray) {
        int i = 0;
        while (i < sArray[0].extLength) {
            if (i % sArray[0].extN[sArray[0].D - 1] < sArray[0].N[sArray[0].D - 1]) {
                float sum = 0.0f;
                int j = 0;
                while (j < sArray.length) {
                    sum += sArray[j].array[i] * sArray[j].array[i];
                    ++j;
                }
                sum = (float)Math.sqrt(sum);
                j = 0;
                while (j < sArray.length) {
                    if (sum == 0.0f) {
                        sArray[j].array[i] = 0.0f;
                    } else {
                        int n = i;
                        sArray[j].array[n] = sArray[j].array[n] / sum;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("RichardsonLucyTV|lambda", Float.toString(this.lambda));
        properties.setProperty("RichardsonLucyTV|initialEst", this.initialEst);
        properties.setProperty("RichardsonLucyTV|useInputImg", Boolean.toString(this.useInputImg));
        properties.setProperty("RichardsonLucyTV|K", Integer.toString(this.K));
        properties.setProperty("RichardsonLucyTV|posConstraint", Boolean.toString(this.posConstraint));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.lambda = Float.parseFloat(properties.getProperty("RichardsonLucyTV|lambda", Float.toString(1.0f)));
        this.initialEst = properties.getProperty("RichardsonLucyTV|initialEst", initialEstdef);
        this.useInputImg = Boolean.parseBoolean(properties.getProperty("RichardsonLucyTV|useInputImg", Boolean.toString(true)));
        this.K = Integer.parseInt(properties.getProperty("RichardsonLucyTV|K", Integer.toString(10)));
        this.posConstraint = Boolean.parseBoolean(properties.getProperty("RichardsonLucyTV|posConstraint", Boolean.toString(true)));
    }

    @Override
    public void getMacroParameters(String options) {
        this.lambda = Float.parseFloat(Macro.getValue((String)options, (String)"lambda", (String)Float.toString(1.0f)));
        this.initialEst = Macro.getValue((String)options, (String)"initialEst", (String)initialEstdef);
        this.useInputImg = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useInputImg", (String)Boolean.toString(true)));
        this.K = Integer.parseInt(Macro.getValue((String)options, (String)"K", (String)Integer.toString(10)));
        this.posConstraint = Boolean.parseBoolean(Macro.getValue((String)options, (String)"posConstraint", (String)Boolean.toString(true)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append(String.valueOf(this.jLabelRegParam.getText()) + " (lambda) " + this.lambda, 2);
        log.append("initialEst: " + this.initialEst, 2);
        log.append("useInputImg: " + this.useInputImg, 2);
        log.append(String.valueOf(this.jLabelNumIter.getText()) + " (K) " + this.K, 2);
        log.append("posConstraint: " + this.posConstraint, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.lambda = Float.parseFloat(this.jTextFieldRegParam.getText());
        this.initialEst = (String)this.jComboBoxInitialEst.getSelectedItem();
        this.useInputImg = this.jCheckBoxUseInputImg.isSelected();
        this.K = Integer.parseInt(this.jTextFieldNumIter.getText());
    }

    @Override
    public void updateGUI() {
        this.jTextFieldRegParam.setText("" + this.lambda);
        this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jTextFieldNumIter.setText("" + this.K);
    }

    @Override
    public void reset() {
        this.lambda = 1.0f;
        this.initialEst = initialEstdef;
        this.useInputImg = true;
        this.K = 10;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getItemSelectable() == this.jCheckBoxUseInputImg) {
            super.setImageList(this.jComboBoxInitialEst);
            this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
            this.jComboBoxInitialEst.setEnabled(!this.jCheckBoxUseInputImg.isSelected());
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == RichardsonLucyTV.this.jTextFieldRegParam) {
                return this.checkFloatField(RichardsonLucyTV.this.getName(), RichardsonLucyTV.this.jLabelRegParam.getText(), RichardsonLucyTV.this.jTextFieldRegParam, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == RichardsonLucyTV.this.jTextFieldNumIter) {
                return this.checkIntField(RichardsonLucyTV.this.getName(), RichardsonLucyTV.this.jLabelNumIter.getText(), RichardsonLucyTV.this.jTextFieldNumIter, 1, 1000000, 10, changeIt);
            }
            return true;
        }
    }
}

