/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import toolbox.Signal;
import toolbox.ToolboxSignal;

public class RiskEstimation {
    public static float getOptimalLambda(Signal yhat, Signal hhat, float gamma, float mu, float sigma2) {
        float lambdaini;
        Signal lhat = new Signal(yhat.N);
        ToolboxSignal.laplacian2D3D(lhat);
        float lambda = lambdaini = RiskEstimation.getInitialLambda(yhat, hhat, lhat, gamma, mu, sigma2);
        return lambda;
    }

    public static float getInitialLambda(Signal yhat, Signal hhat, Signal lhat, float gamma, float mu, float sigma2) {
        float lambdaopt = (float)Math.pow(10.0, -10.0);
        double riskmin = RiskEstimation.evaluateRisk(yhat, hhat, lhat, lambdaopt, gamma, mu, sigma2);
        int i = -9;
        while (i <= 10) {
            float lambda = (float)Math.pow(10.0, i);
            double risk = RiskEstimation.evaluateRisk(yhat, hhat, lhat, lambda, gamma, mu, sigma2);
            if (risk < riskmin) {
                riskmin = risk;
                lambdaopt = lambda;
            }
            ++i;
        }
        return lambdaopt;
    }

    public static double evaluateRisk(Signal yhat, Signal hhat, Signal lhat, float lambda, float gamma, float mu, float sigma2) {
        double risk = 0.0;
        int extN0 = yhat.extN[yhat.D - 1] / 2;
        int i = 0;
        while (i < yhat.extLength / 2) {
            float y2 = RiskEstimation.abs2(yhat.array[2 * i], yhat.array[2 * i + 1]);
            float h2 = RiskEstimation.abs2(hhat.array[2 * i], hhat.array[2 * i + 1]);
            float l2 = RiskEstimation.abs2(lhat.array[2 * i], lhat.array[2 * i + 1]);
            float tmp = h2 + lambda * l2;
            tmp = ((gamma * h2 / tmp - 2.0f) * y2 + (float)(2 * yhat.length) * mu * yhat.array[0] + 2.0f * gamma * (yhat.array[0] + (float)yhat.length * mu) + (float)(2 * yhat.length) * sigma2) / tmp;
            if ((extN0 % 2 == 0 || i % extN0 != extN0 - 1) && i % extN0 != 0) {
                tmp *= 2.0f;
            }
            risk += (double)tmp;
            ++i;
        }
        return risk /= (double)(gamma * (float)yhat.length);
    }

    public static double evaluateRiskD1(Signal yhat, Signal hhat, Signal lhat, float lambda, float sigma2) {
        double riskD1 = 0.0;
        int extN0 = yhat.extN[yhat.D - 1] / 2;
        int i = 0;
        while (i < yhat.extLength / 2) {
            float y2 = RiskEstimation.abs2(yhat.array[2 * i], yhat.array[2 * i + 1]);
            float h2 = RiskEstimation.abs2(hhat.array[2 * i], hhat.array[2 * i + 1]);
            float l2 = RiskEstimation.abs2(lhat.array[2 * i], lhat.array[2 * i + 1]);
            float tmp = h2 + lambda * l2;
            tmp = l2 * ((-2.0f * h2 / tmp + 2.0f) * y2 - 2.0f * yhat.array[0] - (float)(2 * yhat.length) * sigma2) / tmp / tmp;
            if ((extN0 % 2 == 0 || i % extN0 != extN0 - 1) && i % extN0 != 0) {
                tmp *= 2.0f;
            }
            riskD1 += (double)tmp;
            ++i;
        }
        return riskD1 /= (double)yhat.length;
    }

    public static double evaluateRiskD2(Signal yhat, Signal hhat, Signal lhat, float lambda, float sigma2) {
        double riskD2 = 0.0;
        int extN0 = yhat.extN[yhat.D - 1] / 2;
        int i = 0;
        while (i < yhat.extLength / 2) {
            float y2 = RiskEstimation.abs2(yhat.array[2 * i], yhat.array[2 * i + 1]);
            float h2 = RiskEstimation.abs2(hhat.array[2 * i], hhat.array[2 * i + 1]);
            float l2 = RiskEstimation.abs2(lhat.array[2 * i], lhat.array[2 * i + 1]);
            float tmp = h2 + lambda * l2;
            tmp = l2 * l2 * ((6.0f * h2 / tmp - 4.0f) * y2 + 4.0f * yhat.array[0] + (float)(4 * yhat.length) * sigma2) / tmp / tmp / tmp;
            if ((extN0 % 2 == 0 || i % extN0 != extN0 - 1) && i % extN0 != 0) {
                tmp *= 2.0f;
            }
            riskD2 += (double)tmp;
            ++i;
        }
        return riskD2 /= (double)yhat.length;
    }

    private static float abs2(float real, float imag) {
        return real * real + imag * imag;
    }
}

