/*
 * Decompiled with CFR 0.152.
 */
package deconv.algo;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import ij.Macro;
import ij.WindowManager;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import java.util.Random;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.ToolboxWavelet;
import toolbox.gui.AbstractVerifier;

public class ThresholdedLandweber
extends AbstractAlgorithm
implements ActionListener,
ItemListener {
    private JPanel jPanel = null;
    private JLabel jLabelRegParam = null;
    private JTextField jTextFieldRegParam = null;
    private static final float lambdamin = 0.0f;
    private static final float lambdamax = 1000000.0f;
    private static final float lambdadef = 1.0f;
    public float lambda = 1.0f;
    private JLabel jLabelWavFamily = null;
    private JComboBox jComboBoxWavFamily = null;
    private static final int wavFamilydef = 0;
    public int wavFamily = 0;
    private JLabel jLabelNumLevel = null;
    private JTextField jTextFieldNumLevel = null;
    private static final int Jmin = 1;
    private static final int Jmax = 10;
    private static final int Jdef = 3;
    public int J = 3;
    private JLabel jLabelThresh = null;
    private JComboBox jComboBoxThreshType = null;
    private JCheckBox jCheckBoxRandomShifts = null;
    private static final int threshTypedef = 0;
    public int threshType = 0;
    private static final boolean randomShiftsdef = true;
    public boolean randomShifts = true;
    private JLabel jLabelInitialEst = null;
    private JComboBox jComboBoxInitialEst = null;
    private JCheckBox jCheckBoxUseInputImg = null;
    private static final String initialEstdef = new String();
    public String initialEst = new String(initialEstdef);
    private static final boolean useInputImgdef = true;
    public boolean useInputImg = true;
    private JLabel jLabelNumIter = null;
    private JTextField jTextFieldNumIter = null;
    private static final int Kmin = 1;
    private static final int Kmax = 1000000;
    private static final int Kdef = 10;
    public int K = 10;
    private JLabel jLabelStepSize = null;
    private JTextField jTextFieldStepSize = null;
    private JCheckBox jCheckBoxOptStepSize = null;
    private static final float taumin = 0.0f;
    private static final float taumax = 1000000.0f;
    private static final float taudef = 1.0f;
    public float tau = 1.0f;
    private static final boolean autoStepSizedef = true;
    public boolean autoStepSize = true;
    private JLabel jLabelStopCrit = null;
    private JComboBox jComboBoxStopCrit = null;
    private static final int FIXEDNUMITER = 0;
    private static final int RESIDUAL = 1;
    private static final int UPDATE = 2;
    private static final int stopCritdef = 0;
    public int stopCrit = 0;
    private JLabel jLabelStopCritName = null;
    private JTextField jTextFieldStopCritValue = null;
    private JCheckBox jCheckBoxStopCritOption = null;
    private static final float sigmamin = 0.0f;
    private static final float sigmamax = 1000.0f;
    private static final float sigmadef = 1.0f;
    public float sigma = 1.0f;
    private static final boolean estimateSigmadef = false;
    public boolean estimateSigma = false;
    private static final float tolerancemin = 0.0f;
    private static final float tolerancemax = 1.0f;
    private static final float tolerancedef = 0.001f;
    public float tolerance = 0.001f;
    private MyVerifier verifier = new MyVerifier();

    public ThresholdedLandweber() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelThresholdedLandweber");
        this.jLabelRegParam = new JLabel("Regularization parameter:");
        this.jTextFieldRegParam = new JTextField(Float.toString(this.lambda));
        this.jTextFieldRegParam.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelRegParam, this.jTextFieldRegParam, null);
        this.jLabelWavFamily = new JLabel("Wavelet family:");
        this.jComboBoxWavFamily = new JComboBox<String>(ToolboxWavelet.wavFamily);
        this.addTextFieldLine(this.jPanel, 1, 0.0, this.jLabelWavFamily, this.jComboBoxWavFamily, null);
        this.jLabelNumLevel = new JLabel("Number of decomposition levels:");
        this.jTextFieldNumLevel = new JTextField(Integer.toString(this.J));
        this.jTextFieldNumLevel.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 2, 0.0, this.jLabelNumLevel, this.jTextFieldNumLevel, null);
        this.jLabelThresh = new JLabel("Thresholding:");
        this.jComboBoxThreshType = new JComboBox<String>(ToolboxWavelet.threshType);
        this.jCheckBoxRandomShifts = new JCheckBox("Apply random shifts", this.randomShifts);
        this.addTextFieldLine(this.jPanel, 3, 0.0, this.jLabelThresh, this.jComboBoxThreshType, this.jCheckBoxRandomShifts);
        this.jLabelInitialEst = new JLabel("Initial estimate:");
        this.jComboBoxInitialEst = new JComboBox();
        super.setImageList(this.jComboBoxInitialEst);
        this.jComboBoxInitialEst.setEnabled(!this.useInputImg);
        this.jCheckBoxUseInputImg = new JCheckBox("Use input image", this.useInputImg);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jCheckBoxUseInputImg.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 4, 0.0, this.jLabelInitialEst, this.jComboBoxInitialEst, this.jCheckBoxUseInputImg);
        this.jLabelNumIter = new JLabel("Number of iterations (maximum):");
        this.jTextFieldNumIter = new JTextField(Integer.toString(this.K));
        this.jTextFieldNumIter.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 5, 0.0, this.jLabelNumIter, this.jTextFieldNumIter, null);
        this.jLabelStepSize = new JLabel("Step size:");
        this.jTextFieldStepSize = new JTextField(Float.toString(this.tau));
        this.jTextFieldStepSize.setInputVerifier(this.verifier);
        this.jTextFieldStepSize.setEnabled(!this.autoStepSize);
        this.jCheckBoxOptStepSize = new JCheckBox("Auto-adjust step size", this.autoStepSize);
        this.jCheckBoxOptStepSize.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 6, 0.0, this.jLabelStepSize, this.jTextFieldStepSize, this.jCheckBoxOptStepSize);
        this.jLabelStopCrit = new JLabel("Early-stopping criterion:");
        this.jComboBoxStopCrit = new JComboBox();
        this.jComboBoxStopCrit.addItem("None (fixed number of iterations)");
        this.jComboBoxStopCrit.addItem("StdDev of residual < StdDev of noise");
        this.jComboBoxStopCrit.addItem("Norm of update / Norm of estimate < Tolerance");
        this.jComboBoxStopCrit.setSelectedIndex(this.stopCrit);
        this.jComboBoxStopCrit.addActionListener(this);
        this.addTextFieldLine(this.jPanel, 7, 0.0, 2, this.jLabelStopCrit, this.jComboBoxStopCrit, null);
        this.jLabelStopCritName = new JLabel(" ");
        this.jTextFieldStopCritValue = new JTextField();
        this.jTextFieldStopCritValue.setVisible(false);
        this.jTextFieldStopCritValue.setInputVerifier(this.verifier);
        this.jCheckBoxStopCritOption = new JCheckBox();
        this.jCheckBoxStopCritOption.setVisible(false);
        this.jCheckBoxStopCritOption.addItemListener(this);
        this.addTextFieldLine(this.jPanel, 8, 0.0, this.jLabelStopCritName, this.jTextFieldStopCritValue, this.jCheckBoxStopCritOption);
        this.addTextFieldLine(this.jPanel, 9, 1.0, new JLabel(" "), null, null);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Thresholded Landweber";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        int k = 0;
        SignalWavelet yw = new SignalWavelet(y.N, this.J);
        ToolboxWavelet tbWavelet = new ToolboxWavelet(yw, this.wavFamily, parameters.useFFTW, parameters.fileWisdom);
        Random generator = null;
        if (this.randomShifts) {
            generator = parameters.useSeed ? new Random((long)parameters.seed) : new Random();
        }
        int[] n0 = new int[y.D];
        float[][] mr = new float[y.D][];
        float[][] mi = new float[y.D][];
        float serref = 0.0f;
        Signal hbkp = null;
        Signal ybkp = null;
        if (xorig != null && parameters.monitorPerf) {
            this.serg = new float[this.K + 1];
            this.time = new float[this.K + 1];
            serref = ToolboxSignal.calculateSER(y, xorig);
            tbFourier.forwardDFT(xorig);
        }
        log.start("FFT of input image and PSF", 0);
        tbFourier.forwardDFT(y);
        tbFourier.forwardDFT(h);
        log.acknowledge(0);
        log.setProgressLength(30);
        if (this.stopCrit == 1) {
            hbkp = (Signal)h.clone();
            ybkp = (Signal)y.clone();
            if (this.estimateSigma) {
                this.sigma = ToolboxSignal.estimateSigma(y, parameters.useFFTW, parameters.fileWisdom);
                log.append("Estimated standard deviation of noise: " + this.sigma, 2);
            }
        }
        Signal b = (Signal)h.clone();
        ToolboxSignal.conjugate(b);
        ToolboxSignal.multiply(b, y);
        ToolboxSignal.multiplyConj(h, h);
        if (this.autoStepSize) {
            this.tau = 2.0f / (ToolboxSignal.minimum(h) + ToolboxSignal.maximum(h));
            log.append("Step-size value: " + this.tau, 1);
        }
        ToolboxSignal.multiplyConstant(b, this.tau);
        log.setProgressLength(35);
        ToolboxSignal.multiplyConstant(h, -this.tau);
        ToolboxSignal.addConstant(h, 1.0f, 0.0f);
        log.setProgressLength(40);
        if (!this.useInputImg) {
            ImagePlus newInit = WindowManager.getImage((String)this.initialEst);
            if (newInit == null) {
                IJ.error((String)("Initial estimate \"" + this.initialEst + "\" was not found.\n" + "Using input image instead."));
            } else {
                Signal ynew = new Signal(newInit);
                tbFourier.forwardDFT(ynew);
                if (!ToolboxSignal.checkCompatibility(y, ynew)) {
                    IJ.error((String)("Initial estimate \"" + this.initialEst + "\" does not\n" + "have the same size as the input image. Using\n" + "input image instead."));
                } else {
                    ToolboxSignal.transfer(y, ynew);
                    log.append("Initial estimate: " + this.initialEst, 0);
                }
            }
        }
        if (xorig != null && parameters.monitorPerf) {
            this.serg[0] = ToolboxSignal.calculateSER(y, xorig) - serref;
            this.time[0] = log.getElapsedTime();
        }
        k = 1;
        while (k <= this.K) {
            ToolboxSignal.multiply(y, h);
            ToolboxSignal.add(y, b);
            if (this.randomShifts) {
                int d = 0;
                while (d < y.D) {
                    int N = y.N[d];
                    n0[d] = (int)Math.floor((double)y.N[d] * generator.nextDouble());
                    mr[d] = this.modulationFilterReal(N, n0[d], d == y.D - 1);
                    mi[d] = this.modulationFilterImag(N, n0[d], d == y.D - 1);
                    this.filterSep(y, d, mr[d], mi[d]);
                    ++d;
                }
            }
            tbWavelet.transform(y, yw, this.J);
            ToolboxWavelet.threshold(yw, -this.lambda * this.tau / 2.0f, this.lambda * this.tau / 2.0f);
            tbWavelet.transformInverse(yw, y);
            if (this.randomShifts) {
                int d = 0;
                while (d < y.D) {
                    int n = 0;
                    while (n < mi[d].length) {
                        float[] fArray = mi[d];
                        int n2 = n++;
                        fArray[n2] = fArray[n2] * -1.0f;
                    }
                    this.filterSep(y, d, mr[d], mi[d]);
                    ++d;
                }
            }
            log.appendWithTime("Iteration " + k + " completed.", 1);
            log.setProgressLength(40 + (int)((double)(55 * k) / (double)this.K));
            if (xorig != null && parameters.monitorPerf) {
                this.time[k] = log.getElapsedTime();
                this.serg[k] = ToolboxSignal.calculateSER(y, xorig) - serref;
            }
            if (parameters.saveVideo) {
                log.start("Saving ThresholdedLandweberIter" + k + ".tif", 1);
                if (!y.isReal) {
                    tbFourier.inverseDFT(y);
                }
                ToolboxSignal.save(y, parameters.folderVideo, "ThresholdedLandweberIter" + k);
                if (y.isReal) {
                    tbFourier.forwardDFT(y);
                }
                log.acknowledge(1);
            }
            if (this.stopCrit == 1) {
                Signal Hf = (Signal)hbkp.clone();
                ToolboxSignal.multiply(Hf, y);
                float stdDevRes = (float)Math.sqrt(ToolboxSignal.norm2Difference(Hf, ybkp) / (double)Hf.length);
                Hf = null;
                log.append("StdDev of residual: " + stdDevRes, 0);
                if (stdDevRes < this.sigma) break;
            }
            ++k;
        }
        if (xorig != null && parameters.monitorPerf && k < this.K) {
            float[] sergtmp = new float[k + 1];
            float[] timetmp = new float[k + 1];
            k = 0;
            while (k < sergtmp.length) {
                sergtmp[k] = this.serg[k];
                timetmp[k] = this.time[k];
                ++k;
            }
            this.serg = sergtmp;
            this.time = timetmp;
        }
        tbFourier.inverseDFT(y);
        return true;
    }

    @Override
    public void setRegParamValue(float param) {
        this.lambda = param;
    }

    private void filterSep(Signal s, int df, float[] fr, float[] fi) {
        int Nf = fr.length;
        int Nchunk = 1;
        int d = s.D - 1;
        while (d > df) {
            Nchunk *= s.extN[d];
            --d;
        }
        int ns = 0;
        do {
            int nf = 0;
            do {
                float c = fr[nf];
                float d2 = fi[nf];
                int nslim = ns + Nchunk;
                do {
                    float a = s.array[ns];
                    float b = s.array[ns + 1];
                    s.array[ns] = a * c - b * d2;
                    s.array[ns + 1] = a * d2 + b * c;
                } while ((ns += 2) < nslim);
            } while (++nf < Nf);
        } while (ns < s.extLength);
    }

    private float[] modulationFilterReal(int N, int n0, boolean hermitianSym) {
        float[] f;
        if (hermitianSym) {
            f = new float[N / 2 + 1];
            int n = 0;
            while (n <= N / 2) {
                f[n] = (float)Math.cos(Math.PI * 2 * (double)n * (double)n0 / (double)N);
                ++n;
            }
        } else {
            f = new float[N];
            int n = 0;
            while (n < N) {
                f[n] = (float)Math.cos(Math.PI * 2 * (double)n * (double)n0 / (double)N);
                ++n;
            }
        }
        return f;
    }

    private float[] modulationFilterImag(int N, int n0, boolean hermitianSym) {
        float[] f;
        if (hermitianSym) {
            f = new float[N / 2 + 1];
            int n = 0;
            while (n <= N / 2) {
                f[n] = (float)Math.sin(Math.PI * 2 * (double)n * (double)n0 / (double)N);
                ++n;
            }
        } else {
            f = new float[N];
            int n = 0;
            while (n < N) {
                f[n] = (float)Math.sin(Math.PI * 2 * (double)n * (double)n0 / (double)N);
                ++n;
            }
        }
        return f;
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("ThresholdedLandweber|lambda", Float.toString(this.lambda));
        properties.setProperty("ThresholdedLandweber|wavFamily", Integer.toString(this.wavFamily));
        properties.setProperty("ThresholdedLandweber|J", Integer.toString(this.J));
        properties.setProperty("ThresholdedLandweber|threshType", Integer.toString(this.threshType));
        properties.setProperty("ThresholdedLandweber|randomShifts", Boolean.toString(this.randomShifts));
        properties.setProperty("ThresholdedLandweber|initialEst", this.initialEst);
        properties.setProperty("ThresholdedLandweber|useInputImg", Boolean.toString(this.useInputImg));
        properties.setProperty("ThresholdedLandweber|K", Integer.toString(this.K));
        properties.setProperty("ThresholdedLandweber|tau", Float.toString(this.tau));
        properties.setProperty("ThresholdedLandweber|optStepSize", Boolean.toString(this.autoStepSize));
        properties.setProperty("ThresholdedLandweber|stopCrit", Integer.toString(this.stopCrit));
        properties.setProperty("ThresholdedLandweber|sigma", Float.toString(this.sigma));
        properties.setProperty("ThresholdedLandweber|estimateSigma", Boolean.toString(this.estimateSigma));
        properties.setProperty("ThresholdedLandweber|tolerance", Float.toString(this.tolerance));
    }

    @Override
    public void loadParameters(Properties properties) {
        this.lambda = Float.parseFloat(properties.getProperty("ThresholdedLandweber|lambda", Float.toString(1.0f)));
        this.wavFamily = Integer.parseInt(properties.getProperty("ThresholdedLandweber|wavFamily", Integer.toString(0)));
        this.J = Integer.parseInt(properties.getProperty("ThresholdedLandweber|J", Integer.toString(3)));
        this.threshType = Integer.parseInt(properties.getProperty("ThresholdedLandweber|threshType", Integer.toString(0)));
        this.randomShifts = Boolean.parseBoolean(properties.getProperty("ThresholdedLandweber|randomShifts", Boolean.toString(true)));
        this.stopCrit = Integer.parseInt(properties.getProperty("ThresholdedLandweber|stopCrit", Integer.toString(0)));
        this.initialEst = properties.getProperty("ThresholdedLandweber|initialEst", initialEstdef);
        this.useInputImg = Boolean.parseBoolean(properties.getProperty("ThresholdedLandweber|useInputImg", Boolean.toString(true)));
        this.K = Integer.parseInt(properties.getProperty("ThresholdedLandweber|K", Integer.toString(10)));
        this.tau = Float.parseFloat(properties.getProperty("ThresholdedLandweber|tau", Float.toString(1.0f)));
        this.autoStepSize = Boolean.parseBoolean(properties.getProperty("ThresholdedLandweber|optStepSize", Boolean.toString(true)));
        this.sigma = Float.parseFloat(properties.getProperty("ThresholdedLandweber|sigma", Float.toString(1.0f)));
        this.estimateSigma = Boolean.parseBoolean(properties.getProperty("ThresholdedLandweber|estimateSigma", Boolean.toString(false)));
        this.tolerance = Float.parseFloat(properties.getProperty("ThresholdedLandweber|tolerance", Float.toString(0.001f)));
    }

    @Override
    public void getMacroParameters(String options) {
        this.lambda = Float.parseFloat(Macro.getValue((String)options, (String)"lambda", (String)Float.toString(1.0f)));
        this.wavFamily = Integer.parseInt(Macro.getValue((String)options, (String)"wavFamily", (String)Integer.toString(0)));
        this.J = Integer.parseInt(Macro.getValue((String)options, (String)"J", (String)Integer.toString(3)));
        this.threshType = Integer.parseInt(Macro.getValue((String)options, (String)"threshType", (String)Integer.toString(0)));
        this.randomShifts = Boolean.parseBoolean(Macro.getValue((String)options, (String)"randomShifts", (String)Boolean.toString(true)));
        this.stopCrit = Integer.parseInt(Macro.getValue((String)options, (String)"stopCrit", (String)Integer.toString(0)));
        this.initialEst = Macro.getValue((String)options, (String)"initialEst", (String)initialEstdef);
        this.useInputImg = Boolean.parseBoolean(Macro.getValue((String)options, (String)"useInputImg", (String)Boolean.toString(true)));
        this.K = Integer.parseInt(Macro.getValue((String)options, (String)"K", (String)Integer.toString(10)));
        this.tau = Float.parseFloat(Macro.getValue((String)options, (String)"tau", (String)Float.toString(1.0f)));
        this.autoStepSize = Boolean.parseBoolean(Macro.getValue((String)options, (String)"autoStepSize", (String)Boolean.toString(true)));
        this.sigma = Float.parseFloat(Macro.getValue((String)options, (String)"sigma", (String)Float.toString(1.0f)));
        this.estimateSigma = Boolean.parseBoolean(Macro.getValue((String)options, (String)"estimateSigma", (String)Boolean.toString(false)));
        this.tolerance = Float.parseFloat(Macro.getValue((String)options, (String)"tolerance", (String)Float.toString(0.001f)));
    }

    @Override
    public void log() {
        log.append("--------- Algorithm parameters ------------", 2);
        log.append(String.valueOf(this.jLabelRegParam.getText()) + " (lambda) " + this.lambda, 2);
        log.append("initialEst: " + this.initialEst, 2);
        log.append("wavFamily: " + this.wavFamily, 2);
        log.append("J: " + this.J, 2);
        log.append("threshType: " + this.threshType, 2);
        log.append("randomShifts: " + this.randomShifts, 2);
        log.append("useInputImg: " + this.useInputImg, 2);
        log.append(String.valueOf(this.jLabelNumIter.getText()) + " (K) " + this.K, 2);
        log.append(String.valueOf(this.jLabelStepSize.getText()) + " (tau) " + this.tau, 2);
        log.append(String.valueOf(this.jLabelStopCrit.getText()) + " (stopCrit) " + this.stopCrit, 2);
        log.append("sigma: " + this.sigma, 2);
        log.append("estimateSigma: " + this.estimateSigma, 2);
        log.append("tolerance: " + this.tolerance, 2);
        log.append("-------------------------------------------", 2);
    }

    @Override
    public void getParameters() {
        this.lambda = Float.parseFloat(this.jTextFieldRegParam.getText());
        this.wavFamily = this.jComboBoxWavFamily.getSelectedIndex();
        this.J = Integer.parseInt(this.jTextFieldNumLevel.getText());
        this.threshType = this.jComboBoxThreshType.getSelectedIndex();
        this.randomShifts = this.jCheckBoxRandomShifts.isSelected();
        this.initialEst = (String)this.jComboBoxInitialEst.getSelectedItem();
        this.useInputImg = this.jCheckBoxUseInputImg.isSelected();
        this.K = Integer.parseInt(this.jTextFieldNumIter.getText());
        this.tau = Float.parseFloat(this.jTextFieldStepSize.getText());
        this.stopCrit = this.jComboBoxStopCrit.getSelectedIndex();
        this.autoStepSize = this.jCheckBoxOptStepSize.isSelected();
        switch (this.stopCrit) {
            case 1: {
                this.sigma = Float.parseFloat(this.jTextFieldStopCritValue.getText());
                this.estimateSigma = this.jCheckBoxStopCritOption.isSelected();
                break;
            }
            case 2: {
                this.tolerance = Float.parseFloat(this.jTextFieldStopCritValue.getText());
            }
        }
    }

    @Override
    public void updateGUI() {
        this.jTextFieldRegParam.setText(Float.toString(this.lambda));
        this.jComboBoxWavFamily.setSelectedIndex(this.wavFamily);
        this.jTextFieldNumLevel.setText(Integer.toString(this.J));
        this.jComboBoxThreshType.setSelectedIndex(this.threshType);
        this.jCheckBoxRandomShifts.setSelected(this.randomShifts);
        this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
        this.jCheckBoxUseInputImg.setSelected(this.useInputImg);
        this.jTextFieldNumIter.setText(Integer.toString(this.K));
        this.jTextFieldStepSize.setText(Float.toString(this.tau));
        this.jCheckBoxOptStepSize.setSelected(this.autoStepSize);
        this.jComboBoxStopCrit.setSelectedIndex(this.stopCrit);
        switch (this.stopCrit) {
            case 1: {
                this.jTextFieldStopCritValue.setText(Float.toString(this.sigma));
                this.jCheckBoxStopCritOption.setSelected(this.estimateSigma);
                break;
            }
            case 2: {
                this.jTextFieldStopCritValue.setText(Float.toString(this.tolerance));
            }
        }
    }

    @Override
    public void reset() {
        this.lambda = 1.0f;
        this.wavFamily = 0;
        this.J = 3;
        this.threshType = 0;
        this.randomShifts = true;
        this.initialEst = initialEstdef;
        this.useInputImg = true;
        this.K = 10;
        this.tau = 1.0f;
        this.autoStepSize = true;
        this.stopCrit = 0;
        this.sigma = 1.0f;
        this.estimateSigma = false;
        this.tolerance = 0.001f;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        ItemSelectable src = event.getItemSelectable();
        if (src == this.jCheckBoxUseInputImg) {
            super.setImageList(this.jComboBoxInitialEst);
            this.jComboBoxInitialEst.setSelectedItem(this.initialEst);
            this.jComboBoxInitialEst.setEnabled(!this.jCheckBoxUseInputImg.isSelected());
        } else if (src == this.jCheckBoxOptStepSize) {
            this.jTextFieldStepSize.setEnabled(!this.jCheckBoxOptStepSize.isSelected());
        } else if (src == this.jCheckBoxStopCritOption) {
            this.jTextFieldStopCritValue.setEnabled(!this.jCheckBoxStopCritOption.isSelected());
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.jComboBoxStopCrit) {
            switch (this.jComboBoxStopCrit.getSelectedIndex()) {
                case 0: {
                    this.jLabelStopCritName.setVisible(true);
                    this.jLabelStopCritName.setText(" ");
                    this.jTextFieldStopCritValue.setVisible(false);
                    this.jCheckBoxStopCritOption.setVisible(false);
                    break;
                }
                case 1: {
                    this.jLabelStopCritName.setVisible(true);
                    this.jLabelStopCritName.setText("Standard deviation of noise:");
                    this.jTextFieldStopCritValue.setVisible(true);
                    this.jTextFieldStopCritValue.setText(Float.toString(this.sigma));
                    this.jCheckBoxStopCritOption.setVisible(true);
                    this.jCheckBoxStopCritOption.setText("Estimate StdDev of noise");
                    this.jCheckBoxStopCritOption.setSelected(this.estimateSigma);
                    break;
                }
                case 2: {
                    this.jLabelStopCritName.setVisible(true);
                    this.jLabelStopCritName.setText("Tolerance:");
                    this.jTextFieldStopCritValue.setVisible(true);
                    this.jTextFieldStopCritValue.setText(Float.toString(this.tolerance));
                    this.jCheckBoxStopCritOption.setVisible(false);
                }
            }
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == ThresholdedLandweber.this.jTextFieldRegParam) {
                return this.checkFloatField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelRegParam.getText(), ThresholdedLandweber.this.jTextFieldRegParam, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == ThresholdedLandweber.this.jTextFieldNumLevel) {
                return this.checkIntField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelWavFamily.getText(), ThresholdedLandweber.this.jTextFieldNumLevel, 1, 10, 3, changeIt);
            }
            if (input == ThresholdedLandweber.this.jTextFieldNumIter) {
                return this.checkIntField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelNumIter.getText(), ThresholdedLandweber.this.jTextFieldNumIter, 1, 1000000, 10, changeIt);
            }
            if (input == ThresholdedLandweber.this.jTextFieldStepSize) {
                return this.checkFloatField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelStepSize.getText(), ThresholdedLandweber.this.jTextFieldStepSize, 0.0f, 1000000.0f, 1.0f, changeIt);
            }
            if (input == ThresholdedLandweber.this.jTextFieldStopCritValue && ThresholdedLandweber.this.jComboBoxStopCrit.getSelectedIndex() == 1) {
                return this.checkFloatField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelStopCritName.getText(), ThresholdedLandweber.this.jTextFieldStopCritValue, 0.0f, 1000.0f, 1.0f, changeIt);
            }
            if (input == ThresholdedLandweber.this.jTextFieldStopCritValue && ThresholdedLandweber.this.jComboBoxStopCrit.getSelectedIndex() == 2) {
                return this.checkFloatField(ThresholdedLandweber.this.getName(), ThresholdedLandweber.this.jLabelStopCritName.getText(), ThresholdedLandweber.this.jTextFieldStopCritValue, 0.0f, 1.0f, 0.001f, changeIt);
            }
            return true;
        }
    }
}

