/*
 * Decompiled with CFR 0.152.
 */
package deconv.deprecated;

import ij.IJ;
import toolbox.Signal;
import toolbox.ToolboxSignal;

public class SignalSureEstimation {
    public static float getOptimalLambda(Signal g, Signal h) {
        float sigma = ToolboxSignal.estimateSigma(g, false, null);
        return SignalSureEstimation.getOptimalLambda(g, h, sigma);
    }

    public static float getOptimalLambda(Signal g, Signal h, float sigma) {
        float oldLambda;
        float lambda = 1.5E-4f * sigma * sigma;
        int i = 0;
        Signal laplacian = new Signal(g.N);
        ToolboxSignal.laplacian2D3D(laplacian);
        lambda = SignalSureEstimation.getInitialLambda(g, h, laplacian, sigma);
        do {
            oldLambda = lambda;
            lambda -= SignalSureEstimation.evaluateRiskDerivate(g, h, laplacian, lambda, sigma) / SignalSureEstimation.evaluateRiskSecondDerivate(g, h, laplacian, lambda, sigma);
            if (++i <= 100) continue;
            IJ.error((String)"lambda estimation failed");
        } while (Math.abs((oldLambda - lambda) / lambda) > 0.001f || i > 100);
        return lambda;
    }

    public static float getInitialLambda(Signal g, Signal h, Signal laplacian, float sigma) {
        float lambda = 10.0f;
        float optimalLambda = 10.0f;
        float bestRisk = SignalSureEstimation.evaluateRisk(g, h, laplacian, lambda, sigma);
        int i = 0;
        while (i < 100) {
            float currentRisk = SignalSureEstimation.evaluateRisk(g, h, laplacian, lambda /= 2.0f, sigma);
            if (currentRisk <= bestRisk) {
                bestRisk = currentRisk;
                optimalLambda = lambda;
            } else if (currentRisk > bestRisk) break;
            ++i;
        }
        return optimalLambda;
    }

    public static float evaluateRisk(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double risk = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SignalSureEstimation.modulusSquare(g.array[i], g.array[i + 1]);
            float hM2 = SignalSureEstimation.modulusSquare(h.array[i], h.array[i + 1]);
            float lM2 = SignalSureEstimation.modulusSquare(laplacian.array[i], laplacian.array[i + 1]);
            risk += (double)((hM2 * gM2 + 2.0f * (hM2 + lambda * lM2) * ((float)g.length * sigma * sigma - gM2)) / (hM2 + lambda * lM2) / (hM2 + lambda * lM2) / (float)g.length / (float)g.length);
            i += 2;
        }
        return (float)risk;
    }

    public static float evaluateRiskDerivate(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double riskDerivate = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SignalSureEstimation.modulusSquare(g.array[i], g.array[i + 1]);
            float hM2 = SignalSureEstimation.modulusSquare(h.array[i], h.array[i + 1]);
            float lM2 = SignalSureEstimation.modulusSquare(laplacian.array[i], laplacian.array[i + 1]);
            riskDerivate += 2.0 * (double)lM2 * (double)(-hM2 * gM2 + (hM2 + lambda * lM2) * (gM2 - (float)g.length * sigma * sigma)) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)g.length / (double)g.length;
            i += 2;
        }
        return (float)riskDerivate;
    }

    public static float evaluateRiskSecondDerivate(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double riskSecondDerivate = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SignalSureEstimation.modulusSquare(g.array[i], g.array[i + 1]);
            float hM2 = SignalSureEstimation.modulusSquare(h.array[i], h.array[i + 1]);
            float lM2 = SignalSureEstimation.modulusSquare(laplacian.array[i], laplacian.array[i + 1]);
            riskSecondDerivate += 4.0 * (double)lM2 * (double)lM2 * (1.5 * (double)hM2 * (double)gM2 + (double)((hM2 + lambda * lM2) * (-gM2 + (float)g.length * sigma * sigma))) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)g.length / (double)g.length;
            i += 2;
        }
        return (float)riskSecondDerivate;
    }

    private static float modulusSquare(float real, float imag) {
        return real * real + imag * imag;
    }
}

