/*
 * Decompiled with CFR 0.152.
 */
package deconv.deprecated;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import toolbox.MatlabWriter;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.ToolboxWavelet;
import toolbox.gui.AbstractVerifier;

public class SureLambdaEstimation
extends AbstractAlgorithm
implements ItemListener {
    private JPanel jPanel = null;
    private JPanel jPanelSigma = null;
    private JPanel jPanelLambda = null;
    private TitledBorder titledBorderLambda = null;
    private TitledBorder titledBorderSigma = null;
    private JLabel jLabelSigma = null;
    private JLabel jLabelUnitSigma = null;
    private JTextField jTextFieldSigma = null;
    private JLabel jLabelStartLambda = null;
    private JLabel jLabelUnitStartLambda = null;
    private JTextField jTextFieldStartLambda = null;
    private JLabel jLabelEndLambda = null;
    private JLabel jLabelUnitEndLambda = null;
    private JTextField jTextFieldEndLambda = null;
    private JLabel jLabelNumberSteps = null;
    private JLabel jLabelUnitNumberSteps = null;
    private JTextField jTextFieldNumberSteps = null;
    private JCheckBox jCheckBoxOracle = null;
    private JCheckBox jCheckBoxEstimateSigma = null;
    private JCheckBox jCheckBoxEstimateLambda = null;
    private boolean oracle = false;
    private boolean estimateSigma = false;
    private boolean estimateLambda = false;
    private float sigma = 0.0f;
    private float startLambda = 0.0f;
    private float endLambda = 1.0f;
    private int numberSteps = 10;
    private float[] oracleErrorDerivate = null;
    private float[] oracleErrorSecondDerivate = null;
    private float MIN_SIGMA = 0.0f;
    private float MAX_SIGMA = 100.0f;
    private float MIN_START_LAMBDA = 0.0f;
    private float MAX_START_LAMBDA = 100.0f;
    private float MIN_END_LAMBDA = 0.0f;
    private float MAX_END_LAMBDA = 100.0f;
    private int MIN_NUMBER_STEPS = 0;
    private int MAX_NUMBER_STEPS = 100000000;
    private MyVerifier verifier = new MyVerifier();

    public SureLambdaEstimation() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelSureLambdaEstimation");
        this.jPanelSigma = new JPanel();
        this.jPanelLambda = new JPanel();
        this.jPanelSigma.setLayout(this.gbLayout);
        this.jPanelLambda.setLayout(this.gbLayout);
        this.titledBorderLambda = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Parameters", 0, 0, null, null);
        this.titledBorderLambda.setTitle("Lambda Configuration");
        this.jPanelLambda.setBorder(this.titledBorderLambda);
        this.titledBorderSigma = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Parameters", 0, 0, null, null);
        this.titledBorderSigma.setTitle("Sigma Configuration");
        this.jPanelSigma.setBorder(this.titledBorderSigma);
        this.jLabelSigma = new JLabel();
        this.jLabelStartLambda = new JLabel();
        this.jLabelEndLambda = new JLabel();
        this.jLabelNumberSteps = new JLabel();
        this.jLabelUnitSigma = new JLabel();
        this.jLabelUnitStartLambda = new JLabel();
        this.jLabelUnitEndLambda = new JLabel();
        this.jLabelUnitNumberSteps = new JLabel();
        this.jTextFieldSigma = new JTextField();
        this.jTextFieldStartLambda = new JTextField();
        this.jTextFieldEndLambda = new JTextField();
        this.jTextFieldNumberSteps = new JTextField();
        this.jCheckBoxOracle = new JCheckBox();
        this.jCheckBoxEstimateSigma = new JCheckBox();
        this.jCheckBoxEstimateLambda = new JCheckBox();
        this.jLabelSigma.setText("Sigma: ");
        this.jLabelStartLambda.setText("Starting Lambda: ");
        this.jLabelEndLambda.setText("Ending Lambda: ");
        this.jLabelNumberSteps.setText("Number of Steps: ");
        this.jLabelUnitSigma.setText("");
        this.jLabelUnitStartLambda.setText("");
        this.jLabelUnitEndLambda.setText("");
        this.jLabelUnitNumberSteps.setText("");
        this.jTextFieldSigma.setText("" + this.sigma);
        this.jTextFieldStartLambda.setText("" + this.startLambda);
        this.jTextFieldEndLambda.setText("" + this.endLambda);
        this.jTextFieldNumberSteps.setText("" + this.numberSteps);
        this.jTextFieldSigma.setInputVerifier(this.verifier);
        this.jTextFieldStartLambda.setInputVerifier(this.verifier);
        this.jTextFieldEndLambda.setInputVerifier(this.verifier);
        this.jTextFieldNumberSteps.setInputVerifier(this.verifier);
        this.jCheckBoxOracle.setText("Oracle");
        this.jCheckBoxEstimateSigma.setText("Estimate Sigma");
        this.jCheckBoxEstimateLambda.setText("Estimate Lambda");
        this.jCheckBoxOracle.addItemListener(this);
        this.jCheckBoxEstimateSigma.addItemListener(this);
        this.jCheckBoxEstimateLambda.addItemListener(this);
        this.addComponent(this.jPanel, 0, 0, 1, 1, 5, this.jCheckBoxOracle);
        this.addComponent(this.jPanel, 1, 0, 1, 1, 5, this.jPanelSigma);
        this.gbConstraints.fill = 2;
        this.gbLayout.setConstraints(this.jPanelSigma, this.gbConstraints);
        this.addComponent(this.jPanel, 2, 0, 1, 1, 5, this.jPanelLambda);
        this.gbConstraints.fill = 2;
        this.gbConstraints.weightx = 100.0;
        this.gbConstraints.weighty = 100.0;
        this.gbLayout.setConstraints(this.jPanelLambda, this.gbConstraints);
        this.addComponent(this.jPanelSigma, 0, 0, 1, 1, 5, this.jCheckBoxEstimateSigma);
        this.addTextFieldLine(this.jPanelSigma, 1, 0.0, this.jLabelSigma, this.jTextFieldSigma, this.jLabelUnitSigma);
        this.addComponent(this.jPanelLambda, 0, 0, 1, 1, 5, this.jCheckBoxEstimateLambda);
        this.addTextFieldLine(this.jPanelLambda, 1, 0.0, this.jLabelStartLambda, this.jTextFieldStartLambda, this.jLabelUnitStartLambda);
        this.addTextFieldLine(this.jPanelLambda, 2, 0.0, this.jLabelEndLambda, this.jTextFieldEndLambda, this.jLabelUnitEndLambda);
        this.addTextFieldLine(this.jPanelLambda, 3, 0.0, this.jLabelNumberSteps, this.jTextFieldNumberSteps, this.jLabelUnitNumberSteps);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Sure Lambda Estimation";
    }

    @Override
    public boolean process(Signal g, Signal h, Signal reference, Parameters parameters) {
        float usedSigma = 0.0f;
        ToolboxFourier fftToolbox = new ToolboxFourier(g.N, parameters.useFFTW, parameters.fileWisdom);
        MatlabWriter mWriter = new MatlabWriter(parameters.folderPerfMon, "SureLambdaEstimation");
        mWriter.openFile();
        log.start("fft of image and PSF", 0);
        fftToolbox.forwardDFT(g);
        log.setProgressLength(30);
        fftToolbox.forwardDFT(h);
        log.setProgressLength(35);
        log.acknowledge(0);
        if (this.oracle && reference != null) {
            if (!this.drawOracleError(g, h, reference, this.startLambda, this.endLambda, this.numberSteps, mWriter, fftToolbox)) {
                return false;
            }
            this.drawOracleErrorDerivate(mWriter);
            this.drawOracleErrorSecondDerivate(mWriter);
        } else if (this.oracle && reference == null) {
            IJ.error((String)"The oracle option needs a reference image.");
        }
        if (!this.estimateSigma) {
            usedSigma = this.sigma;
        } else {
            usedSigma = SureLambdaEstimation.estimateSigma(g, parameters.useFFTW, parameters.fileWisdom);
            log.append("Using estimated sigma: " + usedSigma, 1);
        }
        if (!this.oracle && !this.estimateLambda) {
            SureLambdaEstimation.drawEstimatedRisk(g, h, this.startLambda, this.endLambda, this.numberSteps, usedSigma, mWriter);
            SureLambdaEstimation.drawEstimatedRiskDerivate(g, h, this.startLambda, this.endLambda, this.numberSteps, usedSigma, mWriter);
            SureLambdaEstimation.drawEstimatedRiskSecondDerivate(g, h, this.startLambda, this.endLambda, this.numberSteps, usedSigma, mWriter);
        } else if (!this.oracle && this.estimateLambda) {
            float oldLambda;
            float lambda = 1.5E-4f * usedSigma * usedSigma;
            int i = 0;
            Signal laplacian = new Signal(g.N);
            ToolboxSignal.laplacian2D3D(laplacian);
            do {
                oldLambda = lambda;
                lambda -= SureLambdaEstimation.calculateRiskDerivate(g, h, laplacian, lambda, usedSigma) / SureLambdaEstimation.calculateRiskSecondDerivate(g, h, laplacian, lambda, usedSigma);
                log.appendWithTime("iteration " + i + ", lambda=" + lambda, 1);
                ++i;
            } while (Math.abs((oldLambda - lambda) / lambda) > 0.001f);
        }
        log.start("inverse fft", 0);
        fftToolbox.inverseDFT(g);
        log.setProgressLength(80);
        log.acknowledge(0);
        mWriter.closeFile();
        return true;
    }

    public float[] getOptParamRange() {
        int N = 2;
        float[] param = new float[N];
        int n = 0;
        while (n < N) {
            param[n] = (float)Math.pow(2.0, n - N / 2);
            ++n;
        }
        return param;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    private boolean drawOracleError(Signal g, Signal h, Signal reference, float startLambda, float endLambda, int numberSteps, MatlabWriter mWriter, ToolboxFourier fftToolbox) {
        float lambda;
        float lambdaStep = (endLambda - startLambda) / (float)numberSteps;
        mWriter.newArray("lambda");
        int i = 0;
        while (i < numberSteps) {
            lambda = startLambda + lambdaStep * (float)i;
            mWriter.addValue(lambda);
            ++i;
        }
        this.oracleErrorDerivate = new float[numberSteps];
        this.oracleErrorSecondDerivate = new float[numberSteps];
        fftToolbox.forwardDFT(reference);
        log.setProgressLength(40);
        Signal hCopy = (Signal)h.clone();
        Signal gCopy = (Signal)g.clone();
        ToolboxSignal.multiplyConj(g, h);
        ToolboxSignal.multiplyConj(h, h);
        Signal ghT = (Signal)g.clone();
        Signal hhT = (Signal)h.clone();
        Signal laplacian = new Signal(g.N);
        ToolboxSignal.laplacian2D3D(laplacian);
        mWriter.newArray("oracleRisk");
        int i2 = 0;
        while (i2 < numberSteps) {
            lambda = startLambda + lambdaStep * (float)i2;
            ToolboxSignal.copy(g, ghT);
            ToolboxSignal.copy(h, hhT);
            ToolboxSignal.addLaplacianSquare2D3D(h, lambda);
            ToolboxSignal.divideStable(g, h, 1.0E-7f);
            log.setProgressLength((int)(40.0f + (float)(i2 * 30) / (float)numberSteps));
            float risk = (float)(ToolboxSignal.norm2Difference(g, reference) / (double)g.length / (double)g.length - ToolboxSignal.norm2(reference) / (double)g.length / (double)g.length);
            mWriter.addValue(risk);
            log.appendWithTime("lambda: " + lambda + "  oracle risk: " + risk, 1);
            this.oracleErrorDerivate[i2] = SureLambdaEstimation.calculateOracleErrorDerivate(reference, g, gCopy, hCopy, laplacian, lambda);
            this.oracleErrorSecondDerivate[i2] = SureLambdaEstimation.calculateOracleErrorSecondDerivate(reference, g, gCopy, hCopy, laplacian, lambda);
            ++i2;
        }
        return true;
    }

    private void drawOracleErrorDerivate(MatlabWriter mWriter) {
        if (mWriter == null || this.oracleErrorDerivate == null) {
            return;
        }
        mWriter.newArray("oracleRiskDerivate");
        int i = 0;
        while (i < this.oracleErrorDerivate.length) {
            mWriter.addValue(this.oracleErrorDerivate[i]);
            ++i;
        }
    }

    private void drawOracleErrorSecondDerivate(MatlabWriter mWriter) {
        if (mWriter == null || this.oracleErrorSecondDerivate == null) {
            return;
        }
        mWriter.newArray("oracleRiskSecondDerivate");
        int i = 0;
        while (i < this.oracleErrorSecondDerivate.length) {
            mWriter.addValue(this.oracleErrorSecondDerivate[i]);
            ++i;
        }
    }

    private static float estimateSigma(Signal s, boolean useFftw, String wisdomFolder) {
        s = (Signal)s.clone();
        SignalWavelet wTransform = new SignalWavelet(s.N, 1);
        ToolboxWavelet wToolbox = new ToolboxWavelet(wTransform, 4, useFftw, wisdomFolder);
        wToolbox.transform(s, wTransform, 1);
        return wToolbox.estimateSigma(wTransform);
    }

    private static boolean drawEstimatedRisk(Signal g, Signal h, float startLambda, float endLambda, int numberSteps, float sigma, MatlabWriter mWriter) {
        float lambda;
        Signal laplacian = new Signal(h.N);
        ToolboxSignal.laplacian2D3D(laplacian);
        float lambdaStep = (endLambda - startLambda) / (float)numberSteps;
        mWriter.newArray("lambda");
        int i = 0;
        while (i < numberSteps) {
            lambda = startLambda + lambdaStep * (float)i;
            mWriter.addValue(lambda);
            ++i;
        }
        mWriter.newArray("estimatedRisk");
        i = 0;
        while (i < numberSteps) {
            lambda = startLambda + lambdaStep * (float)i;
            float risk = SureLambdaEstimation.calculateRisk(g, h, laplacian, lambda, sigma);
            mWriter.addValue(risk);
            log.appendWithTime("lambda: " + lambda + "  estimated risk: " + risk, 1);
            ++i;
        }
        return true;
    }

    private static boolean drawEstimatedRiskDerivate(Signal g, Signal h, float startLambda, float endLambda, int numberSteps, float sigma, MatlabWriter mWriter) {
        Signal laplacian = new Signal(h.N);
        ToolboxSignal.laplacian2D3D(laplacian);
        float lambdaStep = (endLambda - startLambda) / (float)numberSteps;
        mWriter.newArray("estimatedRiskDerivate");
        int i = 0;
        while (i < numberSteps) {
            float lambda = startLambda + lambdaStep * (float)i;
            float riskDerivative = SureLambdaEstimation.calculateRiskDerivate(g, h, laplacian, lambda, sigma);
            mWriter.addValue(riskDerivative);
            log.appendWithTime("lambda: " + lambda + "  estimated risk derivate: " + riskDerivative, 1);
            ++i;
        }
        return true;
    }

    private static boolean drawEstimatedRiskSecondDerivate(Signal g, Signal h, float startLambda, float endLambda, int numberSteps, float sigma, MatlabWriter mWriter) {
        Signal laplacian = new Signal(h.N);
        ToolboxSignal.laplacian2D3D(laplacian);
        float lambdaStep = (endLambda - startLambda) / (float)numberSteps;
        mWriter.newArray("estimatedRiskSecondDerivate");
        int i = 0;
        while (i < numberSteps) {
            float lambda = startLambda + lambdaStep * (float)i;
            float riskSecondDerivative = SureLambdaEstimation.calculateRiskSecondDerivate(g, h, laplacian, lambda, sigma);
            mWriter.addValue(riskSecondDerivative);
            log.appendWithTime("lambda: " + lambda + "  estimated risk second derivate: " + riskSecondDerivative, 1);
            ++i;
        }
        return true;
    }

    private static float calculateRisk(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double risk = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SureLambdaEstimation.moduleSquare(g.array[i], g.array[i + 1]);
            float hM2 = SureLambdaEstimation.moduleSquare(h.array[i], h.array[i + 1]);
            float lM2 = SureLambdaEstimation.moduleSquare(laplacian.array[i], laplacian.array[i + 1]);
            risk += (double)((hM2 * gM2 + 2.0f * (hM2 + lambda * lM2) * ((float)g.length * sigma * sigma - gM2)) / (hM2 + lambda * lM2) / (hM2 + lambda * lM2) / (float)g.length / (float)g.length);
            i += 2;
        }
        return (float)risk;
    }

    private static float calculateRiskDerivate(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double riskDerivate = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SureLambdaEstimation.moduleSquare(g.array[i], g.array[i + 1]);
            float hM2 = SureLambdaEstimation.moduleSquare(h.array[i], h.array[i + 1]);
            float lM2 = SureLambdaEstimation.moduleSquare(laplacian.array[i], laplacian.array[i + 1]);
            riskDerivate += 2.0 * (double)lM2 * (double)(-hM2 * gM2 + (hM2 + lambda * lM2) * (gM2 - (float)g.length * sigma * sigma)) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)g.length / (double)g.length;
            i += 2;
        }
        return (float)riskDerivate;
    }

    private static float calculateRiskSecondDerivate(Signal g, Signal h, Signal laplacian, float lambda, float sigma) {
        double riskSecondDerivate = 0.0;
        int i = 0;
        while (i < g.extLength) {
            float gM2 = SureLambdaEstimation.moduleSquare(g.array[i], g.array[i + 1]);
            float hM2 = SureLambdaEstimation.moduleSquare(h.array[i], h.array[i + 1]);
            float lM2 = SureLambdaEstimation.moduleSquare(laplacian.array[i], laplacian.array[i + 1]);
            riskSecondDerivate += 4.0 * (double)lM2 * (double)lM2 * (1.5 * (double)hM2 * (double)gM2 + (double)((hM2 + lambda * lM2) * (-gM2 + (float)g.length * sigma * sigma))) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)g.length / (double)g.length;
            i += 2;
        }
        return (float)riskSecondDerivate;
    }

    private static float calculateOracleErrorDerivate(Signal xorig, Signal x, Signal y, Signal h, Signal laplacian, float lambda) {
        double riskDerivate = 0.0;
        int i = 0;
        while (i < x.extLength) {
            float yM2 = SureLambdaEstimation.moduleSquare(y.array[i], y.array[i + 1]);
            float hM2 = SureLambdaEstimation.moduleSquare(h.array[i], h.array[i + 1]);
            float lM2 = SureLambdaEstimation.moduleSquare(laplacian.array[i], laplacian.array[i + 1]);
            float real = SureLambdaEstimation.realMult3(xorig.array[i], -xorig.array[i + 1], h.array[i], -h.array[i + 1], y.array[i], y.array[i + 1]);
            riskDerivate += 2.0 * (double)lM2 * (double)(-hM2 * yM2 + real * (hM2 + lambda * lM2)) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)x.length / (double)x.length;
            i += 2;
        }
        return (float)riskDerivate;
    }

    private static float calculateOracleErrorSecondDerivate(Signal xorig, Signal x, Signal y, Signal h, Signal laplacian, float lambda) {
        double riskSecondDerivate = 0.0;
        int i = 0;
        while (i < x.extLength) {
            float yM2 = SureLambdaEstimation.moduleSquare(y.array[i], y.array[i + 1]);
            float hM2 = SureLambdaEstimation.moduleSquare(h.array[i], h.array[i + 1]);
            float lM2 = SureLambdaEstimation.moduleSquare(laplacian.array[i], laplacian.array[i + 1]);
            float real = SureLambdaEstimation.realMult3(xorig.array[i], -xorig.array[i + 1], h.array[i], -h.array[i + 1], y.array[i], y.array[i + 1]);
            riskSecondDerivate += 4.0 * (double)lM2 * (double)lM2 * (1.5 * (double)hM2 * (double)yM2 - (double)(real * (hM2 + lambda * lM2))) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)(hM2 + lambda * lM2) / (double)x.length / (double)x.length;
            i += 2;
        }
        return (float)riskSecondDerivate;
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("sureTestOracle", "" + this.oracle);
        properties.setProperty("sureTestEstimateSigma", "" + this.estimateSigma);
        properties.setProperty("sureTestEstimateLambda", "" + this.estimateLambda);
        properties.setProperty("sureTestSigma", "" + this.sigma);
        properties.setProperty("sureTestStartLambda", "" + this.startLambda);
        properties.setProperty("sureTestEndLambda", "" + this.endLambda);
        properties.setProperty("sureTestNumberSteps", "" + this.numberSteps);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty("sureTestOracle", "" + this.oracle);
        this.oracle = Boolean.parseBoolean(s);
        s = properties.getProperty("sureTestEstimateSigma", "" + this.estimateSigma);
        this.estimateSigma = Boolean.parseBoolean(s);
        s = properties.getProperty("sureTestEstimateLambda", "" + this.estimateLambda);
        this.estimateLambda = Boolean.parseBoolean(s);
        s = properties.getProperty("sureTestSigma", "" + this.sigma);
        this.sigma = Float.parseFloat(s);
        s = properties.getProperty("sureTestStartLambda", "" + this.startLambda);
        this.startLambda = Float.parseFloat(s);
        s = properties.getProperty("sureTestEndLambda", "" + this.endLambda);
        this.endLambda = Float.parseFloat(s);
        s = properties.getProperty("sureTestNumberSteps", "" + this.numberSteps);
        this.numberSteps = Integer.parseInt(s);
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("This algorithm " + this.getName() + " is not macro callable"));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
        this.oracle = this.jCheckBoxOracle.isSelected();
        this.estimateSigma = this.jCheckBoxEstimateSigma.isSelected();
        this.estimateLambda = this.jCheckBoxEstimateLambda.isSelected();
        this.sigma = Float.parseFloat(this.jTextFieldSigma.getText());
        this.startLambda = Float.parseFloat(this.jTextFieldStartLambda.getText());
        this.endLambda = Float.parseFloat(this.jTextFieldEndLambda.getText());
        this.numberSteps = Integer.parseInt(this.jTextFieldNumberSteps.getText());
    }

    @Override
    public void updateGUI() {
        this.jCheckBoxOracle.setSelected(!this.oracle);
        this.jCheckBoxEstimateSigma.setSelected(!this.estimateSigma);
        this.jCheckBoxEstimateLambda.setSelected(!this.estimateLambda);
        if (this.oracle) {
            this.jCheckBoxEstimateSigma.setSelected(this.estimateSigma);
            this.jCheckBoxEstimateLambda.setSelected(this.estimateLambda);
            this.jCheckBoxOracle.setSelected(this.oracle);
        } else {
            this.jCheckBoxOracle.setSelected(this.oracle);
            this.jCheckBoxEstimateSigma.setSelected(this.estimateSigma);
            this.jCheckBoxEstimateLambda.setSelected(this.estimateLambda);
        }
        this.jTextFieldSigma.setText("" + this.sigma);
        this.jTextFieldStartLambda.setText("" + this.startLambda);
        this.jTextFieldEndLambda.setText("" + this.endLambda);
        this.jTextFieldNumberSteps.setText("" + this.numberSteps);
    }

    @Override
    public void reset() {
        this.oracle = false;
        this.estimateSigma = false;
        this.estimateLambda = false;
        this.sigma = 0.0f;
        this.startLambda = 0.0f;
        this.endLambda = 10.0f;
        this.numberSteps = 10;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItemSelectable() == this.jCheckBoxOracle) {
            if (this.jCheckBoxOracle.isSelected()) {
                this.jCheckBoxEstimateLambda.setSelected(false);
                this.jCheckBoxEstimateLambda.setEnabled(false);
                this.jCheckBoxEstimateSigma.setSelected(false);
                this.jCheckBoxEstimateSigma.setEnabled(false);
                this.jLabelSigma.setEnabled(false);
                this.jLabelUnitSigma.setEnabled(false);
                this.jTextFieldSigma.setEnabled(false);
            } else {
                this.jCheckBoxEstimateLambda.setEnabled(true);
                this.jCheckBoxEstimateSigma.setEnabled(true);
                this.jLabelSigma.setEnabled(true);
                this.jLabelUnitSigma.setEnabled(true);
                this.jTextFieldSigma.setEnabled(true);
            }
        } else if (e.getItemSelectable() == this.jCheckBoxEstimateSigma) {
            boolean isSelected = this.jCheckBoxEstimateSigma.isSelected();
            this.jLabelSigma.setEnabled(!isSelected);
            this.jLabelUnitSigma.setEnabled(!isSelected);
            this.jTextFieldSigma.setEnabled(!isSelected);
        } else if (e.getItemSelectable() == this.jCheckBoxEstimateLambda) {
            boolean isSelected = this.jCheckBoxEstimateLambda.isSelected();
            this.jLabelStartLambda.setEnabled(!isSelected);
            this.jLabelUnitStartLambda.setEnabled(!isSelected);
            this.jTextFieldStartLambda.setEnabled(!isSelected);
            this.jLabelEndLambda.setEnabled(!isSelected);
            this.jLabelUnitEndLambda.setEnabled(!isSelected);
            this.jTextFieldEndLambda.setEnabled(!isSelected);
            this.jLabelNumberSteps.setEnabled(!isSelected);
            this.jLabelUnitNumberSteps.setEnabled(!isSelected);
            this.jTextFieldNumberSteps.setEnabled(!isSelected);
        }
    }

    private static float moduleSquare(float real, float imag) {
        return real * real + imag * imag;
    }

    private static float realMult3(float real1, float imag1, float real2, float imag2, float real3, float imag3) {
        return real1 * real2 * real3 - imag1 * imag2 * real3 - real1 * imag2 * imag3 - real2 * imag1 * imag3;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == SureLambdaEstimation.this.jTextFieldSigma) {
                return this.checkFloatField(SureLambdaEstimation.this.getName(), SureLambdaEstimation.this.jLabelSigma.getText(), SureLambdaEstimation.this.jTextFieldSigma, SureLambdaEstimation.this.MIN_SIGMA, SureLambdaEstimation.this.MAX_SIGMA, 0.0f, changeIt);
            }
            if (input == SureLambdaEstimation.this.jTextFieldStartLambda) {
                return this.checkFloatField(SureLambdaEstimation.this.getName(), SureLambdaEstimation.this.jLabelStartLambda.getText(), SureLambdaEstimation.this.jTextFieldStartLambda, SureLambdaEstimation.this.MIN_START_LAMBDA, SureLambdaEstimation.this.MAX_START_LAMBDA, 0.0f, changeIt);
            }
            if (input == SureLambdaEstimation.this.jTextFieldEndLambda) {
                return this.checkFloatField(SureLambdaEstimation.this.getName(), SureLambdaEstimation.this.jLabelEndLambda.getText(), SureLambdaEstimation.this.jTextFieldEndLambda, SureLambdaEstimation.this.MIN_END_LAMBDA, SureLambdaEstimation.this.MAX_END_LAMBDA, 0.0f, changeIt);
            }
            if (input == SureLambdaEstimation.this.jTextFieldNumberSteps) {
                return this.checkIntField(SureLambdaEstimation.this.getName(), SureLambdaEstimation.this.jLabelNumberSteps.getText(), SureLambdaEstimation.this.jTextFieldNumberSteps, SureLambdaEstimation.this.MIN_NUMBER_STEPS, SureLambdaEstimation.this.MAX_NUMBER_STEPS, 10, changeIt);
            }
            return true;
        }
    }
}

