/*
 * Decompiled with CFR 0.152.
 */
package deconv.gui;

import deconv.Parameters;
import ij.ImagePlus;
import ij.WindowManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.DecimalFormat;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import toolbox.gui.LogSingleton;

public abstract class AbstractDialog
extends JFrame
implements WindowListener {
    static final long serialVersionUID = 20090618L;
    public static final int ONE_SECOND = 1000;
    public Parameters parameters;
    public Thread threadDeconvolution;
    public JProgressBar jProgressBar = null;
    public Timer timer;
    public JLabel jLabelMemMessage = null;
    protected String STR_COPYRIGHT = "(c) 2010 Biomedical Imaging Group, EPFL, Switzerland";
    protected GridBagLayout gbLayout = new GridBagLayout();
    protected GridBagConstraints gbConstraints = new GridBagConstraints();
    protected LogSingleton log = LogSingleton.getInstance();

    AbstractDialog() {
        this.parameters = new Parameters();
        this.parameters.useMacro = false;
        this.timer = new Timer(500, new TimerListener());
        this.jLabelMemMessage = new JLabel("");
    }

    protected void addComponent(JPanel pn, int row, int col, int width, int height, int space, Component comp) {
        this.gbConstraints.gridx = col;
        this.gbConstraints.gridy = row;
        this.gbConstraints.gridwidth = width;
        this.gbConstraints.gridheight = height;
        this.gbConstraints.weightx = 0.0;
        this.gbConstraints.weighty = 0.0;
        this.gbConstraints.anchor = 18;
        this.gbConstraints.fill = 0;
        this.gbConstraints.insets = new Insets(space, space, space, space);
        this.gbLayout.setConstraints(comp, this.gbConstraints);
        pn.add(comp);
    }

    protected int setImageList(JComboBox cBox) {
        cBox.removeAllItems();
        int[] wList = WindowManager.getIDList();
        if (wList == null) {
            cBox.addItem("No images open");
            return 0;
        }
        int i = 0;
        while (i < wList.length) {
            ImagePlus imp = WindowManager.getImage((int)wList[i]);
            cBox.addItem(imp.getTitle());
            ++i;
        }
        return cBox.getItemCount();
    }

    public void cleanup() {
        this.threadDeconvolution = null;
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.log.clear();
        this.log = null;
        System.gc();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cleanup();
        this.dispose();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            int length = AbstractDialog.this.log.getProgressLength();
            AbstractDialog.this.jProgressBar.setValue(length);
            AbstractDialog.this.jLabelMemMessage.setText("Mem. Usage = " + new DecimalFormat(" 000.00MB ").format((double)Runtime.getRuntime().freeMemory() / 1024.0 / 1024.0));
            AbstractDialog.this.jLabelMemMessage.repaint();
            if (length == 100) {
                AbstractDialog.this.timer.stop();
            }
        }
    }
}

