/*
 * Decompiled with CFR 0.152.
 */
package deconv.gui;

import deconv.Parameters;
import deconv.ThreadDeconvolution;
import deconv.algo.AbstractAlgorithm;
import deconv.algo.Convolution;
import deconv.algo.FISTA;
import deconv.algo.InverseFiltering;
import deconv.algo.Landweber;
import deconv.algo.RegularizedInverseFiltering;
import deconv.algo.RichardsonLucy;
import deconv.algo.RichardsonLucyTV;
import deconv.algo.ThresholdedLandweber;
import deconv.algo.TikhonovMiller;
import deconv.gui.AboutDialog;
import deconv.gui.AbstractDialog;
import ij.IJ;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import toolbox.gui.AbstractVerifier;
import toolbox.gui.LogPane;
import toolbox.gui.MyTableRenderer;
import toolbox.gui.SimpleTableModel;

public class AdvancedDialog
extends AbstractDialog
implements ListSelectionListener,
ActionListener,
ItemListener {
    static final long serialVersionUID = 20101020L;
    private String MUTE = "Mute";
    private String SILENT = "Silent";
    private String NORMAL = "Normal";
    private String VERBOSE = "Verbose";
    private String RUN = "Run";
    private String STOP = "Stop";
    private String filename = null;
    private JPanel jContentPane = null;
    private JPanel jPanelButtons = null;
    private JPanel jPanelLeft = null;
    private JPanel jPanelRight = null;
    private JPanel jPanelBottom = null;
    private JPanel jPanelBotLeft = null;
    private JPanel jPanelBotRight = null;
    private JPanel jPanelAlgo = null;
    private JPanel jPanelPSF = null;
    private JPanel jPanelPerfMon = null;
    private JPanel jPanelVideo = null;
    private JPanel jPanelWindowing = null;
    private JPanel jPanelFftw = null;
    private JPanel jPanelLog = null;
    private JPanel jPanelAlgoParams = null;
    private JPanel jPanelBotCenter = null;
    private JPanel jPanelBatch = null;
    private JPanel jPanelBackground = null;
    private JSplitPane jSplitPane = null;
    private JScrollPane jScrollPane = null;
    private JTable jTable = null;
    private LogPane logPane = null;
    private JButton jButtonRun = null;
    private JButton jButtonClose = null;
    private JButton jButtonCredits = null;
    private JButton jButtonSaveSettings = null;
    private JButton jButtonLoadSettings = null;
    private JButton jButtonResetSettings = null;
    private JButton jButtonVideoBrowse = null;
    private JButton jButtonSERBrowse = null;
    private JButton jButtonSERRefresh = null;
    private JButton jButtonPSFRefresh = null;
    private JButton jButtonBatchInputBrowse = null;
    private JButton jButtonBatchOutputBrowse = null;
    private JButton jButtonClearLog = null;
    private JCheckBox jCheckBoxPerfMon = null;
    private JCheckBox jCheckBoxSeed = null;
    private JCheckBox jCheckBoxCrop = null;
    private JCheckBox jCheckBoxVideo = null;
    private JCheckBox jCheckBoxFFTW = null;
    private JCheckBox jCheckBoxWindowing = null;
    private JCheckBox jCheckBoxAddBorders = null;
    private JCheckBox jCheckBoxMultiFile = null;
    private JCheckBox jCheckBoxMultiParam = null;
    private JCheckBox jCheckBoxNormalizePSF = null;
    private JCheckBox jCheckBoxRecenterPSF = null;
    private JCheckBox jCheckBoxSubtractBackground = null;
    private JCheckBox jCheckBoxEstimateBackground = null;
    private JComboBox jComboBoxAlgo = null;
    private JComboBox jComboBoxPSF = null;
    private JComboBox jComboBoxSERReference = null;
    private JComboBox jComboBoxLog = null;
    private JComboBox jComboBoxWeightBorderFunction = null;
    private JLabel jLabelVideoText = null;
    private JLabel jLabelVideoFolder = null;
    private JLabel jLabelPerfMonRef = null;
    private JLabel jLabelPerfMonFolderDesc = null;
    private JLabel jLabelPerfMonFolderName = null;
    private JLabel jLabelSeed = null;
    private JLabel jLabelPSFText1 = null;
    private JLabel jLabelAlgo = null;
    private JLabel jLabelCopyRight = null;
    private JLabel jLabelLogMode = null;
    private JLabel jLabelWindowSliderLegend = null;
    private JLabel jLabelBorderSliderLegend = null;
    private JLabel jLabelWindowComboBoxLegend = null;
    private JLabel jLabelBatchInputFolder = null;
    private JLabel jLabelBatchOutputFolder = null;
    private JLabel jLabelBatchInputText = null;
    private JLabel jLabelBatchOutputText = null;
    private JLabel jLabelBackgroundLabel = null;
    private JSlider jSliderWindowing = null;
    private JSlider jSliderAddBorders = null;
    private JTextField jTextFieldSeed = null;
    private JTextField jTextFieldBackground = null;
    private JTextField jTextFieldMultiParamStart = null;
    private JTextField jTextFieldMultiParamStep = null;
    private JTextField jTextFieldMultiParamEnd = null;
    private MyVerifier verifier = null;
    private AbstractAlgorithm[] algo;

    public AdvancedDialog() {
        this.initialize();
    }

    private void initialize() {
        this.filename = String.valueOf(Parameters.getDirectory()) + "Settings";
        this.algo = new AbstractAlgorithm[9];
        this.algo[0] = new Convolution();
        this.algo[1] = new InverseFiltering();
        this.algo[2] = new RegularizedInverseFiltering();
        this.algo[3] = new Landweber();
        this.algo[4] = new ThresholdedLandweber();
        this.algo[5] = new FISTA();
        this.algo[6] = new TikhonovMiller();
        this.algo[7] = new RichardsonLucy();
        this.algo[8] = new RichardsonLucyTV();
        this.setContentPane(this.getJContentPane());
        this.setTitle("DeconvolutionLab");
        this.getPreferences();
        this.repaint();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(this.gbLayout);
            this.addComponent(this.jContentPane, 0, 0, 1, 1, 0, this.getJSplitPane());
            this.gbConstraints.fill = 1;
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.getJSplitPane(), this.gbConstraints);
            this.addComponent(this.jContentPane, 1, 0, 1, 1, 0, this.getJPanelButtons());
            this.gbConstraints.fill = 2;
            this.gbConstraints.weightx = 0.0;
            this.gbConstraints.weighty = 0.0;
            this.gbLayout.setConstraints(this.getJPanelButtons(), this.gbConstraints);
            this.addComponent(this.jContentPane, 2, 0, 1, 1, 0, this.getJPanelBottom());
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJPanelBottom(), this.gbConstraints);
        }
        return this.jContentPane;
    }

    private JButton getJButtonCredits() {
        if (this.jButtonCredits == null) {
            this.jButtonCredits = new JButton();
            this.jButtonCredits.setText("About...");
            this.jButtonCredits.addActionListener(this);
        }
        return this.jButtonCredits;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setLeftComponent(this.getJPanelLeft());
            this.jSplitPane.setRightComponent(this.getJPanelRight());
        }
        return this.jSplitPane;
    }

    private JPanel getJPanelButtons() {
        if (this.jPanelButtons == null) {
            this.jPanelButtons = new JPanel();
            this.jPanelButtons.setLayout(this.gbLayout);
            this.addComponent(this.jPanelButtons, 0, 0, 1, 1, 5, this.getJButtonSaveSettings());
            this.gbConstraints.anchor = 17;
            this.gbConstraints.insets = new Insets(10, 10, 5, 5);
            this.gbLayout.setConstraints(this.getJButtonSaveSettings(), this.gbConstraints);
            this.addComponent(this.jPanelButtons, 0, 1, 1, 1, 5, this.getJButtonLoadSettings());
            this.gbConstraints.insets = new Insets(10, 5, 5, 5);
            this.gbConstraints.anchor = 17;
            this.gbLayout.setConstraints(this.getJButtonLoadSettings(), this.gbConstraints);
            this.addComponent(this.jPanelButtons, 0, 2, 1, 1, 5, this.getJButtonResetSettings());
            this.gbConstraints.insets = new Insets(10, 5, 5, 5);
            this.gbConstraints.anchor = 17;
            this.gbLayout.setConstraints(this.getJButtonResetSettings(), this.gbConstraints);
            this.addComponent(this.jPanelButtons, 0, 3, 1, 1, 5, this.getJButtonCredits());
            this.gbConstraints.anchor = 17;
            this.gbConstraints.insets = new Insets(10, 5, 5, 5);
            this.gbLayout.setConstraints(this.getJButtonCredits(), this.gbConstraints);
            this.addComponent(this.jPanelButtons, 0, 4, 1, 1, 5, this.getJButtonRun());
            this.gbConstraints.anchor = 10;
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.insets = new Insets(10, 5, 5, 5);
            this.gbLayout.setConstraints(this.getJButtonRun(), this.gbConstraints);
            this.addComponent(this.jPanelButtons, 0, 5, 1, 1, 5, this.getJButtonClose());
            this.gbConstraints.anchor = 13;
            this.gbConstraints.weightx = 0.0;
            this.gbConstraints.insets = new Insets(10, 10, 5, 5);
            this.gbLayout.setConstraints(this.getJButtonClose(), this.gbConstraints);
        }
        return this.jPanelButtons;
    }

    private JButton getJButtonRun() {
        if (this.jButtonRun == null) {
            this.jButtonRun = new JButton();
            this.jButtonRun.setText(this.RUN);
            this.jButtonRun.addActionListener(this);
        }
        return this.jButtonRun;
    }

    private JButton getJButtonClose() {
        if (this.jButtonClose == null) {
            this.jButtonClose = new JButton();
            this.jButtonClose.setText("Close");
            this.jButtonClose.addActionListener(this);
        }
        return this.jButtonClose;
    }

    private JPanel getJPanelLeft() {
        if (this.jPanelLeft == null) {
            this.jPanelLeft = new JPanel();
            this.jPanelLeft.setLayout(new BoxLayout(this.getJPanelLeft(), 0));
            this.jPanelLeft.add((Component)this.getJScrollPane(), null);
        }
        return this.jPanelLeft;
    }

    private JPanel getJPanelRight() {
        if (this.jPanelRight == null) {
            this.jPanelRight = new JPanel();
            this.jPanelRight.setLayout(new CardLayout());
            this.jPanelRight.add((Component)this.getJPanelAlgo(), this.getJPanelAlgo().getName());
            this.jPanelRight.add((Component)this.getJPanelPSF(), this.getJPanelPSF().getName());
            this.jPanelRight.add((Component)this.getJPanelPerfMon(), this.getJPanelPerfMon().getName());
            this.jPanelRight.add((Component)this.getJPanelBackground(), this.getJPanelBackground().getName());
            this.jPanelRight.add((Component)this.getJPanelVideo(), this.getJPanelVideo().getName());
            this.jPanelRight.add((Component)this.getJPanelWindowing(), this.getJPanelWindowing().getName());
            this.jPanelRight.add((Component)this.getJPanelFFTW(), this.getJPanelFFTW().getName());
            this.jPanelRight.add((Component)this.getJPanelBatch(), this.getJPanelBatch().getName());
            this.jPanelRight.add((Component)this.getJPanelLog(), this.getJPanelLog().getName());
            ((CardLayout)this.jPanelRight.getLayout()).show(this.jPanelRight, this.getJPanelAlgo().getName());
        }
        return this.jPanelRight;
    }

    private JPanel getJPanelBottom() {
        if (this.jPanelBottom == null) {
            this.jPanelBottom = new JPanel();
            this.jPanelBottom.setLayout(this.gbLayout);
            super.addComponent(this.jPanelBottom, 0, 0, 1, 1, 0, this.getJPanelBotLeft());
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.fill = 1;
            this.gbLayout.setConstraints(this.getJPanelBotLeft(), this.gbConstraints);
            super.addComponent(this.jPanelBottom, 0, 1, 1, 1, 0, this.getJPanelBotCenter());
            this.gbConstraints.fill = 1;
            this.gbLayout.setConstraints(this.getJPanelBotCenter(), this.gbConstraints);
            super.addComponent(this.jPanelBottom, 0, 2, 1, 1, 0, this.getJPanelBotRight());
            this.gbConstraints.fill = 1;
            this.gbLayout.setConstraints(this.getJPanelBotRight(), this.gbConstraints);
        }
        return this.jPanelBottom;
    }

    private JPanel getJPanelBotLeft() {
        if (this.jPanelBotLeft == null) {
            this.jLabelCopyRight = new JLabel();
            this.jLabelCopyRight.setText(this.STR_COPYRIGHT);
            this.jPanelBotLeft = new JPanel();
            this.jPanelBotLeft.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelBotLeft.add((Component)this.jLabelCopyRight, null);
        }
        return this.jPanelBotLeft;
    }

    private JPanel getJPanelBotCenter() {
        if (this.jPanelBotCenter == null) {
            this.jLabelMemMessage = new JLabel();
            this.jLabelMemMessage.setText("Mem. Usage");
            this.jLabelMemMessage.setPreferredSize(new Dimension(190, 14));
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.fill = 1;
            this.jPanelBotCenter = new JPanel();
            this.jPanelBotCenter.setLayout(new GridBagLayout());
            this.jPanelBotCenter.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelBotCenter.setPreferredSize(new Dimension(200, 28));
            this.jPanelBotCenter.setMinimumSize(new Dimension(200, 28));
            this.jPanelBotCenter.add((Component)this.jLabelMemMessage, gridBagConstraints11);
        }
        return this.jPanelBotCenter;
    }

    private JPanel getJPanelBotRight() {
        if (this.jPanelBotRight == null) {
            this.jPanelBotRight = new JPanel();
            this.jPanelBotRight.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanelBotRight.setMinimumSize(new Dimension(140, 28));
            this.jPanelBotRight.setPreferredSize(new Dimension(140, 28));
            this.jPanelBotRight.add((Component)this.getJProgressBar(), null);
        }
        return this.jPanelBotRight;
    }

    private JProgressBar getJProgressBar() {
        if (this.jProgressBar == null) {
            this.jProgressBar = new JProgressBar(0, 100);
            this.jProgressBar.setPreferredSize(new Dimension(100, 14));
        }
        return this.jProgressBar;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setBackground(Color.white);
            this.jScrollPane.setViewportView(this.getJTable());
            this.jScrollPane.getViewport().setBackground(Color.white);
            this.jScrollPane.setPreferredSize(new Dimension(260, 100));
        }
        return this.jScrollPane;
    }

    private JTable getJTable() {
        if (this.jTable == null) {
            String[] columnNames = new String[]{"Modules", "Values"};
            Object[][] data = new Object[][]{{"Algorithm", ""}, {"PSF", ""}, {"Monitoring", ""}, {"Background", ""}, {"Video", ""}, {"Windowing", ""}, {"FFTW", ""}, {"Batch", ""}, {"Log", ""}};
            this.jTable = new JTable(new SimpleTableModel(columnNames, data));
            MyTableRenderer tr = new MyTableRenderer();
            this.jTable.setDefaultRenderer(String.class, tr);
            ListSelectionModel rowSM = this.jTable.getSelectionModel();
            this.jTable.setSelectionMode(0);
            rowSM.addListSelectionListener(this);
        }
        return this.jTable;
    }

    private JPanel getJPanelAlgo() {
        if (this.jPanelAlgo == null) {
            this.jLabelAlgo = new JLabel();
            this.jLabelAlgo.setText("Algorithm:");
            this.jPanelAlgo = new JPanel();
            this.jPanelAlgo.setLayout(this.gbLayout);
            this.jPanelAlgo.setName("jPanelAlgo");
            this.addComponent(this.jPanelAlgo, 0, 0, 1, 1, 10, this.jLabelAlgo);
            this.addComponent(this.jPanelAlgo, 0, 1, 1, 1, 10, this.getJComboBoxAlgo());
            this.gbConstraints.weightx = 1.0;
            this.gbLayout.setConstraints(this.getJComboBoxAlgo(), this.gbConstraints);
            this.addComponent(this.jPanelAlgo, 1, 0, 2, 1, 5, this.getJPanelAlgoParams());
            this.gbConstraints.fill = 1;
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.getJPanelAlgoParams(), this.gbConstraints);
        }
        return this.jPanelAlgo;
    }

    private JComboBox getJComboBoxAlgo() {
        if (this.jComboBoxAlgo == null) {
            this.jComboBoxAlgo = new JComboBox();
            int i = 0;
            while (i < this.algo.length) {
                this.jComboBoxAlgo.addItem(this.algo[i].getName());
                ++i;
            }
            this.jComboBoxAlgo.setEditable(false);
            this.jComboBoxAlgo.addActionListener(this);
        }
        return this.jComboBoxAlgo;
    }

    private JPanel getJPanelAlgoParams() {
        if (this.jPanelAlgoParams == null) {
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), "Parameters", 0, 0, null, null);
            titledBorder.setTitle("Parameters");
            this.jPanelAlgoParams = new JPanel();
            this.jPanelAlgoParams.setLayout(new CardLayout());
            this.jPanelAlgoParams.setBorder(titledBorder);
            int i = 0;
            while (i < this.algo.length) {
                this.jPanelAlgoParams.add((Component)this.algo[i].getJPanel(), this.algo[i].getJPanel().getName());
                ++i;
            }
        }
        return this.jPanelAlgoParams;
    }

    private JPanel getJPanelPSF() {
        if (this.jPanelPSF == null) {
            this.jPanelPSF = new JPanel();
            this.jPanelPSF.setLayout(this.gbLayout);
            this.jPanelPSF.setName("jPanelPSF");
            this.jLabelPSFText1 = new JLabel();
            this.jLabelPSFText1.setText("PSF:");
            this.jLabelPSFText1.setEnabled(true);
            this.addComponent(this.jPanelPSF, 0, 0, 1, 1, 5, this.jLabelPSFText1);
            this.gbConstraints.weightx = 1.0;
            this.gbLayout.setConstraints(this.jLabelPSFText1, this.gbConstraints);
            this.addComponent(this.jPanelPSF, 1, 0, 1, 1, 5, this.getJComboBoxPSF());
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJComboBoxPSF(), this.gbConstraints);
            this.addComponent(this.jPanelPSF, 1, 1, 1, 1, 5, this.getJButtonPSFRefresh());
            this.gbConstraints.anchor = 12;
            this.gbLayout.setConstraints(this.getJButtonPSFRefresh(), this.gbConstraints);
            this.addComponent(this.jPanelPSF, 2, 0, 2, 1, 5, this.getJCheckBoxNormalizePSF());
            this.gbLayout.setConstraints(this.getJCheckBoxNormalizePSF(), this.gbConstraints);
            this.addComponent(this.jPanelPSF, 3, 0, 2, 1, 5, this.getJCheckBoxRecenterPSF());
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.getJCheckBoxRecenterPSF(), this.gbConstraints);
        }
        return this.jPanelPSF;
    }

    private JComboBox getJComboBoxPSF() {
        if (this.jComboBoxPSF == null) {
            this.jComboBoxPSF = new JComboBox();
            this.jComboBoxPSF.addActionListener(this);
            this.jComboBoxPSF.setEnabled(true);
            this.setImageList(this.jComboBoxPSF);
            this.jComboBoxAlgo.setEditable(false);
        }
        return this.jComboBoxPSF;
    }

    private JButton getJButtonPSFRefresh() {
        if (this.jButtonPSFRefresh == null) {
            this.jButtonPSFRefresh = new JButton();
            this.jButtonPSFRefresh.setText("Refresh");
            this.jButtonPSFRefresh.addActionListener(this);
            this.jButtonPSFRefresh.setEnabled(true);
        }
        return this.jButtonPSFRefresh;
    }

    private JCheckBox getJCheckBoxNormalizePSF() {
        if (this.jCheckBoxNormalizePSF == null) {
            this.jCheckBoxNormalizePSF = new JCheckBox();
            this.jCheckBoxNormalizePSF.setText("Normalize PSF");
            this.jCheckBoxNormalizePSF.setSelected(true);
        }
        return this.jCheckBoxNormalizePSF;
    }

    private JCheckBox getJCheckBoxRecenterPSF() {
        if (this.jCheckBoxRecenterPSF == null) {
            this.jCheckBoxRecenterPSF = new JCheckBox();
            this.jCheckBoxRecenterPSF.setText("Flip PSF quadrants (activate if PSF is centered)");
            this.jCheckBoxRecenterPSF.setSelected(true);
        }
        return this.jCheckBoxRecenterPSF;
    }

    private JPanel getJPanelPerfMon() {
        if (this.jPanelPerfMon == null) {
            this.jPanelPerfMon = new JPanel();
            this.jPanelPerfMon.setLayout(this.gbLayout);
            this.jPanelPerfMon.setName("jPanelSER");
            this.addComponent(this.jPanelPerfMon, 0, 0, 3, 1, 5, this.getJCheckBoxPerfMon());
            this.gbConstraints.weightx = 1.0;
            this.gbLayout.setConstraints(this.getJCheckBoxPerfMon(), this.gbConstraints);
            this.jLabelPerfMonRef = new JLabel("Ground-truth image:");
            this.jLabelPerfMonRef.setEnabled(false);
            this.addComponent(this.jPanelPerfMon, 1, 0, 1, 1, 5, this.jLabelPerfMonRef);
            this.addComponent(this.jPanelPerfMon, 1, 1, 1, 1, 5, this.getJComboBoxPerfMonRef());
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJComboBoxPerfMonRef(), this.gbConstraints);
            this.addComponent(this.jPanelPerfMon, 1, 2, 1, 1, 5, this.getJButtonPerfMonRefresh());
            this.gbConstraints.anchor = 12;
            this.gbLayout.setConstraints(this.getJButtonPerfMonRefresh(), this.gbConstraints);
            this.jLabelPerfMonFolderDesc = new JLabel("Folder where the result will be saved:");
            this.jLabelPerfMonFolderDesc.setEnabled(false);
            this.addComponent(this.jPanelPerfMon, 2, 0, 1, 1, 5, this.jLabelPerfMonFolderDesc);
            this.gbLayout.setConstraints(this.jLabelPerfMonFolderDesc, this.gbConstraints);
            this.jLabelPerfMonFolderName = new JLabel();
            this.jLabelPerfMonFolderName.setText(this.parameters.folderPerfMon);
            this.jLabelPerfMonFolderName.setBorder(BorderFactory.createEtchedBorder());
            this.jLabelPerfMonFolderName.setEnabled(false);
            this.addComponent(this.jPanelPerfMon, 2, 1, 1, 1, 5, this.jLabelPerfMonFolderName);
            this.gbLayout.setConstraints(this.jLabelPerfMonFolderName, this.gbConstraints);
            this.addComponent(this.jPanelPerfMon, 2, 2, 1, 1, 5, this.getJButtonPerfMonBrowse());
            this.gbConstraints.anchor = 12;
            this.gbLayout.setConstraints(this.getJButtonPerfMonBrowse(), this.gbConstraints);
            this.addComponent(this.jPanelPerfMon, 3, 0, 3, 1, 5, this.getJCheckBoxSeed());
            this.gbConstraints.weightx = 1.0;
            this.gbLayout.setConstraints(this.getJCheckBoxSeed(), this.gbConstraints);
            this.jLabelSeed = new JLabel("Seed value:");
            this.addComponent(this.jPanelPerfMon, 4, 0, 1, 1, 5, this.jLabelSeed);
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.jLabelSeed, this.gbConstraints);
            this.addComponent(this.jPanelPerfMon, 4, 1, 1, 1, 5, this.getJTextFieldSeed());
            this.gbConstraints.fill = 2;
            this.gbConstraints.weightx = 30.0;
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.getJTextFieldSeed(), this.gbConstraints);
        }
        return this.jPanelPerfMon;
    }

    private JCheckBox getJCheckBoxPerfMon() {
        if (this.jCheckBoxPerfMon == null) {
            this.jCheckBoxPerfMon = new JCheckBox("Monitor Signal-to-Error Ratio (SER) and computation time");
            this.jCheckBoxPerfMon.setSelected(false);
            this.jCheckBoxPerfMon.addItemListener(this);
        }
        return this.jCheckBoxPerfMon;
    }

    private JButton getJButtonPerfMonBrowse() {
        if (this.jButtonSERBrowse == null) {
            this.jButtonSERBrowse = new JButton("Browse");
            this.jButtonSERBrowse.addActionListener(this);
            this.jButtonSERBrowse.setEnabled(false);
        }
        return this.jButtonSERBrowse;
    }

    private JButton getJButtonPerfMonRefresh() {
        if (this.jButtonSERRefresh == null) {
            this.jButtonSERRefresh = new JButton("Refresh");
            this.jButtonSERRefresh.addActionListener(this);
            this.jButtonSERRefresh.setEnabled(false);
        }
        return this.jButtonSERRefresh;
    }

    private JComboBox getJComboBoxPerfMonRef() {
        if (this.jComboBoxSERReference == null) {
            this.jComboBoxSERReference = new JComboBox();
            this.jComboBoxSERReference.addActionListener(this);
            this.jComboBoxSERReference.setEnabled(false);
            this.setImageList(this.jComboBoxSERReference);
            this.jComboBoxAlgo.setEditable(false);
        }
        return this.jComboBoxSERReference;
    }

    private JCheckBox getJCheckBoxSeed() {
        if (this.jCheckBoxSeed == null) {
            this.jCheckBoxSeed = new JCheckBox("Use a specific seed to ensure the reproducibility of the results");
            this.jCheckBoxSeed.setSelected(false);
            this.jCheckBoxSeed.addItemListener(this);
        }
        return this.jCheckBoxSeed;
    }

    private JTextField getJTextFieldSeed() {
        if (this.jTextFieldSeed == null) {
            this.verifier = new MyVerifier();
            this.jTextFieldSeed = new JTextField();
            this.jTextFieldSeed.setText("" + this.parameters.seed);
            this.jTextFieldSeed.setInputVerifier(this.verifier);
        }
        return this.jTextFieldSeed;
    }

    private JPanel getJPanelBackground() {
        if (this.jPanelBackground == null) {
            this.jPanelBackground = new JPanel();
            this.jPanelBackground.setLayout(this.gbLayout);
            this.jPanelBackground.setName("jPanelBackground");
            this.jLabelBackgroundLabel = new JLabel("Background value:");
            this.addComponent(this.jPanelBackground, 0, 0, 3, 1, 5, this.getJCheckBoxSubtractBackground());
            this.gbConstraints.weighty = 10.0;
            this.gbLayout.setConstraints(this.getJCheckBoxSubtractBackground(), this.gbConstraints);
            this.addComponent(this.jPanelBackground, 1, 0, 1, 1, 5, this.jLabelBackgroundLabel);
            this.addComponent(this.jPanelBackground, 1, 1, 1, 1, 5, this.getJTextFieldBackground());
            this.gbConstraints.fill = 2;
            this.gbConstraints.weightx = 30.0;
            this.gbLayout.setConstraints(this.getJTextFieldBackground(), this.gbConstraints);
            this.addComponent(this.jPanelBackground, 1, 2, 1, 1, 5, this.getJCheckBoxEstimateBackground());
            this.gbConstraints.weighty = 90.0;
            this.gbConstraints.weightx = 70.0;
            this.gbLayout.setConstraints(this.getJCheckBoxEstimateBackground(), this.gbConstraints);
        }
        return this.jPanelBackground;
    }

    private JCheckBox getJCheckBoxSubtractBackground() {
        if (this.jCheckBoxSubtractBackground == null) {
            this.jCheckBoxSubtractBackground = new JCheckBox();
            this.jCheckBoxSubtractBackground.setText("Subtract Background");
            this.jCheckBoxSubtractBackground.setSelected(false);
            this.jCheckBoxSubtractBackground.addItemListener(this);
        }
        return this.jCheckBoxSubtractBackground;
    }

    private JTextField getJTextFieldBackground() {
        if (this.jTextFieldBackground == null) {
            this.verifier = new MyVerifier();
            this.jTextFieldBackground = new JTextField();
            this.jTextFieldBackground.setText("" + this.parameters.background);
            this.jTextFieldBackground.setInputVerifier(this.verifier);
        }
        return this.jTextFieldBackground;
    }

    private JTextField getJTextFieldMultiParamStart() {
        if (this.jTextFieldMultiParamStart == null) {
            this.verifier = new MyVerifier();
            this.jTextFieldMultiParamStart = new JTextField();
            this.jTextFieldMultiParamStart.setText("" + this.parameters.multiParamStart);
            this.jTextFieldMultiParamStart.setInputVerifier(this.verifier);
        }
        return this.jTextFieldMultiParamStart;
    }

    private JTextField getJTextFieldMultiParamStep() {
        if (this.jTextFieldMultiParamStep == null) {
            this.verifier = new MyVerifier();
            this.jTextFieldMultiParamStep = new JTextField();
            this.jTextFieldMultiParamStep.setText("" + this.parameters.multiParamStep);
            this.jTextFieldMultiParamStep.setInputVerifier(this.verifier);
        }
        return this.jTextFieldMultiParamStep;
    }

    private JTextField getJTextFieldMultiParamEnd() {
        if (this.jTextFieldMultiParamEnd == null) {
            this.verifier = new MyVerifier();
            this.jTextFieldMultiParamEnd = new JTextField();
            this.jTextFieldMultiParamEnd.setText("" + this.parameters.multiParamEnd);
            this.jTextFieldMultiParamEnd.setInputVerifier(this.verifier);
        }
        return this.jTextFieldMultiParamEnd;
    }

    private JCheckBox getJCheckBoxEstimateBackground() {
        if (this.jCheckBoxEstimateBackground == null) {
            this.jCheckBoxEstimateBackground = new JCheckBox();
            this.jCheckBoxEstimateBackground.setText("Use minimal intensity");
            this.jCheckBoxEstimateBackground.setSelected(false);
            this.jCheckBoxEstimateBackground.addItemListener(this);
        }
        return this.jCheckBoxEstimateBackground;
    }

    private JPanel getJPanelVideo() {
        if (this.jPanelVideo == null) {
            this.jPanelVideo = new JPanel();
            this.jPanelVideo.setLayout(this.gbLayout);
            this.jPanelVideo.setName("jPanelVideo");
            this.jLabelVideoText = new JLabel();
            this.jLabelVideoText.setText("Folder where the file series will be saved:");
            this.jLabelVideoText.setEnabled(false);
            this.jLabelVideoFolder = new JLabel();
            this.jLabelVideoFolder.setText(this.parameters.folderVideo);
            this.jLabelVideoFolder.setBorder(BorderFactory.createEtchedBorder());
            this.jLabelVideoFolder.setEnabled(false);
            this.addComponent(this.jPanelVideo, 0, 0, 2, 1, 5, this.getJCheckboxVideo());
            this.gbConstraints.weighty = 10.0;
            this.gbLayout.setConstraints(this.getJCheckboxVideo(), this.gbConstraints);
            this.addComponent(this.jPanelVideo, 1, 0, 1, 1, 5, this.jLabelVideoText);
            this.addComponent(this.jPanelVideo, 1, 1, 1, 2, 5, this.getJButtonVideoBrowse());
            this.gbConstraints.weightx = 100.0;
            this.gbConstraints.anchor = 12;
            this.gbLayout.setConstraints(this.getJButtonVideoBrowse(), this.gbConstraints);
            this.addComponent(this.jPanelVideo, 2, 0, 2, 1, 5, this.jLabelVideoFolder);
            this.gbConstraints.weighty = 90.0;
            this.gbLayout.setConstraints(this.jLabelVideoFolder, this.gbConstraints);
        }
        return this.jPanelVideo;
    }

    private JCheckBox getJCheckboxVideo() {
        if (this.jCheckBoxVideo == null) {
            this.jCheckBoxVideo = new JCheckBox();
            this.jCheckBoxVideo.setText("Save intermediate estimates (generates a video as a file series)");
            this.jCheckBoxVideo.setSelected(false);
            this.jCheckBoxVideo.addItemListener(this);
        }
        return this.jCheckBoxVideo;
    }

    private JButton getJButtonVideoBrowse() {
        if (this.jButtonVideoBrowse == null) {
            this.jButtonVideoBrowse = new JButton();
            this.jButtonVideoBrowse.setText("Browse");
            this.jButtonVideoBrowse.addActionListener(this);
            this.jButtonVideoBrowse.setEnabled(false);
        }
        return this.jButtonVideoBrowse;
    }

    private JPanel getJPanelWindowing() {
        if (this.jPanelWindowing == null) {
            this.jPanelWindowing = new JPanel();
            this.jPanelWindowing.setLayout(this.gbLayout);
            this.jPanelWindowing.setName("jPanelWindowing");
            this.jLabelBorderSliderLegend = new JLabel();
            this.jLabelBorderSliderLegend.setText(" % of initial image dimensions.");
            this.jLabelWindowSliderLegend = new JLabel();
            this.jLabelWindowSliderLegend.setText(" % of initial image dimensions.");
            this.jLabelWindowComboBoxLegend = new JLabel();
            this.jLabelWindowComboBoxLegend.setText(" weight function");
            this.addComponent(this.jPanelWindowing, 0, 0, 3, 1, 5, this.getJCheckBoxTest());
            this.addComponent(this.jPanelWindowing, 1, 0, 1, 1, 5, this.getJCheckBoxAddBorders());
            this.addComponent(this.jPanelWindowing, 1, 1, 1, 1, 5, this.getJSliderAddBorders());
            this.addComponent(this.jPanelWindowing, 1, 2, 1, 1, 5, this.jLabelBorderSliderLegend);
            this.addComponent(this.jPanelWindowing, 2, 0, 1, 1, 5, this.getJCheckBoxWindowing());
            this.addComponent(this.jPanelWindowing, 2, 1, 1, 1, 5, this.getJSliderWindowing());
            this.addComponent(this.jPanelWindowing, 2, 2, 1, 1, 5, this.jLabelWindowSliderLegend);
            this.addComponent(this.jPanelWindowing, 3, 1, 1, 1, 5, this.getJComboBoxWeightBorderFunction());
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJComboBoxWeightBorderFunction(), this.gbConstraints);
            this.addComponent(this.jPanelWindowing, 3, 2, 1, 1, 5, this.jLabelWindowComboBoxLegend);
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.jLabelWindowComboBoxLegend, this.gbConstraints);
        }
        return this.jPanelWindowing;
    }

    private JCheckBox getJCheckBoxTest() {
        if (this.jCheckBoxCrop == null) {
            this.jCheckBoxCrop = new JCheckBox();
            this.jCheckBoxCrop.setText("Test the algorithm on a small rectangular selection");
            this.jCheckBoxCrop.setSelected(false);
            this.jCheckBoxCrop.addItemListener(this);
        }
        return this.jCheckBoxCrop;
    }

    private JCheckBox getJCheckBoxWindowing() {
        if (this.jCheckBoxWindowing == null) {
            this.jCheckBoxWindowing = new JCheckBox();
            this.jCheckBoxWindowing.setText("Weight borders");
            this.jCheckBoxWindowing.setSelected(false);
            this.jCheckBoxWindowing.addItemListener(this);
        }
        return this.jCheckBoxWindowing;
    }

    private JComboBox getJComboBoxWeightBorderFunction() {
        if (this.jComboBoxWeightBorderFunction == null) {
            this.jComboBoxWeightBorderFunction = new JComboBox();
            this.jComboBoxSERReference.setEnabled(false);
            this.jComboBoxWeightBorderFunction.addItem("constant zero");
            this.jComboBoxWeightBorderFunction.addItem("Hann");
            this.jComboBoxAlgo.setEditable(false);
        }
        return this.jComboBoxWeightBorderFunction;
    }

    private JCheckBox getJCheckBoxAddBorders() {
        if (this.jCheckBoxAddBorders == null) {
            this.jCheckBoxAddBorders = new JCheckBox();
            this.jCheckBoxAddBorders.setText("Add borders");
            this.jCheckBoxAddBorders.setSelected(false);
            this.jCheckBoxAddBorders.addItemListener(this);
        }
        return this.jCheckBoxAddBorders;
    }

    private JSlider getJSliderWindowing() {
        if (this.jSliderWindowing == null) {
            this.jSliderWindowing = new JSlider(0, 100, 10);
            this.jSliderWindowing.setMinorTickSpacing(10);
            this.jSliderWindowing.setMajorTickSpacing(50);
            this.jSliderWindowing.setSnapToTicks(true);
            this.jSliderWindowing.setPaintTicks(true);
            this.jSliderWindowing.setLabelTable(this.jSliderWindowing.createStandardLabels(100, 0));
            this.jSliderWindowing.setPaintLabels(true);
        }
        return this.jSliderWindowing;
    }

    private JSlider getJSliderAddBorders() {
        if (this.jSliderAddBorders == null) {
            this.jSliderAddBorders = new JSlider(0, 100, 10);
            this.jSliderAddBorders.setMinorTickSpacing(10);
            this.jSliderAddBorders.setMajorTickSpacing(50);
            this.jSliderAddBorders.setSnapToTicks(true);
            this.jSliderAddBorders.setPaintTicks(true);
            this.jSliderAddBorders.setLabelTable(this.jSliderAddBorders.createStandardLabels(100, 0));
            this.jSliderAddBorders.setPaintLabels(true);
        }
        return this.jSliderAddBorders;
    }

    private JPanel getJPanelFFTW() {
        if (this.jPanelFftw == null) {
            this.jPanelFftw = new JPanel();
            this.jPanelFftw.setLayout(this.gbLayout);
            this.jPanelFftw.setName("jPanelFftw");
            this.addComponent(this.jPanelFftw, 0, 0, 2, 1, 5, this.getJCheckBoxFftw());
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 1.0;
            this.gbLayout.setConstraints(this.getJCheckBoxFftw(), this.gbConstraints);
        }
        return this.jPanelFftw;
    }

    private JCheckBox getJCheckBoxFftw() {
        if (this.jCheckBoxFFTW == null) {
            this.jCheckBoxFFTW = new JCheckBox();
            this.jCheckBoxFFTW.setText("Use the FFTW library");
            this.jCheckBoxFFTW.setSelected(true);
            this.jCheckBoxFFTW.addItemListener(this);
        }
        return this.jCheckBoxFFTW;
    }

    private JPanel getJPanelBatch() {
        if (this.jPanelBatch == null) {
            this.jPanelBatch = new JPanel();
            this.jPanelBatch.setLayout(this.gbLayout);
            this.jPanelBatch.setName("jPanelBatch");
            this.addComponent(this.jPanelBatch, 0, 0, 3, 1, 5, this.getJCheckBoxBatch());
            this.gbConstraints.weightx = 1.0;
            this.gbLayout.setConstraints(this.getJCheckBoxBatch(), this.gbConstraints);
            this.jLabelBatchInputText = new JLabel();
            this.jLabelBatchInputText.setText("Input Folder:");
            this.addComponent(this.jPanelBatch, 1, 0, 1, 1, 5, this.jLabelBatchInputText);
            this.jLabelBatchInputFolder = new JLabel();
            this.jLabelBatchInputFolder.setText(this.parameters.folderBatchInput);
            this.jLabelBatchInputFolder.setBorder(BorderFactory.createEtchedBorder());
            this.addComponent(this.jPanelBatch, 1, 1, 1, 1, 5, this.jLabelBatchInputFolder);
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.jLabelBatchInputFolder, this.gbConstraints);
            this.addComponent(this.jPanelBatch, 1, 2, 1, 1, 5, this.getJButtonBatchInputBrowse());
            this.jLabelBatchOutputText = new JLabel();
            this.jLabelBatchOutputText.setText("Output Folder:");
            this.addComponent(this.jPanelBatch, 2, 0, 1, 1, 5, this.jLabelBatchOutputText);
            this.jLabelBatchOutputFolder = new JLabel();
            this.jLabelBatchOutputFolder.setText(this.parameters.folderBatchOutput);
            this.jLabelBatchOutputFolder.setBorder(BorderFactory.createEtchedBorder());
            this.addComponent(this.jPanelBatch, 2, 1, 1, 1, 5, this.jLabelBatchOutputFolder);
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.jLabelBatchOutputFolder, this.gbConstraints);
            this.addComponent(this.jPanelBatch, 2, 2, 1, 1, 5, this.getJButtonBatchOutputBrowse());
            this.addComponent(this.jPanelBatch, 3, 0, 3, 1, 5, this.getJCheckBoxMultiParam());
            this.addComponent(this.jPanelBatch, 4, 0, 1, 1, 5, this.getJTextFieldMultiParamStart());
            this.gbConstraints.weighty = 1.0;
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJTextFieldMultiParamStart(), this.gbConstraints);
            this.addComponent(this.jPanelBatch, 4, 1, 1, 1, 5, this.getJTextFieldMultiParamStep());
            this.gbConstraints.weighty = 1.0;
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJTextFieldMultiParamStep(), this.gbConstraints);
            this.addComponent(this.jPanelBatch, 4, 2, 1, 1, 5, this.getJTextFieldMultiParamEnd());
            this.gbConstraints.weighty = 1.0;
            this.gbConstraints.fill = 2;
            this.gbLayout.setConstraints(this.getJTextFieldMultiParamEnd(), this.gbConstraints);
        }
        return this.jPanelBatch;
    }

    private JCheckBox getJCheckBoxBatch() {
        if (this.jCheckBoxMultiFile == null) {
            this.jCheckBoxMultiFile = new JCheckBox();
            this.jCheckBoxMultiFile.setText("Run the algorithm on multiple data sets");
            this.jCheckBoxMultiFile.setSelected(false);
            this.jCheckBoxMultiFile.addItemListener(this);
        }
        return this.jCheckBoxMultiFile;
    }

    private JCheckBox getJCheckBoxMultiParam() {
        if (this.jCheckBoxMultiParam == null) {
            this.jCheckBoxMultiParam = new JCheckBox();
            this.jCheckBoxMultiParam.setText("Run the algorithm with multiple regularization parameters (enter start, step and end values)");
            this.jCheckBoxMultiParam.setSelected(false);
            this.jCheckBoxMultiParam.addItemListener(this);
        }
        return this.jCheckBoxMultiParam;
    }

    private JButton getJButtonBatchInputBrowse() {
        if (this.jButtonBatchInputBrowse == null) {
            this.jButtonBatchInputBrowse = new JButton();
            this.jButtonBatchInputBrowse.setText("Browse");
            this.jButtonBatchInputBrowse.addActionListener(this);
            this.jButtonBatchInputBrowse.setEnabled(false);
        }
        return this.jButtonBatchInputBrowse;
    }

    private JButton getJButtonBatchOutputBrowse() {
        if (this.jButtonBatchOutputBrowse == null) {
            this.jButtonBatchOutputBrowse = new JButton();
            this.jButtonBatchOutputBrowse.setText("Browse");
            this.jButtonBatchOutputBrowse.addActionListener(this);
            this.jButtonBatchOutputBrowse.setEnabled(false);
        }
        return this.jButtonBatchOutputBrowse;
    }

    private JPanel getJPanelLog() {
        if (this.jPanelLog == null) {
            this.jPanelLog = new JPanel();
            this.jPanelLog.setLayout(this.gbLayout);
            this.jPanelLog.setName("jPanelLog");
            this.jLabelLogMode = new JLabel();
            this.jLabelLogMode.setText("Mode:");
            this.jButtonClearLog = new JButton("Clear log");
            this.jButtonClearLog.addActionListener(this);
            this.addComponent(this.jPanelLog, 0, 0, 1, 1, 5, this.jLabelLogMode);
            this.addComponent(this.jPanelLog, 0, 1, 1, 1, 5, this.getJComboBoxLog());
            this.addComponent(this.jPanelLog, 0, 2, 1, 1, 5, this.jButtonClearLog);
            this.addComponent(this.jPanelLog, 1, 0, 3, 1, 5, this.getJScrollPaneLog());
            this.gbConstraints.weightx = 1.0;
            this.gbConstraints.weighty = 1.0;
            this.gbConstraints.fill = 1;
            this.gbLayout.setConstraints(this.getJScrollPaneLog(), this.gbConstraints);
        }
        return this.jPanelLog;
    }

    private JComboBox getJComboBoxLog() {
        if (this.jComboBoxLog == null) {
            this.jComboBoxLog = new JComboBox();
            this.jComboBoxLog.addItem(this.VERBOSE);
            this.jComboBoxLog.addItem(this.NORMAL);
            this.jComboBoxLog.addItem(this.SILENT);
            this.jComboBoxLog.addItem(this.MUTE);
            this.jComboBoxLog.addActionListener(this);
        }
        return this.jComboBoxLog;
    }

    private LogPane getJScrollPaneLog() {
        if (this.logPane == null) {
            this.logPane = new LogPane();
            this.logPane.setEnabled(true);
        }
        return this.logPane;
    }

    private JButton getJButtonSaveSettings() {
        if (this.jButtonSaveSettings == null) {
            this.jButtonSaveSettings = new JButton();
            this.jButtonSaveSettings.setText("Save settings");
            this.jButtonSaveSettings.addActionListener(this);
        }
        return this.jButtonSaveSettings;
    }

    private JButton getJButtonLoadSettings() {
        if (this.jButtonLoadSettings == null) {
            this.jButtonLoadSettings = new JButton();
            this.jButtonLoadSettings.setText("Load settings");
            this.jButtonLoadSettings.addActionListener(this);
        }
        return this.jButtonLoadSettings;
    }

    private JButton getJButtonResetSettings() {
        if (this.jButtonResetSettings == null) {
            this.jButtonResetSettings = new JButton();
            this.jButtonResetSettings.setText("Default Settings");
            this.jButtonResetSettings.addActionListener(this);
        }
        return this.jButtonResetSettings;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.jButtonCredits) {
            AboutDialog about = new AboutDialog(this);
            about.setVisible(true);
        } else if (source == this.jButtonClose) {
            this.cleanup();
            this.dispose();
            System.gc();
        } else if (source == this.jButtonRun) {
            this.getParameters();
            if (this.jButtonRun.getText() == this.RUN) {
                if (this.threadDeconvolution != null && this.threadDeconvolution.isAlive()) {
                    IJ.error((String)"Another algorithm is still running.");
                    return;
                }
                int i = 0;
                while (i < this.algo.length) {
                    if (this.algo[i].getName().equals(this.parameters.nameAlgo)) break;
                    ++i;
                }
                this.threadDeconvolution = new ThreadDeconvolution(this.algo[i], this.parameters, this.jButtonRun, this.RUN);
                this.threadDeconvolution.setPriority(1);
                this.threadDeconvolution.start();
                this.timer.start();
                if (this.parameters.logPriorityLevel < 2) {
                    this.jTable.setRowSelectionInterval(1, 8);
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelLog().getName());
                }
                this.jButtonRun.setText(this.STOP);
            } else if (this.jButtonRun.getText() == this.STOP) {
                this.threadDeconvolution.stop();
                if (this.timer != null) {
                    this.timer.stop();
                }
                this.jProgressBar.setValue(0);
                this.jButtonRun.setText(this.RUN);
            }
        } else if (source == this.jButtonSaveSettings) {
            this.setPreferences();
        } else if (source == this.jButtonLoadSettings) {
            this.getPreferences();
            this.repaint();
        } else if (source == this.jButtonResetSettings) {
            this.resetParameters();
            this.updateGUIFromParameters();
        } else if (source == this.jButtonVideoBrowse) {
            this.jLabelVideoFolder.setText(IJ.getDirectory((String)""));
        } else if (source == this.jButtonBatchInputBrowse) {
            this.jLabelBatchInputFolder.setText(IJ.getDirectory((String)""));
        } else if (source == this.jButtonBatchOutputBrowse) {
            this.jLabelBatchOutputFolder.setText(IJ.getDirectory((String)""));
        } else if (source == this.jButtonSERBrowse) {
            this.jLabelPerfMonFolderName.setText(IJ.getDirectory((String)""));
        } else if (source == this.jButtonSERRefresh) {
            this.setImageList(this.jComboBoxSERReference);
        } else if (source == this.jComboBoxSERReference) {
            if (this.getJCheckBoxPerfMon().isSelected()) {
                this.jTable.setValueAt(this.getJComboBoxPerfMonRef().getSelectedItem(), 2, 1);
            }
        } else if (source == this.jButtonPSFRefresh) {
            this.setImageList(this.jComboBoxPSF);
        } else if (source == this.jButtonClearLog) {
            this.logPane.clear();
        } else if (source == this.jComboBoxPSF) {
            this.jTable.setValueAt(this.getJComboBoxPSF().getSelectedItem(), 1, 1);
        } else if (source == this.jComboBoxLog) {
            this.jTable.setValueAt(this.getJComboBoxLog().getSelectedItem(), 8, 1);
            this.log.activePriorityLevel = this.getJComboBoxLog().getSelectedIndex();
        } else if (source == this.jComboBoxAlgo) {
            String algoName = (String)this.getJComboBoxAlgo().getSelectedItem();
            this.jTable.setValueAt(algoName, 0, 1);
            int i = 0;
            while (i < this.algo.length) {
                if (algoName.equalsIgnoreCase(this.algo[i].getName())) {
                    ((CardLayout)this.jPanelAlgoParams.getLayout()).show(this.jPanelAlgoParams, this.algo[i].getJPanel().getName());
                }
                ++i;
            }
        } else {
            throw new RuntimeException("Unknown error: unknown source.");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        ItemSelectable src = e.getItemSelectable();
        if (e.getStateChange() == 2) {
            if (src == this.jCheckBoxPerfMon) {
                this.jLabelPerfMonRef.setEnabled(false);
                this.jLabelPerfMonFolderDesc.setEnabled(false);
                this.jLabelPerfMonFolderName.setEnabled(false);
                this.jButtonSERBrowse.setEnabled(false);
                this.jButtonSERRefresh.setEnabled(false);
                this.jComboBoxSERReference.setEnabled(false);
                this.jTable.setValueAt("No", 2, 1);
            } else if (src == this.jCheckBoxSeed) {
                this.jLabelSeed.setEnabled(false);
                this.jTextFieldSeed.setEnabled(false);
            } else if (src == this.jCheckBoxVideo) {
                this.jLabelVideoText.setEnabled(false);
                this.jLabelVideoFolder.setEnabled(false);
                this.jButtonVideoBrowse.setEnabled(false);
                this.jTable.setValueAt("No", 4, 1);
            } else if (src == this.jCheckBoxCrop) {
                if (!this.getJCheckBoxWindowing().isSelected() && !this.getJCheckBoxAddBorders().isSelected()) {
                    this.jTable.setValueAt("No", 5, 1);
                }
            } else if (src == this.jCheckBoxFFTW) {
                this.jTable.setValueAt("No", 6, 1);
            } else if (src == this.jCheckBoxWindowing) {
                this.jSliderWindowing.setEnabled(false);
                this.jComboBoxWeightBorderFunction.setEnabled(false);
                this.jLabelWindowSliderLegend.setEnabled(false);
                this.jLabelWindowComboBoxLegend.setEnabled(false);
                if (!this.getJCheckBoxTest().isSelected() && !this.getJCheckBoxAddBorders().isSelected()) {
                    this.jTable.setValueAt("No", 5, 1);
                }
            } else if (src == this.jCheckBoxAddBorders) {
                this.jSliderAddBorders.setEnabled(false);
                this.jLabelBorderSliderLegend.setEnabled(false);
                if (!this.getJCheckBoxTest().isSelected() && !this.getJCheckBoxWindowing().isSelected()) {
                    this.jTable.setValueAt("No", 5, 1);
                }
            } else if (src == this.jCheckBoxMultiFile) {
                this.jLabelBatchInputFolder.setEnabled(false);
                this.jLabelBatchInputText.setEnabled(false);
                this.jLabelBatchOutputFolder.setEnabled(false);
                this.jLabelBatchOutputText.setEnabled(false);
                this.jButtonBatchInputBrowse.setEnabled(false);
                this.jButtonBatchOutputBrowse.setEnabled(false);
                this.jTable.setValueAt("No", 7, 1);
            } else if (src == this.jCheckBoxMultiParam) {
                this.jTextFieldMultiParamStart.setEnabled(false);
                this.jTextFieldMultiParamStep.setEnabled(false);
                this.jTextFieldMultiParamEnd.setEnabled(false);
                this.jTable.setValueAt("No", 7, 1);
            } else if (src == this.jCheckBoxSubtractBackground) {
                this.jLabelBackgroundLabel.setEnabled(false);
                this.jTextFieldBackground.setEnabled(false);
                this.jCheckBoxEstimateBackground.setEnabled(false);
                this.jTable.setValueAt("No", 3, 1);
            } else if (src == this.jCheckBoxEstimateBackground && this.jCheckBoxSubtractBackground.isSelected()) {
                this.jTextFieldBackground.setEnabled(true);
            }
        } else if (src == this.jCheckBoxPerfMon) {
            this.jLabelPerfMonRef.setEnabled(true);
            this.jLabelPerfMonFolderDesc.setEnabled(true);
            this.jLabelPerfMonFolderName.setEnabled(true);
            this.jButtonSERBrowse.setEnabled(true);
            this.jButtonSERRefresh.setEnabled(true);
            this.jComboBoxSERReference.setEnabled(true);
            this.setImageList(this.getJComboBoxPerfMonRef());
            this.jTable.setValueAt("Yes", 2, 1);
        } else if (src == this.jCheckBoxSeed) {
            this.jLabelSeed.setEnabled(true);
            this.jTextFieldSeed.setEnabled(true);
        } else if (src == this.jCheckBoxVideo) {
            this.jTable.setValueAt("Yes", 4, 1);
            this.jLabelVideoText.setEnabled(true);
            this.jLabelVideoFolder.setEnabled(true);
            this.jButtonVideoBrowse.setEnabled(true);
        } else if (src == this.jCheckBoxCrop) {
            this.jTable.setValueAt("Yes", 5, 1);
        } else if (src == this.jCheckBoxFFTW) {
            this.jTable.setValueAt("Yes", 6, 1);
        } else if (src == this.jCheckBoxWindowing) {
            this.jSliderWindowing.setEnabled(true);
            this.jComboBoxWeightBorderFunction.setEnabled(true);
            this.jLabelWindowSliderLegend.setEnabled(true);
            this.jLabelWindowComboBoxLegend.setEnabled(true);
            this.jTable.setValueAt("Yes", 5, 1);
        } else if (src == this.jCheckBoxAddBorders) {
            this.jSliderAddBorders.setEnabled(true);
            this.jLabelBorderSliderLegend.setEnabled(true);
            this.jTable.setValueAt("Yes", 5, 1);
        } else if (src == this.jCheckBoxMultiFile) {
            this.jLabelBatchInputFolder.setEnabled(true);
            this.jLabelBatchInputText.setEnabled(true);
            this.jLabelBatchOutputFolder.setEnabled(true);
            this.jLabelBatchOutputText.setEnabled(true);
            this.jButtonBatchInputBrowse.setEnabled(true);
            this.jButtonBatchOutputBrowse.setEnabled(true);
            this.jCheckBoxMultiParam.setSelected(false);
            this.jTextFieldMultiParamStart.setEnabled(false);
            this.jTextFieldMultiParamStep.setEnabled(false);
            this.jTextFieldMultiParamEnd.setEnabled(false);
            this.jTable.setValueAt("Yes", 7, 1);
        } else if (src == this.jCheckBoxMultiParam) {
            this.jTextFieldMultiParamStart.setEnabled(true);
            this.jTextFieldMultiParamStep.setEnabled(true);
            this.jTextFieldMultiParamEnd.setEnabled(true);
            this.jCheckBoxMultiFile.setSelected(false);
            this.jLabelBatchInputFolder.setEnabled(false);
            this.jLabelBatchInputText.setEnabled(false);
            this.jLabelBatchOutputFolder.setEnabled(false);
            this.jLabelBatchOutputText.setEnabled(false);
            this.jButtonBatchInputBrowse.setEnabled(false);
            this.jButtonBatchOutputBrowse.setEnabled(false);
            this.jTable.setValueAt("Yes", 7, 1);
        } else if (src == this.jCheckBoxSubtractBackground) {
            this.jLabelBackgroundLabel.setEnabled(true);
            this.jCheckBoxEstimateBackground.setEnabled(true);
            this.jTextFieldBackground.setEnabled(!this.jCheckBoxEstimateBackground.isSelected());
            this.jTable.setValueAt("Yes", 3, 1);
        } else if (src == this.jCheckBoxEstimateBackground) {
            this.jTextFieldBackground.setEnabled(false);
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (lsm.isSelectionEmpty()) {
            System.out.println("No rows are selected.");
        } else {
            int selectedRow = lsm.getMinSelectionIndex();
            switch (selectedRow) {
                case 0: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelAlgo().getName());
                    break;
                }
                case 1: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelPSF().getName());
                    break;
                }
                case 2: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelPerfMon().getName());
                    break;
                }
                case 3: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelBackground().getName());
                    break;
                }
                case 4: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelVideo().getName());
                    break;
                }
                case 5: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelWindowing().getName());
                    break;
                }
                case 6: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelFFTW().getName());
                    break;
                }
                case 7: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelBatch().getName());
                    break;
                }
                case 8: {
                    ((CardLayout)this.jPanelRight.getLayout()).show(this.getJPanelRight(), this.getJPanelLog().getName());
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid option.");
                }
            }
        }
    }

    private void getParameters() {
        int i = 0;
        while (i < this.algo.length) {
            this.algo[i].getParameters();
            ++i;
        }
        this.parameters.nameAlgo = (String)this.jComboBoxAlgo.getSelectedItem();
        this.parameters.namePSF = (String)this.jComboBoxPSF.getSelectedItem();
        this.parameters.nameRef = (String)this.jComboBoxSERReference.getSelectedItem();
        this.parameters.folderPerfMon = this.jLabelPerfMonFolderName.getText();
        this.parameters.folderVideo = this.jLabelVideoFolder.getText();
        this.parameters.folderBatchInput = this.jLabelBatchInputFolder.getText();
        this.parameters.folderBatchOutput = this.jLabelBatchOutputFolder.getText();
        this.parameters.monitorPerf = this.jCheckBoxPerfMon.isSelected();
        this.parameters.useSeed = this.jCheckBoxSeed.isSelected();
        this.parameters.saveVideo = this.jCheckBoxVideo.isSelected();
        this.parameters.cropSelection = this.jCheckBoxCrop.isSelected();
        this.parameters.useFFTW = this.jCheckBoxFFTW.isSelected();
        this.parameters.logPriorityLevel = this.jComboBoxLog.getSelectedIndex();
        this.parameters.useWindowing = this.jCheckBoxWindowing.isSelected();
        this.parameters.addBorders = this.jCheckBoxAddBorders.isSelected();
        this.parameters.processMultiFile = this.jCheckBoxMultiFile.isSelected();
        this.parameters.processMultiParam = this.jCheckBoxMultiParam.isSelected();
        this.parameters.normalizePSF = this.jCheckBoxNormalizePSF.isSelected();
        this.parameters.recenterPSF = this.jCheckBoxRecenterPSF.isSelected();
        this.parameters.seed = Float.parseFloat(this.jTextFieldSeed.getText());
        this.parameters.windowingFunction = this.jComboBoxWeightBorderFunction.getSelectedIndex();
        this.parameters.percentWindowing = (float)this.jSliderWindowing.getValue() / 100.0f;
        this.parameters.percentBorder = (float)this.jSliderAddBorders.getValue() / 100.0f;
        this.parameters.subtractBackground = this.jCheckBoxSubtractBackground.isSelected();
        this.parameters.estimateBackground = this.jCheckBoxEstimateBackground.isSelected();
        this.parameters.background = Float.parseFloat(this.jTextFieldBackground.getText());
        this.parameters.multiParamStart = Float.parseFloat(this.jTextFieldMultiParamStart.getText());
        this.parameters.multiParamStep = Float.parseFloat(this.jTextFieldMultiParamStep.getText());
        this.parameters.multiParamEnd = Float.parseFloat(this.jTextFieldMultiParamEnd.getText());
    }

    private void updateGUIFromParameters() {
        int i = 0;
        while (i < this.algo.length) {
            this.algo[i].updateGUI();
            ++i;
        }
        this.jComboBoxAlgo.setSelectedIndex(0);
        this.jComboBoxAlgo.setSelectedItem(this.parameters.nameAlgo);
        this.jTable.setValueAt((String)this.getJComboBoxAlgo().getSelectedItem(), 0, 1);
        this.jCheckBoxPerfMon.setSelected(!this.parameters.monitorPerf);
        this.jCheckBoxPerfMon.setSelected(this.parameters.monitorPerf);
        this.jCheckBoxSeed.setSelected(!this.parameters.useSeed);
        this.jCheckBoxSeed.setSelected(this.parameters.useSeed);
        this.jCheckBoxVideo.setSelected(!this.parameters.saveVideo);
        this.jCheckBoxVideo.setSelected(this.parameters.saveVideo);
        this.jCheckBoxCrop.setSelected(!this.parameters.cropSelection);
        this.jCheckBoxCrop.setSelected(this.parameters.cropSelection);
        this.jCheckBoxFFTW.setSelected(!this.parameters.useFFTW);
        this.jCheckBoxFFTW.setSelected(this.parameters.useFFTW);
        this.jCheckBoxMultiFile.setSelected(!this.parameters.processMultiFile);
        this.jCheckBoxMultiFile.setSelected(this.parameters.processMultiFile);
        this.jCheckBoxMultiParam.setSelected(!this.parameters.processMultiParam);
        this.jCheckBoxMultiParam.setSelected(this.parameters.processMultiParam);
        this.jCheckBoxWindowing.setSelected(!this.parameters.useWindowing);
        this.jCheckBoxWindowing.setSelected(this.parameters.useWindowing);
        this.jCheckBoxAddBorders.setSelected(!this.parameters.addBorders);
        this.jCheckBoxAddBorders.setSelected(this.parameters.addBorders);
        this.jCheckBoxNormalizePSF.setSelected(!this.parameters.normalizePSF);
        this.jCheckBoxNormalizePSF.setSelected(this.parameters.normalizePSF);
        this.jCheckBoxRecenterPSF.setSelected(!this.parameters.recenterPSF);
        this.jCheckBoxRecenterPSF.setSelected(this.parameters.recenterPSF);
        this.jCheckBoxSubtractBackground.setSelected(!this.parameters.subtractBackground);
        this.jCheckBoxSubtractBackground.setSelected(this.parameters.subtractBackground);
        this.jCheckBoxEstimateBackground.setSelected(!this.parameters.estimateBackground);
        this.jCheckBoxEstimateBackground.setSelected(this.parameters.estimateBackground);
        this.jTextFieldSeed.setText("" + this.parameters.seed);
        this.jTextFieldBackground.setText("" + this.parameters.background);
        this.jTextFieldMultiParamStart.setText("" + this.parameters.multiParamStart);
        this.jTextFieldMultiParamStep.setText("" + this.parameters.multiParamStep);
        this.jTextFieldMultiParamEnd.setText("" + this.parameters.multiParamEnd);
        this.setImageList(this.jComboBoxPSF);
        this.jComboBoxPSF.setSelectedItem(this.parameters.namePSF);
        this.setImageList(this.jComboBoxSERReference);
        this.jComboBoxSERReference.setSelectedItem(this.parameters.nameRef);
        this.jComboBoxLog.setSelectedIndex(this.parameters.logPriorityLevel);
        this.jComboBoxWeightBorderFunction.setSelectedIndex(this.parameters.windowingFunction);
        this.jLabelPerfMonFolderName.setText(this.parameters.folderPerfMon);
        this.jLabelVideoFolder.setText(this.parameters.folderVideo);
        this.jLabelBatchInputFolder.setText(this.parameters.folderBatchInput);
        this.jLabelBatchOutputFolder.setText(this.parameters.folderBatchOutput);
        this.jSliderWindowing.setValue((int)(this.parameters.percentWindowing * 100.0f));
        this.jSliderAddBorders.setValue((int)(this.parameters.percentBorder * 100.0f));
    }

    private void setPreferences() {
        try {
            FileOutputStream fos = new FileOutputStream(this.filename);
            BufferedOutputStream bos = new BufferedOutputStream(fos);
            Properties properties = new Properties();
            this.getParameters();
            int i = 0;
            while (i < this.algo.length) {
                this.algo[i].saveParameters(properties);
                ++i;
            }
            properties.setProperty("nameAlgo", this.parameters.nameAlgo);
            properties.setProperty("namePSF", this.parameters.namePSF);
            properties.setProperty("nameRef", this.parameters.nameRef);
            properties.setProperty("folderPerfMon", this.parameters.folderPerfMon);
            properties.setProperty("folderVideo", this.parameters.folderVideo);
            properties.setProperty("folderBatchInput", this.parameters.folderBatchInput);
            properties.setProperty("folderBatchOutput", this.parameters.folderBatchOutput);
            properties.setProperty("monitorPerf", Boolean.toString(this.parameters.monitorPerf));
            properties.setProperty("useSeed", Boolean.toString(this.parameters.useSeed));
            properties.setProperty("saveVideo", Boolean.toString(this.parameters.saveVideo));
            properties.setProperty("cropSelection", Boolean.toString(this.parameters.cropSelection));
            properties.setProperty("useFFTW", Boolean.toString(this.parameters.useFFTW));
            properties.setProperty("useWindowing", Boolean.toString(this.parameters.useWindowing));
            properties.setProperty("addBorders", Boolean.toString(this.parameters.addBorders));
            properties.setProperty("processMultiFile", Boolean.toString(this.parameters.processMultiFile));
            properties.setProperty("processMultiParam", Boolean.toString(this.parameters.processMultiParam));
            properties.setProperty("normalizePSF", Boolean.toString(this.parameters.normalizePSF));
            properties.setProperty("recenterPSF", Boolean.toString(this.parameters.recenterPSF));
            properties.setProperty("subtractBackground", Boolean.toString(this.parameters.subtractBackground));
            properties.setProperty("estimateBackground", Boolean.toString(this.parameters.estimateBackground));
            properties.setProperty("seed", Float.toString(this.parameters.seed));
            properties.setProperty("percentWindowing", Float.toString(this.parameters.percentWindowing));
            properties.setProperty("percentBorder", Float.toString(this.parameters.percentBorder));
            properties.setProperty("background", Float.toString(this.parameters.background));
            properties.setProperty("multiParamStart", Float.toString(this.parameters.multiParamStart));
            properties.setProperty("multiParamStep", Float.toString(this.parameters.multiParamStep));
            properties.setProperty("multiParamEnd", Float.toString(this.parameters.multiParamEnd));
            properties.setProperty("logPriorityLevel", Integer.toString(this.parameters.logPriorityLevel));
            properties.setProperty("windowingFunction", Integer.toString(this.parameters.windowingFunction));
            properties.store(bos, "DeconvolutionLab settings");
            bos.flush();
            bos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void getPreferences() {
        try {
            FileInputStream fis = new FileInputStream(this.filename);
            BufferedInputStream bis = new BufferedInputStream(fis);
            Properties properties = new Properties();
            properties.load(bis);
            int i = 0;
            while (i < this.algo.length) {
                this.algo[i].loadParameters(properties);
                ++i;
            }
            this.parameters.nameAlgo = properties.getProperty("nameAlgo", this.parameters.nameAlgo);
            this.parameters.namePSF = properties.getProperty("namePSF", this.parameters.namePSF);
            this.parameters.nameRef = properties.getProperty("nameRef", this.parameters.nameRef);
            this.parameters.folderPerfMon = properties.getProperty("folderPerfMon", this.parameters.folderPerfMon);
            this.parameters.folderVideo = properties.getProperty("folderVideo", this.parameters.folderVideo);
            this.parameters.folderBatchInput = properties.getProperty("folderBatchInput", this.parameters.folderBatchInput);
            this.parameters.folderBatchOutput = properties.getProperty("folderBatchOutput", this.parameters.folderBatchOutput);
            this.parameters.monitorPerf = Boolean.parseBoolean(properties.getProperty("monitorPerf", "" + this.parameters.monitorPerf));
            this.parameters.useSeed = Boolean.parseBoolean(properties.getProperty("useSeed", "" + this.parameters.useSeed));
            this.parameters.saveVideo = Boolean.parseBoolean(properties.getProperty("saveVideo", "" + this.parameters.saveVideo));
            this.parameters.cropSelection = Boolean.parseBoolean(properties.getProperty("cropSelection", "" + this.parameters.cropSelection));
            this.parameters.useFFTW = Boolean.parseBoolean(properties.getProperty("useFFTW", "" + this.parameters.useFFTW));
            this.parameters.useWindowing = Boolean.parseBoolean(properties.getProperty("useWindowing", "" + this.parameters.useWindowing));
            this.parameters.addBorders = Boolean.parseBoolean(properties.getProperty("addBorders", "" + this.parameters.addBorders));
            this.parameters.processMultiFile = Boolean.parseBoolean(properties.getProperty("processMultiFile", "" + this.parameters.processMultiFile));
            this.parameters.processMultiParam = Boolean.parseBoolean(properties.getProperty("processMultiParam", "" + this.parameters.processMultiParam));
            this.parameters.normalizePSF = Boolean.parseBoolean(properties.getProperty("normalizePSF", "" + this.parameters.normalizePSF));
            this.parameters.recenterPSF = Boolean.parseBoolean(properties.getProperty("recenterPSF", "" + this.parameters.recenterPSF));
            this.parameters.subtractBackground = Boolean.parseBoolean(properties.getProperty("subtractBackground", "" + this.parameters.subtractBackground));
            this.parameters.estimateBackground = Boolean.parseBoolean(properties.getProperty("estimateBackground", "" + this.parameters.estimateBackground));
            this.parameters.seed = Float.parseFloat(properties.getProperty("seed", "" + this.parameters.seed));
            this.parameters.percentWindowing = Float.parseFloat(properties.getProperty("percentWindowing", "" + this.parameters.percentWindowing));
            this.parameters.percentBorder = Float.parseFloat(properties.getProperty("percentBorder", "" + this.parameters.percentBorder));
            this.parameters.background = Float.parseFloat(properties.getProperty("background", "" + this.parameters.background));
            this.parameters.multiParamStart = Float.parseFloat(properties.getProperty("multiParamStart", "" + this.parameters.multiParamStart));
            this.parameters.multiParamStep = Float.parseFloat(properties.getProperty("multiParamStep", "" + this.parameters.multiParamStep));
            this.parameters.multiParamEnd = Float.parseFloat(properties.getProperty("multiParamEnd", "" + this.parameters.multiParamEnd));
            this.parameters.logPriorityLevel = Integer.parseInt(properties.getProperty("logPriorityLevel", "" + this.parameters.logPriorityLevel));
            this.parameters.windowingFunction = Integer.parseInt(properties.getProperty("windowingFunction", "" + this.parameters.windowingFunction));
            bis.close();
            this.updateGUIFromParameters();
        }
        catch (Exception e) {
            this.resetParameters();
            this.updateGUIFromParameters();
            IJ.showMessage((String)"Info", (String)"The default settings were loaded. To define customized\nsettings, use the \"Save settings\" button.");
        }
    }

    private void resetParameters() {
        this.parameters.reset();
        int i = 0;
        while (i < this.algo.length) {
            this.algo[i].reset();
            ++i;
        }
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == AdvancedDialog.this.jTextFieldSeed) {
                return this.checkFloatField("Table entry Seed", AdvancedDialog.this.jLabelSeed.getText(), AdvancedDialog.this.jTextFieldSeed, -1.0E20f, 1.0E20f, 0.0f, changeIt);
            }
            if (input == AdvancedDialog.this.jTextFieldBackground) {
                return this.checkFloatField("Table entry Background", AdvancedDialog.this.jLabelBackgroundLabel.getText(), AdvancedDialog.this.jTextFieldBackground, -1.0E20f, 1.0E20f, 0.0f, changeIt);
            }
            if (input == AdvancedDialog.this.jTextFieldMultiParamStart) {
                return this.checkFloatField("Table entry Multiple parameters", "Start value", AdvancedDialog.this.jTextFieldMultiParamStart, -1.0E20f, 1.0E20f, 0.0f, changeIt);
            }
            if (input == AdvancedDialog.this.jTextFieldMultiParamStep) {
                return this.checkFloatField("Table entry Multiple parameters", "Step value", AdvancedDialog.this.jTextFieldMultiParamStep, -1.0E20f, 1.0E20f, 0.1f, changeIt);
            }
            if (input == AdvancedDialog.this.jTextFieldMultiParamEnd) {
                return this.checkFloatField("Table entry Multiple parameters", "End value", AdvancedDialog.this.jTextFieldMultiParamEnd, -1.0E20f, 1.0E20f, 1.0f, changeIt);
            }
            return true;
        }
    }
}

