/*
 * Decompiled with CFR 0.152.
 */
package deconv.validation;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.MatlabWriter;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.gui.AbstractVerifier;

public class FFTBenchmark
extends AbstractAlgorithm {
    private JPanel jPanel = null;
    private JLabel jLabelIterations = null;
    private JLabel jLabelUnit = null;
    private JTextField jTextFieldIterations = null;
    private int iterations = 100;
    private int MIN_ITERATIONS = 1;
    private int MAX_ITERATIONS = 1000000000;
    private MyVerifier verifier = new MyVerifier();

    public FFTBenchmark() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelBenchmarkFFT");
        this.jLabelIterations = new JLabel();
        this.jLabelUnit = new JLabel();
        this.jTextFieldIterations = new JTextField();
        this.jLabelIterations.setText("Iterations:");
        this.jLabelUnit.setText("");
        this.jTextFieldIterations.setText("" + this.iterations);
        this.jTextFieldIterations.setInputVerifier(this.verifier);
        this.addTextFieldLine(this.jPanel, 0, 100.0, this.jLabelIterations, this.jTextFieldIterations, this.jLabelUnit);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "FFT benchmark";
    }

    @Override
    public boolean process(Signal g, Signal h, Signal reference, Parameters parameters) {
        MatlabWriter serWriter = null;
        float initialSER = 0.0f;
        ToolboxFourier fftToolbox = new ToolboxFourier(g.N, parameters.useFFTW, parameters.fileWisdom);
        if (parameters.saveVideo) {
            log.start("Saving PreBenchFFT.tiff", 1);
            ToolboxSignal.save(g, parameters.folderVideo, "PreBenchFFT");
            log.acknowledge(1);
        }
        if (reference != null && parameters.monitorPerf) {
            log.start("Calculating and saving SER", 0);
            serWriter = new MatlabWriter(parameters.folderPerfMon, "BenchFFT");
            serWriter.openFile();
            serWriter.newArray("serBenchFFT");
            initialSER = ToolboxSignal.calculateSER(g, reference);
            serWriter.addValue(initialSER);
            log.acknowledge(0);
            log.append("SER before ffts: " + initialSER + "dB.", 1);
        }
        log.setProgressLength(30);
        log.append("Using FFTW library:" + parameters.useFFTW, 2);
        log.start(this.iterations + "ffts and inverse ffts", 2);
        int i = 0;
        while (i < this.iterations) {
            fftToolbox.forwardDFT(g);
            fftToolbox.inverseDFT(g);
            ++i;
        }
        log.acknowledge(2);
        log.setProgressLength(80);
        if (reference != null && parameters.monitorPerf) {
            log.start("Calculating and saving SER", 0);
            float ser = ToolboxSignal.calculateSER(g, reference);
            float gain = ser - initialSER;
            serWriter.addValue(gain);
            serWriter.closeFile();
            log.acknowledge(0);
            log.append("SER gain after ffts: " + gain + "dB.", 1);
        }
        if (parameters.saveVideo) {
            log.start("Saving PostBenchFFT.tiff", 1);
            ToolboxSignal.save(g, parameters.folderVideo, "PostBenchFFT");
            log.acknowledge(1);
        }
        log.setProgressLength(90);
        return true;
    }

    public float[] getOptParamRange() {
        int N = 2;
        float[] param = new float[N];
        int n = 0;
        while (n < N) {
            param[n] = (float)Math.pow(2.0, n - N / 2);
            ++n;
        }
        return param;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("benchmarkFFTIterations", "" + this.iterations);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty("benchmarkFFTIterations", "" + this.iterations);
        this.iterations = Integer.parseInt(s);
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("This algorithm " + this.getName() + " is not macro callable"));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
        this.iterations = Integer.parseInt(this.jTextFieldIterations.getText());
    }

    @Override
    public void updateGUI() {
        this.jTextFieldIterations.setText("" + this.iterations);
    }

    @Override
    public void reset() {
        this.iterations = 100;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == FFTBenchmark.this.jTextFieldIterations) {
                return this.checkIntField(FFTBenchmark.this.getName(), FFTBenchmark.this.jLabelIterations.getText(), FFTBenchmark.this.jTextFieldIterations, FFTBenchmark.this.MIN_ITERATIONS, FFTBenchmark.this.MAX_ITERATIONS, 100, changeIt);
            }
            return true;
        }
    }
}

