/*
 * Decompiled with CFR 0.152.
 */
package deconv.validation;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import deconv.algo.RegularizedInverseFiltering;
import deconv.algo.RiskEstimation;
import ij.IJ;
import ij.gui.Plot;
import java.awt.Color;
import java.util.Properties;
import javax.swing.JPanel;
import toolbox.MatlabWriter;
import toolbox.Signal;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;

public class TestRiskEstimation
extends AbstractAlgorithm {
    private JPanel jPanel = new JPanel();

    public TestRiskEstimation() {
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelTestRiskEstimation");
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Test Risk Estimation";
    }

    @Override
    public boolean process(Signal y, Signal h, Signal xorig, Parameters parameters) {
        ToolboxFourier tbFourier = new ToolboxFourier(y.N, parameters.useFFTW, parameters.fileWisdom);
        RegularizedInverseFiltering regInvFilt = new RegularizedInverseFiltering();
        regInvFilt.regParamEst = false;
        regInvFilt.noiseParamEst = false;
        regInvFilt.gamma = 1.0f;
        regInvFilt.mu = 0.0f;
        regInvFilt.sigma = 1.0f;
        log.start("Estimating noise parameters", 0);
        log.acknowledge(0);
        log.append("Estimated gain: " + regInvFilt.gamma, 2);
        log.append("Estimated standard deviation: " + regInvFilt.sigma, 2);
        log.append("Estimated background: " + regInvFilt.mu, 2);
        ToolboxSignal.addConstant(y, -regInvFilt.mu, 0.0f);
        ToolboxSignal.multiplyConstant(y, 1.0f / regInvFilt.gamma);
        regInvFilt.sigma /= regInvFilt.gamma;
        regInvFilt.gamma = 1.0f;
        regInvFilt.mu = 0.0f;
        Signal xorighat = (Signal)xorig.clone();
        tbFourier.forwardDFT(xorighat);
        Signal yhat = (Signal)y.clone();
        tbFourier.forwardDFT(yhat);
        Signal hhat = (Signal)h.clone();
        tbFourier.forwardDFT(hhat);
        Signal lhat = new Signal(y.N);
        ToolboxSignal.laplacian2D3D(lhat);
        float[] lambda = new float[100];
        int k = 0;
        while (k < lambda.length) {
            lambda[k] = (float)Math.pow(10.0, (double)k / 10.0 - 5.0);
            ++k;
        }
        float[] index = new float[lambda.length];
        int k2 = 0;
        while (k2 < lambda.length) {
            index[k2] = (float)Math.log10(lambda[k2]);
            ++k2;
        }
        float[] MSEOracle = new float[lambda.length];
        float[] MSEEst = new float[lambda.length];
        float lambdaOptEst = 0.0f;
        float MSEOptEst = 0.0f;
        Signal yhatopt = null;
        log.start("Exhaustive search for optimal regularization parameter", 0);
        int k3 = 0;
        while (k3 < lambda.length) {
            Signal yhattmp = (Signal)yhat.clone();
            Signal hhattmp = (Signal)hhat.clone();
            regInvFilt.regInvFilt(yhattmp, hhattmp, lambda[k3]);
            MSEOracle[k3] = (float)(ToolboxSignal.norm2DifferenceDouble(yhattmp, xorighat) / Math.pow(y.length, 2.0));
            MSEEst[k3] = (float)(ToolboxSignal.norm2(xorig) + RiskEstimation.evaluateRisk(yhat, hhat, lhat, lambda[k3], regInvFilt.gamma, regInvFilt.mu, (float)Math.pow(regInvFilt.sigma, 2.0))) / (float)y.length;
            if (k3 == 0 || MSEEst[k3] <= MSEOptEst) {
                lambdaOptEst = lambda[k3];
                MSEOptEst = MSEEst[k3];
                yhatopt = (Signal)yhattmp.clone();
            }
            ++k3;
        }
        tbFourier.inverseDFT(yhatopt);
        ToolboxSignal.copy(y, yhatopt);
        log.acknowledge(0);
        log.setProgressLength(50);
        log.append("Optimal regularization parameter: " + lambdaOptEst, 0);
        MatlabWriter mWriter = new MatlabWriter(String.valueOf(parameters.folderPerfMon) + "/MSE.m");
        mWriter.openFile();
        mWriter.writeArray("lambda", lambda);
        mWriter.writeArray("MSEOracle", MSEOracle);
        mWriter.writeArray("MSEEst", MSEEst);
        mWriter.closeFile();
        Plot plot = new Plot("MSE vs. lambda", "log10(lambda)", "MSE", null, null);
        plot.setLimits((double)this.min(index), (double)this.max(index), -1000.0, 5000.0);
        plot.setColor(Color.BLUE);
        plot.addPoints(index, MSEEst, 2);
        plot.setColor(Color.RED);
        plot.addPoints(index, MSEOracle, 2);
        plot.draw();
        plot.show();
        return true;
    }

    private float min(float[] array) {
        float m = array[0];
        int k = 1;
        while (k < array.length) {
            if (array[k] < m) {
                m = array[k];
            }
            ++k;
        }
        return m;
    }

    private float max(float[] array) {
        float m = array[0];
        int k = 1;
        while (k < array.length) {
            if (array[k] > m) {
                m = array[k];
            }
            ++k;
        }
        return m;
    }

    public float[] getOptParamRange() {
        int N = 2;
        float[] param = new float[N];
        int n = 0;
        while (n < N) {
            param[n] = (float)Math.pow(2.0, n - N / 2);
            ++n;
        }
        return param;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
    }

    @Override
    public void loadParameters(Properties properties) {
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("This algorithm " + this.getName() + " is not macro callable"));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
    }

    @Override
    public void updateGUI() {
    }

    @Override
    public void reset() {
    }
}

