/*
 * Decompiled with CFR 0.152.
 */
package deconv.validation;

import deconv.Parameters;
import deconv.algo.AbstractAlgorithm;
import ij.IJ;
import ij.ImagePlus;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import toolbox.MatlabWriter;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.ToolboxWavelet;
import toolbox.gui.AbstractVerifier;

public class TestWaveletTransform
extends AbstractAlgorithm {
    private JPanel jPanel = null;
    private JLabel jLabelIterations = null;
    private JTextField jTextFieldIterations = null;
    private JLabel jLabelUnit = null;
    private JLabel jLabelWaveShape = null;
    private JComboBox jComboBoxWaveShape = null;
    private int iterations = 0;
    private int waveShape = 0;
    private int MIN_ITERATIONS = 0;
    private int MAX_ITERATIONS = 100;
    MatlabWriter serWriter = null;
    private MyVerifier verifier = new MyVerifier();

    public TestWaveletTransform() {
        this.jPanel = new JPanel();
        this.jPanel.setLayout(this.gbLayout);
        this.jPanel.setName("jPanelWaveletTransformTest");
        this.jTextFieldIterations = new JTextField();
        this.jLabelIterations = new JLabel();
        this.jLabelUnit = new JLabel();
        this.jLabelWaveShape = new JLabel();
        this.jComboBoxWaveShape = new JComboBox();
        this.jLabelIterations.setText("Iterations:");
        this.jLabelUnit.setText("");
        this.jTextFieldIterations.setText("" + this.iterations);
        this.jTextFieldIterations.setInputVerifier(this.verifier);
        this.jLabelWaveShape.setText("Wavelet Family: ");
        this.jComboBoxWaveShape.addItem("Fractional Splines");
        this.jComboBoxWaveShape.addItem("Haar");
        this.jComboBoxWaveShape.addItem("Daubechies p=2");
        this.jComboBoxWaveShape.addItem("Daubechies p=4");
        this.jComboBoxWaveShape.addItem("Daubechies p=6");
        this.addTextFieldLine(this.jPanel, 0, 0.0, this.jLabelIterations, this.jTextFieldIterations, this.jLabelUnit);
        this.addTextFieldLine(this.jPanel, 1, 100.0, this.jLabelWaveShape, this.jComboBoxWaveShape, this.jLabelUnit);
    }

    @Override
    public JPanel getJPanel() {
        return this.jPanel;
    }

    @Override
    public String getName() {
        return "Wavelet Transform Test";
    }

    @Override
    public boolean process(Signal g, Signal h, Signal reference, Parameters parameters) {
        ToolboxFourier fftToolbox = new ToolboxFourier(g.N, parameters.useFFTW, parameters.fileWisdom);
        log.start("fft of image", 0);
        fftToolbox.forwardDFT(g);
        log.acknowledge(0);
        log.setProgressLength(10);
        SignalWavelet wTransform = new SignalWavelet(g.N, this.iterations);
        log.appendWithTime("Space for wavelet transform is allocated.", 0);
        ToolboxWavelet wToolbox = new ToolboxWavelet(wTransform, this.waveShape, parameters.useFFTW, parameters.fileWisdom);
        log.appendWithTime("FFTs are initialized.", 0);
        wToolbox.transform(g, wTransform, this.iterations);
        log.appendWithTime("Wavelet transform performed.", 0);
        ImagePlus res = wToolbox.getImage(wTransform, "Wavelet Transform");
        res.show();
        log.appendWithTime("Image retrieved.", 0);
        float sigma = wToolbox.estimateSigma(wTransform);
        log.appendWithTime("Noise estimated. Sigma= " + sigma, 0);
        wToolbox.transformInverse(wTransform, g);
        log.appendWithTime("Inverse transform done.", 0);
        log.start("inverse fft of image", 0);
        fftToolbox.inverseDFT(g);
        log.acknowledge(0);
        log.setProgressLength(80);
        if (reference != null && parameters.monitorPerf) {
            log.start("Calculating and saving SER", 0);
            this.serWriter = new MatlabWriter(parameters.folderPerfMon, "WaveTest");
            this.serWriter.openFile();
            this.serWriter.newArray("serWaveletTest");
            float ser = ToolboxSignal.calculateSER(g, reference);
            this.serWriter.addValue(ser);
            log.acknowledge(0);
            log.append("SER after wavelet transform: " + ser + "dB.", 1);
        }
        if (parameters.saveVideo) {
            log.start("Saving PostWavelet.tiff", 1);
            ToolboxSignal.save(g, parameters.folderVideo, "PostConv");
            log.acknowledge(1);
        }
        return true;
    }

    public float[] getOptParamRange() {
        int N = 2;
        float[] param = new float[N];
        int n = 0;
        while (n < N) {
            param[n] = (float)Math.pow(2.0, n - N / 2);
            ++n;
        }
        return param;
    }

    @Override
    public void setRegParamValue(float param) {
    }

    @Override
    public void saveParameters(Properties properties) {
        properties.setProperty("WaveTestIterations", "" + this.iterations);
        properties.setProperty("WaveTestWaveShape", "" + this.waveShape);
    }

    @Override
    public void loadParameters(Properties properties) {
        String s = properties.getProperty("WaveTestIterations", "" + this.iterations);
        this.iterations = Integer.parseInt(s);
        s = properties.getProperty("WaveTestWaveShape", "" + this.waveShape);
        this.waveShape = Integer.parseInt(s);
    }

    @Override
    public void getMacroParameters(String options) {
        IJ.error((String)("This algorithm " + this.getName() + " is not macro callable"));
    }

    @Override
    public void log() {
    }

    @Override
    public void getParameters() {
        this.iterations = Integer.parseInt(this.jTextFieldIterations.getText());
        this.waveShape = this.jComboBoxWaveShape.getSelectedIndex();
    }

    @Override
    public void updateGUI() {
        this.jTextFieldIterations.setText("" + this.iterations);
        this.jComboBoxWaveShape.setSelectedIndex(this.waveShape);
    }

    @Override
    public void reset() {
        this.iterations = 1;
        this.waveShape = 0;
    }

    class MyVerifier
    extends AbstractVerifier {
        MyVerifier() {
        }

        @Override
        protected boolean checkField(JComponent input, boolean changeIt) {
            if (input == TestWaveletTransform.this.jTextFieldIterations) {
                return this.checkIntField(TestWaveletTransform.this.getName(), TestWaveletTransform.this.jLabelIterations.getText(), TestWaveletTransform.this.jTextFieldIterations, TestWaveletTransform.this.MIN_ITERATIONS, TestWaveletTransform.this.MAX_ITERATIONS, 1, changeIt);
            }
            return true;
        }
    }
}

