/*
 * Decompiled with CFR 0.152.
 */
package jfftw;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import jfftw.FFTWLoader;

public class Wisdom {
    static {
        FFTWLoader.run();
    }

    private Wisdom() {
    }

    public static void save(File file) throws IOException {
        BufferedWriter out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
        String wisdom = Wisdom.get();
        out.write(wisdom, 0, wisdom.length());
        out.close();
    }

    public static native String get();

    public static void load(File file) throws IOException {
        int c;
        BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        CharArrayWriter tmp = new CharArrayWriter();
        while ((c = in.read()) != -1) {
            tmp.write(c);
        }
        in.close();
        try {
            Wisdom.add(new String(tmp.toCharArray()));
        }
        catch (IllegalArgumentException e) {
            throw new IOException("badly formatted wisdom file");
        }
    }

    public static native void add(String var0) throws IllegalArgumentException;

    public static native void clear();
}

