/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.IJ;
import java.io.FileWriter;
import java.io.IOException;

public class MatlabWriter {
    private String path;
    private String filename;
    private FileWriter fWriter;
    private boolean activeArray;
    private boolean isFirstValue;
    private String[] variableNames;
    int numberArrays;

    public MatlabWriter(String path, String filename) {
        this.path = path;
        this.filename = filename;
    }

    public MatlabWriter(String fullfilename) {
        this.path = "";
        this.filename = fullfilename;
    }

    public boolean openFile() {
        try {
            this.fWriter = new FileWriter(String.valueOf(this.path) + this.filename, false);
        }
        catch (IOException e) {
            IJ.error((String)("The file \"" + this.path + this.filename + "\" could not be opened."));
            return false;
        }
        this.activeArray = false;
        this.isFirstValue = true;
        this.variableNames = null;
        this.numberArrays = 0;
        return true;
    }

    public boolean closeFile() {
        this.writeEnd();
        try {
            this.fWriter.close();
        }
        catch (IOException e) {
            IJ.error((String)("The file \"" + this.path + this.filename + "\" could not be closed."));
            return false;
        }
        return true;
    }

    public void newArray(String name) {
        try {
            if (this.activeArray) {
                this.fWriter.write("];\n");
            }
            String[] oldArray = this.variableNames;
            this.variableNames = new String[this.numberArrays + 1];
            int i = 0;
            while (i < this.numberArrays) {
                this.variableNames[i] = oldArray[i];
                ++i;
            }
            ++this.numberArrays;
            this.variableNames[this.numberArrays - 1] = name;
            this.fWriter.write(String.valueOf(name) + " = [");
            this.isFirstValue = true;
            this.activeArray = true;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean addValue(float value) {
        String valString;
        block5: {
            try {
                valString = String.valueOf(value);
                if (this.activeArray) break block5;
                return false;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        if (this.isFirstValue) {
            this.fWriter.write(valString);
            this.isFirstValue = false;
        } else {
            this.fWriter.write(", " + valString);
        }
        return true;
    }

    public void addComment(String comment) {
        try {
            if (this.activeArray) {
                this.fWriter.write("];\n");
                this.activeArray = false;
            }
            this.fWriter.write("\n%" + comment);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void addText(String text) {
        try {
            if (this.activeArray) {
                this.fWriter.write("];\n");
                this.activeArray = false;
            }
            this.fWriter.write("\n" + text);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void writeEnd() {
        try {
            if (this.activeArray) {
                this.fWriter.write("];\n");
                this.activeArray = false;
            }
            if (this.numberArrays > 0) {
                this.fWriter.write("\n\n");
                this.fWriter.write("hold on;\n");
                int i = 0;
                while (i < this.numberArrays) {
                    this.fWriter.write("plot(" + this.variableNames[i] + ");\n");
                    ++i;
                }
                this.fWriter.write("hold off;\n");
                this.fWriter.write("\n");
                this.fWriter.write("xlabel('iterations');\n");
                this.fWriter.write("ylabel('SER [dB]');\n");
                this.fWriter.write("legend('" + this.variableNames[0] + "'");
                i = 1;
                while (i < this.numberArrays) {
                    this.fWriter.write(", ...\n'" + this.variableNames[i] + "'");
                    ++i;
                }
                this.fWriter.write(");\n");
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean writeArray(String varname, float[] array) {
        try {
            this.fWriter.write(String.valueOf(varname) + " = [");
            int k = 0;
            while (k < array.length) {
                this.fWriter.write(String.valueOf(array[k]) + ", ");
                ++k;
            }
            this.fWriter.write("];\n");
            return true;
        }
        catch (IOException e) {
            IJ.error((String)("The array \"" + varname + "\" could not be written."));
            return false;
        }
    }
}

