/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import toolbox.ToolboxSignal;

public class Signal
implements Cloneable {
    public int D;
    public boolean isReal;
    public int[] N;
    public int[] extN;
    public int length;
    public int extLength;
    public float[] array;

    public Signal() {
    }

    public Signal(int[] N) {
        this.isReal = true;
        this.D = N.length;
        this.N = (int[])N.clone();
        this.extN = (int[])N.clone();
        this.extN[this.D - 1] = 2 * (N[this.D - 1] / 2 + 1);
        this.length = 1;
        this.extLength = 1;
        int i = 0;
        while (i < this.D) {
            this.length *= N[i];
            this.extLength *= this.extN[i];
            ++i;
        }
        this.array = new float[this.extLength];
    }

    public Signal(ImagePlus im) {
        this.isReal = true;
        if (im.getStackSize() == 1) {
            this.D = 2;
            this.N = new int[2];
            this.extN = new int[2];
            this.N[0] = im.getHeight();
            this.extN[0] = this.N[0];
            this.N[1] = im.getWidth();
            this.extN[1] = 2 * (this.N[1] / 2 + 1);
            this.length = this.N[0] * this.N[1];
            this.extLength = this.extN[0] * this.extN[1];
            this.array = new float[this.extLength];
            ImageProcessor im_processor = im.getProcessor();
            int y = 0;
            while (y < this.N[0]) {
                int contribY = y * this.extN[1];
                int x = 0;
                while (x < this.N[1]) {
                    this.array[x + contribY] = im_processor.getPixelValue(x, y);
                    ++x;
                }
                ++y;
            }
        } else {
            this.D = 3;
            this.N = new int[3];
            this.extN = new int[3];
            this.N[0] = im.getStackSize();
            this.extN[0] = this.N[0];
            this.N[1] = im.getHeight();
            this.extN[1] = this.N[1];
            this.N[2] = im.getWidth();
            this.extN[2] = 2 * (this.N[2] / 2 + 1);
            this.length = this.N[0] * this.N[1] * this.N[2];
            this.extLength = this.extN[0] * this.extN[1] * this.extN[2];
            this.array = new float[this.extLength];
            int sliceArea = this.extN[2] * this.extN[1];
            int z = 0;
            while (z < this.N[0]) {
                ImageProcessor im_processor = im.getStack().getProcessor(z + 1);
                int contribZ = z * sliceArea;
                int y = 0;
                while (y < this.N[1]) {
                    int contribYZ = contribZ + y * this.extN[2];
                    int x = 0;
                    while (x < this.N[2]) {
                        this.array[x + contribYZ] = im_processor.getPixelValue(x, y);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
    }

    public Signal(ImagePlus im, Rectangle rect) {
        this.isReal = true;
        if (im.getStackSize() == 1) {
            this.D = 2;
            this.N = new int[2];
            this.extN = new int[2];
            this.N[0] = rect.height;
            this.extN[0] = this.N[0];
            this.N[1] = rect.width;
            this.extN[1] = 2 * (this.N[1] / 2 + 1);
            this.length = this.N[0] * this.N[1];
            this.extLength = this.extN[0] * this.extN[1];
            this.array = new float[this.extLength];
            ImageProcessor im_processor = im.getProcessor();
            int heightImage = im_processor.getHeight();
            int widthImage = im_processor.getWidth();
            int y = 0;
            while (y < this.N[0]) {
                int contribY = y * this.extN[1];
                int coordY = rect.y + y;
                coordY = this.mirror(coordY, heightImage);
                int x = 0;
                while (x < this.N[1]) {
                    int coordX = rect.x + x;
                    coordX = this.mirror(coordX, widthImage);
                    this.array[x + contribY] = im_processor.getPixelValue(coordX, coordY);
                    ++x;
                }
                ++y;
            }
        }
    }

    public Signal(ImagePlus im, Rectangle rect, int z0, int depth) {
        this.isReal = true;
        if (im.getStackSize() != 1) {
            this.D = 3;
            this.N = new int[3];
            this.extN = new int[3];
            this.N[0] = depth;
            this.extN[0] = this.N[0];
            this.N[1] = rect.height;
            this.extN[1] = this.N[1];
            this.N[2] = rect.width;
            this.extN[2] = 2 * (this.N[2] / 2 + 1);
            this.length = this.N[0] * this.N[1] * this.N[2];
            this.extLength = this.extN[0] * this.extN[1] * this.extN[2];
            this.array = new float[this.extLength];
            int sliceArea = this.extN[2] * this.extN[1];
            int depthImage = im.getStackSize();
            int widthImage = im.getWidth();
            int heightImage = im.getHeight();
            int z = 0;
            while (z < this.N[0]) {
                int contribZ = z * sliceArea;
                int coordZ = z0 + z;
                coordZ = this.mirror(coordZ, depthImage);
                ImageProcessor im_processor = im.getStack().getProcessor(coordZ + 1);
                int y = 0;
                while (y < this.N[1]) {
                    int contribYZ = contribZ + y * this.extN[2];
                    int coordY = rect.y + y;
                    coordY = this.mirror(coordY, heightImage);
                    int x = 0;
                    while (x < this.N[2]) {
                        int coordX = rect.x + x;
                        coordX = this.mirror(coordX, widthImage);
                        this.array[x + contribYZ] = im_processor.getPixelValue(coordX, coordY);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
    }

    public ImagePlus get_image(String title) {
        ImagePlus result = null;
        if (this.D == 2) {
            int ny;
            int nx;
            if (this.isReal) {
                nx = this.N[1];
                ny = this.N[0];
            } else {
                nx = this.extN[1];
                ny = this.extN[0];
            }
            FloatProcessor im_processor = new FloatProcessor(nx, ny);
            float[] imageArray = (float[])im_processor.getPixels();
            int y = 0;
            while (y < ny) {
                System.arraycopy(this.array, y * this.extN[1], imageArray, y * nx, nx);
                ++y;
            }
            result = new ImagePlus(title, (ImageProcessor)im_processor);
            result.getProcessor().setMinAndMax((double)this.getMin(), (double)this.getMax());
        } else if (this.D == 3) {
            int nz;
            int ny;
            int nx;
            if (this.isReal) {
                nx = this.N[2];
                ny = this.N[1];
                nz = this.N[0];
            } else {
                nx = this.extN[2];
                ny = this.extN[1];
                nz = this.extN[0];
            }
            ImageStack stack = new ImageStack(nx, ny);
            int sliceArea = this.extN[2] * this.extN[1];
            float mini = this.getMin();
            float maxi = this.getMax();
            int z = 0;
            while (z < nz) {
                FloatProcessor im_processor = new FloatProcessor(nx, ny);
                float[] imageArray = (float[])im_processor.getPixels();
                int contribZ = z * sliceArea;
                int y = 0;
                while (y < ny) {
                    System.arraycopy(this.array, y * this.extN[2] + contribZ, imageArray, y * nx, nx);
                    ++y;
                }
                im_processor.setMinAndMax((double)mini, (double)maxi);
                stack.addSlice("", (ImageProcessor)im_processor);
                ++z;
            }
            result = new ImagePlus(title, stack);
        }
        return result;
    }

    public ImagePlus get_image(String title, Rectangle roi) {
        ImagePlus result = null;
        if (this.D == 2) {
            FloatProcessor im_processor = new FloatProcessor(roi.width, roi.height);
            float[] imageArray = (float[])im_processor.getPixels();
            int y = 0;
            while (y < roi.height) {
                System.arraycopy(this.array, (y + roi.y) * this.extN[1] + roi.x, imageArray, y * roi.width, roi.width);
                ++y;
            }
            result = new ImagePlus(title, (ImageProcessor)im_processor);
            result.getProcessor().setMinAndMax((double)this.getMin(), (double)this.getMax());
        }
        return result;
    }

    public ImagePlus get_image(String title, Rectangle roi, int z0, int depth) {
        ImagePlus result = null;
        if (this.D == 3) {
            ImageStack stack = new ImageStack(roi.width, roi.height);
            int sliceArea = this.extN[2] * this.extN[1];
            int z = 0;
            while (z < depth) {
                FloatProcessor im_processor = new FloatProcessor(roi.width, roi.height);
                float[] imageArray = (float[])im_processor.getPixels();
                int contribZ = (z + z0) * sliceArea;
                int y = 0;
                while (y < roi.height) {
                    System.arraycopy(this.array, (y + roi.y) * this.extN[2] + contribZ + roi.x, imageArray, y * roi.width, roi.width);
                    ++y;
                }
                im_processor.setMinAndMax((double)this.getMin(), (double)this.getMax());
                stack.addSlice("", (ImageProcessor)im_processor);
                ++z;
            }
            result = new ImagePlus(title, stack);
        }
        return result;
    }

    public Object clone() {
        Signal s = new Signal();
        s.isReal = this.isReal;
        s.D = this.D;
        s.length = this.length;
        s.extLength = this.extLength;
        s.array = new float[this.array.length];
        s.N = new int[this.N.length];
        s.extN = new int[this.extN.length];
        int i = 0;
        while (i < s.extN.length) {
            s.extN[i] = this.extN[i];
            ++i;
        }
        i = 0;
        while (i < s.N.length) {
            s.N[i] = this.N[i];
            ++i;
        }
        i = 0;
        while (i < s.array.length) {
            s.array[i] = this.array[i];
            ++i;
        }
        return s;
    }

    private int mirror(int k, int K) {
        if (k < 0) {
            k = -k;
        }
        if ((k %= 2 * K - 2) >= K) {
            k = 2 * K - 2 - k;
        }
        return k;
    }

    private float getMin() {
        float min = ToolboxSignal.minimum(this);
        return min < 0.0f ? min : 0.0f;
    }

    private float getMax() {
        float max = ToolboxSignal.maximum(this);
        return max > 255.0f ? max : 255.0f;
    }
}

