/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.IJ;
import toolbox.Signal;

public class SignalWavelet {
    public int[] N;
    public int J;
    public int M;
    public Signal[][] w;
    public Signal s = null;
    public int performedIterations = 0;

    public SignalWavelet(int[] N, int J) {
        int D = N.length;
        int downSamplingFactor = this.power(2, J);
        int d = 0;
        while (d < D) {
            if (N[d] % downSamplingFactor != 0) {
                IJ.error((String)("The dimensions of the input signal must be divisible by " + downSamplingFactor + "."));
                return;
            }
            ++d;
        }
        this.N = new int[D];
        int i = 0;
        while (i < D) {
            this.N[i] = N[i];
            ++i;
        }
        this.J = J;
        this.M = this.power(2, D) - 1;
        this.w = new Signal[J][this.M];
        int[] Nsubband = new int[D];
        int d2 = 0;
        while (d2 < D) {
            Nsubband[d2] = N[d2];
            ++d2;
        }
        int j = 0;
        while (j < J) {
            int d3 = 0;
            while (d3 < D) {
                int n = d3++;
                Nsubband[n] = Nsubband[n] / 2;
            }
            int m = 0;
            while (m < this.M) {
                this.w[j][m] = new Signal(Nsubband);
                this.w[j][m].isReal = false;
                ++m;
            }
            ++j;
        }
    }

    private int power(int x, int P) {
        int y = 1;
        int p = 0;
        while (p < P) {
            y *= x;
            ++p;
        }
        return y;
    }
}

