/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.IJ;
import java.io.File;
import java.io.IOException;
import jfftw.Wisdom;
import jfftw.real.nd.Plan;
import toolbox.FFT1D;
import toolbox.Signal;

public class ToolboxFourier {
    Plan planForwardFFTW = null;
    Plan planInverseFftw = null;
    boolean useFFTW = false;
    int[] dimensions;

    public ToolboxFourier(int[] dim, boolean useFFTW, String wisdomFileName) {
        this.dimensions = new int[dim.length];
        int i = 0;
        while (i < this.dimensions.length) {
            this.dimensions[i] = dim[i];
            ++i;
        }
        this.useFFTW = useFFTW;
        if (useFFTW) {
            File wisdomFile = new File(wisdomFileName);
            try {
                Wisdom.load(wisdomFile);
            }
            catch (IOException e) {
                IJ.error((String)("Warning: the FFTW wisdom file " + wisdomFileName + " cannot be read."));
            }
            this.planForwardFFTW = new Plan(this.dimensions, -1, 24);
            this.planInverseFftw = new Plan(this.dimensions, 1, 24);
            try {
                Wisdom.save(wisdomFile);
            }
            catch (IOException e) {
                IJ.error((String)("Warning: the FFTW wisdom file " + wisdomFileName + " cannot be written."));
            }
            wisdomFile = null;
        }
    }

    public boolean signalIsCompatible(Signal s) {
        if (s.N.length != this.dimensions.length) {
            return false;
        }
        int i = 0;
        while (i < this.dimensions.length) {
            if (s.N[i] != this.dimensions[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void forwardDFT(Signal s) {
        if (this.useFFTW) {
            this.forwardFFTW(s);
        } else {
            this.forwardFFT(s);
        }
    }

    public void inverseDFT(Signal s) {
        if (this.useFFTW) {
            this.inverseFFTW(s);
        } else {
            this.inverseFFT(s);
        }
    }

    public boolean forwardFFTW(Signal s) {
        if (s.isReal && this.useFFTW && this.signalIsCompatible(s)) {
            this.planForwardFFTW.transform(s.array);
            s.isReal = false;
            return true;
        }
        return false;
    }

    public boolean inverseFFTW(Signal s) {
        if (!s.isReal && this.useFFTW && this.signalIsCompatible(s)) {
            this.planInverseFftw.transform(s.array);
            int i = 0;
            while (i < s.extLength) {
                int n = i++;
                s.array[n] = s.array[n] / (float)s.length;
            }
            s.isReal = true;
            return true;
        }
        return false;
    }

    public boolean forwardFFT(Signal s) {
        if (!s.isReal) {
            return false;
        }
        if (s.D == 1) {
            FFT1D fft = new FFT1D(s.N[0]);
            double[] real = new double[s.N[0]];
            double[] imag = new double[s.N[0]];
            int i = 0;
            while (i < s.N[0]) {
                real[i] = s.array[i];
                ++i;
            }
            fft.transform(real, imag, s.N[0], 0);
            i = 0;
            while (i < s.extN[0]) {
                s.array[i] = (float)real[i / 2];
                s.array[i + 1] = (float)imag[i / 2];
                i += 2;
            }
            s.isReal = false;
            return true;
        }
        if (s.D == 2) {
            int factorY = s.extN[1];
            FFT1D fft = new FFT1D(s.N[1]);
            double[] real = new double[s.N[1]];
            double[] imag = new double[s.N[1]];
            int y = 0;
            while (y < s.N[0]) {
                int contribY = factorY * y;
                int x = 0;
                while (x < s.N[1]) {
                    real[x] = s.array[x + contribY];
                    imag[x] = 0.0;
                    ++x;
                }
                fft.transform(real, imag, s.N[1], 0);
                x = 0;
                while (x < s.extN[1]) {
                    s.array[x + contribY] = (float)real[x / 2];
                    s.array[x + 1 + contribY] = (float)imag[x / 2];
                    x += 2;
                }
                ++y;
            }
            fft = new FFT1D(s.extN[0]);
            real = new double[s.extN[0]];
            imag = new double[s.extN[0]];
            int x = 0;
            while (x < s.extN[1]) {
                int y2 = 0;
                while (y2 < s.extN[0]) {
                    real[y2] = s.array[factorY * y2 + x];
                    imag[y2] = s.array[factorY * y2 + x + 1];
                    ++y2;
                }
                fft.transform(real, imag, s.extN[0], 0);
                y2 = 0;
                while (y2 < s.extN[0]) {
                    s.array[factorY * y2 + x] = (float)real[y2];
                    s.array[factorY * y2 + x + 1] = (float)imag[y2];
                    ++y2;
                }
                x += 2;
            }
            s.isReal = false;
            return true;
        }
        if (s.D == 3) {
            int y;
            int x;
            int contribZ;
            int factorZ = s.extN[1] * s.extN[2];
            int factorY = s.extN[2];
            FFT1D fft = new FFT1D(s.N[2]);
            double[] real = new double[s.N[2]];
            double[] imag = new double[s.N[2]];
            int z = 0;
            while (z < s.N[0]) {
                contribZ = z * factorZ;
                int y3 = 0;
                while (y3 < s.N[1]) {
                    int contribYZ = factorY * y3 + contribZ;
                    x = 0;
                    while (x < s.N[2]) {
                        real[x] = s.array[x + contribYZ];
                        imag[x] = 0.0;
                        ++x;
                    }
                    fft.transform(real, imag, s.N[2], 0);
                    x = 0;
                    while (x < s.extN[2]) {
                        s.array[x + contribYZ] = (float)real[x / 2];
                        s.array[x + 1 + contribYZ] = (float)imag[x / 2];
                        x += 2;
                    }
                    ++y3;
                }
                ++z;
            }
            fft = new FFT1D(s.extN[1]);
            real = new double[s.extN[1]];
            imag = new double[s.extN[1]];
            int z2 = 0;
            while (z2 < s.extN[0]) {
                contribZ = z2 * factorZ;
                x = 0;
                while (x < s.extN[2]) {
                    int contribXZ = contribZ + x;
                    y = 0;
                    while (y < s.extN[1]) {
                        real[y] = s.array[factorY * y + contribXZ];
                        imag[y] = s.array[factorY * y + contribXZ + 1];
                        ++y;
                    }
                    fft.transform(real, imag, s.extN[1], 0);
                    y = 0;
                    while (y < s.extN[1]) {
                        s.array[factorY * y + contribXZ] = (float)real[y];
                        s.array[factorY * y + contribXZ + 1] = (float)imag[y];
                        ++y;
                    }
                    x += 2;
                }
                ++z2;
            }
            fft = new FFT1D(s.extN[0]);
            real = new double[s.extN[0]];
            imag = new double[s.extN[0]];
            y = 0;
            while (y < s.extN[1]) {
                int contribY = y * factorY;
                int x2 = 0;
                while (x2 < s.extN[2]) {
                    int contribXY = contribY + x2;
                    int z3 = 0;
                    while (z3 < s.extN[0]) {
                        real[z3] = s.array[factorZ * z3 + contribXY];
                        imag[z3] = s.array[factorZ * z3 + contribXY + 1];
                        ++z3;
                    }
                    fft.transform(real, imag, s.extN[0], 0);
                    z3 = 0;
                    while (z3 < s.extN[0]) {
                        s.array[factorZ * z3 + contribXY] = (float)real[z3];
                        s.array[factorZ * z3 + contribXY + 1] = (float)imag[z3];
                        ++z3;
                    }
                    x2 += 2;
                }
                ++y;
            }
            s.isReal = false;
            return true;
        }
        if (s.D > 0) {
            int[] factor = new int[s.N.length];
            int i = 0;
            while (i < s.N.length) {
                factor[i] = 1;
                int j = i + 1;
                while (j < s.N.length) {
                    int n = i;
                    factor[n] = factor[n] * s.extN[j];
                    ++j;
                }
                ++i;
            }
            this.recursiveFftFirstPass(s, factor, 0, 0);
            i = s.N.length - 2;
            while (i >= 0) {
                this.recursiveFftPass(s, factor, i, 0, 0);
                --i;
            }
            s.isReal = false;
            return true;
        }
        return false;
    }

    public boolean inverseFFT(Signal s) {
        if (s.isReal) {
            return false;
        }
        if (s.D == 1) {
            FFT1D fft = new FFT1D(s.N[0]);
            double[] real = new double[s.N[0]];
            double[] imag = new double[s.N[0]];
            int i = 0;
            while (i < s.extN[0] / 2) {
                real[i] = s.array[2 * i];
                imag[i] = s.array[2 * i + 1];
                ++i;
            }
            i = s.extN[0] / 2;
            while (i < s.N[0]) {
                real[i] = real[s.N[0] - i];
                imag[i] = -imag[s.N[0] - i];
                ++i;
            }
            fft.inverse(real, imag, s.N[0], 0);
            i = 0;
            while (i < s.N[0]) {
                s.array[i] = (float)real[i];
                ++i;
            }
            s.isReal = true;
            return true;
        }
        if (s.D == 2) {
            int y;
            int factorY = s.extN[1];
            FFT1D fft = new FFT1D(s.extN[0]);
            double[] real = new double[s.extN[0]];
            double[] imag = new double[s.extN[0]];
            int x = 0;
            while (x < s.extN[1]) {
                y = 0;
                while (y < s.extN[0]) {
                    real[y] = s.array[factorY * y + x];
                    imag[y] = s.array[factorY * y + x + 1];
                    ++y;
                }
                fft.inverse(real, imag, s.extN[0], 0);
                y = 0;
                while (y < s.extN[0]) {
                    s.array[factorY * y + x] = (float)real[y];
                    s.array[factorY * y + x + 1] = (float)imag[y];
                    ++y;
                }
                x += 2;
            }
            fft = new FFT1D(s.N[1]);
            real = new double[s.N[1]];
            imag = new double[s.N[1]];
            y = 0;
            while (y < s.N[0]) {
                int contribY = factorY * y;
                int x2 = 0;
                while (x2 < s.extN[1] / 2) {
                    real[x2] = s.array[2 * x2 + contribY];
                    imag[x2] = s.array[2 * x2 + 1 + contribY];
                    ++x2;
                }
                x2 = s.extN[1] / 2;
                while (x2 < s.N[1]) {
                    real[x2] = real[s.N[1] - x2];
                    imag[x2] = -imag[s.N[1] - x2];
                    ++x2;
                }
                fft.inverse(real, imag, s.N[1], 0);
                x2 = 0;
                while (x2 < s.N[1]) {
                    s.array[x2 + contribY] = (float)real[x2];
                    ++x2;
                }
                ++y;
            }
            s.isReal = true;
            return true;
        }
        if (s.D == 3) {
            int y;
            int contribZ;
            int z;
            int factorZ = s.extN[1] * s.extN[2];
            int factorY = s.extN[2];
            FFT1D fft = new FFT1D(s.extN[0]);
            double[] real = new double[s.extN[0]];
            double[] imag = new double[s.extN[0]];
            int y2 = 0;
            while (y2 < s.extN[1]) {
                int contribY = y2 * factorY;
                int x = 0;
                while (x < s.extN[2]) {
                    int contribXY = contribY + x;
                    z = 0;
                    while (z < s.extN[0]) {
                        real[z] = s.array[factorZ * z + contribXY];
                        imag[z] = s.array[factorZ * z + contribXY + 1];
                        ++z;
                    }
                    fft.inverse(real, imag, s.extN[0], 0);
                    z = 0;
                    while (z < s.extN[0]) {
                        s.array[factorZ * z + contribXY] = (float)real[z];
                        s.array[factorZ * z + contribXY + 1] = (float)imag[z];
                        ++z;
                    }
                    x += 2;
                }
                ++y2;
            }
            fft = new FFT1D(s.extN[1]);
            real = new double[s.extN[1]];
            imag = new double[s.extN[1]];
            z = 0;
            while (z < s.extN[0]) {
                contribZ = z * factorZ;
                int x = 0;
                while (x < s.extN[2]) {
                    int contribXZ = contribZ + x;
                    y = 0;
                    while (y < s.extN[1]) {
                        real[y] = s.array[factorY * y + contribXZ];
                        imag[y] = s.array[factorY * y + contribXZ + 1];
                        ++y;
                    }
                    fft.inverse(real, imag, s.extN[1], 0);
                    y = 0;
                    while (y < s.extN[1]) {
                        s.array[factorY * y + contribXZ] = (float)real[y];
                        s.array[factorY * y + contribXZ + 1] = (float)imag[y];
                        ++y;
                    }
                    x += 2;
                }
                ++z;
            }
            fft = new FFT1D(s.N[2]);
            real = new double[s.N[2]];
            imag = new double[s.N[2]];
            int z2 = 0;
            while (z2 < s.N[0]) {
                contribZ = z2 * factorZ;
                y = 0;
                while (y < s.N[1]) {
                    int contribYZ = factorY * y + contribZ;
                    int x = 0;
                    while (x < s.extN[2] / 2) {
                        real[x] = s.array[2 * x + contribYZ];
                        imag[x] = s.array[2 * x + 1 + contribYZ];
                        ++x;
                    }
                    x = s.extN[2] / 2;
                    while (x < s.N[2]) {
                        real[x] = real[s.N[2] - x];
                        imag[x] = -imag[s.N[2] - x];
                        ++x;
                    }
                    fft.inverse(real, imag, s.N[2], 0);
                    x = 0;
                    while (x < s.N[2]) {
                        s.array[x + contribYZ] = (float)real[x];
                        ++x;
                    }
                    ++y;
                }
                ++z2;
            }
            s.isReal = true;
            return true;
        }
        if (s.D > 0) {
            int[] factor = new int[s.N.length];
            int i = 0;
            while (i < s.N.length) {
                factor[i] = 1;
                int j = i + 1;
                while (j < s.N.length) {
                    int n = i;
                    factor[n] = factor[n] * s.extN[j];
                    ++j;
                }
                ++i;
            }
            i = 0;
            while (i < s.N.length - 1) {
                this.recursiveInverseFftPass(s, factor, i, 0, 0);
                ++i;
            }
            this.recursiveInverseFftLastPass(s, factor, 0, 0);
            s.isReal = true;
            return true;
        }
        return false;
    }

    private void recursiveFftFirstPass(Signal s, int[] factor, int offset, int currentDim) {
        int nextDim = currentDim + 1;
        if (currentDim < s.N.length - 1) {
            int i = 0;
            while (i < s.N[currentDim]) {
                int offsetModified = offset + factor[currentDim] * i;
                this.recursiveFftFirstPass(s, factor, offsetModified, nextDim);
                ++i;
            }
        } else {
            FFT1D fft = new FFT1D(s.N[currentDim]);
            double[] real = new double[s.N[currentDim]];
            double[] imag = new double[s.N[currentDim]];
            int x = 0;
            while (x < s.N[currentDim]) {
                real[x] = s.array[x + offset];
                imag[x] = 0.0;
                ++x;
            }
            fft.transform(real, imag, s.N[currentDim], 0);
            x = 0;
            while (x < s.extN[currentDim]) {
                s.array[x + offset] = (float)real[x / 2];
                s.array[x + 1 + offset] = (float)imag[x / 2];
                x += 2;
            }
        }
    }

    private void recursiveFftPass(Signal s, int[] factor, int passDim, int offset, int currentDim) {
        int nextDim = currentDim + 1;
        if (currentDim == passDim) {
            this.recursiveFftPass(s, factor, passDim, offset, nextDim);
        } else if (currentDim < s.N.length - 1) {
            int i = 0;
            while (i < s.extN[currentDim]) {
                int offsetModified = offset + factor[currentDim] * i;
                this.recursiveFftPass(s, factor, passDim, offsetModified, nextDim);
                ++i;
            }
        } else {
            FFT1D fft = new FFT1D(s.extN[passDim]);
            double[] real = new double[s.extN[passDim]];
            double[] imag = new double[s.extN[passDim]];
            int x = 0;
            while (x < s.extN[s.N.length - 1]) {
                int totalOffset = offset + x;
                int i = 0;
                while (i < s.extN[passDim]) {
                    real[i] = s.array[factor[passDim] * i + totalOffset];
                    imag[i] = s.array[factor[passDim] * i + totalOffset + 1];
                    ++i;
                }
                fft.transform(real, imag, s.extN[passDim], 0);
                i = 0;
                while (i < s.extN[passDim]) {
                    s.array[factor[passDim] * i + totalOffset] = (float)real[i];
                    s.array[factor[passDim] * i + totalOffset + 1] = (float)imag[i];
                    ++i;
                }
                x += 2;
            }
        }
    }

    private void recursiveInverseFftLastPass(Signal s, int[] factor, int offset, int currentDim) {
        int nextDim = currentDim + 1;
        if (currentDim < s.N.length - 1) {
            int i = 0;
            while (i < s.N[currentDim]) {
                int offsetModified = offset + factor[currentDim] * i;
                this.recursiveInverseFftLastPass(s, factor, offsetModified, nextDim);
                ++i;
            }
        } else {
            FFT1D fft = new FFT1D(s.N[currentDim]);
            double[] real = new double[s.N[currentDim]];
            double[] imag = new double[s.N[currentDim]];
            int x = 0;
            while (x < s.extN[currentDim] / 2) {
                real[x] = s.array[2 * x + offset];
                imag[x] = s.array[2 * x + 1 + offset];
                ++x;
            }
            x = s.extN[currentDim] / 2;
            while (x < s.N[currentDim]) {
                real[x] = real[s.N[currentDim] - x];
                imag[x] = -imag[s.N[currentDim] - x];
                ++x;
            }
            fft.inverse(real, imag, s.N[currentDim], 0);
            x = 0;
            while (x < s.N[currentDim]) {
                s.array[x + offset] = (float)real[x];
                ++x;
            }
        }
    }

    private void recursiveInverseFftPass(Signal s, int[] factor, int passDim, int offset, int currentDim) {
        int nextDim = currentDim + 1;
        if (currentDim == passDim) {
            this.recursiveInverseFftPass(s, factor, passDim, offset, nextDim);
        } else if (currentDim < s.N.length - 1) {
            int i = 0;
            while (i < s.extN[currentDim]) {
                int offsetModified = offset + factor[currentDim] * i;
                this.recursiveInverseFftPass(s, factor, passDim, offsetModified, nextDim);
                ++i;
            }
        } else {
            FFT1D fft = new FFT1D(s.extN[passDim]);
            double[] real = new double[s.extN[passDim]];
            double[] imag = new double[s.extN[passDim]];
            int x = 0;
            while (x < s.extN[s.N.length - 1]) {
                int totalOffset = offset + x;
                int i = 0;
                while (i < s.extN[passDim]) {
                    real[i] = s.array[factor[passDim] * i + totalOffset];
                    imag[i] = s.array[factor[passDim] * i + totalOffset + 1];
                    ++i;
                }
                fft.inverse(real, imag, s.extN[passDim], 0);
                i = 0;
                while (i < s.extN[passDim]) {
                    s.array[factor[passDim] * i + totalOffset] = (float)real[i];
                    s.array[factor[passDim] * i + totalOffset + 1] = (float)imag[i];
                    ++i;
                }
                x += 2;
            }
        }
    }
}

