/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.ImagePlus;
import ij.io.FileSaver;
import java.io.File;
import java.util.Arrays;
import java.util.Random;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxWavelet;
import toolbox.random.Poisson;

public class ToolboxSignal {
    public static boolean multiply(Signal s1, Signal s2) {
        if (ToolboxSignal.checkCompatibility(s1, s2)) {
            if (s1.isReal) {
                int i = 0;
                while (i < s1.extLength) {
                    int n = i;
                    s1.array[n] = s1.array[n] * s2.array[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < s1.extLength / 2) {
                    float temp1 = s1.array[2 * i];
                    float temp2 = s2.array[2 * i];
                    s1.array[2 * i] = temp1 * temp2 - s1.array[2 * i + 1] * s2.array[2 * i + 1];
                    s1.array[2 * i + 1] = temp1 * s2.array[2 * i + 1] + s1.array[2 * i + 1] * temp2;
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean filterBy2D(Signal s, Signal filter, ToolboxFourier fftTB) {
        if (s == null || filter == null || s.D != 3 && s.D != 2 || filter.D != 2) {
            return false;
        }
        if (filter.isReal) {
            return false;
        }
        boolean was_real = s.isReal;
        if (s.D == 3) {
            Signal slice = new Signal(filter.N);
            int i = 0;
            while (i < s.N[0]) {
                if (!ToolboxSignal.getSlice(s, i, slice)) {
                    return false;
                }
                if (slice.isReal) {
                    fftTB.forwardDFT(slice);
                }
                ToolboxSignal.multiply(slice, filter);
                if (was_real) {
                    fftTB.inverseDFT(slice);
                }
                if (!ToolboxSignal.putSlice(s, i, slice)) {
                    return false;
                }
                ++i;
            }
        } else if (s.D == 2) {
            if (s.isReal) {
                fftTB.forwardDFT(s);
            }
            ToolboxSignal.multiply(s, filter);
            if (was_real) {
                fftTB.inverseDFT(s);
            }
        }
        return true;
    }

    public static boolean multiplyConj(Signal s1, Signal s2) {
        if (!s1.isReal && ToolboxSignal.checkCompatibility(s1, s2)) {
            int i = 0;
            while (i < s1.extLength / 2) {
                float temp1 = s1.array[2 * i];
                float temp2 = s2.array[2 * i];
                s1.array[2 * i] = temp1 * temp2 + s1.array[2 * i + 1] * s2.array[2 * i + 1];
                s1.array[2 * i + 1] = -temp1 * s2.array[2 * i + 1] + s1.array[2 * i + 1] * temp2;
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean add(Signal s1, Signal s2) {
        if (ToolboxSignal.checkCompatibility(s1, s2)) {
            int i = 0;
            while (i < s1.extLength) {
                int n = i;
                s1.array[n] = s1.array[n] + s2.array[i];
                ++i;
            }
            return true;
        }
        return false;
    }

    public static boolean addAbs(Signal s1, Signal s2) {
        if (ToolboxSignal.checkCompatibility(s1, s2)) {
            int i = 0;
            while (i < s1.extLength) {
                int n = i;
                s1.array[n] = s1.array[n] + Math.abs(s2.array[i]);
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void divideStable(Signal s1, Signal s2, float threshold) {
        if (s1.isReal) {
            int i = 0;
            while (i < s1.extLength) {
                if (s2.array[i] < threshold) {
                    s1.array[i] = 0.0f;
                } else {
                    int n = i;
                    s1.array[n] = s1.array[n] / s2.array[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < s1.extLength / 2) {
                float module = s2.array[2 * i] * s2.array[2 * i] + s2.array[2 * i + 1] * s2.array[2 * i + 1];
                if (Math.sqrt(module) < (double)threshold) {
                    s1.array[2 * i] = 0.0f;
                    s1.array[2 * i + 1] = 0.0f;
                } else {
                    float temp = s1.array[2 * i];
                    s1.array[2 * i] = (s1.array[2 * i] * s2.array[2 * i] + s1.array[2 * i + 1] * s2.array[2 * i + 1]) / module;
                    s1.array[2 * i + 1] = (s1.array[2 * i + 1] * s2.array[2 * i] - temp * s2.array[2 * i + 1]) / module;
                }
                ++i;
            }
        }
    }

    public static boolean divideStable2(Signal s1, Signal s2, float threshold) {
        if (ToolboxSignal.checkCompatibility(s1, s2)) {
            if (s1.isReal) {
                int i = 0;
                while (i < s1.extLength) {
                    s2.array[i] = s2.array[i] < threshold ? 0.0f : s1.array[i] / s2.array[i];
                    ++i;
                }
            } else {
                int i = 0;
                while (i < s1.extLength / 2) {
                    float module2 = s2.array[2 * i] * s2.array[2 * i] + s2.array[2 * i + 1] * s2.array[2 * i + 1];
                    if (Math.sqrt(module2) < (double)threshold) {
                        s2.array[2 * i] = 0.0f;
                        s2.array[2 * i + 1] = 0.0f;
                    } else {
                        float temp = s2.array[2 * i];
                        s2.array[2 * i] = (s1.array[2 * i] * s2.array[2 * i] + s1.array[2 * i + 1] * s2.array[2 * i + 1]) / module2;
                        s2.array[2 * i + 1] = (s1.array[2 * i + 1] * temp - s1.array[2 * i] * s2.array[2 * i + 1]) / module2;
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    public static boolean checkCompatibility(Signal s1, Signal s2) {
        if (s1.D != s2.D) {
            return false;
        }
        if (s1.isReal != s2.isReal) {
            return false;
        }
        if (s1.length != s2.length) {
            return false;
        }
        if (s1.extLength != s2.extLength) {
            return false;
        }
        int d = 0;
        while (d < s1.D) {
            if (s1.N[d] != s2.N[d]) {
                return false;
            }
            ++d;
        }
        d = 0;
        while (d < s1.D) {
            if (s1.extN[d] != s2.extN[d]) {
                return false;
            }
            ++d;
        }
        return true;
    }

    public static boolean setRealPixel(Signal s, int[] pos, float value) {
        if (!s.isReal || pos.length != s.N.length) {
            return false;
        }
        int position = ToolboxSignal.getPositionReal(pos, s);
        s.array[position] = value;
        return true;
    }

    public static float getRealPixel(Signal s, int[] pos) {
        if (!s.isReal || pos.length != s.N.length) {
            return 0.0f;
        }
        return s.array[ToolboxSignal.getPositionReal(pos, s)];
    }

    public static boolean getComplexPixel(Signal s, int[] pos, int[] factor, float[] result) {
        if (s == null || pos == null || factor == null || result == null) {
            return false;
        }
        if (s.isReal || pos.length != s.D || factor.length != s.D || result.length < 2) {
            return false;
        }
        int[] coord = new int[pos.length];
        int xDim = s.D - 1;
        boolean herm = false;
        int position = 0;
        int i = 0;
        while (i < coord.length) {
            coord[i] = pos[i] % s.N[i];
            ++i;
        }
        i = 0;
        while (i < coord.length) {
            if (coord[i] > 0) {
                int n = i;
                coord[n] = coord[n] - s.N[i];
            }
            ++i;
        }
        if (coord[xDim] <= -s.extN[xDim] / 2) {
            i = 0;
            while (i < coord.length) {
                int n = i;
                coord[n] = coord[n] + s.N[i];
                ++i;
            }
        } else {
            i = 0;
            while (i < coord.length) {
                coord[i] = -coord[i];
                ++i;
            }
            herm = true;
        }
        int n = xDim;
        coord[n] = coord[n] * 2;
        i = 0;
        while (i < coord.length) {
            position += coord[i] * factor[i];
            ++i;
        }
        result[0] = s.array[position];
        result[1] = (herm ? -1.0f : 1.0f) * s.array[position + 1];
        return true;
    }

    public static boolean resizePSF(int[] dim, Signal s) {
        if (!s.isReal) {
            return false;
        }
        if (dim.length != s.N.length) {
            return false;
        }
        int i = 0;
        while (i < dim.length) {
            if (s.N[i] > dim[i]) {
                return false;
            }
            ++i;
        }
        Signal signalOld = new Signal(s.N);
        signalOld.array = s.array;
        signalOld.N = s.N;
        signalOld.extN = s.extN;
        signalOld.length = s.length;
        signalOld.extLength = s.extLength;
        signalOld.isReal = true;
        signalOld.D = s.D;
        Signal dummySignal = new Signal(dim);
        s.array = dummySignal.array;
        s.N = dummySignal.N;
        s.extN = dummySignal.extN;
        s.length = dummySignal.length;
        s.extLength = dummySignal.extLength;
        s.isReal = true;
        s.D = dummySignal.D;
        dummySignal = null;
        int[] factorOld = new int[dim.length];
        int[] factorNew = new int[dim.length];
        int i2 = 0;
        while (i2 < dim.length) {
            factorOld[i2] = 1;
            factorNew[i2] = 1;
            int j = i2 + 1;
            while (j < dim.length) {
                int n = i2;
                factorOld[n] = factorOld[n] * signalOld.extN[j];
                int n2 = i2;
                factorNew[n2] = factorNew[n2] * s.extN[j];
                ++j;
            }
            ++i2;
        }
        ToolboxSignal.resizePSFRecursive(signalOld, s, 0, 0, factorOld, factorNew, 0);
        return true;
    }

    private static int getPositionReal(int[] coord, Signal s) {
        int position = 0;
        int factor = 1;
        int i = 0;
        while (i < coord.length) {
            int temp = coord[i];
            if ((temp %= s.N[i]) < 0) {
                temp += s.N[i];
            }
            factor = 1;
            int j = i + 1;
            while (j < coord.length) {
                factor *= s.extN[j];
                ++j;
            }
            position += temp * factor;
            ++i;
        }
        return position;
    }

    private static int getPosition(int[] coord, int[] factor, Signal s) {
        int position = 0;
        int i = 0;
        while (i < coord.length) {
            int temp = coord[i];
            if (s.isReal) {
                if ((temp %= s.N[i]) < 0) {
                    temp += s.N[i];
                }
            } else if ((temp %= s.extN[i]) < 0) {
                temp += s.extN[i];
            }
            position += temp * factor[i];
            ++i;
        }
        return position;
    }

    public static void save(Signal s, String path, String filename) {
        ImagePlus imp = s.get_image("");
        FileSaver fs = new FileSaver(imp);
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdir();
        }
        if (s.D == 2) {
            fs.saveAsTiff(String.valueOf(path) + filename + ".tif");
        } else if (s.D == 3) {
            fs.saveAsTiffStack(String.valueOf(path) + filename + ".tif");
        }
        fs = null;
        imp = null;
    }

    public static void module2(Signal s) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                s.array[i] = s.array[i] * s.array[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < s.extLength / 2) {
                s.array[2 * i] = s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1];
                s.array[2 * i + 1] = 0.0f;
                ++i;
            }
        }
    }

    public static double sumDouble(Signal s) {
        float sum = 0.0f;
        if (s.isReal) {
            int lengthX = s.N[s.N.length - 1];
            int extendedLengthX = s.extN[s.extN.length - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    sum = (float)((double)sum + (double)s.array[i]);
                }
                ++i;
            }
        } else {
            int lengthX = s.extN[s.extN.length - 1] / 2;
            int i = 0;
            while (i < s.extLength / 2) {
                sum = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (float)((double)sum + 2.0 * Math.sqrt((double)s.array[2 * i] * (double)s.array[2 * i] + (double)s.array[2 * i + 1] * (double)s.array[2 * i + 1])) : (float)((double)sum + Math.sqrt((double)s.array[2 * i] * (double)s.array[2 * i] + (double)s.array[2 * i + 1] * (double)s.array[2 * i + 1]));
                ++i;
            }
        }
        return sum;
    }

    public static float sum(Signal s) {
        float sum = 0.0f;
        if (s.isReal) {
            int lengthX = s.N[s.N.length - 1];
            int extendedLengthX = s.extN[s.extN.length - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    sum += s.array[i];
                }
                ++i;
            }
        } else {
            int lengthX = s.extN[s.extN.length - 1] / 2;
            int i = 0;
            while (i < s.extLength / 2) {
                sum = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (sum += 2.0f * (float)Math.sqrt(s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1])) : (sum += (float)Math.sqrt(s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1]));
                ++i;
            }
        }
        return sum;
    }

    public static double sumAbs(Signal s) {
        double sum = 0.0;
        if (s.isReal) {
            int lengthX = s.N[s.N.length - 1];
            int extendedLengthX = s.extN[s.extN.length - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    sum += (double)Math.abs(s.array[i]);
                }
                ++i;
            }
        } else {
            int lengthX = s.extN[s.extN.length - 1] / 2;
            int i = 0;
            while (i < s.extLength / 2) {
                sum = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (sum += (double)(2.0f * (float)Math.sqrt(s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1]))) : (sum += (double)((float)Math.sqrt(s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1])));
                ++i;
            }
        }
        return sum;
    }

    public static double norm2(Signal s) {
        double norm2 = 0.0;
        if (s.isReal) {
            int extendedLengthX = s.extN[s.D - 1];
            int lengthX = s.N[s.D - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    norm2 += (double)(s.array[i] * s.array[i]);
                }
                ++i;
            }
        } else {
            int lengthX = s.extN[s.D - 1] / 2;
            int i = 0;
            while (i < s.extLength / 2) {
                norm2 = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (norm2 += (double)(2.0f * (s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1]))) : (norm2 += (double)(s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1]));
                ++i;
            }
        }
        return norm2;
    }

    public static float l1Norm(Signal s) {
        float norm = 0.0f;
        if (s.isReal) {
            int lengthX = s.N[s.D - 1];
            int extendedLengthX = s.extN[s.D - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    norm += Math.abs(s.array[i]);
                }
                ++i;
            }
            return norm;
        }
        return -1.0f;
    }

    public static double norm2Difference(Signal s1, Signal s2) {
        if (!ToolboxSignal.checkCompatibility(s1, s2)) {
            return -1.0;
        }
        double result = 0.0;
        if (s1.isReal) {
            int lengthX = s1.N[s1.N.length - 1];
            int extendedLengthX = s1.extN[s1.extN.length - 1];
            int i = 0;
            while (i < s1.extLength) {
                if (i % extendedLengthX < lengthX) {
                    float temp = s1.array[i] - s2.array[i];
                    result += (double)(temp * temp);
                }
                ++i;
            }
        } else {
            int lengthX = s1.extN[s1.extN.length - 1] / 2;
            int i = 0;
            while (i < s1.extLength / 2) {
                float temp1 = s1.array[2 * i] - s2.array[2 * i];
                float temp2 = s1.array[2 * i + 1] - s2.array[2 * i + 1];
                result = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (result += (double)(2.0f * (temp1 * temp1 + temp2 * temp2))) : (result += (double)(temp1 * temp1 + temp2 * temp2));
                ++i;
            }
        }
        return result;
    }

    public static double norm2DifferenceDouble(Signal s1, Signal s2) {
        if (!ToolboxSignal.checkCompatibility(s1, s2)) {
            return -1.0;
        }
        double result = 0.0;
        if (s1.isReal) {
            int lengthX = s1.N[s1.N.length - 1];
            int extendedLengthX = s1.extN[s1.extN.length - 1];
            int i = 0;
            while (i < s1.extLength) {
                if (i % extendedLengthX < lengthX) {
                    double temp = (double)s1.array[i] - (double)s2.array[i];
                    result += temp * temp;
                }
                ++i;
            }
        } else {
            int lengthX = s1.extN[s1.extN.length - 1] / 2;
            int i = 0;
            while (i < s1.extLength / 2) {
                double real = (double)s1.array[2 * i] - (double)s2.array[2 * i];
                double imag = (double)s1.array[2 * i + 1] - (double)s2.array[2 * i + 1];
                result = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (result += 2.0 * (real * real + imag * imag)) : (result += real * real + imag * imag);
                ++i;
            }
        }
        return result;
    }

    public static float norm2Difference(Signal s, float c) {
        float result = 0.0f;
        if (s.isReal) {
            int lengthX = s.N[s.D - 1];
            int extendedLengthX = s.extN[s.D - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % extendedLengthX < lengthX) {
                    result += (s.array[i] - c) * (s.array[i] - c);
                }
                ++i;
            }
        } else {
            int lengthX = s.extN[s.D - 1] / 2;
            result = (s.array[0] - c * (float)s.length) * (s.array[0] - c * (float)s.length) + s.array[1] * s.array[1];
            int i = 1;
            while (i < s.extLength / 2) {
                result = (lengthX % 2 == 0 || i % lengthX != lengthX - 1) && i % lengthX != 0 ? (result += 2.0f * (s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1])) : (result += s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1]);
                ++i;
            }
        }
        return result;
    }

    public static float calculateSER(Signal approx, Signal ref) {
        return (float)(10.0 * Math.log(ToolboxSignal.norm2(ref) / ToolboxSignal.norm2Difference(approx, ref)) / Math.log(10.0));
    }

    private static void resizePSFRecursive(Signal signalOld, Signal signalNew, int offsetOld, int offsetNew, int[] factorOld, int[] factorNew, int currentDim) {
        int nextDim = currentDim + 1;
        int half1 = (signalOld.N[currentDim] + 1) / 2;
        int half2 = signalOld.N[currentDim] / 2;
        int offset = signalNew.N[currentDim] - signalOld.N[currentDim];
        if (currentDim < signalOld.N.length - 1) {
            int offsetNewModified;
            int offsetOldModified;
            int i = 0;
            while (i < half1) {
                offsetOldModified = offsetOld + factorOld[currentDim] * i;
                offsetNewModified = offsetNew + factorNew[currentDim] * i;
                ToolboxSignal.resizePSFRecursive(signalOld, signalNew, offsetOldModified, offsetNewModified, factorOld, factorNew, nextDim);
                ++i;
            }
            i = half1;
            while (i < signalOld.N[currentDim]) {
                offsetOldModified = offsetOld + factorOld[currentDim] * i;
                offsetNewModified = offsetNew + factorNew[currentDim] * (offset + i);
                ToolboxSignal.resizePSFRecursive(signalOld, signalNew, offsetOldModified, offsetNewModified, factorOld, factorNew, nextDim);
                ++i;
            }
        } else {
            System.arraycopy(signalOld.array, offsetOld, signalNew.array, offsetNew, half1);
            System.arraycopy(signalOld.array, offsetOld + half1, signalNew.array, offsetNew + offset + half1, half2);
        }
    }

    public static void conjugate(Signal s) {
        if (!s.isReal) {
            int i = 1;
            while (i < s.extLength) {
                s.array[i] = -s.array[i];
                i += 2;
            }
        }
    }

    public static void multiplyConstant(Signal s, float p) {
        int i = 0;
        while (i < s.extLength) {
            int n = i++;
            s.array[n] = s.array[n] * p;
        }
    }

    public static boolean subtract(Signal s1, Signal s2) {
        if (ToolboxSignal.checkCompatibility(s1, s2)) {
            int i = 0;
            while (i < s1.extLength) {
                int n = i;
                s1.array[n] = s1.array[n] - s2.array[i];
                ++i;
            }
            return true;
        }
        return false;
    }

    public static void subtract(float c, Signal s) {
        int i = 0;
        while (i < s.extLength) {
            s.array[i] = c - s.array[i];
            ++i;
        }
    }

    public static void identity(Signal s) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                s.array[i] = 1.0f;
                ++i;
            }
        } else {
            int i = 0;
            while (i < s.extLength) {
                s.array[i] = 1.0f;
                s.array[i + 1] = 0.0f;
                i += 2;
            }
        }
    }

    public static boolean laplacianApprox2D3D(Signal s) {
        s.isReal = false;
        if (s.D == 2) {
            float fStepX = (float)Math.PI * 2 / (float)s.N[1];
            float fStepY = (float)Math.PI * 2 / (float)s.N[0];
            int y = 0;
            while (y < s.extN[0]) {
                float wy = fStepY * (float)y;
                int contribY = y * s.extN[1];
                int x = 0;
                while (x < s.extN[1] / 2) {
                    if (y < s.N[0] / 2 + 1) {
                        float wx = fStepX * (float)x;
                        s.array[contribY + 2 * x] = wx * wx + wy * wy;
                    } else {
                        s.array[contribY + 2 * x] = s.array[(s.N[0] - y) * s.extN[1] + 2 * x];
                    }
                    s.array[contribY + 2 * x + 1] = 0.0f;
                    ++x;
                }
                ++y;
            }
            return true;
        }
        if (s.D == 3) {
            float fStepX = (float)Math.PI * 2 / (float)s.N[2];
            float fStepY = (float)Math.PI * 2 / (float)s.N[1];
            float fStepZ = (float)Math.PI * 2 / (float)s.N[0];
            int sliceArea = s.extN[1] * s.extN[2];
            int z = 0;
            while (z < s.extN[0]) {
                float wz = fStepZ * (float)z;
                int contribZ = sliceArea * z;
                int y = 0;
                while (y < s.extN[1]) {
                    float wy = fStepY * (float)y;
                    int contribYZ = y * s.extN[2] + contribZ;
                    int x = 0;
                    while (x < s.extN[2] / 2) {
                        if (z < s.N[0] / 2 + 1 && y < s.N[1] / 2 + 1) {
                            float wx = fStepX * (float)x;
                            s.array[contribYZ + 2 * x] = wx * wx + wy * wy + wz * wz;
                        } else {
                            s.array[contribYZ + 2 * x] = z < s.N[0] / 2 + 1 && y >= s.N[1] / 2 + 1 ? s.array[z * sliceArea + (s.N[1] - y) * s.extN[2] + 2 * x] : (z >= s.N[0] / 2 + 1 && y < s.N[1] / 2 + 1 ? s.array[(s.N[0] - z) * sliceArea + y * s.extN[2] + 2 * x] : s.array[(s.N[0] - z) * sliceArea + (s.N[1] - y) * s.extN[2] + 2 * x]);
                        }
                        s.array[contribYZ + 2 * x + 1] = 0.0f;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            return true;
        }
        return false;
    }

    public static boolean laplacian2D3D(Signal s) {
        s.isReal = false;
        if (s.D == 2) {
            float fStepX = (float)Math.PI * 2 / (float)s.N[1];
            float fStepY = (float)Math.PI * 2 / (float)s.N[0];
            int y = 0;
            while (y < s.extN[0]) {
                float contribY = 2.0f * (float)Math.cos(fStepY * (float)y);
                int offsetY = y * s.extN[1];
                int x = 0;
                while (x < s.extN[1] / 2) {
                    s.array[offsetY + 2 * x] = 2.0f * (float)Math.cos(fStepX * (float)x) + contribY - 4.0f;
                    s.array[offsetY + 2 * x + 1] = 0.0f;
                    ++x;
                }
                ++y;
            }
            return true;
        }
        if (s.D == 3) {
            float fStepX = (float)Math.PI * 2 / (float)s.N[2];
            float fStepY = (float)Math.PI * 2 / (float)s.N[1];
            float fStepZ = (float)Math.PI * 2 / (float)s.N[0];
            int sliceArea = s.extN[1] * s.extN[2];
            int z = 0;
            while (z < s.extN[0]) {
                float contribZ = 2.0f * (float)Math.cos(fStepZ * (float)z);
                int offsetZ = sliceArea * z;
                int y = 0;
                while (y < s.extN[1]) {
                    float contribYZ = 2.0f * (float)Math.cos(fStepY * (float)y) + contribZ;
                    int offsetYZ = y * s.extN[2] + offsetZ;
                    int x = 0;
                    while (x < s.extN[2] / 2) {
                        s.array[offsetYZ + 2 * x] = 2.0f * (float)Math.cos(fStepX * (float)x) + contribYZ - 6.0f;
                        s.array[offsetYZ + 2 * x + 1] = 0.0f;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            return true;
        }
        return false;
    }

    public static void addLaplacianSquare2D3D(Signal s, float lambda) {
        block7: {
            block6: {
                if (s == null || s.isReal) {
                    return;
                }
                if (s.D != 2) break block6;
                float fStepX = (float)Math.PI * 2 / (float)s.N[1];
                float fStepY = (float)Math.PI * 2 / (float)s.N[0];
                int y = 0;
                while (y < s.extN[0]) {
                    float contribY = 2.0f * (float)Math.cos(fStepY * (float)y);
                    int offsetY = y * s.extN[1];
                    int x = 0;
                    while (x < s.extN[1] / 2) {
                        int n = offsetY + 2 * x;
                        s.array[n] = s.array[n] + lambda * (float)Math.pow(2.0 * Math.cos(fStepX * (float)x) + (double)contribY - 4.0, 2.0);
                        ++x;
                    }
                    ++y;
                }
                break block7;
            }
            if (s.D != 3) break block7;
            float fStepX = (float)Math.PI * 2 / (float)s.N[2];
            float fStepY = (float)Math.PI * 2 / (float)s.N[1];
            float fStepZ = (float)Math.PI * 2 / (float)s.N[0];
            int sliceArea = s.extN[1] * s.extN[2];
            int z = 0;
            while (z < s.extN[0]) {
                float contribZ = -2.0f * (float)Math.cos(fStepZ * (float)z);
                int offsetZ = sliceArea * z;
                int y = 0;
                while (y < s.extN[1]) {
                    float contribYZ = -2.0f * (float)Math.cos(fStepY * (float)y) + contribZ;
                    int offsetYZ = y * s.extN[2] + offsetZ;
                    int x = 0;
                    while (x < s.extN[2] / 2) {
                        int n = offsetYZ + 2 * x;
                        s.array[n] = s.array[n] + lambda * (-2.0f * (float)Math.cos(fStepX * (float)x) + contribYZ + 6.0f);
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
    }

    public static void multiplyWithLaplacian2D3D(Signal s) {
        block7: {
            block6: {
                if (s == null || s.isReal) {
                    return;
                }
                if (s.D != 2) break block6;
                float fStepX = (float)Math.PI * 2 / (float)s.N[1];
                float fStepY = (float)Math.PI * 2 / (float)s.N[0];
                int y = 0;
                while (y < s.extN[0]) {
                    float contribY = 2.0f * (float)Math.cos(fStepY * (float)y);
                    int offsetY = y * s.extN[1];
                    int x = 0;
                    while (x < s.extN[1] / 2) {
                        float factor = 2.0f * (float)Math.cos(fStepX * (float)x) + contribY - 4.0f;
                        int n = offsetY + 2 * x;
                        s.array[n] = s.array[n] * factor;
                        int n2 = offsetY + 2 * x + 1;
                        s.array[n2] = s.array[n2] * factor;
                        ++x;
                    }
                    ++y;
                }
                break block7;
            }
            if (s.D != 3) break block7;
            float fStepX = (float)Math.PI * 2 / (float)s.N[2];
            float fStepY = (float)Math.PI * 2 / (float)s.N[1];
            float fStepZ = (float)Math.PI * 2 / (float)s.N[0];
            int sliceArea = s.extN[1] * s.extN[2];
            int z = 0;
            while (z < s.extN[0]) {
                float contribZ = 2.0f * (float)Math.cos(fStepZ * (float)z);
                int offsetZ = sliceArea * z;
                int y = 0;
                while (y < s.extN[1]) {
                    float contribYZ = 2.0f * (float)Math.cos(fStepY * (float)y) + contribZ;
                    int offsetYZ = y * s.extN[2] + offsetZ;
                    int x = 0;
                    while (x < s.extN[2] / 2) {
                        float factor = 2.0f * (float)Math.cos(fStepX * (float)x) + contribYZ - 6.0f;
                        int n = offsetYZ + 2 * x;
                        s.array[n] = s.array[n] * factor;
                        int n3 = offsetYZ + 2 * x + 1;
                        s.array[n3] = s.array[n3] * factor;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
    }

    public static boolean clipBelow(Signal s, float min) {
        boolean changed = false;
        int i = 0;
        while (i < s.extLength) {
            if (s.array[i] < min) {
                s.array[i] = min;
                changed = true;
            }
            ++i;
        }
        return changed;
    }

    public static void threshold(Signal s, float inferiorLimit, float superiorLimit) {
        if (s == null) {
            return;
        }
        int i = 0;
        while (i < s.extLength) {
            if (s.array[i] > inferiorLimit && s.array[i] < superiorLimit) {
                s.array[i] = 0.0f;
            }
            ++i;
        }
    }

    public static void softThreshold(Signal s, float theta) {
        if (s == null) {
            return;
        }
        theta = Math.abs(theta);
        int i = 0;
        while (i < s.extLength) {
            s.array[i] = s.array[i] > theta ? s.array[i] - theta : (s.array[i] < theta ? s.array[i] + theta : 0.0f);
            ++i;
        }
    }

    public static void transfer(Signal s1, Signal s2) {
        if (s1 != null && s2 != null) {
            s1.D = s2.D;
            s1.isReal = s2.isReal;
            s1.array = s2.array;
            s1.N = s2.N;
            s1.extN = s2.extN;
            s1.length = s2.length;
            s1.extLength = s2.extLength;
        }
    }

    public static boolean copy(Signal s1, Signal s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        s1.isReal = s2.isReal;
        if (!ToolboxSignal.checkCompatibility(s1, s2)) {
            return false;
        }
        int i = 0;
        while (i < s1.extLength) {
            s1.array[i] = s2.array[i];
            ++i;
        }
        return true;
    }

    public static void minConstraint(Signal s, float min, boolean saveMemory, ToolboxFourier sFft) {
        if (!s.isReal && !saveMemory) {
            Signal newS = (Signal)s.clone();
            sFft.inverseDFT(newS);
            if (ToolboxSignal.clipBelow(newS, 0.0f)) {
                ToolboxSignal.transfer(s, newS);
                newS = null;
                sFft.forwardDFT(s);
            }
        } else if (!s.isReal && saveMemory) {
            sFft.inverseDFT(s);
            ToolboxSignal.clipBelow(s, 0.0f);
            sFft.forwardDFT(s);
        } else if (s.isReal) {
            ToolboxSignal.clipBelow(s, 0.0f);
        }
    }

    public static void addConstant(Signal s, float real, float imag) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                int n = i++;
                s.array[n] = s.array[n] + real;
            }
        } else {
            int i = 0;
            while (i < s.extLength) {
                int n = i;
                s.array[n] = s.array[n] + real;
                int n2 = i + 1;
                s.array[n2] = s.array[n2] + imag;
                i += 2;
            }
        }
    }

    public static float minimum(Signal s) {
        float min = 1.0E20f;
        if (s.isReal) {
            int lengthX = s.N[s.D - 1];
            int eLengthX = s.extN[s.D - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % eLengthX < lengthX && s.array[i] < min) {
                    min = s.array[i];
                }
                ++i;
            }
            return min;
        }
        int i = 0;
        while (i < s.extLength) {
            float temp = s.array[i] * s.array[i] + s.array[i + 1] * s.array[i + 1];
            if (temp < min) {
                min = temp;
            }
            i += 2;
        }
        return (float)Math.sqrt(min);
    }

    public static float maximum(Signal s) {
        float max = -1.0E20f;
        if (s.isReal) {
            int lengthX = s.N[s.D - 1];
            int eLengthX = s.extN[s.D - 1];
            int i = 0;
            while (i < s.extLength) {
                if (i % eLengthX < lengthX && s.array[i] > max) {
                    max = s.array[i];
                }
                ++i;
            }
            return max;
        }
        int i = 0;
        while (i < s.extLength) {
            float temp = s.array[i] * s.array[i] + s.array[i + 1] * s.array[i + 1];
            if (temp > max) {
                max = temp;
            }
            i += 2;
        }
        return (float)Math.sqrt(max);
    }

    public static void pow(Signal s, float power) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                s.array[i] = (float)Math.pow(s.array[i], power);
                ++i;
            }
        } else {
            int i = 0;
            while (i < s.extLength) {
                float module = (float)Math.pow(Math.sqrt(s.array[i] * s.array[i] + s.array[i + 1] * s.array[i + 1]), power);
                float phase = power * (float)Math.atan2(s.array[i + 1], s.array[i]);
                s.array[i] = (float)Math.cos(phase) * module;
                s.array[i + 1] = (float)Math.sin(phase) * module;
                i += 2;
            }
        }
    }

    public static void pow(Signal s, int power) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                float temp = s.array[i];
                int j = 0;
                while (j < power - 1) {
                    int n = i;
                    s.array[n] = s.array[n] * temp;
                    ++j;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < s.extLength) {
                float tempReal = s.array[i];
                float tempImag = s.array[i + 1];
                int j = 0;
                while (j < power - 1) {
                    float temp = s.array[i];
                    s.array[i] = s.array[i] * tempReal - s.array[i + 1] * tempImag;
                    s.array[i + 1] = s.array[i + 1] * tempReal + temp * tempImag;
                    ++j;
                }
                i += 2;
            }
        }
    }

    public static boolean fftShift(Signal s, int[] shift) {
        if (s.D != shift.length || !s.isReal) {
            return false;
        }
        int i = 0;
        while (i < shift.length) {
            ToolboxSignal.fftShift1D(s, i, shift[i]);
            ++i;
        }
        return true;
    }

    public static void fftShift1D(Signal s, int dimension, int shift) {
        if (dimension >= s.D || !s.isReal) {
            return;
        }
        int[] coord = new int[s.D];
        ToolboxSignal.recursiveFftShift1D(s, dimension, shift, 0, coord);
    }

    private static void recursiveFftShift1D(Signal s, int dimension, int shift, int currentDimension, int[] coord) {
        block6: {
            block5: {
                if (currentDimension >= s.D || currentDimension < 0) break block5;
                if (currentDimension == dimension) {
                    ToolboxSignal.recursiveFftShift1D(s, dimension, shift, ++currentDimension, coord);
                } else {
                    int newDimension = currentDimension + 1;
                    int i = 0;
                    while (i < s.N[currentDimension]) {
                        coord[currentDimension] = i++;
                        ToolboxSignal.recursiveFftShift1D(s, dimension, shift, newDimension, coord);
                    }
                }
                break block6;
            }
            if (currentDimension != s.D) break block6;
            float[] copy = new float[s.N[dimension]];
            int i = 0;
            while (i < s.N[dimension]) {
                coord[dimension] = i;
                copy[i] = s.array[ToolboxSignal.getPositionReal(coord, s)];
                ++i;
            }
            i = 0;
            while (i < s.N[dimension]) {
                coord[dimension] = i + shift;
                s.array[ToolboxSignal.getPositionReal((int[])coord, (Signal)s)] = copy[i];
                ++i;
            }
        }
    }

    public static void weightBorder(Signal s, float p, int function) {
        if ((double)p > 0.5 || p < 0.0f) {
            return;
        }
        int i = 0;
        while (i < s.D) {
            ToolboxSignal.weightBorder1D(s, i, p, function);
            ++i;
        }
    }

    public static void weightBorder1D(Signal s, int dimension, float p, int function) {
        if (dimension >= s.D || dimension < 0) {
            return;
        }
        int[] factor = new int[s.D];
        ToolboxSignal.calculateFactors(s, factor);
        ToolboxSignal.recursiveWeightBorder1D(s, dimension, p, 0, 0, factor, function);
    }

    private static void recursiveWeightBorder1D(Signal s, int dimension, float p, int currentDimension, int offset, int[] factor, int function) {
        block20: {
            block19: {
                if (currentDimension >= s.D || currentDimension < 0) break block19;
                if (currentDimension == dimension) {
                    ToolboxSignal.recursiveWeightBorder1D(s, dimension, p, ++currentDimension, offset, factor, function);
                } else {
                    int newDimension = currentDimension + 1;
                    int i = 0;
                    while (i < s.N[currentDimension]) {
                        int newOffset = offset + i * factor[currentDimension];
                        ToolboxSignal.recursiveWeightBorder1D(s, dimension, p, newDimension, newOffset, factor, function);
                        ++i;
                    }
                }
                break block20;
            }
            if (currentDimension != s.D) break block20;
            int border1 = (int)((float)s.N[dimension] * p);
            int border2 = s.N[dimension] - border1;
            if (border1 > 1) {
                int i = 0;
                while (i < s.N[dimension]) {
                    int newOffset;
                    if (i < border1) {
                        newOffset = offset + i * factor[dimension];
                        switch (function) {
                            case 0: {
                                s.array[newOffset] = 0.0f;
                                break;
                            }
                            case 1: {
                                int n = newOffset;
                                s.array[n] = (float)((double)s.array[n] * (0.5 * (1.0 - Math.cos((double)i * Math.PI / (double)(border1 - 1)))));
                                break;
                            }
                            case 2: {
                                if (border1 <= 3) break;
                                if (i < border1 / 2) {
                                    s.array[newOffset] = 0.0f;
                                    break;
                                }
                                int n = newOffset;
                                s.array[n] = (float)((double)s.array[n] * (0.5 * (1.0 - Math.cos((double)(i - border1 / 2) * Math.PI / (double)(border1 - 1 - border1 / 2)))));
                            }
                        }
                    }
                    if (i >= border2) {
                        newOffset = offset + i * factor[dimension];
                        switch (function) {
                            case 0: {
                                s.array[newOffset] = 0.0f;
                                break;
                            }
                            case 1: {
                                int n = newOffset;
                                s.array[n] = (float)((double)s.array[n] * (0.5 * (1.0 + Math.cos((double)(i - border2) * Math.PI / (double)(s.N[dimension] - border2 - 1)))));
                                break;
                            }
                            case 2: {
                                if (border1 <= 3) break;
                                int border3 = border2 + border1 / 2;
                                if (i < border3) {
                                    int n = newOffset;
                                    s.array[n] = (float)((double)s.array[n] * (0.5 * (1.0 + Math.cos((double)(i - border2) * Math.PI / (double)(border3 - border2 - 1)))));
                                    break;
                                }
                                s.array[newOffset] = 0.0f;
                            }
                        }
                    }
                    ++i;
                }
            }
        }
    }

    public static void calculateFactors(Signal s, int[] factor) {
        if (s.D != factor.length) {
            return;
        }
        int i = 0;
        while (i < s.D) {
            factor[i] = 1;
            int j = i + 1;
            while (j < s.D) {
                int n = i;
                factor[n] = factor[n] * s.extN[j];
                ++j;
            }
            ++i;
        }
    }

    public static boolean getLine(Signal s, int dimension, int[] pos, float[] line, int length) {
        if (s == null || pos == null || dimension < 0 || dimension >= s.D || pos.length != s.D) {
            return false;
        }
        if (line == null || line.length < length) {
            return false;
        }
        int[] factor = new int[s.D];
        ToolboxSignal.calculateFactors(s, factor);
        int offset = ToolboxSignal.getPosition(pos, factor, s);
        int i = 0;
        while (i < length) {
            line[i] = s.array[offset + i * factor[dimension]];
            ++i;
        }
        return true;
    }

    public static boolean putLine(Signal s, int dimension, int[] pos, float[] line, int length) {
        if (s == null || pos == null || line == null || dimension < 0 || dimension >= s.D || pos.length != s.D || line.length < length) {
            return false;
        }
        int[] factor = new int[s.D];
        ToolboxSignal.calculateFactors(s, factor);
        int offset = ToolboxSignal.getPosition(pos, factor, s);
        int i = 0;
        while (i < length) {
            s.array[offset + i * factor[dimension]] = line[i];
            ++i;
        }
        return true;
    }

    public static boolean getSlice(Signal s, int z, Signal slice) {
        if (s == null || slice == null || s.D != 3 || slice.D != 2 || z < 0 || z >= s.N[0]) {
            return false;
        }
        if (slice.N[0] != s.N[1] || slice.N[1] != s.N[2]) {
            return false;
        }
        int[] factor = new int[3];
        int[] pos = new int[]{z, 0, 0};
        ToolboxSignal.calculateFactors(s, factor);
        int offset = ToolboxSignal.getPosition(pos, factor, s);
        System.arraycopy(s.array, offset, slice.array, 0, slice.extLength);
        slice.isReal = s.isReal;
        return true;
    }

    public static boolean putSlice(Signal s, int z, Signal slice) {
        if (s == null || slice == null || s.D != 3 || slice.D != 2 || z < 0 || z >= s.N[0]) {
            return false;
        }
        if (slice.N[0] != s.N[1] || slice.N[1] != s.N[2]) {
            return false;
        }
        if (s.isReal != slice.isReal) {
            return false;
        }
        int[] factor = new int[3];
        int[] pos = new int[]{z, 0, 0};
        ToolboxSignal.calculateFactors(s, factor);
        int offset = ToolboxSignal.getPosition(pos, factor, s);
        System.arraycopy(slice.array, 0, s.array, offset, slice.extLength);
        return true;
    }

    static boolean interlace(float[] output, float[] real, float[] imag, boolean useHermSym) {
        if (real == null || imag == null || real.length != imag.length) {
            return false;
        }
        if (useHermSym && 2 * (real.length / 2 + 1) != output.length) {
            return false;
        }
        if (!useHermSym && 2 * real.length != output.length) {
            return false;
        }
        int i = 0;
        while (i < output.length) {
            output[i] = real[i / 2];
            output[i + 1] = imag[i / 2];
            i += 2;
        }
        return true;
    }

    static boolean deinterlace(float[] input, float[] real, float[] imag, boolean useHermSym) {
        if (real == null || imag == null || input == null) {
            return false;
        }
        if (2 * real.length < input.length || 2 * imag.length < input.length) {
            return false;
        }
        int i = 0;
        while (i < input.length / 2) {
            real[i] = input[2 * i];
            imag[i] = input[2 * i + 1];
            ++i;
        }
        if (useHermSym) {
            i = input.length / 2;
            while (i < real.length) {
                real[i] = real[real.length - i];
                imag[i] = -imag[real.length - i];
                ++i;
            }
        }
        return true;
    }

    static boolean getDeinterlacedLine(Signal s, int[] pos, float[] real, float[] imag, int length, boolean useHermSym) {
        if (s == null || pos == null || real == null || imag == null || s.isReal) {
            return false;
        }
        if (length > real.length || length > imag.length || pos.length != s.D) {
            return false;
        }
        if (pos[s.D - 1] % 2 != 0) {
            return false;
        }
        int[] coord = new int[pos.length];
        int xDim = s.D - 1;
        if (!useHermSym) {
            if (length > s.extN[xDim] / 2) {
                return false;
            }
            float[] line = new float[length];
            ToolboxSignal.getLine(s, xDim, pos, line, length);
            ToolboxSignal.deinterlace(line, real, imag, false);
        } else {
            if (length > s.N[xDim]) {
                return false;
            }
            int i = 0;
            while (i < coord.length) {
                coord[i] = pos[i];
                ++i;
            }
            int[] factor = new int[s.D];
            ToolboxSignal.calculateFactors(s, factor);
            int offset = ToolboxSignal.getPosition(coord, factor, s);
            int i2 = 0;
            while (i2 < (s.extN[xDim] - coord[xDim]) / 2) {
                real[i2] = s.array[offset + 2 * i2];
                imag[i2] = s.array[offset + 2 * i2 + 1];
                ++i2;
            }
            float[] result = new float[2];
            int offsetX = coord[xDim];
            coord[xDim] = s.extN[xDim] / 2;
            int i3 = (s.extN[xDim] - offsetX) / 2;
            while (i3 < length) {
                ToolboxSignal.getComplexPixel(s, coord, factor, result);
                real[i3] = result[0];
                imag[i3] = result[1];
                int n = xDim;
                coord[n] = coord[n] + 1;
                ++i3;
            }
        }
        return true;
    }

    public static float mad(Signal s) {
        if (s == null || !s.isReal) {
            return 0.0f;
        }
        float[] x = new float[s.length];
        int j = 0;
        int i = 0;
        while (i < s.extLength) {
            if (i % s.extN[s.D - 1] < s.N[s.D - 1]) {
                x[j] = s.array[i];
                ++j;
            }
            ++i;
        }
        Arrays.sort(x);
        float medX = x.length % 2 == 0 ? (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0f : x[x.length / 2];
        j = 0;
        i = 0;
        while (i < s.extLength) {
            if (i % s.extN[s.D - 1] < s.N[s.D - 1]) {
                x[j] = Math.abs(s.array[i] - medX);
                ++j;
            }
            ++i;
        }
        Arrays.sort(x);
        return x.length % 2 == 0 ? (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0f : x[x.length / 2];
    }

    public static void inverseStable(Signal s, float threshold) {
        if (s.isReal) {
            int i = 0;
            while (i < s.extLength) {
                s.array[i] = s.array[i] < threshold ? 0.0f : 1.0f / s.array[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < s.extLength / 2) {
                float module2 = s.array[2 * i] * s.array[2 * i] + s.array[2 * i + 1] * s.array[2 * i + 1];
                if (Math.sqrt(module2) < (double)threshold) {
                    s.array[2 * i] = 0.0f;
                    s.array[2 * i + 1] = 0.0f;
                } else {
                    s.array[2 * i] = s.array[2 * i] / module2;
                    s.array[2 * i + 1] = -s.array[2 * i + 1] / module2;
                }
                ++i;
            }
        }
    }

    public static float estimateSigma(Signal s, boolean useFftw, String wisdomFolder) {
        s = (Signal)s.clone();
        SignalWavelet wTransform = new SignalWavelet(s.N, 1);
        ToolboxWavelet wToolbox = new ToolboxWavelet(wTransform, 4, useFftw, wisdomFolder);
        wToolbox.transform(s, wTransform, 1);
        return wToolbox.estimateSigma(wTransform);
    }

    public static void addNoisePoisson(boolean useSeed, long seed, Signal s) {
        Poisson poissrnd = new Poisson(useSeed, seed);
        int i = 0;
        while (i < s.extLength) {
            s.array[i] = s.array[i] < 0.0f ? 0.0f : (float)poissrnd.next(s.array[i]);
            ++i;
        }
    }

    public static void addNoiseGaussian(boolean useSeed, long seed, Signal s, float sigma) {
        Random randn = useSeed ? new Random(seed) : new Random();
        int i = 0;
        while (i < s.extLength) {
            int n = i++;
            s.array[n] = s.array[n] + sigma * (float)randn.nextGaussian();
        }
    }

    public static void derivate1D(Signal s, int dim) {
        block17: {
            block15: {
                block16: {
                    if (s.isReal) break block15;
                    if (s.D != 2) break block16;
                    float fStep = (float)Math.PI * 2 / (float)s.N[dim];
                    int y = 0;
                    while (y < s.extN[0]) {
                        float imagY = (dim == 0 ? 2.0f : 0.0f) * (float)Math.sin(fStep * (float)y);
                        int offset = y * s.extN[1];
                        int x = 0;
                        while (x < s.extN[1] / 2) {
                            float imag = imagY + (dim == 1 ? 2.0f : 0.0f) * (float)Math.sin(fStep * (float)x);
                            float temp = s.array[offset + 2 * x];
                            s.array[offset + 2 * x] = -s.array[offset + 2 * x + 1] * imag;
                            s.array[offset + 2 * x + 1] = temp * imag;
                            ++x;
                        }
                        ++y;
                    }
                    break block17;
                }
                if (s.D != 3) break block17;
                float fStep = (float)Math.PI * 2 / (float)s.N[dim];
                int z = 0;
                while (z < s.extN[0]) {
                    float imagZ = (dim == 0 ? 2.0f : 0.0f) * (float)Math.sin(fStep * (float)z);
                    int offsetZ = z * s.extN[1] * s.extN[2];
                    int y = 0;
                    while (y < s.extN[1]) {
                        float imagYZ = imagZ + (dim == 1 ? 2.0f : 0.0f) * (float)Math.sin(fStep * (float)y);
                        int offsetYZ = offsetZ + y * s.extN[2];
                        int x = 0;
                        while (x < s.extN[2] / 2) {
                            float imag = imagYZ + (dim == 2 ? 2.0f : 0.0f) * (float)Math.sin(fStep * (float)x);
                            float temp = s.array[offsetYZ + 2 * x];
                            s.array[offsetYZ + 2 * x] = -s.array[offsetYZ + 2 * x + 1] * imag;
                            s.array[offsetYZ + 2 * x + 1] = temp * imag;
                            ++x;
                        }
                        ++y;
                    }
                    ++z;
                }
                break block17;
            }
            int[] pos = new int[s.D];
            float[] line = new float[s.N[dim]];
            pos[dim] = 0;
            if (s.D == 2) {
                int iteratedDim = dim == 1 ? 0 : 1;
                int i = 0;
                while (i < s.N[iteratedDim]) {
                    pos[iteratedDim] = i++;
                    ToolboxSignal.getLine(s, dim, pos, line, s.N[dim]);
                    ToolboxSignal.derivateLine(line);
                    ToolboxSignal.putLine(s, dim, pos, line, s.N[dim]);
                }
            } else if (s.D == 3) {
                int iteratedDim2;
                int iteratedDim1;
                if (dim == 0) {
                    iteratedDim1 = 1;
                    iteratedDim2 = 2;
                } else if (dim == 1) {
                    iteratedDim1 = 0;
                    iteratedDim2 = 2;
                } else {
                    iteratedDim1 = 0;
                    iteratedDim2 = 1;
                }
                int i = 0;
                while (i < s.N[iteratedDim1]) {
                    pos[iteratedDim1] = i;
                    int j = 0;
                    while (j < s.N[iteratedDim2]) {
                        pos[iteratedDim2] = j++;
                        ToolboxSignal.getLine(s, dim, pos, line, s.N[dim]);
                        ToolboxSignal.derivateLine(line);
                        ToolboxSignal.putLine(s, dim, pos, line, s.N[dim]);
                    }
                    ++i;
                }
            }
        }
    }

    private static void derivateLine(float[] line) {
        float firstPixel = line[0];
        float precedingPixel = line[line.length - 1];
        int i = 0;
        while (i < line.length - 1) {
            float temp = line[i];
            line[i] = -precedingPixel + line[i + 1];
            precedingPixel = temp;
            ++i;
        }
        line[line.length - 1] = -precedingPixel + firstPixel;
    }

    public static boolean gaussian2D3D(Signal s, float sigma) {
        s.isReal = true;
        int[] factor = new int[s.D];
        int[] pos = new int[s.D];
        ToolboxSignal.calculateFactors(s, factor);
        if (s.D == 2) {
            int y = -s.N[0] / 2;
            while (y < s.N[0] / 2) {
                pos[0] = y;
                float contribY = (float)(Math.exp((double)(-y * y) / 2.0 / (double)sigma / (double)sigma) / (Math.PI * 2 * (double)sigma * (double)sigma));
                int x = -s.N[1] / 2;
                while (x < s.N[1] / 2) {
                    pos[1] = x;
                    s.array[ToolboxSignal.getPosition((int[])pos, (int[])factor, (Signal)s)] = (float)Math.exp((double)(-x * x) / 2.0 / (double)sigma / (double)sigma) * contribY;
                    ++x;
                }
                ++y;
            }
            return true;
        }
        if (s.D == 3) {
            int z = -s.N[0] / 2;
            while (z < s.N[0] / 2) {
                pos[0] = z;
                float contribZ = (float)(Math.exp((double)(-z * z) / 2.0 / (double)sigma / (double)sigma) / (Math.PI * 2 * Math.sqrt(Math.PI * 2) * (double)sigma * (double)sigma * (double)sigma));
                int y = -s.N[1] / 2;
                while (y < s.N[1] / 2) {
                    pos[1] = y;
                    float contribYZ = (float)Math.exp((double)(-y * y) / 2.0 / (double)sigma / (double)sigma) * contribZ;
                    int x = -s.N[2] / 2;
                    while (x < s.N[2] / 2) {
                        pos[2] = x;
                        s.array[ToolboxSignal.getPosition((int[])pos, (int[])factor, (Signal)s)] = (float)Math.exp((double)(-x * x) / 2.0 / (double)sigma / (double)sigma) * contribYZ;
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
            return true;
        }
        return false;
    }
}

