/*
 * Decompiled with CFR 0.152.
 */
package toolbox;

import ij.ImagePlus;
import ij.ImageStack;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import toolbox.FFT1D;
import toolbox.Signal;
import toolbox.SignalWavelet;
import toolbox.ToolboxFourier;
import toolbox.ToolboxSignal;
import toolbox.waveletFilters.Daubechies;
import toolbox.waveletFilters.FractSpline;

public class ToolboxWavelet {
    public static final int HAAR = 0;
    public static final int DAUBECHIES2 = 1;
    public static final int DAUBECHIES4 = 2;
    public static final int DAUBECHIES6 = 3;
    public static final int FRACT_SPLINE = 4;
    public static final String[] wavFamily = new String[]{"Haar", "Daubechies2", "Daubechies4", "Daubechies6", "Fractional spline"};
    public static final int SOFT = 0;
    public static final int HARD = 1;
    public static final String[] threshType = new String[]{"Soft", "Hard"};
    private ToolboxFourier[] fftToolbox;
    private float[] HImagXAnalysis;
    private float[] HRealXAnalysis;
    private float[] GImagXAnalysis;
    private float[] GRealXAnalysis;
    private float[] HImagYAnalysis;
    private float[] HRealYAnalysis;
    private float[] GImagYAnalysis;
    private float[] GRealYAnalysis;
    private float[] HImagZAnalysis;
    private float[] HRealZAnalysis;
    private float[] GImagZAnalysis;
    private float[] GRealZAnalysis;
    private float[] HImagXSynthesis;
    private float[] HRealXSynthesis;
    private float[] GImagXSynthesis;
    private float[] GRealXSynthesis;
    private float[] HImagYSynthesis;
    private float[] HRealYSynthesis;
    private float[] GImagYSynthesis;
    private float[] GRealYSynthesis;
    private float[] HImagZSynthesis;
    private float[] HRealZSynthesis;
    private float[] GImagZSynthesis;
    private float[] GRealZSynthesis;
    private boolean useFftw = false;
    String nameWisdomFolder = null;

    public ToolboxWavelet(SignalWavelet sw, int wavFamily, boolean useFftw, String nameWisdomFolder) {
        this.fftToolbox = new ToolboxFourier[sw.J];
        int j = 0;
        while (j < sw.J) {
            this.fftToolbox[j] = new ToolboxFourier(sw.w[j][0].N, useFftw, nameWisdomFolder);
            ++j;
        }
        this.getFilters(sw, wavFamily);
        this.useFftw = useFftw;
        if (nameWisdomFolder != null) {
            this.nameWisdomFolder = new String(nameWisdomFolder);
        }
    }

    public void transformFreq(Signal s, SignalWavelet sw, int J) {
        sw.s = s;
        int j = 0;
        while (j < J) {
            sw.s = this.iterate(sw.s, sw.w[j]);
            ++j;
        }
    }

    public void transform(Signal s, SignalWavelet sw, int J) {
        if (s.isReal) {
            ToolboxFourier fftTB = new ToolboxFourier(s.N, this.useFftw, this.nameWisdomFolder);
            fftTB.forwardDFT(s);
        }
        this.transformFreq(s, sw, J);
        this.toSpatial(sw);
    }

    public void transformInverse(SignalWavelet sw, Signal s) {
        this.toFourier(sw);
        this.transformInverseFreq(sw, s);
    }

    public void transformInverseFreq(SignalWavelet sw, Signal s) {
        Signal ss = sw.s;
        int j = sw.J - 1;
        while (j >= 0) {
            ss = this.iterateInverse(ss, sw.w[j]);
            --j;
        }
        ToolboxSignal.transfer(s, ss);
    }

    public static void threshold(SignalWavelet sw, float inferiorLimit, float superiorLimit) {
        if (sw == null) {
            return;
        }
        int j = 0;
        while (j < sw.J) {
            int m = 0;
            while (m < sw.M) {
                ToolboxSignal.threshold(sw.w[j][m], inferiorLimit, superiorLimit);
                ++m;
            }
            ++j;
        }
    }

    public ImagePlus getImage(SignalWavelet sw, String title) {
        ImagePlus result = null;
        int dimension = sw.N.length;
        if (dimension == 2) {
            FloatProcessor im_processor = new FloatProcessor(sw.N[1], sw.N[0]);
            float[] imageArray = (float[])im_processor.getPixels();
            int i = 0;
            while (i < sw.J) {
                int j = 0;
                while (j < sw.M) {
                    this.paint(sw.w[i][j], imageArray, i, j);
                    ++j;
                }
                ++i;
            }
            this.paint(sw.s, imageArray, sw.J - 1, -1);
            result = new ImagePlus(title, (ImageProcessor)im_processor);
            result.getProcessor().setMinAndMax(0.0, 255.0);
        } else if (dimension == 3) {
            float[] bigArray = new float[sw.N[2] * sw.N[1] * sw.N[0]];
            int i = 0;
            while (i < sw.J) {
                int j = 0;
                while (j < sw.M) {
                    this.paint(sw.w[i][j], bigArray, i, j);
                    ++j;
                }
                ++i;
            }
            this.paint(sw.s, bigArray, sw.J - 1, -1);
            ImageStack stack = new ImageStack(sw.N[2], sw.N[1]);
            int z = 0;
            while (z < sw.N[0]) {
                FloatProcessor im_processor = new FloatProcessor(sw.N[2], sw.N[1]);
                float[] imageArray = (float[])im_processor.getPixels();
                int contribZ = z * sw.N[2] * sw.N[1];
                int y = 0;
                while (y < sw.N[1]) {
                    System.arraycopy(bigArray, y * sw.N[2] + contribZ, imageArray, y * sw.N[2], sw.N[2]);
                    ++y;
                }
                im_processor.setMinAndMax(0.0, 255.0);
                stack.addSlice("", (ImageProcessor)im_processor);
                ++z;
            }
            result = new ImagePlus(title, stack);
        }
        return result;
    }

    private void filterAndDownsample1D(Signal s, int dim, Signal ss, Signal sw) {
        block15: {
            float[] GImag;
            float[] GReal;
            float[] HImag;
            float[] HReal;
            float[] outputImag;
            float[] outputReal;
            float[] filteredImag;
            float[] filteredReal;
            float[] lineImag;
            float[] lineReal;
            int[] coord;
            block13: {
                float[] lineOut;
                block14: {
                    if (s.N[dim] != 2 * ss.N[dim]) {
                        return;
                    }
                    int d = 0;
                    while (d < s.D) {
                        if (d != dim && (s.N[d] != ss.N[d] || s.N[d] != sw.N[d])) {
                            return;
                        }
                        ++d;
                    }
                    ss.isReal = false;
                    sw.isReal = false;
                    coord = new int[s.D];
                    lineReal = new float[s.N[dim]];
                    lineImag = new float[s.N[dim]];
                    filteredReal = new float[s.N[dim]];
                    filteredImag = new float[s.N[dim]];
                    outputReal = new float[ss.N[dim]];
                    outputImag = new float[ss.N[dim]];
                    HReal = new float[s.N[dim]];
                    HImag = new float[s.N[dim]];
                    GReal = new float[s.N[dim]];
                    GImag = new float[s.N[dim]];
                    if (dim != s.D - 1) break block13;
                    this.adaptFilter(HReal, HImag, this.HRealXAnalysis, this.HImagXAnalysis, false);
                    this.adaptFilter(GReal, GImag, this.GRealXAnalysis, this.GImagXAnalysis, false);
                    lineOut = new float[ss.extN[dim]];
                    if (s.D != 3) break block14;
                    coord[2] = 0;
                    int z = 0;
                    while (z < s.extN[0]) {
                        coord[0] = z;
                        int y = 0;
                        while (y < s.extN[1]) {
                            coord[1] = y++;
                            this.filterAndDownsampleLineX(s, ss, sw, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, filteredReal, filteredImag, outputReal, outputImag, lineOut);
                        }
                        ++z;
                    }
                    break block15;
                }
                if (s.D != 2) break block15;
                coord[1] = 0;
                int y = 0;
                while (y < s.extN[0]) {
                    coord[0] = y++;
                    this.filterAndDownsampleLineX(s, ss, sw, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, filteredReal, filteredImag, outputReal, outputImag, lineOut);
                }
                break block15;
            }
            int dimLoop = 0;
            if (s.D == 3) {
                if (dim == 1) {
                    this.adaptFilter(HReal, HImag, this.HRealYAnalysis, this.HImagYAnalysis, false);
                    this.adaptFilter(GReal, GImag, this.GRealYAnalysis, this.GImagYAnalysis, false);
                    dimLoop = 0;
                }
                if (dim == 0) {
                    this.adaptFilter(HReal, HImag, this.HRealZAnalysis, this.HImagZAnalysis, false);
                    this.adaptFilter(GReal, GImag, this.GRealZAnalysis, this.GImagZAnalysis, false);
                    dimLoop = 1;
                }
                coord[dim] = 0;
                int z = 0;
                while (z < s.extN[dimLoop]) {
                    coord[dimLoop] = z;
                    int x = 0;
                    while (x < s.extN[2]) {
                        coord[2] = x;
                        this.filterAndDownsampleLine(s, ss, sw, dim, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, filteredReal, filteredImag, outputReal, outputImag);
                        x += 2;
                    }
                    ++z;
                }
            }
            if (s.D == 2) {
                this.adaptFilter(HReal, HImag, this.HRealYAnalysis, this.HImagYAnalysis, false);
                this.adaptFilter(GReal, GImag, this.GRealYAnalysis, this.GImagYAnalysis, false);
                coord[dim] = 0;
                int x = 0;
                while (x < s.extN[1]) {
                    coord[1] = x;
                    this.filterAndDownsampleLine(s, ss, sw, dim, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, filteredReal, filteredImag, outputReal, outputImag);
                    x += 2;
                }
            }
        }
    }

    private void upsampleAndFilter1D(Signal lowBand, Signal highBand, int dim, Signal s) {
        block17: {
            float[] GImag;
            float[] GReal;
            float[] HImag;
            float[] HReal;
            float[] outputImag;
            float[] outputReal;
            float[] upsampledImag;
            float[] upsampledReal;
            float[] lineImag;
            float[] lineReal;
            int[] coord;
            block15: {
                float[] lineOut;
                block16: {
                    if (s == null || lowBand == null || highBand == null || lowBand.isReal || highBand.isReal) {
                        return;
                    }
                    if (s.D <= dim || s.D != lowBand.D || s.D != highBand.D) {
                        return;
                    }
                    if (s.N[dim] != 2 * lowBand.N[dim]) {
                        return;
                    }
                    int i = 0;
                    while (i < s.D) {
                        if (i != dim && (s.N[i] != lowBand.N[i] || s.N[i] != highBand.N[i])) {
                            return;
                        }
                        ++i;
                    }
                    s.isReal = false;
                    int dimension = s.D;
                    coord = new int[dimension];
                    lineReal = new float[lowBand.N[dim]];
                    lineImag = new float[lowBand.N[dim]];
                    upsampledReal = new float[s.N[dim]];
                    upsampledImag = new float[s.N[dim]];
                    outputReal = new float[s.N[dim]];
                    outputImag = new float[s.N[dim]];
                    HReal = new float[s.N[dim]];
                    HImag = new float[s.N[dim]];
                    GReal = new float[s.N[dim]];
                    GImag = new float[s.N[dim]];
                    if (dim != s.D - 1) break block15;
                    this.adaptFilter(HReal, HImag, this.HRealXSynthesis, this.HImagXSynthesis, false);
                    this.adaptFilter(GReal, GImag, this.GRealXSynthesis, this.GImagXSynthesis, false);
                    lineOut = new float[s.extN[dim]];
                    if (s.D != 3) break block16;
                    coord[2] = 0;
                    int z = 0;
                    while (z < s.extN[0]) {
                        coord[0] = z;
                        int y = 0;
                        while (y < s.extN[1]) {
                            coord[1] = y++;
                            this.upsampleAndFilterLineX(s, lowBand, highBand, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, upsampledReal, upsampledImag, outputReal, outputImag, lineOut);
                        }
                        ++z;
                    }
                    break block17;
                }
                if (s.D != 2) break block17;
                coord[1] = 0;
                int y = 0;
                while (y < s.extN[0]) {
                    coord[0] = y++;
                    this.upsampleAndFilterLineX(s, lowBand, highBand, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, upsampledReal, upsampledImag, outputReal, outputImag, lineOut);
                }
                break block17;
            }
            int dimLoop = 0;
            if (s.D == 3) {
                if (dim == 1) {
                    this.adaptFilter(HReal, HImag, this.HRealYSynthesis, this.HImagYSynthesis, false);
                    this.adaptFilter(GReal, GImag, this.GRealYSynthesis, this.GImagYSynthesis, false);
                    dimLoop = 0;
                }
                if (dim == 0) {
                    this.adaptFilter(HReal, HImag, this.HRealZSynthesis, this.HImagZSynthesis, false);
                    this.adaptFilter(GReal, GImag, this.GRealZSynthesis, this.GImagZSynthesis, false);
                    dimLoop = 1;
                }
                coord[dim] = 0;
                int z = 0;
                while (z < s.extN[dimLoop]) {
                    coord[dimLoop] = z;
                    int x = 0;
                    while (x < s.extN[2]) {
                        coord[2] = x;
                        this.upsampleAndFilterLine(s, lowBand, highBand, dim, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, upsampledReal, upsampledImag, outputReal, outputImag);
                        x += 2;
                    }
                    ++z;
                }
            }
            if (s.D == 2) {
                this.adaptFilter(HReal, HImag, this.HRealYSynthesis, this.HImagYSynthesis, false);
                this.adaptFilter(GReal, GImag, this.GRealYSynthesis, this.GImagYSynthesis, false);
                coord[dim] = 0;
                int x = 0;
                while (x < s.extN[1]) {
                    coord[1] = x;
                    this.upsampleAndFilterLine(s, lowBand, highBand, dim, coord, HReal, HImag, GReal, GImag, lineReal, lineImag, upsampledReal, upsampledImag, outputReal, outputImag);
                    x += 2;
                }
            }
        }
    }

    private void filterAndDownsampleLineX(Signal input, Signal outLow, Signal outHigh, int[] coord, float[] HReal, float[] HImag, float[] GReal, float[] GImag, float[] lineReal, float[] lineImag, float[] filteredReal, float[] filteredImag, float[] outputReal, float[] outputImag, float[] lineOut) {
        int xDim = input.D - 1;
        ToolboxSignal.getDeinterlacedLine(input, coord, lineReal, lineImag, input.N[xDim], true);
        this.multiply(lineReal, lineImag, HReal, HImag, filteredReal, filteredImag);
        this.downsample2(outputReal, outputImag, filteredReal, filteredImag);
        ToolboxSignal.interlace(lineOut, outputReal, outputImag, true);
        ToolboxSignal.putLine(outLow, xDim, coord, lineOut, lineOut.length);
        this.multiply(lineReal, lineImag, GReal, GImag, filteredReal, filteredImag);
        this.downsample2(outputReal, outputImag, filteredReal, filteredImag);
        ToolboxSignal.interlace(lineOut, outputReal, outputImag, true);
        ToolboxSignal.putLine(outHigh, xDim, coord, lineOut, lineOut.length);
    }

    private void filterAndDownsampleLine(Signal input, Signal outLow, Signal outHigh, int dimProcess, int[] coord, float[] HReal, float[] HImag, float[] GReal, float[] GImag, float[] lineReal, float[] lineImag, float[] filteredReal, float[] filteredImag, float[] outputReal, float[] outputImag) {
        int xDim = input.D - 1;
        ToolboxSignal.getLine(input, dimProcess, coord, lineReal, input.N[dimProcess]);
        int n = xDim;
        coord[n] = coord[n] + 1;
        ToolboxSignal.getLine(input, dimProcess, coord, lineImag, input.N[dimProcess]);
        this.multiply(lineReal, lineImag, HReal, HImag, filteredReal, filteredImag);
        this.downsample2(outputReal, outputImag, filteredReal, filteredImag);
        int n2 = xDim;
        coord[n2] = coord[n2] - 1;
        ToolboxSignal.putLine(outLow, dimProcess, coord, outputReal, outLow.N[dimProcess]);
        int n3 = xDim;
        coord[n3] = coord[n3] + 1;
        ToolboxSignal.putLine(outLow, dimProcess, coord, outputImag, outLow.N[dimProcess]);
        this.multiply(lineReal, lineImag, GReal, GImag, filteredReal, filteredImag);
        this.downsample2(outputReal, outputImag, filteredReal, filteredImag);
        int n4 = xDim;
        coord[n4] = coord[n4] - 1;
        ToolboxSignal.putLine(outHigh, dimProcess, coord, outputReal, outHigh.N[dimProcess]);
        int n5 = xDim;
        coord[n5] = coord[n5] + 1;
        ToolboxSignal.putLine(outHigh, dimProcess, coord, outputImag, outHigh.N[dimProcess]);
        int n6 = xDim;
        coord[n6] = coord[n6] - 1;
    }

    private void upsampleAndFilterLineX(Signal output, Signal inLow, Signal inHigh, int[] coord, float[] HReal, float[] HImag, float[] GReal, float[] GImag, float[] lineReal, float[] lineImag, float[] upsampledReal, float[] upsampledImag, float[] outputReal, float[] outputImag, float[] lineOut) {
        int xDim = output.D - 1;
        ToolboxSignal.getDeinterlacedLine(inLow, coord, lineReal, lineImag, inLow.N[xDim], true);
        this.upsample2(upsampledReal, upsampledImag, lineReal, lineImag);
        this.multiply(upsampledReal, upsampledImag, HReal, HImag, outputReal, outputImag);
        ToolboxSignal.getDeinterlacedLine(inHigh, coord, lineReal, lineImag, inHigh.N[xDim], true);
        this.upsample2(upsampledReal, upsampledImag, lineReal, lineImag);
        this.multiply(upsampledReal, upsampledImag, GReal, GImag);
        this.add(outputReal, outputImag, upsampledReal, upsampledImag);
        ToolboxSignal.interlace(lineOut, outputReal, outputImag, true);
        ToolboxSignal.putLine(output, xDim, coord, lineOut, lineOut.length);
    }

    private void upsampleAndFilterLine(Signal output, Signal inLow, Signal inHigh, int dimProcess, int[] coord, float[] HReal, float[] HImag, float[] GReal, float[] GImag, float[] lineReal, float[] lineImag, float[] upsampledReal, float[] upsampledImag, float[] outputReal, float[] outputImag) {
        int xDim = output.D - 1;
        ToolboxSignal.getLine(inLow, dimProcess, coord, lineReal, inLow.N[dimProcess]);
        int n = xDim;
        coord[n] = coord[n] + 1;
        ToolboxSignal.getLine(inLow, dimProcess, coord, lineImag, inLow.N[dimProcess]);
        this.upsample2(upsampledReal, upsampledImag, lineReal, lineImag);
        this.multiply(upsampledReal, upsampledImag, HReal, HImag, outputReal, outputImag);
        int n2 = xDim;
        coord[n2] = coord[n2] - 1;
        ToolboxSignal.getLine(inHigh, dimProcess, coord, lineReal, inHigh.N[dimProcess]);
        int n3 = xDim;
        coord[n3] = coord[n3] + 1;
        ToolboxSignal.getLine(inHigh, dimProcess, coord, lineImag, inHigh.N[dimProcess]);
        this.upsample2(upsampledReal, upsampledImag, lineReal, lineImag);
        this.multiply(upsampledReal, upsampledImag, GReal, GImag);
        this.add(outputReal, outputImag, upsampledReal, upsampledImag);
        int n4 = xDim;
        coord[n4] = coord[n4] - 1;
        ToolboxSignal.putLine(output, dimProcess, coord, outputReal, output.N[dimProcess]);
        int n5 = xDim;
        coord[n5] = coord[n5] + 1;
        ToolboxSignal.putLine(output, dimProcess, coord, outputImag, output.N[dimProcess]);
        int n6 = xDim;
        coord[n6] = coord[n6] - 1;
    }

    private Signal iterate(Signal s, Signal[] sw) {
        Signal ss = null;
        int[] N = (int[])s.N.clone();
        if (s.D == 3) {
            N[2] = N[2] / 2;
            Signal xl = new Signal(N);
            Signal xh = new Signal(N);
            this.filterAndDownsample1D(s, 2, xl, xh);
            N[1] = N[1] / 2;
            Signal xlyl = new Signal(N);
            Signal xlyh = new Signal(N);
            this.filterAndDownsample1D(xl, 1, xlyl, xlyh);
            xl = null;
            Signal xhyl = new Signal(N);
            Signal xhyh = new Signal(N);
            this.filterAndDownsample1D(xh, 1, xhyl, xhyh);
            xh = null;
            N[0] = N[0] / 2;
            ss = new Signal(N);
            this.filterAndDownsample1D(xlyl, 0, ss, sw[3]);
            xlyl = null;
            this.filterAndDownsample1D(xhyl, 0, sw[0], sw[4]);
            xhyl = null;
            this.filterAndDownsample1D(xlyh, 0, sw[1], sw[5]);
            xlyh = null;
            this.filterAndDownsample1D(xhyh, 0, sw[2], sw[6]);
            xhyh = null;
        } else if (s.D == 2) {
            N[1] = N[1] / 2;
            Signal xl = new Signal(N);
            Signal xh = new Signal(N);
            this.filterAndDownsample1D(s, 1, xl, xh);
            N[0] = N[0] / 2;
            ss = new Signal(N);
            this.filterAndDownsample1D(xl, 0, ss, sw[1]);
            xl = null;
            this.filterAndDownsample1D(xh, 0, sw[0], sw[2]);
            xh = null;
        }
        return ss;
    }

    private Signal iterateInverse(Signal ss, Signal[] sw) {
        int[] N = (int[])ss.N.clone();
        Signal s = null;
        if (ss.D == 3) {
            N[0] = N[0] * 2;
            Signal xlyl = new Signal(N);
            Signal xlyh = new Signal(N);
            Signal xhyl = new Signal(N);
            Signal xhyh = new Signal(N);
            this.upsampleAndFilter1D(ss, sw[3], 0, xlyl);
            this.upsampleAndFilter1D(sw[0], sw[4], 0, xhyl);
            this.upsampleAndFilter1D(sw[1], sw[5], 0, xlyh);
            this.upsampleAndFilter1D(sw[2], sw[6], 0, xhyh);
            N[1] = N[1] * 2;
            Signal xl = new Signal(N);
            this.upsampleAndFilter1D(xlyl, xlyh, 1, xl);
            xlyl = null;
            xlyh = null;
            Signal xh = new Signal(N);
            this.upsampleAndFilter1D(xhyl, xhyh, 1, xh);
            xhyl = null;
            xhyh = null;
            N[2] = N[2] * 2;
            s = new Signal(N);
            this.upsampleAndFilter1D(xl, xh, 2, s);
            xl = null;
            xh = null;
        } else if (ss.D == 2) {
            N[0] = N[0] * 2;
            Signal xl = new Signal(N);
            Signal xh = new Signal(N);
            this.upsampleAndFilter1D(ss, sw[1], 0, xl);
            this.upsampleAndFilter1D(sw[0], sw[2], 0, xh);
            N[1] = N[1] * 2;
            s = new Signal(N);
            this.upsampleAndFilter1D(xl, xh, 1, s);
            xl = null;
            xh = null;
        }
        return s;
    }

    private void toSpatial(SignalWavelet sw) {
        if (sw.J < 1) {
            return;
        }
        int i = 0;
        while (i < sw.J) {
            int j = 0;
            while (j < sw.M) {
                Signal s = sw.w[i][j];
                if (!s.isReal) {
                    this.fftToolbox[i].inverseDFT(s);
                }
                ++j;
            }
            ++i;
        }
        this.fftToolbox[sw.J - 1].inverseDFT(sw.s);
    }

    private void toFourier(SignalWavelet sw) {
        if (sw.J < 1) {
            return;
        }
        int j = 0;
        while (j < sw.J) {
            int m = 0;
            while (m < sw.M) {
                Signal s = sw.w[j][m];
                if (s.isReal) {
                    this.fftToolbox[j].forwardDFT(s);
                }
                ++m;
            }
            ++j;
        }
        this.fftToolbox[sw.J - 1].forwardDFT(sw.s);
    }

    public void getFilters(SignalWavelet sw, int wavFamily) {
        int dimension = sw.N.length;
        int lengthX = 0;
        int lengthY = 0;
        int lengthZ = 0;
        lengthX = sw.N[--dimension];
        this.HRealXAnalysis = new float[lengthX];
        this.HImagXAnalysis = new float[lengthX];
        this.GRealXAnalysis = new float[lengthX];
        this.GImagXAnalysis = new float[lengthX];
        this.HRealXSynthesis = new float[lengthX];
        this.HImagXSynthesis = new float[lengthX];
        this.GRealXSynthesis = new float[lengthX];
        this.GImagXSynthesis = new float[lengthX];
        lengthY = sw.N[--dimension];
        this.HRealYAnalysis = new float[lengthY];
        this.HImagYAnalysis = new float[lengthY];
        this.GRealYAnalysis = new float[lengthY];
        this.GImagYAnalysis = new float[lengthY];
        this.HRealYSynthesis = new float[lengthY];
        this.HImagYSynthesis = new float[lengthY];
        this.GRealYSynthesis = new float[lengthY];
        this.GImagYSynthesis = new float[lengthY];
        if (--dimension == 0) {
            lengthZ = sw.N[dimension];
            this.HRealZAnalysis = new float[lengthZ];
            this.HImagZAnalysis = new float[lengthZ];
            this.GRealZAnalysis = new float[lengthZ];
            this.GImagZAnalysis = new float[lengthZ];
            this.HRealZSynthesis = new float[lengthZ];
            this.HImagZSynthesis = new float[lengthZ];
            this.GRealZSynthesis = new float[lengthZ];
            this.GImagZSynthesis = new float[lengthZ];
        } else {
            this.GRealZAnalysis = null;
            this.GImagZAnalysis = null;
            this.HRealZAnalysis = null;
            this.HImagZAnalysis = null;
        }
        switch (wavFamily) {
            case 0: {
                ToolboxWavelet.getHaar(this.GRealXAnalysis, this.GImagXAnalysis, this.HRealXAnalysis, this.HImagXAnalysis, this.GRealXSynthesis, this.GImagXSynthesis, this.HRealXSynthesis, this.HImagXSynthesis, lengthX);
                ToolboxWavelet.getHaar(this.GRealYAnalysis, this.GImagYAnalysis, this.HRealYAnalysis, this.HImagYAnalysis, this.GRealYSynthesis, this.GImagYSynthesis, this.HRealYSynthesis, this.HImagYSynthesis, lengthY);
                ToolboxWavelet.getHaar(this.GRealZAnalysis, this.GImagZAnalysis, this.HRealZAnalysis, this.HImagZAnalysis, this.GRealZSynthesis, this.GImagZSynthesis, this.HRealZSynthesis, this.HImagZSynthesis, lengthZ);
                break;
            }
            case 4: {
                ToolboxWavelet.getFractSplines(this.GRealXAnalysis, this.GImagXAnalysis, this.HRealXAnalysis, this.HImagXAnalysis, this.GRealXSynthesis, this.GImagXSynthesis, this.HRealXSynthesis, this.HImagXSynthesis, lengthX);
                ToolboxWavelet.getFractSplines(this.GRealYAnalysis, this.GImagYAnalysis, this.HRealYAnalysis, this.HImagYAnalysis, this.GRealYSynthesis, this.GImagYSynthesis, this.HRealYSynthesis, this.HImagYSynthesis, lengthY);
                ToolboxWavelet.getFractSplines(this.GRealZAnalysis, this.GImagZAnalysis, this.HRealZAnalysis, this.HImagZAnalysis, this.GRealZSynthesis, this.GImagZSynthesis, this.HRealZSynthesis, this.HImagZSynthesis, lengthZ);
                break;
            }
            case 1: {
                ToolboxWavelet.getDaubechies(2, this.GRealXAnalysis, this.GImagXAnalysis, this.HRealXAnalysis, this.HImagXAnalysis, this.GRealXSynthesis, this.GImagXSynthesis, this.HRealXSynthesis, this.HImagXSynthesis, lengthX);
                ToolboxWavelet.getDaubechies(2, this.GRealYAnalysis, this.GImagYAnalysis, this.HRealYAnalysis, this.HImagYAnalysis, this.GRealYSynthesis, this.GImagYSynthesis, this.HRealYSynthesis, this.HImagYSynthesis, lengthY);
                ToolboxWavelet.getDaubechies(2, this.GRealZAnalysis, this.GImagZAnalysis, this.HRealZAnalysis, this.HImagZAnalysis, this.GRealZSynthesis, this.GImagZSynthesis, this.HRealZSynthesis, this.HImagZSynthesis, lengthZ);
                break;
            }
            case 2: {
                ToolboxWavelet.getDaubechies(4, this.GRealXAnalysis, this.GImagXAnalysis, this.HRealXAnalysis, this.HImagXAnalysis, this.GRealXSynthesis, this.GImagXSynthesis, this.HRealXSynthesis, this.HImagXSynthesis, lengthX);
                ToolboxWavelet.getDaubechies(4, this.GRealYAnalysis, this.GImagYAnalysis, this.HRealYAnalysis, this.HImagYAnalysis, this.GRealYSynthesis, this.GImagYSynthesis, this.HRealYSynthesis, this.HImagYSynthesis, lengthY);
                ToolboxWavelet.getDaubechies(4, this.GRealZAnalysis, this.GImagZAnalysis, this.HRealZAnalysis, this.HImagZAnalysis, this.GRealZSynthesis, this.GImagZSynthesis, this.HRealZSynthesis, this.HImagZSynthesis, lengthZ);
                break;
            }
            case 3: {
                ToolboxWavelet.getDaubechies(6, this.GRealXAnalysis, this.GImagXAnalysis, this.HRealXAnalysis, this.HImagXAnalysis, this.GRealXSynthesis, this.GImagXSynthesis, this.HRealXSynthesis, this.HImagXSynthesis, lengthX);
                ToolboxWavelet.getDaubechies(6, this.GRealYAnalysis, this.GImagYAnalysis, this.HRealYAnalysis, this.HImagYAnalysis, this.GRealYSynthesis, this.GImagYSynthesis, this.HRealYSynthesis, this.HImagYSynthesis, lengthY);
                ToolboxWavelet.getDaubechies(6, this.GRealZAnalysis, this.GImagZAnalysis, this.HRealZAnalysis, this.HImagZAnalysis, this.GRealZSynthesis, this.GImagZSynthesis, this.HRealZSynthesis, this.HImagZSynthesis, lengthZ);
            }
        }
    }

    private static void getFractSplines(float[] GRealAn, float[] GImagAn, float[] HRealAn, float[] HImagAn, float[] GRealSyn, float[] GImagSyn, float[] HRealSyn, float[] HImagSyn, int length) {
        if (GRealAn == null || GImagAn == null || HRealAn == null || HImagAn == null || GRealSyn == null || GImagSyn == null || HRealSyn == null || HImagSyn == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        FractSpline filters = new FractSpline(length, 0, 3.0, 0.0);
        filters.generateAnalysisFilters();
        double[] GReal = filters.getRealHighpassFilter();
        double[] GImag = filters.getImaginaryHighpassFilter();
        double[] HReal = filters.getRealLowpassFilter();
        double[] HImag = filters.getImaginaryLowpassFilter();
        int i = 0;
        while (i < length) {
            GRealAn[i] = (float)GReal[i];
            GImagAn[i] = (float)GImag[i];
            HRealAn[i] = (float)HReal[i];
            HImagAn[i] = (float)HImag[i];
            GRealSyn[i] = (float)GReal[i];
            GImagSyn[i] = -((float)GImag[i]);
            HRealSyn[i] = (float)HReal[i];
            HImagSyn[i] = -((float)HImag[i]);
            ++i;
        }
    }

    private static void getHaar(float[] GRealAn, float[] GImagAn, float[] HRealAn, float[] HImagAn, float[] GRealSyn, float[] GImagSyn, float[] HRealSyn, float[] HImagSyn, int length) {
        double invSqrt2;
        if (GRealAn == null || GImagAn == null || HRealAn == null || HImagAn == null || GRealSyn == null || GImagSyn == null || HRealSyn == null || HImagSyn == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        double[] HReal = new double[length];
        double[] HImag = new double[length];
        double[] GReal = new double[length];
        double[] GImag = new double[length];
        HReal[0] = invSqrt2 = 1.0 / Math.sqrt(2.0);
        HReal[length - 1] = invSqrt2;
        GReal[0] = invSqrt2;
        GReal[length - 1] = -invSqrt2;
        FFT1D fft = new FFT1D(length);
        fft.transform(HReal, HImag, length, 0);
        fft.transform(GReal, GImag, length, 0);
        int i = 0;
        while (i < length) {
            GRealAn[i] = (float)GReal[i];
            GImagAn[i] = (float)GImag[i];
            HRealAn[i] = (float)HReal[i];
            HImagAn[i] = (float)HImag[i];
            GRealSyn[i] = (float)GReal[i];
            GImagSyn[i] = -((float)GImag[i]);
            HRealSyn[i] = (float)HReal[i];
            HImagSyn[i] = -((float)HImag[i]);
            ++i;
        }
    }

    private static void getDaubechies(int p, float[] GRealAn, float[] GImagAn, float[] HRealAn, float[] HImagAn, float[] GRealSyn, float[] GImagSyn, float[] HRealSyn, float[] HImagSyn, int length) {
        if (GRealAn == null || GImagAn == null || HRealAn == null || HImagAn == null || GRealSyn == null || GImagSyn == null || HRealSyn == null || HImagSyn == null) {
            return;
        }
        if (length == 0) {
            return;
        }
        Daubechies filters = new Daubechies(length, p);
        double[] GReal = filters.getRealHighPassAnalysis();
        double[] GImag = filters.getImagHighPassAnalysis();
        double[] HReal = filters.getRealLowPassAnalysis();
        double[] HImag = filters.getImagLowPassAnalysis();
        int i = 0;
        while (i < length) {
            GRealAn[i] = (float)GReal[i];
            GImagAn[i] = (float)GImag[i];
            HRealAn[i] = (float)HReal[i];
            HImagAn[i] = (float)HImag[i];
            GRealSyn[i] = (float)GReal[i];
            GImagSyn[i] = -((float)GImag[i]);
            HRealSyn[i] = (float)HReal[i];
            HImagSyn[i] = -((float)HImag[i]);
            ++i;
        }
    }

    private boolean adaptFilter(float[] realOutput, float[] imagOutput, float[] realFilter, float[] imagFilter, boolean conjugate) {
        if (realFilter == null || imagFilter == null || realOutput == null || imagOutput == null) {
            return false;
        }
        if (realFilter.length != imagFilter.length || realOutput.length != imagOutput.length) {
            return false;
        }
        int length = realFilter.length;
        int targetLength = realOutput.length;
        if (!this.isDyadicQuotient(length, targetLength)) {
            return false;
        }
        int quotient = length / targetLength;
        if (conjugate) {
            int i = 0;
            while (i < targetLength) {
                realOutput[i] = realFilter[quotient * i];
                imagOutput[i] = -imagFilter[quotient * i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < targetLength) {
                realOutput[i] = realFilter[quotient * i];
                imagOutput[i] = imagFilter[quotient * i];
                ++i;
            }
        }
        return true;
    }

    private boolean isDyadicQuotient(int a, int b) {
        int power = (int)(Math.log((double)a / (double)b) / Math.log(2.0) + 0.01);
        return b * this.power(2, power) == a && power >= 0;
    }

    private boolean multiply(float[] a, float[] b, float[] c, float[] d, float[] e, float[] f) {
        if (a == null || b == null || c == null || d == null) {
            return false;
        }
        int N = a.length;
        if (N != b.length || N != c.length || N != d.length || N != e.length || N != f.length) {
            return false;
        }
        int n = 0;
        while (n < N) {
            e[n] = a[n] * c[n] - b[n] * d[n];
            f[n] = a[n] * d[n] + c[n] * b[n];
            ++n;
        }
        return true;
    }

    private boolean multiply(float[] a, float[] b, float[] c, float[] d) {
        if (a == null || b == null || c == null || d == null) {
            return false;
        }
        int N = a.length;
        if (N != c.length || N != b.length || N != d.length) {
            return false;
        }
        int n = 0;
        while (n < N) {
            float temp = a[n];
            a[n] = temp * c[n] - b[n] * d[n];
            b[n] = temp * d[n] + c[n] * b[n];
            ++n;
        }
        return true;
    }

    private boolean add(float[] a, float[] b, float[] c, float[] d) {
        if (a == null || b == null || c == null || d == null) {
            return false;
        }
        int N = a.length;
        if (N != c.length || N != b.length || N != d.length) {
            return false;
        }
        int n = 0;
        while (n < N) {
            a[n] = a[n] + c[n];
            b[n] = b[n] + d[n];
            ++n;
        }
        return true;
    }

    private boolean downsample2(float[] outputReal, float[] outputImag, float[] inputReal, float[] inputImag) {
        if (outputReal == null || outputImag == null || inputReal == null || inputImag == null) {
            return false;
        }
        if (outputReal.length != outputImag.length || outputReal.length != inputReal.length / 2 || inputReal.length != inputImag.length) {
            return false;
        }
        int half = outputReal.length;
        int i = 0;
        while (i < half) {
            outputReal[i] = (inputReal[i] + inputReal[half + i]) / 2.0f;
            outputImag[i] = (inputImag[i] + inputImag[half + i]) / 2.0f;
            ++i;
        }
        return true;
    }

    private boolean upsample2(float[] outputReal, float[] outputImag, float[] inputReal, float[] inputImag) {
        if (outputReal == null || outputImag == null || inputReal == null || inputImag == null) {
            return false;
        }
        if (outputReal.length != outputImag.length || outputReal.length != 2 * inputReal.length || inputReal.length != inputImag.length) {
            return false;
        }
        int half = inputReal.length;
        int i = 0;
        while (i < half) {
            outputReal[i] = inputReal[i];
            outputReal[i + half] = inputReal[i];
            outputImag[i] = inputImag[i];
            outputImag[i + half] = inputImag[i];
            ++i;
        }
        return true;
    }

    private void paint(Signal s, float[] array, int iteration, int direction) {
        int dimension = s.D;
        if (dimension == 3) {
            int imageHeight = s.N[1] * this.power(2, iteration + 1);
            int imageWidth = s.N[2] * this.power(2, iteration + 1);
            int offsetZ = (direction + 1) / 4 * s.N[0];
            int offsetY = (direction + 1 - (direction + 1) / 4 * 4) / 2 * s.N[1];
            int offsetX = (direction + 1) % 2 * s.N[2];
            int z = 0;
            while (z < s.N[0]) {
                int signalOffsetZ = z * s.extN[2] * s.extN[1];
                int arrayOffsetZ = (z + offsetZ) * imageHeight * imageWidth;
                int y = 0;
                while (y < s.N[1]) {
                    int signalOffsetZY = signalOffsetZ + y * s.extN[2];
                    int arrayOffsetZY = arrayOffsetZ + (y + offsetY) * imageWidth;
                    int x = 0;
                    while (x < s.N[2]) {
                        array[arrayOffsetZY + x + offsetX] = s.array[signalOffsetZY + x];
                        ++x;
                    }
                    ++y;
                }
                ++z;
            }
        }
        if (dimension == 2) {
            int imageWidth = s.N[1] * this.power(2, iteration + 1);
            int offsetY = (direction + 1) / 2 * s.N[0];
            int offsetX = (direction + 1) % 2 * s.N[1];
            int y = 0;
            while (y < s.N[0]) {
                int signalOffsetY = y * s.extN[1];
                int arrayOffsetY = (y + offsetY) * imageWidth;
                int x = 0;
                while (x < s.N[1]) {
                    array[arrayOffsetY + x + offsetX] = s.array[signalOffsetY + x];
                    ++x;
                }
                ++y;
            }
        }
    }

    private int power(int a, int b) {
        int pow = 1;
        int i = 0;
        while (i < b) {
            pow *= a;
            ++i;
        }
        return pow;
    }

    public float estimateSigma(SignalWavelet sw) {
        if (sw == null || sw.J < 1) {
            return 0.0f;
        }
        return ToolboxSignal.mad(sw.w[0][sw.M - 1]) / 0.6745f;
    }

    public static void copy(SignalWavelet s1w, SignalWavelet s2w) {
        s1w.J = s2w.J;
        s1w.s = (Signal)s2w.s.clone();
        int j = 0;
        while (j < s1w.J) {
            int m = 0;
            while (m < s1w.M) {
                s1w.w[j][m].isReal = s2w.w[j][m].isReal;
                ToolboxSignal.copy(s1w.w[j][m], s2w.w[j][m]);
                ++m;
            }
            ++j;
        }
    }
}

