/*
 * Decompiled with CFR 0.152.
 */
package toolbox.gui;

import ij.IJ;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;

public abstract class AbstractVerifier
extends InputVerifier {
    @Override
    public boolean shouldYieldFocus(JComponent input) {
        boolean inputOK = this.verify(input);
        this.makeItPretty(input);
        if (inputOK) {
            return true;
        }
        IJ.beep();
        return false;
    }

    @Override
    public boolean verify(JComponent input) {
        return this.checkField(input, false);
    }

    protected void makeItPretty(JComponent input) {
        this.checkField(input, true);
    }

    protected abstract boolean checkField(JComponent var1, boolean var2);

    protected boolean checkFloatField(String algorithmName, String parameterName, JTextField jTextField, float min, float max, float defaultValue, boolean change) {
        boolean wasValid = true;
        float value = defaultValue;
        try {
            value = Float.parseFloat(jTextField.getText());
        }
        catch (NumberFormatException e) {
            wasValid = false;
        }
        if (!wasValid && change) {
            value = defaultValue;
            IJ.error((String)("Parameter \"" + parameterName + "\" in \"" + algorithmName + "\" was not a float.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
        }
        if (value < min || value > max) {
            wasValid = false;
            if (change) {
                if (value < min) {
                    value = min;
                    IJ.error((String)("Parameter \"" + parameterName + "\" in \"" + algorithmName + "\" was too small.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
                } else {
                    value = max;
                    IJ.error((String)("Parameter \"" + parameterName + "\" in \"" + algorithmName + "\" was too big.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
                }
            }
        }
        if (change) {
            jTextField.setText("" + value);
            jTextField.selectAll();
        }
        return wasValid;
    }

    protected boolean checkIntField(String algorithmName, String parameterName, JTextField jTextField, int min, int max, int defaulT, boolean change) {
        boolean wasValid = true;
        int value = defaulT;
        try {
            value = Integer.parseInt(jTextField.getText());
        }
        catch (NumberFormatException e) {
            wasValid = false;
        }
        if (!wasValid && change) {
            value = defaulT;
            IJ.error((String)("Parameter \"" + parameterName + "\" for algorithm \"" + algorithmName + "\" was not an int.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
        }
        if (value < min || value > max) {
            wasValid = false;
            if (change) {
                if (value < min) {
                    value = min;
                    IJ.error((String)("Parameter \"" + parameterName + "\" for algorithm \"" + algorithmName + "\" was too small.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
                } else {
                    value = max;
                    IJ.error((String)("Parameter \"" + parameterName + "\" for algorithm \"" + algorithmName + "\" was too big.\nValue \"" + jTextField.getText() + "\" has been changed to \"" + value + "\"."));
                }
            }
        }
        if (change) {
            jTextField.setText("" + value);
            jTextField.selectAll();
        }
        return wasValid;
    }
}

