/*
 * Decompiled with CFR 0.152.
 */
package toolbox.gui;

import ij.IJ;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.JTextArea;

public class LogSingleton {
    private static LogSingleton instance;
    private JTextArea log = new JTextArea();
    private long startTime;
    private int progressLength;
    private String mem;
    public boolean macroMode = false;
    public int activePriorityLevel = 0;

    private LogSingleton() {
        this.log.setFont(new Font("Monospaced", 0, 12));
    }

    public static LogSingleton getInstance() {
        if (instance == null) {
            instance = new LogSingleton();
            LogSingleton.instance.activePriorityLevel = 0;
        }
        return instance;
    }

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    public JTextArea getJTextArea() {
        return this.log;
    }

    public void resetStartTime() {
        this.startTime = this.getCurrentTime();
    }

    public void setProgressLength(int current) {
        this.progressLength = current;
    }

    public int getProgressLength() {
        return this.progressLength;
    }

    public String getMemString() {
        return this.mem;
    }

    public void start(String msg, int priority) {
        if (priority >= this.activePriorityLevel) {
            long freeMem = Runtime.getRuntime().freeMemory() / 1024L;
            DecimalFormat dfm = new DecimalFormat(" 000000 KB ");
            this.mem = dfm.format(freeMem);
            DecimalFormat dft = new DecimalFormat(" 000.00 s ");
            String time = dft.format(this.getElapsedTime());
            this.addText(String.valueOf(this.mem) + "\t" + time + "\t" + String.format("%-60s", msg));
        }
    }

    public void acknowledge(int priority) {
        if (priority >= this.activePriorityLevel) {
            DecimalFormat dft = new DecimalFormat(" 000.00 s ");
            String time = dft.format(this.getElapsedTime());
            this.addText(" Done\t" + time + "\n");
        }
    }

    public long getCurrentTime() {
        return System.nanoTime();
    }

    public float getElapsedTime() {
        return (float)((double)(this.getCurrentTime() - this.startTime) / 1.0E9);
    }

    public void append(String msg, int priority) {
        if (priority >= this.activePriorityLevel) {
            this.addText(String.valueOf(msg) + "\n");
        }
    }

    public void appendWithTime(String msg, int priority) {
        if (priority >= this.activePriorityLevel) {
            DecimalFormat dft = new DecimalFormat(" 000.00s ");
            String time = dft.format(this.getElapsedTime());
            this.addText(String.valueOf(msg) + "\t" + time + "\n");
        }
    }

    public void clear() {
        this.log.setText("");
    }

    private void addText(String msg) {
        if (this.macroMode) {
            IJ.log((String)msg);
        } else {
            this.log.append(msg);
            this.log.setCaretPosition(this.log.getDocument().getLength());
        }
    }
}

