/*
 * Decompiled with CFR 0.152.
 */
package toolbox.random;

import java.util.Random;

public class Poisson {
    private Random rand;

    public Poisson(boolean useSeed, long seed) {
        this.rand = useSeed ? new Random(seed) : new Random();
    }

    public int next(double lambda) {
        double em;
        double sq = 0.0;
        double alxm = 0.0;
        double g = 0.0;
        double oldm = -1.0;
        if (lambda < 12.0) {
            if (lambda != oldm) {
                oldm = lambda;
                g = Math.exp(-lambda);
            }
            em = -1.0;
            double t = 1.0;
            do {
                em += 1.0;
            } while ((t *= this.rand.nextDouble()) > g);
        } else {
            if (lambda != oldm) {
                oldm = lambda;
                sq = Math.sqrt(2.0 * lambda);
                alxm = Math.log(lambda);
                g = lambda * alxm - this.gammln(lambda + 1.0);
            }
            while (true) {
                double y;
                if ((em = sq * (y = Math.tan(Math.PI * this.rand.nextDouble())) + lambda) < 0.0) {
                    continue;
                }
                em = Math.floor(em);
                double t = 0.9 * (1.0 + y * y) * Math.exp(em * alxm - this.gammln(em + 1.0) - g);
                if (!(this.rand.nextDouble() > t)) break;
            }
        }
        return (int)em;
    }

    private double gammln(double xx) {
        double[] cof = new double[]{76.18009172947146, -86.50532032941678, 24.01409824083091, -1.231739572450155, 0.001208650973866179, -5.395239384953E-6};
        double x = xx;
        double y = xx;
        double tmp = x + 5.5;
        tmp -= (x + 0.5) * Math.log(tmp);
        double ser = 1.000000000190015;
        int j = 0;
        while (j <= 5) {
            ser += cof[j] / (y += 1.0);
            ++j;
        }
        return -tmp + Math.log(2.5066282746310007 * ser / x);
    }
}

