/*
 * Decompiled with CFR 0.152.
 */
package toolbox.waveletFilters;

public final class FractSpline {
    public static final int ORTHONORMAL = 0;
    public static final int BSPLINE = 3;
    public static final int DUAL = 6;
    private double[] Himag;
    private double[] Hreal;
    private double[] Gimag;
    private double[] Greal;
    private double[] A;
    private double[] A2;
    private int filter = 0;
    private int size = 0;
    private double degree = 0.0;
    private double shift = 0.0;

    public FractSpline(int size, int filter, double degree, double shift) {
        this.size = size;
        this.filter = filter;
        this.degree = degree;
        this.shift = shift;
        this.Himag = new double[size];
        this.Hreal = new double[size];
        this.Gimag = new double[size];
        this.Greal = new double[size];
        this.A = new double[size];
        this.A2 = new double[size];
        this.computeAutocorrelation();
        this.computeAutocorrelation2();
    }

    public void generateAnalysisFilters() {
        this.generateBspline();
        switch (this.filter) {
            case 0: {
                this.normalizeOrthogonal();
                this.generateHighpass();
                this.mirrorHighpass();
                break;
            }
            case 3: {
                this.generateHighpass();
                this.divideAutocorrelation2();
                this.mirrorHighpass();
                this.normalizeBspline();
                break;
            }
            case 6: {
                this.generateHighpass();
                this.multiplyAutocorrelation();
                this.mirrorHighpass();
                break;
            }
            default: {
                throw new IllegalStateException("Wrong filter name.");
            }
        }
    }

    public final void generateSynthesisFilters() {
        this.generateBspline();
        switch (this.filter) {
            case 0: {
                this.normalizeOrthogonal();
                this.generateHighpass();
                this.mirrorHighpass();
                break;
            }
            case 3: {
                this.generateHighpass();
                this.multiplyAutocorrelation();
                this.mirrorHighpass();
                break;
            }
            case 6: {
                this.generateHighpass();
                this.divideAutocorrelation2();
                this.mirrorHighpass();
                this.normalizeBspline();
                break;
            }
            default: {
                throw new IllegalStateException("Wrong filter name.");
            }
        }
    }

    private final void generateBspline() {
        double M = this.size;
        double sqrt2 = Math.sqrt(2.0);
        int halfsize = this.size / 2;
        double order = this.degree + 1.0;
        int k = 0;
        while (k < this.size) {
            double c;
            double b;
            double w2 = Math.PI * (double)k / M;
            double w = 2.0 * w2;
            if (k <= halfsize) {
                b = this.shift * w;
                c = sqrt2 * Math.pow(Math.cos(w2), order);
            } else {
                b = this.shift * (w - Math.PI * 2);
                c = sqrt2 * Math.pow(-Math.cos(w2), order);
            }
            this.Hreal[k] = c * Math.cos(b);
            this.Himag[k] = -c * Math.sin(b);
            ++k;
        }
    }

    private final void normalizeOrthogonal() {
        int k = 0;
        while (k < this.size) {
            double factor = Math.sqrt(this.A[k] / this.A2[k]);
            int n = k;
            this.Hreal[n] = this.Hreal[n] * factor;
            int n2 = k++;
            this.Himag[n2] = this.Himag[n2] * factor;
        }
    }

    private final void normalizeBspline() {
        int k = 0;
        while (k < this.size) {
            double factor = this.A[k] / this.A2[k];
            int n = k;
            this.Hreal[n] = this.Hreal[n] * factor;
            int n2 = k++;
            this.Himag[n2] = this.Himag[n2] * factor;
        }
    }

    private final void generateHighpass() {
        double M = this.size;
        int k = 0;
        while (k < this.size) {
            double w = Math.PI * 2 * (double)k / M;
            double d = Math.cos(w);
            double e = Math.sin(w);
            this.Greal[k] = d * this.Hreal[k] + e * this.Himag[k];
            this.Gimag[k] = d * this.Himag[k] - e * this.Hreal[k];
            ++k;
        }
    }

    private final void mirrorHighpass() {
        int halfsize = this.size / 2;
        int k = 0;
        while (k < halfsize) {
            double swap = this.Greal[k + halfsize];
            this.Greal[k + halfsize] = this.Greal[k];
            this.Greal[k] = swap;
            swap = this.Gimag[k + halfsize];
            this.Gimag[k + halfsize] = -this.Gimag[k];
            this.Gimag[k] = -swap;
            ++k;
        }
    }

    private final void multiplyAutocorrelation() {
        int k = 0;
        while (k < this.size) {
            int n = k;
            this.Greal[n] = this.Greal[n] * this.A[k];
            int n2 = k;
            this.Gimag[n2] = this.Gimag[n2] * this.A[k];
            ++k;
        }
    }

    private final void divideAutocorrelation2() {
        int k = 0;
        while (k < this.size) {
            int n = k;
            this.Greal[n] = this.Greal[n] / this.A2[k];
            int n2 = k;
            this.Gimag[n2] = this.Gimag[n2] / this.A2[k];
            ++k;
        }
    }

    private final void computeAutocorrelation() {
        double M = this.size;
        int N = 100;
        double degree2 = 2.0 * this.degree + 2.0;
        double sum = 0.0;
        int k = 0;
        while (k < this.size) {
            double nu = (double)k / M;
            if (nu == 0.0) {
                this.A[k] = 1.0;
            } else {
                sum = 0.0;
                int l = -N;
                while (l <= N) {
                    sum += 1.0 / Math.pow(Math.abs(nu + (double)l), degree2);
                    ++l;
                }
                sum += 2.0 / (degree2 - 1.0) / Math.pow(N, degree2 - 1.0);
                sum -= 1.0 / Math.pow(N, degree2);
                sum += (this.degree + 1.0) * (0.3333333333333333 + 2.0 * nu * nu) / Math.pow(N, degree2 + 1.0);
                sum -= (this.degree + 1.0) * (degree2 + 1.0) * nu * nu / Math.pow(N, degree2 + 2.0);
                this.A[k] = sum *= Math.pow(Math.abs(Math.sin(Math.PI * nu) / Math.PI), degree2);
            }
            ++k;
        }
    }

    private void computeAutocorrelation2() {
        int halfsize = this.size / 2;
        int k = 0;
        while (k < halfsize) {
            this.A2[k] = this.A[k * 2];
            this.A2[k + halfsize] = this.A[k * 2];
            ++k;
        }
    }

    public double[] getRealHighpassFilter() {
        return this.Greal;
    }

    public double[] getImaginaryHighpassFilter() {
        return this.Gimag;
    }

    public double[] getRealLowpassFilter() {
        return this.Hreal;
    }

    public double[] getImaginaryLowpassFilter() {
        return this.Himag;
    }
}

